%{
#ifndef lint
static char *rcs = "$Header: qmspag.y,v 1.1 88/01/15 12:19:19 simpson Rel $";
#endif
/*
$Log:	qmspag.y,v $
 * Revision 1.1  88/01/15  12:19:19  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  17:12:07  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <setjmp.h>
#include <local/standard.h>
#include "qms.h"

extern FILE *_Ifp, *_Ofp;
extern Boolean	_FirstChar;
static jmp_buf	Env;
static struct qmspag	Result;
%}
%union {
    float   r;
    int	    i;
}
%token PAG POT TMT BMT LMT RMT LPIT CPIT PROP PTT PST SOT CCT ENDLINE 
%token <r> REAL 
%token <i> INTEGER
%type <i> orientation yesorno 'P' 'L' 'Y' 'N'
%%
paglines : paglines pagline | pagline ;

pagline : PAG settings ENDLINE ;

settings : settings setting optcomma | /* epsilon */ ;

setting :
    POT '=' orientation 
	{
	    Result.PO = $3;
	}
    |
    TMT '=' INTEGER
	{
	    Result.TM = $3;
	}
    |
    TMT '=' REAL
	{
	    Result.TM = $3;
	}
    |
    BMT '=' INTEGER
	{
	    Result.BM = $3;
	}
    |
    BMT '=' REAL
	{
	    Result.BM = $3;
	}
    |
    LMT '=' INTEGER
	{
	    Result.LM = $3;
	}
    |
    LMT '=' REAL
	{
	    Result.LM = $3;
	}
    |
    RMT '=' INTEGER
	{
	    Result.RM = $3;
	}
    |
    RMT '=' REAL
	{
	    Result.RM = $3;
	}
    |
    LPIT '=' INTEGER
	{
	    Result.LPI = $3;
	}
    |
    LPIT '=' REAL
	{
	    Result.LPI = $3;
	}
    |
    CPIT '=' INTEGER
	{
	    Result.CPI = $3;
	}
    |
    CPIT '=' REAL
	{
	    Result.CPI = $3;
	}
    |
    CPIT '=' PROP
	{
	    Result.CPI = 0;
	}
    |
    PTT '=' INTEGER
	{
	    Result.PT = $3;
	}
    |
    PST '=' INTEGER
	{
	    Result.PS = $3;
	}
    |
    SOT '=' yesorno
	{
	    Result.SO = $3;
	}
    |
    CCT '=' INTEGER
	{
	    Result.CC = $3;
	}
    ;
    
orientation : 'P' | 'L' ;

yesorno : 'Y' | 'N' ;

optcomma : ',' | /* epsilon */ ;
%%
#include "qmspaglex.c"

struct qmspag *qmspag()
{
    _FirstChar = TRUE;
    fputs(QUICON, _Ofp);
    fprintf(_Ofp, "%s00000", SYNTAX);
    fprintf(_Ofp, "%sPAG%s", INFO, ENDCMD);
    fputs(QUICOFF, _Ofp);
    (void)fflush(_Ofp);
    if (setjmp(Env)) {
	while (timedgetc(_Ifp) != EOF)	/* Discard remaining input */
	    ;
	return NULL;
    }
    if (yyparse() != 0)
	return NULL;
    yysptr = yysbuf;	    /* Resets lex lookahead buffer */
    return &Result;
}

static yyerror(s)
char	*s;
{
    longjmp(Env, TRUE);
}
