%{
#ifndef lint
static char *rcs = "$Header: qmsovl.y,v 1.1 88/01/15 12:19:13 simpson Rel $";
#endif
/*
$Log:	qmsovl.y,v $
 * Revision 1.1  88/01/15  12:19:13  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  17:12:05  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <setjmp.h>
#include <local/standard.h>
#include "qms.h"

extern FILE	*_Ifp, *_Ofp;
extern Boolean	_FirstChar;
static jmp_buf	Env;
char		*malloc();
static struct qmsovl	*OvlList, *P;
%}
%token OVL INTEGER SPACE AUTOPAGE NONE ENDLINE
%%
ovllines : ovllines ovlline | ovlline ;

ovlline : OVL overlay ENDLINE ;

overlay : 
    NONE
	{
	    OvlList = NULL;
	}
    |
    INTEGER SPACE
	{
	    P = (struct qmsovl *)malloc((unsigned)sizeof(struct qmsovl));
	    P->next = OvlList, OvlList = P;
	    P->ovltype = regular;
	    P->ovlnumber = $1;
	    P->ovlsize = $2;
	}
    |
    AUTOPAGE
	{
	    P = (struct qmsovl *)malloc((unsigned)sizeof(struct qmsovl));
	    P->next = OvlList, OvlList = P;
	    P->ovltype = automatic;
	}
    ;
%%
#include "qmsovllex.c"

struct qmsovl *qmsovl()
{
    _FirstChar = TRUE;
    OvlList = NULL;
    fputs(QUICON, _Ofp);
    fprintf(_Ofp, "%s00000", SYNTAX);
    fprintf(_Ofp, "%sOVL%s", INFO, ENDCMD);
    fputs(QUICOFF, _Ofp);
    (void)fflush(_Ofp);
    if (setjmp(Env)) {
	while (timedgetc(_Ifp) != EOF)	/* Discard remaining input */
	    ;
	return NULL;
    }
    if (yyparse() != 0)
	return NULL;
    yysptr = yysbuf;	    /* Resets lex lookahead buffer */
    return OvlList;
}

static yyerror(s)
char	*s;
{
    longjmp(Env, TRUE);
}
