%{
#ifndef lint
static char *rcs = "$Header: qmsopc.y,v 1.1 88/01/15 12:19:09 simpson Rel $";
#endif
/*
$Log:	qmsopc.y,v $
 * Revision 1.1  88/01/15  12:19:09  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  17:12:03  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <setjmp.h>
#include <local/standard.h>
#include "qms.h"

extern FILE	*_Ifp, *_Ofp;
extern Boolean	_FirstChar;
static jmp_buf	Env;
char		*malloc();
static struct qmsopc	Opc;
static struct optnode	*P;
%}
%token NONE ENDLINE
%token <i> OC INTEGER
%type <p> numlist
%union {
    int	    i;
    struct optnode  *p;
}
%%
opclines : opclines opcline | opcline ;

opcline : 
    OC NONE ENDLINE
	{
	    switch ($1) {
	    case 1:
		Opc.OC1 = NULL;
		break;
	    case 2:
		Opc.OC2 = NULL;
		break;
	    case 3:
		Opc.OC3 = NULL;
		break;
	    case 4:
		Opc.OC4 = NULL;
		break;
	    case 5:
		Opc.OC5 = NULL;
		break;
	    }
	}
    |
    OC numlist ENDLINE
	{
	    switch ($1) {
	    case 1:
		Opc.OC1 = $2;
		break;
	    case 2:
		Opc.OC2 = $2;
		break;
	    case 3:
		Opc.OC3 = $2;
		break;
	    case 4:
		Opc.OC4 = $2;
		break;
	    case 5:
		Opc.OC5 = $2;
		break;
	    }
	}
    ;

numlist :
    numlist INTEGER optcomma 
	{
	    if ($1 == NULL) {
		$1 = (struct optnode *)malloc((unsigned)
		sizeof(struct optnode));
		$1->option = $2;
		$1->next = NULL;
	    } else {
		for (P = $1; P->next; P = P->next)
		    ;
		P->next = (struct optnode *)malloc((unsigned)
		sizeof(struct optnode));
		P = P->next;
		P->option = $2;
		P->next = NULL;
	    }
	    $$ = $1;
	}
    | 
	{
	    /* epsilon */ 
	    $$ = NULL;
	}
    ;

optcomma : ',' | /* epsilon */ ;
%%
#include "qmsopclex.c"

struct qmsopc *qmsopc()
{
    _FirstChar = TRUE;
    fputs(QUICON, _Ofp);
    fprintf(_Ofp, "%s00000", SYNTAX);
    fprintf(_Ofp, "%sOPC%s", INFO, ENDCMD);
    fputs(QUICOFF, _Ofp);
    (void)fflush(_Ofp);
    if (setjmp(Env)) {
	while (timedgetc(_Ifp) != EOF)	/* Discard remaining input */
	    ;
	return NULL;
    }
    if (yyparse() != 0)
	return NULL;
    yysptr = yysbuf;	    /* Resets lex lookahead buffer */
    return &Opc;
}

static yyerror(s)
char	*s;
{
    longjmp(Env, TRUE);
}
