%{
#ifndef lint
static char *rcs = "$Header: qmsfnt.y,v 1.1 88/01/15 12:18:57 simpson Rel $";
#endif
/*
$Log:	qmsfnt.y,v $
 * Revision 1.1  88/01/15  12:18:57  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  17:11:59  simpson
 * beta test
 * 
*/
#include <stdio.h>
#include <setjmp.h>
#include <local/standard.h>
#include "qms.h"

extern FILE	*_Ifp, *_Ofp;
extern Boolean	_FirstChar;
static jmp_buf	Env;
char		*malloc();
static struct qmsfnt	Fnt;
static struct fontnode	*P;
%}
%token FRO FDL INTEGER CHAR NONE ENDLINE
%%
fntlines : fntlines fntline | /* epsilon */ ;

fntline : 
    fonttype NONE ENDLINE
	{
	    if ($1 == FRO)
		Fnt.rom = NULL;
	    else
		Fnt.ram = NULL;
	}
    |
    fonttype orientation INTEGER 'S' INTEGER 'V' anychar 'C' anychar ENDLINE
	{
	    P = (struct fontnode *)malloc((unsigned)sizeof(struct fontnode));
	    if ($1 == FRO) {
		P->next = Fnt.rom, Fnt.rom = P;
	    } else {
		P->next = Fnt.ram, Fnt.ram = P;
	    }
	    P->orientation = $2;
	    P->number = $3;
	    P->bytes = $5;
	    P->version = $7;
	    P->class = $9;
	}
    ;

fonttype : FRO | FDL ;

orientation : 'P' | 'L' ;

anychar : 
    'P' | 'L' | 'S' | 'V' | 'C' | CHAR 
    | 
    INTEGER
	{
	    $$ = '0' + $1;
	}
    ;
%%
#include "qmsfntlex.c"

struct qmsfnt *qmsfnt()
{
    _FirstChar = TRUE;
    Fnt.rom = Fnt.ram = NULL;
    fputs(QUICON, _Ofp);
    fprintf(_Ofp, "%s00000", SYNTAX);
    fprintf(_Ofp, "%sFNTB%s", INFO, ENDCMD);
    fputs(QUICOFF, _Ofp);
    (void)fflush(_Ofp);
    if (setjmp(Env)) {
	while (timedgetc(_Ifp) != EOF)	/* Discard remaining input */
	    ;
	return NULL;
    }
    if (yyparse() != 0)
	return NULL;
    yysptr = yysbuf;	    /* Resets lex lookahead buffer */
    return &Fnt;
}

static yyerror(s)
char	*s;
{
    longjmp(Env, TRUE);
}
