/* $Header: qms.h,v 1.1 88/01/15 12:18:55 simpson Rel $ */
/*
$Log:	qms.h,v $
 * Revision 1.1  88/01/15  12:18:55  simpson
 * initial release
 * 
 * Revision 0.1  87/12/11  17:11:57  simpson
 * beta test
 * 
*/
#define	QUICON		"\r^PY^-\r"	/* QUIC Conversion On */
#define	QUICOFF		"\r^-^PN^-\r"	/* QUIC Conversion Off */
#define PORTRAIT	"^IOP"		/* Portrait mode */
#define LANDSCAPE	"^IOL"		/* Landscape mode */
#define COMMAND		"^N"		/* Change command character */
#define SYNTAX		"^ISYNTAX"	/* Set syntax of numeric parameters */
#define	FREEFORM	"^F"		/* Begin free-form input */
#define	FREEOFF		"^O"		/* End free-form input */
#define IGNOREDATA	"^X"		/* Ignore subsequent input */
#define ENDIGNORE	"^A"		/* Stop ignoring data */
#define	INITIALIZE	"^IF"		/* Select tray, offset page length */
#define STATUS		"^ISTATUS"	/* Print status page */
#define SPECIAL		"^$"		/* Enter special characters */
#define INITJUST	"^IJ"		/* Default top page margin */
#define INITBOTTOM	"^IB"		/* Default bottom page margin */
#define INITTAB		"^IT"		/* Default left page margin */
#define JUSTIFY		"^J"		/* Vertical positioning */
#define JUSTIFYMARGIN	"^JM"		/* Vertical positioning from margin */
#define JUSTIFYRELATIVE	"^JR"		/* Relative vertical positioning */
#define JUSTIFYDOTS	"^JD"		/* Relative vertical in dots */
#define TAB		"^T"		/* Horizontal positioning */
#define TABRELATIVE	"^TR"		/* Relative horizontal positioning */
#define TABDOTS		"^TD"		/* Relative horizontal in dots */
#define INITMARGVERT	"^IMV"		/* Default vertical margins */
#define INITMARGHORZ	"^IMH"		/* Default horizontal margins */
#define DEFFONT		"^IS"		/* Default font select */
#define FONT		"^S"		/* Select font */
#define CHARSPACING	"^IC"		/* Character spacing */
#define LINESPACING	"^IL"		/* Line spacing */
#define DOWNLOAD	"^DF"		/* Download font */
#define ADOWNLOAD	"^DFA"		/* Advanced download font */
#define QUICCHAR	"^M"		/* Quic characters */
#define VERTQUIC	"^V"		/* Vertical Quic characters */
#define LEFTVERTQUIC	"^E"		/* Left vertical Quic characters */
#define INVERTQUIC	"^U"		/* Upside down Quic characters */
#define DESCENDER	"^DL"		/* Lower case descenders on */
#define HALFTONE	"^KH"		/* Half tone */
#define HALFTONESELECT	"^KL"		/* Select a half tone */
#define REVERSE		"^R"		/* Reverse image */
#define LINE		"^LS"		/* Line drawing */
#define DASHEDLINE	"^LD"		/* Dashed lines */
#define HORLINEPLOT	"^LP"		/* Horizontal line plotting */
#define VERTLINEPLOT	"^LQ"		/* Vertical line plotting */
#define ARC		"^LA"		/* Arc drawing */
#define DECIMALARC	"^LAD"		/* Decimal arc drawing */
#define BOX		"^LB"		/* Box drawing */
#define FORM		"^LF"		/* Form drawing */
#define HORFORM		"^LE"		/* Horizontal form drawing */
#define PLOT		"^P"		/* Plotting */
#define PATTVEC		"^PV"		/* Pattern vector */
#define PLOTEXPAND	"^IP"		/* Plot expansion */
#define PENWIDTH	"^PW"		/* Pen width */
#define PENUP		"^U"		/* Pen up */
#define PENDOWN		"^D"		/* Pen down */
#define PENERASE	"^E"		/* Pen erase */
#define VECTORON	"^IGV"		/* Vector graphics on */
#define VECTOROFF	"^IGE"		/* Vector graphics off */
#define BARCHART	"^BAR"		/* Bar chart drawing */
#define PIECHART	"^LAP"		/* Pie chart drawing */
#define AREAFILL	"^LAF"		/* Area fill */
#define REPEAT		"^DR"		/* Repeat command */
#define AUTOINCDEC	"^Y"		/* Automatic increment/decrement */
#define INFO		"^INFO"		/* Get information from printer */
#define COPIES		"^DC"		/* Number of page copies */
#define STOREOVERLAY	"^DOS"		/* Store an overlay sequence */
#define RECALLOVERLAY	"^DOR"		/* Recall an overlay sequence */
#define CLEAROVERLAY	"^DOC"		/* Clear an overlay sequence */
#define AUTOOVERLAY	"^DAOS"		/* Define an automatic overlay */
#define CLEARAOVERLAY	"^DAOC"		/* Clear an automatic overlay */
#define HORBARCODE	"^B"		/* Horizontal barcodes */
#define VERTBARCODE	"^C"		/* Vertical barcodes */
#define DIABLO		"^IWD"		/* Enable diablo simulation */
#define QUME		"^IWQ"		/* Enable QUME simulation */
#define EXITSIMULATE	"^IWE"		/* Exit simulation mode */
#define PCONFIG		"^ICFG"		/* Printer configuration */
#define TEXTPROC	"^ISTF"		/* Text processing command */
#define EIGHTBITON	"^("		/* Turn on eight bit format */
#define EIGHTBITOFF	"^)"		/* Turn off eight bit format */

#define ENDPASS		"^-"		/* End pass */
#define	NEWLINE		"^*"		/* End pass, new line */
#define	FORMFEED	"^,"		/* End pass, form feed */
#define	ENDCMD		"^G"		/* Command terminator */
#define HEIGHT		"^H"		/* Quic character height */
#define WIDTH		"^W"		/* Quic character width */

/* Structure returned when requesting MAP info */
struct qmsmap {
    int     count;      /* Byte count */
    int     checksum;
    char    *data;      /* "count" bytes of data terminated by NULL */
    struct qmsmap *next;
};

/* Structure returned when requesting PAG info */
struct qmspag {
    char    PO;     /* Orientation. 'P' or 'L' */
    float   TM;     /* Top margin */
    float   BM;     /* Bottom margin */
    float   LM;     /* Left margin */
    float   RM;     /* Right margin */
    float   LPI;    /* Lines per inch */
    float   CPI;    /* Characters per inch. 0 == Proportional */
    short   PT;     /* Paper Tray. 0 == Top tray. 1 == Bottom Tray */
    short   PS;     /* Page Size. 0 == Short. 1 == Long. 2 == European A-4 */
    char    SO;     /* Stacker Offset. 'Y' or 'N' */
    short   CC;     /* Copy Count */
};

/* Structure returned when requesting OVL info */
struct qmsovl {
    enum { regular, automatic } ovltype;
    /* The number and size are only valid for regular overlays */
    int ovlnumber;  /* Overlay number */
    int ovlsize;    /* Overlay size in bytes */
    struct qmsovl   *next;
};

/* Structure returned when requesting PFP info */
struct qmspfp {
    char    *module;    /* Name of installed module */
    struct qmspfp   *next;
};

/* Structure returned when requesting OPC info */
struct qmsopc {
    struct optnode  *OC1, *OC2, *OC3, *OC4, *OC5;
};

struct optnode {
    short   option;     /* Number of option */
    struct optnode  *next;
};

/* Structure returned when requesting RAM info */
struct qmsram {
    short   TR;         /* Total Ram memory in printer */
    short   AR;         /* Current Available Ram memory */
    short   FR;         /* Font Ram memory used */
    short   OR;         /* Overlay Ram memory used */
};

/* Structure returned when requesting FNTB info */
struct qmsfnt {
    struct fontnode *rom;   /* List of rom fonts */
    struct fontnode *ram;   /* List of ram fonts */
};

struct fontnode {
    char    orientation;    /* 'P' or 'L' */
    short   number;         /* Font number */
    long    bytes;          /* Number of bytes in printer */
    char    version;
    char    class;          /* '1' or '2' */
    struct fontnode *next;
};

/* Structure returned when requesting version information */
struct qmsver {
    float   version;	    /* Version of QUIC */
    float   firmware;	    /* Version of the firmware */
    struct date {	    /* Date of the firmware */
	short	month;
	short	day;
	short	year;	    /* Without the 1900 */
    } date;
};

struct qmsmap	*qmsmap();
struct qmspag	*qmspag();
struct qmsovl	*qmsovl();
struct qmspfp	*qmspfp();
struct qmsopc	*qmsopc();
struct qmsram	*qmsram();
struct qmsfnt	*qmsfnt();
struct qmsver	*qmsver();
