# AWK script which takes token names in a token file
#	generating the token definitions for yacc.
# The source token file may contain comments which
# start with a % at the beginning of a line.
# A line looks as follows. First thing is the token, the
#	second thing, if present, the type of the value
#	returned by the token.
#     T_STRING     s
BEGIN {val = 1;
	print "/* TOKEN DEFINITIONS FOR YACC */"
	print "/* !!!!!! DO NOT CHANGE THIS FILE !!!!!!!!! */"
	print "/* Generated by an awk script */"
}

{if ( $1 == "%" ) break; }
{if ( $2 == "" )
	printf "%%token  %-20s  %2d\n", $1, val;
 else
	printf "%%token  <%s> %-20s  %2d\n", $2, $1, val;
 val++;
}
