#! /bin/sh
PATH=/usr/local/bin:/bin:/usr/bin:/usr/ucb:.:../sup:../../sup
progname=`basename $0`
if [ $# = 0 ] ; then
    cat << EOF
	usage: $progname tokenfile >  lexinfile

  Prepare that part of the input to lex which scans keywords.
The information needed to build this part of lex is read from a tokenfile.
  It is assumed that in the tokenfile each keyword token is
K_* (other tokens have to start with a string different from K_).
A lower case version of '*' will be the keyword.
  Output written to stdout.
  Other tokens (which don't start with K_) are ignored.

  Options:
	-b: keywords are matched by lex only at the beginning of a line.
	-c: preserve case sensitivity, does not map keywords to lower case.
	-a: enclose keywords in <>
EOF
    exit
fi

# Purdue-ism
NOSAVE=''
export	NOSAVE

TMPDIR=.
TMP1=$TMPDIR/$progname.1.$$.tmp
TMP2=$TMPDIR/$progname.2.$$.tmp
TMP3=$TMPDIR/$progname.3.$$.tmp
TMP4=$TMPDIR/$progname.4.$$.tmp

# Default: map everything to lower case
PRESERVE_CASE='no'

# Default: keywords are not only recognized at the beginning of a line
BOL='no'

# By default no <> around the keywords.
ANGLE_BRACKETS='no'

# Look for options
while [ `expr "$1" : '-*'` -gt 0 ] ; do
    case $1 in
	'-b')	BOL='yes';;
	'-c')   PRESERVE_CASE='yes';;
	'-a')	ANGLE_BRACKETS='yes';;
	*)      echo "$progname: Illegal option"
		exit 1;;
    esac
    shift
done

# Check whether tokenfile readable.
tokenfile=$1
if [ ! -r "$tokenfile" ] ; then
    echo "$progname: no tokenfile \"$tokenfile\", abort"
    exit 1
fi

# Extract first column of token file, and there only keyword tokens.
egrep '^K_' $tokenfile | awk '{ print $1; }'	> $TMP4

# Our goal is to store in TMP2 the tokens and in TMP3 the keywords
if [ $PRESERVE_CASE = 'no' ] ; then
    sed -e 's/^K_//' $TMP4 | tr A-Z a-z	> $TMP2
else
    sed -e 's/^K_//' $TMP4		> $TMP2
fi

# Angle brackets around the key words?
if [ $ANGLE_BRACKETS = 'yes' ] ; then
	awk '{printf "<%s>\n", $0' $TMP2 > $TMP3
	mv $TMP3 $TMP2
fi

# Keywords only if at the beginning of a line?
if [ $BOL = 'yes' ] ; then
    sed -e 's/^/\^/' $TMP2	> $TMP1
    mv $TMP1 $TMP2
fi

cat $TMP4				> $TMP3

# Write to standard output
joinfiles $TMP2 $TMP3 '' ' {return(' ');}'
rm -f $TMP1 $TMP2 $TMP3 $TMP4
