/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/*
 * Mapping stuff for short to long and long to short AFM file names.
 * This stuff here is only relevant if the -m option was used.
 */

#include <stdio.h>
#include "defs.h"
#include "extfil.h"

extern char *SetUpHashTable();
extern char *InsertKeyIntoHashTable();
extern char *StrcpyAlloc();
extern char *LocateFileWithPath();
extern char *afm_path_default;
extern char *getenv();
extern int Verbose;

/*
 * Map file name: for systems, where file names are limited in
 * length a mapping file is provided. The -m option (followed by
 * the name of the mapping file) tries to located the map file.
 * This file is tried to be located using AFMPATH. The name stored here is the
 * complete file name.
 */
char *MapFileName = NULL; /* default: no mapping. Used to
			   * check whether there is mapping! */

/* Two hash tables: short names to long names and long names to
 * short names */
char * HashShortToLong;
char * HashLongToShort;

/*
 * SetUpFileNameMapping
 * ********************
 * Set up the file name mapping needed for systems which only
 * allow for short file names (for AFM files). Routine is called by main
 * with the argument to -m as parameter to this procedure. If no -m
 * option is diven, this procedure is never called.
 *
 * fn: file name
 */
void
SetUpFileNameMapping (fn)
     char *fn;
{
  EX_FILES ef;
  char name_short[256]; /* Short and long file names of AFM files. */
  char name_long[256];
  char * n_short, * n_long;
  char ** ptr;

  if ((MapFileName = LocateFileWithPath (fn, getenv("AFMPATH"), afm_path_default,
					 Verbose > V_SOME)) == NULL)
      Fatal2 ("SetUpFileNameMapping(): -m option: map file \"%s\" not found", fn);

  HashShortToLong = SetUpHashTable (20, sizeof (char *),
				    "AFM file mapping: short to long names");
  HashLongToShort = SetUpHashTable (20, sizeof (char *),
				    "AFM file mapping: long to short names");
  FExOpen (&ef, EFT_READ, 0, MapFileName, NULL);

  /* Read the table on a pair of names fashion. */
  for(;;) {
    if (fscanf (EX_FP(ef), "%s %s", name_long, name_short) != 2)
      break;
#ifdef DEBUG
    fprintf (stderr, "SetUpFileNameMapping: \"%s\" -> \"%s\"\n",
	     name_long, name_short);
#endif
    /* Make duplicates of the string, enter into the hash tables */
    n_short = StrcpyAlloc(name_short);
    n_long =  StrcpyAlloc(name_long);
    ptr = (char **) InsertKeyIntoHashTable (HashShortToLong, name_short);
    *ptr = n_long;
    ptr = (char **) InsertKeyIntoHashTable (HashLongToShort, name_long);
    *ptr = n_short;

#ifdef DEBUG
    ptr = (char **) LookUpKeyInHashTableE(HashShortToLong, n_short, "");
    fprintf (stderr, "HashShortToLong: %s->%s\n", n_short, *ptr);
#endif
  }

  FExClose (&ef);
}
