%{
/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

#include  "defs.h"
#include  "defenc.h"
#undef    input()
#undef    unput(c)
extern	char * StrncpyAlloc();
extern	char * StrcpyAlloc();
extern	int LexDebug;
extern char * DefaultString;
extern int DefaultInt;
%}
%%
\t		{}
" "		{}
\n		{}
[A-Za-z][A-Za-z0-9]* {
		DefaultString = StrcpyAlloc(yytext);
		if (LexDebug)
		  fprintf (stderr, "ID: \"%s\", \"%s\"\n",
				 DefaultString, yytext);
		return (TOC_ID);
		}

[-]*[0-9]+ {
		 if (sscanf (yytext, "%d", &DefaultInt) != 1)
		    Fatal ("free.lex(): error scanning integer");
		 if (LexDebug) {
		     fprintf (stderr, "Integer is %d\n", DefaultInt);
		     fflush (stderr);
	         }
		 return (TOC_INT);
	       }

8#[0-7]+ {
		/* Skip '8#' in input, then read octal number */
		 if (sscanf (yytext+2, "%o", &DefaultInt) != 1)
		    Fatal ("free.lex(): error scanning octal");
		 if (LexDebug) {
		     fprintf (stderr, "Octal is %o\n", DefaultInt);
		     fflush (stderr);
	         }
		 return (TOC_INT);
	       }

16#[0-9a-fA-F]+ {
		/* Skip '16#' in input, then read hex number */
		 if (sscanf (yytext+3, "%x", &DefaultInt) != 1)
		    Fatal ("free.lex(): error scanning hexadecimal");
		 if (LexDebug) {
		     fprintf (stderr, "Hexadecimal is %d\n", DefaultInt);
		     fflush (stderr);
	         }
		 return (TOC_INT);
	       }
.               {return (TOC_ILLEGAL);}
%%
