/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Convert 32.20bit integer to floating point number.
   x: a 32.20bit integer.
   RET: floating pointer number x/2**20  */
#define	 FIXES_TO_FLOAT(x) ((double)x / (double)(1<<20))

/* This is how information is read out of the 4 byte character info array. */
#define	GET_WIDTH_INDEX(c)	(c>>24)
#define	GET_HEIGHT_INDEX(c)	((c>>20)&0xF)
#define	GET_ITALIC_INDEX(c)	((c>>16)&0xF)
#define	GET_REMAINDER(c)	(c&0xFF)

#define MAX_CHAR_CODE_IN_TFM_FILE 256

/* Some remark here about the following structure to store information
   read in from a tfm file. The information in this structure is already
   modified, and not a direct image of the tfm file. For instance, it is
   possible to directly access the width of each character. Observe also
   that height and depth of characters are read in but not saved in this array,
   at least as of now. */
typedef struct tfm {
  char * tfm_name; /* Name of the fonts. */
  char * tfm_file_name; /* Complete file name of the tfm file. */
  int tfm_cs; /* Checksum */
  int tfm_designsize; /* Design size, b12.20 format, [pt] */
  int tfm_space; /* width of regular space */
  int tfm_lf; /* length of entire tfm file, in words		*/
  int tfm_lh;	/* length of header data, in words		*/
  int tfm_bc;	/* smallest character code in the font		*/
  int tfm_ec;	/* largest ...					*/
  int tfm_nw;	/* number of words in width table		*/
  int tfm_nh;	/*		      height			*/
  int tfm_nd;	/*		      depth			*/
  int tfm_ni;	/*		      italic correction		*/
  int tfm_nl;	/*		      lig/kern			*/
  int tfm_nk;	/*		      kern			*/
  int tfm_ne;	/*		      extensible character	*/
  int tfm_np;	/* number of font parameter words		*/
  int tfm_c_def[MAX_CHAR_CODE_IN_TFM_FILE]; /* Is the character defined? */
  int tfm_c_width[MAX_CHAR_CODE_IN_TFM_FILE]; /* Width in B32.20 multiples of
						 the design size. Directly
						 indexed by character code. */
} TFM_S, *TFM_S_P;
