/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* The following control codes are used to find out what type of font
 * it is, when it comes to find pxl, gf, etc. */
#define CF_PXL 0
#define CF_GF 1
#define CF_PK 2
#define CF_PDR 3
#define CF_NONE 4

/* The maximum number of characters which can be handled in any of the
 * programs. */
#define MAX_CHARS 256

/* Maximum number of characters in a PS font. */
#define MAX_CHARS_PS 256

/* Maximum character code of a character in pixel file based fonts (gf, pk).
 * Observe the maximum of 127 for pxl files. In case you changed this value
 * here observe that it must be consistent with the value in pixel-fonts.pro. */
#define MAX_CHAR_CODE_PIXEL_FONTS 255

/*
 * PDR, PDR_P
 * **********
 * Store what is in a pdr file here.
 */
typedef struct pdr {
  char *p_basename;
  int p_cs; /* Check sum */
  int p_hcc; /* Highest character code in this font */
  int p_fc; /* Font class */
  int p_ds; /* Design size */
  int p_sp; /* Font space */
  double p_a; /* Font matrix: a, b, c, d, t_x, t_y	*/
  double p_b;
  double p_c;
  double p_d;
  double p_tx;
  double p_ty;
  int p_o; /* Outline factor */
  int p_length;	/* Length of encoding array (number of elements, not bytes)
		   as read in from the pdr file. */
  int p_mc;	/* 0: no mono case font. Otherwise mono case factor. */
  int p_emul; /* Emulation font: 0 is regular font, 1 is emulating font */
  int p_ser; /* Serial number (counts conversions) of PS fonts.
		Serial number 0 corresponds to the Basefont. */
  struct font_entry * p_same; /* NULL: no PS font of the same type, otherwise
				 a circular linked list of PS fonts with the
				 the same encoding vector is built. */
  int p_i_slitex; /* Is this a Slitex invisible font? */
} PDR, *PDR_P;

/* Limits of legal ExecPs classes as read in from the driver. */
#define EXECPS_LOW 0
#define EXECPS_HIGH 0

/* Driver internal ExecPs class. */
#define EXECPS_DRIVER 255

/*
 * CE, CE_P
 * ********
 * char_entry: entry for each character
 * The information comes from pxl, gf, pk, or pdr files.
 * There is one such structure per character in each font.
 */
typedef struct char_entry {
  int c_offset; /* Offset of the pixel info in font file (in bytes). */
  char c_dl; /* Down loaded? This is used for pixel files. Characters
	      * of the PS fonts are marked downloaded from the beginning, if
	      * they are regular characters. For PS procedure characters this
	      * flag is used to trigger the procedure definition for PS procedure
	      * characters. */
  char c_type; /* CT_..., PS fonts only */
  char c_execps_type; /* PS fonts: if ExecPs character: id of procedure. */
  char c_flag; /* Flag byte (pk files only). */
  char *c_n; /* PS fonts only: name of character or name of the
		PS procedure to be invoked for that character (CT_PROCPS). */
  char *c_prog; /* PS program for a CT_PROCPS character; PS fonts. */
  DVIU c_w_tfm; /* TFM width when the character is being printed. This amount
		   is the amount by which the horizontal position changes. This value
		   is normally loaded from a gf, pk, pxl or pdr file. If the current
		   font is FOCLASS_REPLACEMENT_FONT then this information is loaded
		   from the tfm file of the font. */
  DVIU c_rw; /* Rounded tfm width: divides without remainder through HConv. */
  PXLU c_pw; /* Width and height, in pixels, of the smallest bounding box. */
  PXLU c_ph; /* Containing the character. */
  PXLU c_xoff; /* x offset and y offset of the zero point of the character, */
  PXLU c_yoff; /* measured from the upper left corner of the bounding box. */
} CE, *CE_P;

/* Specify here which type of font was loaded. Is it a font which is as specified
   in the dvi file or is it a replacement font, because it was not possible
   to load a pdr, pxl, pk or gf file for the font as specified. */
#define FOCLASS_UNDEFINED    0
#define FOCLASS_AS_REQUESTED 1
#define FOCLASS_REPLACEMENT_FONT 2

/*
 * FE
 * **
 * Font_entry:
 *
 * One such structure for each font in question. It contains
 * information from dvi and (pixel or pdr) files.
 * It represents the current knowledge of a font, excluding
 * character information.
 * Character information is stored in a data structure CE defined before
 * in this file.
 */
typedef struct font_entry {
  int f_class; /* FOCLASS_* */

  /* The following fields are loaded or computed from the dvi file. */
  int f_k; /* TeX's font number. */
  int f_c; /* Checksum of font from the dvi file. In case the font is
	      FOCLASS_REPLACEMENT_FONT, the checksum originally read in
	      here is replaced by the checksum from the font being used
	      to replace this font. */
  int f_s; /* Actual size. */
  int f_d; /* Design size according to dvi file. */
  /* Font name business, from dvi file. */
  int f_a; /* Length of area (directory) where font can found. Use
	      TEXFONTS path if 0. */
  int f_l; /* Length of font name. */
  char *f_n; /* Name of the font from dvi file. */
  int f_fnt_def_length; /* Length of the whole FNT_DEF instruction of the
			   current font, excluding the FNT_DEF opcode itself */
  double f_mag;	/* Magnification at which font is to be used,
		   (excluding the global magnification), 1.0 for no mag. */

  /* Information computed by dvitps. */
  int f_type; /* What type of a font is it ? CF_.... */
  int f_new_font; /* New font instruction already sent? */
  char *f_sf; /* Set font instruction (complete). */

  /* The following stuff is only used for PS fonts. */
  PDR_P f_pdr;

  /* Extended file stuff for this font. Files are cached, with the
     exception of .pdr files. */
  EX_FILES f_ex_file; /* Extended file identifier. In this data structure
		         the full font file name
			 (like /usr/local/lib/tex/fonts/cmr10.300pk) is loaded.
			 If it's a FOCLASS_REPLACEMENT_FONT then the replacement
			 font file name can be found here. */

  /* Information read in from font files. */
  int f_ff_mag; /* Magnification */
  int f_ff_ds; /* Design size */

  /* The following information is relevant only for FOCLASS_REPLACEMENT_FONT. */
  char *f_repl_n; /* Font name of the replacement font. */
  double f_repl_mag; /* Original font magnification. */

  /* Character information. */
  CE f_ch[MAX_CHARS]; /* Character information goes here! */
} FE, *FE_P;

/* Structure to store font file priorities and related information. */
typedef struct ffp {
  int  ffp_p;   /* Priority 0..3 with 0 the highest; -1 if unused. */
  char *ffp_n; /* "gf", "pk", .... */
  char *ffp_s; /* Search path to be used for this type. */
} FFP, *FFP_P;
