/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Extended file manipulation data structures. */

/* This data structure includes all the necessary bookkeeping information
   for files handled by the FEx.... routines. */
typedef struct e_flp {
  int ef_type;  /* File type. FT_* */
  char *ef_fn;    /* File name, with extension, if applicable. */
  char *ef_fn_ne; /* File name, no extension, if applicable. This structure
		     is also loaded and then identical to en_fn, if the
		     file name has no extension in the first place. */
  FILE *ef_filep; /* File pointer. */
  char *ef_fn_sec;/* Secondary file name (for instance, if temporary
		     file is used currently). */
  FILE *ef_filep_2;/* Sometimes you need a second file pointer */
  int  ef_intr_1;  /* What happens in case of an interrupt to the main file. FIT_*. */
  int  ef_intr_2;  /* What happens in case of an interrupt to the secondary file. FIT_*. */
  /* The following two pointers are for building a double linked list of
     such file data structures. */
  struct e_flp *ef_next; /* Pointer to next such structure. If NULL, this is the
			    last one. */
  struct e_flp *ef_prev; /* Pointer to preceding such structure. */

  int ef_open; /* Is this file currently open */
  int ef_sn; /* Serial number. Assigned when FExOpen is called. */
  int ef_dup; /* Is this extended file structure a duplicate. */

  int ef_cache_value; /* If cache is full, element with smallest value
			 will be removed from cache. */
  int ef_in_cache; /* Is this file currently in cache? This variable
		      can be used to avoid a call to FExOpen() when a
		      file is being cached. Note that this field is
		      set correctly AFTER the first call to FExOpen()
		      only. Also note that this field is NOT used
		      by FExOpen(), but FExOpen() always does its work
		      using a list of open pointers. */
}
EX_FILES, *EX_FILES_P;

/* The macro EX_FP extracts the file pointer from a EX_FILES data structure. */
#define EX_FP(e) e.ef_filep

/* The macro EX_FN extracts the file name from a EX_FILES data structure
   (with extension). */
#define EX_FN(e) e.ef_fn

/* The macro EX_FN_NO_EXT extracts the file name from a EX_FILES data structure
   (without extension). */
#define EX_FN_NO_EXT(e) e.ef_fn_no_ext

/* The following constants are used to define the first parameter of an
 * FExOpen() call. */
#define EFT_READ    1  /* Open for input */
#define EFT_WRITE   2  /* Open for output */
#define EFT_TEMP    3  /* Open temporary file */
#define EFT_INIT    4  /* Initialize an extended file array. */

/* Additional qualifiers for FExOpen(), the second parameter of it. */
#define EFQ_NO_STDIN           0x1  /* Generate error if file name = "-" for input. */
#define EFQ_NO_STDOUT          0x1  /* Generate error if file name = "-" for output. */
#define EFQ_STDIN_TMP_FILE     0x2  /* If stdin, read stdin in to temporary file, and
				       then use this file for input. */
#define EFQ_STDOUT_TMP_FILE    0x2  /* If output to stdout write
				       to temporary file. When FExClose() occurs
				       copy temporary file to stdout and then
				       remove temporary file. */
#define EFQ_STDIN_TWICE        0x4  /* If input is stdin, then use temporary file
				       (EFQ_STDIN_TMP_FILE is implied), but on
				       the first FExClose() do nothing. Assume
				       that a second FExOpen() with
				       EFQ_STDIN_TWICE_SECOND_TIME occurs.
				       Use the temporary file again, but on the
				       second FExClose() now remove the temporary file.
				       This option has no effect if the file is not stdin.  */
#define EFQ_STDIN_TWICE_SECOND_TIME 0x8 /* This option should be used on the second
					   FExOpen() call, if EFQ_STDIN_TWICE was used before.
					   If the file name is not "stdin" this has no effect.*/
#define EFQ_SHADOW             0x10  /* Shadow writing. */
#define EFQ_FORCE_TMP_FILE     0x20  /* Use a tmp file: read: make copy of original
					file. Write: write to temporary file, later,
					on FExClose(), replace desired file by temporary
					file. */
#define EFQ_NO_FILE_NO_ERROR  0x40 /* Assume opening file for input. If, on read, file could
				      not be opened, just return FALSE, no fatal error
				      is generated. In general, when FExOpen() for read
				      succeeded, return TRUE. */
#define EFQ_DELETE_FILE_IF_EXISTS 0x40 /* Assume opening for output. If file is a regular
					  file, and a file of the given name already
					  exists, delete the file first. When the
					  file then subsequently is opened for output,
					  the modification date of the directory
					  will change always, not only if file did
					  not exist before. */
#define EFQ_FILE_NAME_LOADED   0x80 /* The file name, when FExOpen() is called, is already
				       loaded into ef_fn. FExOpen() will normalize the
				       filename, use this filename, and also load ef_fn_ne */

#define EFQ_CACHE              0x100 /* Caching goes on. */

/* The following qualifiers apply only when EFT_TEMP is used. */
#define EFQ_TEMP_MODE_1       0x1  /* When FExClose() on tmp file occurs, close and
				      reopen for input. Next FExClose(): remove file. */
#define EFQ_TEMP_MODE_2       0x2  /* When FExClose() on tmp file occurs, close
				      and leave around. When second FExClose() occurs
				      remove file. */

/* FSEEK definitions needed fairly frequently. */
#define FSEEK_ABS 0 /* Absolute seek */
#define FSEEK_REL 1 /* Relative seek */
#define FSEEK_END 2 /* See relative to the end of the file. */
