/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/* Programs which do the searching for pdr, pk, gf or pxl files. */

#include <stdio.h>
#include <strings.h>
#include "defs.h"
#include "units.h"
#include "dvitps.h"
#include "extfil.h"
#include "fontd.h"

extern int HConv;
extern int CurFontNumber;
extern int Verbose;
extern FE_P CurFontPointer;
extern int ChecksumError;

extern FE_P Fonts[MAX_FONTS];

extern void ReadPxlFileInfo();

/*
 * HandleCheckSum
 * **************
 * Handle checksum comparison here.  Prints a warning if checksums
 * don't agree.
 *
 * cs_font: checksum as found in the font file (gf, pk, pdr or pxl). The checksum
 *          we already know is the checksum from the dvi file.
 */
void
HandleCheckSum (cs_font)
     int cs_font;
{
  if ((CurFontPointer->f_c != 0) && (cs_font != 0)
      && (CurFontPointer->f_c != cs_font)) {
    Warning2 ("HandleCheckSum(): Checksums do not match for font \"%s\"",
	      CurFontPointer->f_n);
    ChecksumError = TRUE;
  }
}

/* The cache strategy is to throw out the font with the smallest value of
   ef_cache_value. The value assigned to ef_in_cache is determined by
   the following variable, which is assigned to ef_in_cache when the
   OpenFontFileCached procedure is called. It is incremented after each call.
*/
int OpenFontFileCachedValue = 0;

/*
 * OpenFontFileCached
 * ******************
 * Open CurFontNumber font file, maintaining a cache of all open font files.
 * The assumption is that the file name was already loaded into the data
 * structure for the current font. This procedure is called in two different
 * instances: one is when the initial setups of font files occur
 * (in ReadGf/Pk/PxlFileInf()) and the other is when a character is being
 * downloaded.
 */
void
OpenFontFileCached()
{
  if (CurFontPointer == NULL)
    Fatal ("OpenFontFileCached(): undefined font.");

  /* You cannot use the ef_in_cache field here to determine whether the font
     file is currently loaded or not, because this routine is also
     called when the font file was not loaded at all so far. */
  FExOpen (&(CurFontPointer->f_ex_file), EFT_READ, EFQ_CACHE | EFQ_FILE_NAME_LOADED,
	   NULL, NULL);
  CurFontPointer->f_ex_file.ef_cache_value = OpenFontFileCachedValue++;
}

/*
 * PxlCluge
 * ********
 * Magnfication correction for .pxl file extension.
 *
 * f: a numerical file extension as computed sofar.
 * RET: the file extension to use.
 */
int
PxlCluge (f)
     double f;
{
  int ret;
  ret = f + 0.5;

  if (1642<=ret && ret<=1644)
    ret = 1643;
  if (3109<=ret && ret<=3111)
    ret = 3110;

#ifdef DEBUG
  fprintf (stderr, "%% PxlCluge(): %6.2lf -> %d\n", f, ret);
#endif

  return (ret);
}

/*
 * GfPkCluge
 * *********
 * Same as PxlCluge, just for .pk and .gf files
 *
 * f: file extension computed so far.
 * RET: correctly rounded value.
 */
int
GfPkCluge (f)
     double f;
{
  int ret;
  ret = f + 0.5;

#ifdef DEBUG
  fprintf (stderr, "%% GfPkCluge(): %6.2lf -> %d\n", f, ret);
#endif
  if (ret==328)
    ret = 329;

  return (ret);
}
