/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/*
 * The following DEBUG switches are defined in this file:
 * DEBUG
 * DEBUG_GF
 * DEBUG_PXL
 */

#include <stdio.h>
#include <strings.h>
#include "defs.h"
#include "units.h"
#include "dvitps.h"
#include "extfil.h"
#include "fontd.h"
#include "gf-com.h"

extern int Resolution;
extern int HConv;
extern int CurFontNumber;
extern int FontsMissing;
extern FE_P CurFontPointer;
extern FE_P Fonts[MAX_FONTS];

/*
 * ReadPxlFileInfo
 * ***************
 * Read the most important information from the pxl file:
 *	(a)	header of the pxl file
 *	(b)	width, offsets, sizes etc. of EACH character,
 *		EXCLUDING its bitmap though.
 */
void
ReadPxlFileInfo()
{
  register CE_P ce;
  int i;
  int tfm;
  int check_sum;
  
  /* Code for generating pixel fonts. */
  PsDownLoad ("pixel-fonts.pro", 0);

  OpenFontFileCached();

  if (NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 4) != PXLID)
	Fatal("ReadPxlFileInfo(): PXLID wrong");

  FExSeek (&(CurFontPointer->f_ex_file), -20, 2);

  /* Read checksum and handle it. */
  check_sum = NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 4);
  switch (CurFontPointer->f_class) {
    case FOCLASS_AS_REQUESTED:
      HandleCheckSum (check_sum);
      break;
    case FOCLASS_REPLACEMENT_FONT:
      /* Note that when a replacement font is used the checksum as found in
	 the dvi file has no relevancy. */
      CurFontPointer->f_c = check_sum;
      break;
    default:
      Fatal ("ReadPxlFileInfo(): FOCLASS_ illegal.");
    }

  CurFontPointer->f_ff_mag = NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 4);
  CurFontPointer->f_ff_ds =  NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 4);

  /* Position at the beginning of the font dictionary. */
  FExSeek (&(CurFontPointer->f_ex_file),
	   NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 4) * 4, 0);

  /* Read width, offset, size and such information about each character
   * of the font from the "font directory". Bit patterns are NOT read in. */
  for (i = 0; i <= 127; i++) {
    ce = &(CurFontPointer->f_ch[i]);
    ce->c_dl = FALSE;
    ce->c_pw   = NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 2);
    ce->c_ph   = NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 2);
    ce->c_xoff = SignExtend(CurFontPointer->f_ex_file.ef_filep, 2);
    ce->c_yoff = SignExtend(CurFontPointer->f_ex_file.ef_filep, 2);
    /* The offsets into the .pxl file are given in words, we use bytes. */
    ce->c_offset = 4 * NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 4);

    /* Observe that f_s already includes the font magnification, but
       not the global magnification. The unit of f_s is DVIU.
       tfm is noa loaded with the tfm width from the pxl file. */
    tfm = NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 4);
    switch (CurFontPointer->f_class) {
      case FOCLASS_AS_REQUESTED:
        ce->c_w_tfm = (DVIU) (CurFontPointer->f_s * FIXES_TO_FLOAT(tfm));
	WarningTfmVersusPxlWidth(i, ce);
	break;
      case FOCLASS_REPLACEMENT_FONT:
	/* In case of a replacement font the tfm width to be used is already
	   loaded (from the font which was supposed to be used originally.)
	   Now we convert from tfm units to DVIUs. */
	ce->c_w_tfm = (DVIU) (CurFontPointer->f_s * FIXES_TO_FLOAT(ce->c_w_tfm));
	break;
      }

    /* Width, when magnified and converted to pixels, must be an integer. */
    ce->c_rw = HConv * PixRound(ce->c_w_tfm, HConv);
  }
}
