/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/* Read capability file. */

#include <stdio.h>
#include "defs.h"
#include "dvitps.h"
#include "units.h"
#include "extfil.h"
#include "fontd.h"

extern char *dvitps_cap_dir;
extern char *ProgNameS;

/* Set to TRUE if a valid capability file was found and read in. */
int ValidCapabilities;

/* Keep track of all font file types and their priorities here. */
FFP FileP[4];

/*
 * ReadDvitpsCap
 * *************
 * Read the driver capability file. This file as of now contains
 * only information about what font types are available on the
 * local installation and in which order the driver is supposed
 * to look for these font file types.
 */
void
ReadDvitpsCap()
{
  EX_FILES ex_f;
  char buffer[256];
  char buffer2[256];
  char id[16];
  int priority;
  int index;
  int i;
  int all;
  int count;

  ValidCapabilities = FALSE;

  /* Part 1: handle file which determines the search patterns for fonts
     i.e. which font file types does the driver know about at a specific
     installation and in which order are files searched for. */
  for (i=0; i<=3; i++) {
    FileP[i].ffp_p = -1;
    FileP[i].ffp_n = NULL;
    FileP[i].ffp_s = NULL;
  }
  FileP[CF_GF].ffp_n = "gf";
  FileP[CF_PK].ffp_n = "pk";
  FileP[CF_PXL].ffp_n ="pxl";
  FileP[CF_PDR].ffp_n = "pdr";

  sprintf (buffer, "%s/fonts.%s", dvitps_cap_dir, ProgNameS);
  if (! FExOpen(&ex_f, EFT_READ, EFQ_NO_STDIN | EFQ_NO_FILE_NO_ERROR, buffer, ""))
    return;

  ValidCapabilities = TRUE;
  while (ReadLineIntoBuffer(EX_FP(ex_f), buffer2, 256) != EOF) {
    /* Ignore empty lines and comment lines (starting with %) */
    if (IsEmptyLine(buffer2))
      continue;
    if (buffer2[0] == '%')
      continue;
#ifdef DEBUG
    fprintf (stderr, "ReadDvitpsCap(): READ: %s\n", buffer2);
#endif
    if (sscanf (buffer2, "%s %d", id, &priority) != 2)
      Fatal2 ("ReadDvitpsCap(): Format error in \"%s\"", buffer);
    index = -1; /* invalid */
    if (strcmp(id, "GF:") == 0)  index = CF_GF;
    if (strcmp(id, "PK:") == 0)  index = CF_PK;
    if (strcmp(id, "PXL:") == 0) index = CF_PXL;
    if (strcmp(id, "PDR:") == 0) index = CF_PDR;
    if (index == -1)
      Fatal2 ("ReadDvitpsCap(): Format error 2 [%s]", id);
    FileP[index].ffp_p = priority;
  }
  FExClose(&ex_f);

  /*
   * Now check on whether the user's initialisation makes any sense:
   * no "double priorities", no "holes" etc. This is actually redundant,
   * because the installation program already did these checks. But we
   * had in here before, so why not leave it in here.
   */
  all = FALSE;
  for (priority=0; priority<=3; priority++) {
    count = 0;
    for (i=0; i<=3; i++) {
      if (FileP[i].ffp_p == priority)
	  count++;
    }
    if (count > 1)
      Fatal ("InitFilePriorities(): FONT_TYPES wrong.");
    if (all && count != 0)
      Fatal ("InitFilePriorities(): FONT_TYPES wrong.");
    if (count == 0) {
      if (!all)
	all = TRUE;
    }
  }
}

/*
 * ReportFontFileTypes
 * *******************
 * Report all font file types the driver looks for and report their
 * search paths.
 */
void
ReportFontFileTypes()
{
  int pri, i;
  char * p;
  int tab_now;

  for (pri=0; pri<=3; pri++) {
    /* Loops through CF_PXL through CF_PDR. */
    for (i=0; i<=3; i++) {
      if (FileP[i].ffp_p == pri) {
	fprintf (stderr, "\t%d. Search path for \"%s\" files:\n",
		 pri+1, FileP[i].ffp_n);
	if ((p = FileP[i].ffp_s) == NULL)
	  Fatal ("ReportFontFileTypes(): NULL search path.");
	tab_now = TRUE;
	while (*p) {
	  if (tab_now)
	    fprintf (stderr, "\t\t");
	  tab_now = FALSE;
	  if (*p == ':') {
	    p++;
	    fprintf (stderr, "\n");
	    tab_now = TRUE;
	    continue;
	  }
	  putc (*p++, stderr);
	} /* while */
	fprintf (stderr, "\n");
      }
    }
  }
}
