/*
 * dvipage: DVI Previewer Program for Suns
 *
 * Neil Hunt (hunt@spar.slb.com)
 *
 * This program is based, in part, upon the program dvisun,
 * distributed by the UnixTeX group, extensively modified by
 * Neil Hunt at the Schlumberger Palo Alto Research Laboratories
 * of Schlumberger Technologies, Inc.
 *
 * Copyright (c) 1988 Schlumberger Technologies, Inc 1988.
 * Anyone can use this software in any manner they choose,
 * including modification and redistribution, provided they make
 * no charge for it, and these conditions remain unchanged.
 *
 * This program is distributed as is, with all faults (if any), and
 * without any warranty. No author or distributor accepts responsibility
 * to anyone for the consequences of using it, or for whether it serves any
 * particular purpose at all, or any other reason.
 *
 * $Log:	utils.c,v $
 * Revision 1.1  88/11/28  18:41:33  hunt
 * Initial revision
 * 
 * Stripped from dvipage.c 1.4.
 */

#include <stdio.h>
#include <fcntl.h>
#include <sys/param.h>		/* For MAXPATHLEN */
#include <suntool/sunview.h>
#include "dvipage.h"

/*
 * Utility Functions.
 * =================
 */

/*
 * get_unsigned:
 *
 */

unsigned int
get_unsigned(fp, n)
register FILE *fp;
register int n;
{
	register int x;

	x = 0;
	while (n--)
	{
		x <<= 8;
		x |= getc(fp);
	}

	return(x);
}

/*
 * get_signed:
 *
 */

int
get_signed(fp, n)
register FILE *fp;
register int n;
{
	int n1;
	register int x;

	x = getc(fp);   /* get first (high-order) byte */
	n1 = n--;
	while (n--)
	{
		x <<= 8;
		x |= getc(fp);
	}

	/* NOTE: This code assumes that the right-shift is an arithmetic, rather
	than logical, shift which will propagate the sign bit right.   According
	to Kernighan and Ritchie, this is compiler dependent! */

	x<<=32-8*n1;
	x>>=32-8*n1;  /* sign extend */

	return(x);
}

/*
 * actual_factor:
 *	compute the actual size factor given the approximation.
 */

double
actual_factor(unmodsize)
int unmodsize;  /* actually factor * 1000 */
{
	float realsize;	/* the actual magnification factor */

	realsize = (float)unmodsize / 1000.0;
	/* a real hack to correct for rounding in some cases--rkf */
	if(unmodsize==1095) realsize = 1.095445;	/*stephalf*/
	else if(unmodsize==1315) realsize=1.314534;	/*stepihalf*/
	else if(unmodsize==2074) realsize=2.0736;	/*stepiv*/
	else if(unmodsize==2488) realsize=2.48832;  /*stepv*/
	else if(unmodsize==2986) realsize=2.985984;	/*stepiv*/
	/* the remaining magnification steps are represented with sufficient
	   accuracy already */
	return(realsize);
}


/*
 * do_convert
 */

int
do_convert(num, den, convResolution)
int num;
int den;
int convResolution;
{
	register float conv;
	conv = ((float)num/(float)den) * 
#ifdef USEGLOBALMAG
/*	actual_factor(mag) * why was this in as Actual Factor?  jls */
	((float) mag/1000.0) *
#endif
	((float)convResolution/254000.0);
	return((int) (1.0 / conv + 0.5));
}
