/*
 * dvipage: DVI Previewer Program for Suns
 *
 * Neil Hunt (hunt@spar.slb.com)
 *
 * This program is based, in part, upon the program dvisun,
 * distributed by the UnixTeX group, extensively modified by
 * Neil Hunt at the Schlumberger Palo Alto Research Laboratories
 * of Schlumberger Technologies, Inc.
 *
 * Copyright (c) 1988 Schlumberger Technologies, Inc 1988.
 * Anyone can use this software in any manner they choose,
 * including modification and redistribution, provided they make
 * no charge for it, and these conditions remain unchanged.
 *
 * This program is distributed as is, with all faults (if any), and
 * without any warranty. No author or distributor accepts responsibility
 * to anyone for the consequences of using it, or for whether it serves any
 * particular purpose at all, or any other reason.
 *
 * $Log:	args.c,v $
 * Revision 1.1  88/11/28  18:39:09  hunt
 * Initial revision
 * 
 * Stripped from dvipage.c 1.4.
 */

#include <stdio.h>
#include <sys/param.h>		/* For MAXPATHLEN */
#include <suntool/sunview.h>
#include "dvipage.h"

static char *	a_arg_ptr = NULL;
static int	a_arg_index = 0;
static bool	a_escape_seen;

char *		a_prog_name = "Anonymous";

/*
 * a_next:
 *	Returns the next flag in the command line,
 *	or A_ARG if it is not a flag,
 *	or A_END if there are no more args.
 */

char
a_next(argc, argv)
int argc;
char **argv;
{
	char opt;

	/*
	 * Checks.
	 */
	if(argv == NULL || argc < 1)
	{
		fprintf(stderr, "a_next: bad arguments\n");
		exit(2);
	}

	/*
	 * Get program name on first call.
	 */
	if(a_arg_index == 0)
	{
		a_prog_name = argv[0];
		a_arg_index = 1;
	}

	/*
	 * If there is part of the previous word left, then return it.
	 */
	if(a_arg_ptr && *a_arg_ptr)
		return *a_arg_ptr++;

	/*
	 * Return A_END after the end of the list.
	 */
	if(a_arg_index >= argc)
		return A_END;

	/*
	 * Look at the next word.
	 */
	a_arg_ptr = argv[a_arg_index++];

	/*
	 * If we have seen the escape "--",
	 * or if the first char of the word * is not a '-',
	 * or if this is an isolated "-",
	 * then return ARG.
	 */
	if(a_escape_seen || a_arg_ptr[0] != '-' || a_arg_ptr[1] == '\0')
		return A_ARG;

	/*
	 * Look at the next char.
	 */
	a_arg_ptr++;
	opt = *a_arg_ptr++;

	/*
	 * If the next char is '-', then this is the escape.
	 * start over...
	 */
	if(opt == '-')
	{
		a_escape_seen = TRUE;
		return a_next(argc, argv);
	}

	/*
	 * Otherwise, return this option.
	 */
	return opt;
}

/*
 * a_arg:
 *	Returns the next argument in the command line,
 *	or NULL if there are no more args.
 */

char *
a_arg(argc, argv)
int argc;
char **argv;
{
	char *arg;

	/*
	 * Checks.
	 */
	if(argv == NULL || argc < 1)
	{
		fprintf(stderr, "a_arg: bad arguments\n");
		exit(2);
	}

	/*
	 * Get program name on first call.
	 */
	if(a_arg_index == 0)
	{
		a_prog_name = argv[0];
		a_arg_index = 1;
	}

	/*
	 * If there is part of the previous word left, then return it.
	 */
	if(a_arg_ptr && *a_arg_ptr)
	{
		arg = a_arg_ptr;
		a_arg_ptr = NULL;
		return arg;
	}

	/*
	 * Return NULL after the end of the list.
	 */
	if(a_arg_index >= argc)
		return NULL;

	/*
	 * Return the next word.
	 */
	return argv[a_arg_index++];
}

/*
 * a_number:
 *	Interpret the next word or part word as a number.
 */

double
a_number(argc, argv)
int argc;
char **argv;
{
	char *arg;

	if((arg = a_arg(argc, argv)) == NULL)
		return 0.0;
	else
		return atof(arg);
}

/*
 * a_integer:
 *	Interpret the next word or part word as an integer.
 */

int
a_integer(argc, argv)
int argc;
char **argv;
{
	char *arg;

	if((arg = a_arg(argc, argv)) == NULL)
		return 0;
	else
		return atoi(arg);
}
