% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thetaMoment.R
\name{thetaMoment}
\alias{thetaMoment}
\title{Moment estimator}
\usage{
thetaMoment(x, k = NULL, x0 = NULL)
}
\arguments{
\item{x}{a numeric vector.}

\item{k}{the number of observations in the upper tail to which the Pareto
distribution is fitted.}

\item{x0}{the threshold (scale parameter) above which the Pareto distribution
is fitted.}
}
\value{
The estimated shape parameter.
}
\description{
Estimate the shape parameter of a Pareto distribution based on moments.
}
\details{
The arguments \code{k} and \code{x0} of course correspond with each other.
If \code{k} is supplied, the threshold \code{x0} is estimated with the \eqn{n
- k} largest value in \code{x}, where \eqn{n} is the number of observations.
On the other hand, if the threshold \code{x0} is supplied, \code{k} is given
by the number of observations in \code{x} larger than \code{x0}.  Therefore,
either \code{k} or \code{x0} needs to be supplied.  If both are supplied,
only \code{k} is used (mainly for back compatibility).
}
\note{
The argument \code{x0} for the threshold (scale parameter) of the
Pareto distribution was introduced in version 0.2.
}
\examples{
data(eusilc)
# equivalized disposable income is equal for each household
# member, therefore only one household member is taken
eusilc <- eusilc[!duplicated(eusilc$db030),]

# estimate threshold
ts <- paretoScale(eusilc$eqIncome, w = eusilc$db090)

# using number of observations in tail
thetaMoment(eusilc$eqIncome, k = ts$k)

# using threshold
thetaMoment(eusilc$eqIncome, x0 = ts$x0)

}
\references{
Dekkers, A.L.M., Einmahl, J.H.J. and de Haan, L. (1989) A moment
estimator for the index of an extreme-value distribution. \emph{The Annals of
Statistics}, \bold{17}(4), 1833--1855.
}
\seealso{
\code{\link{paretoTail}}, \code{\link{fitPareto}}
}
\author{
Andreas Alfons and Josef Holzer
}
\keyword{manip}
