% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newarima2.R
\name{auto.arima}
\alias{auto.arima}
\title{Fit best ARIMA model to univariate time series}
\usage{
auto.arima(
  y,
  d = NA,
  D = NA,
  max.p = 5,
  max.q = 5,
  max.P = 2,
  max.Q = 2,
  max.order = 5,
  max.d = 2,
  max.D = 1,
  start.p = 2,
  start.q = 2,
  start.P = 1,
  start.Q = 1,
  stationary = FALSE,
  seasonal = TRUE,
  ic = c("aicc", "aic", "bic"),
  stepwise = TRUE,
  nmodels = 94,
  trace = FALSE,
  approximation = (length(x) > 150 | frequency(x) > 12),
  method = NULL,
  truncate = NULL,
  xreg = NULL,
  test = c("kpss", "adf", "pp"),
  test.args = list(),
  seasonal.test = c("seas", "ocsb", "hegy", "ch"),
  seasonal.test.args = list(),
  allowdrift = TRUE,
  allowmean = TRUE,
  lambda = NULL,
  biasadj = FALSE,
  parallel = FALSE,
  num.cores = 2,
  x = y,
  ...
)
}
\arguments{
\item{y}{a univariate time series}

\item{d}{Order of first-differencing. If missing, will choose a value based
on \code{test}.}

\item{D}{Order of seasonal-differencing. If missing, will choose a value
based on \code{season.test}.}

\item{max.p}{Maximum value of p}

\item{max.q}{Maximum value of q}

\item{max.P}{Maximum value of P}

\item{max.Q}{Maximum value of Q}

\item{max.order}{Maximum value of p+q+P+Q if model selection is not
stepwise.}

\item{max.d}{Maximum number of non-seasonal differences}

\item{max.D}{Maximum number of seasonal differences}

\item{start.p}{Starting value of p in stepwise procedure.}

\item{start.q}{Starting value of q in stepwise procedure.}

\item{start.P}{Starting value of P in stepwise procedure.}

\item{start.Q}{Starting value of Q in stepwise procedure.}

\item{stationary}{If \code{TRUE}, restricts search to stationary models.}

\item{seasonal}{If \code{FALSE}, restricts search to non-seasonal models.}

\item{ic}{Information criterion to be used in model selection.}

\item{stepwise}{If \code{TRUE}, will do stepwise selection (faster).
Otherwise, it searches over all models. Non-stepwise selection can be very
slow, especially for seasonal models.}

\item{nmodels}{Maximum number of models considered in the stepwise search.}

\item{trace}{If \code{TRUE}, the list of ARIMA models considered will be
reported.}

\item{approximation}{If \code{TRUE}, estimation is via conditional sums of
squares and the information criteria used for model selection are
approximated. The final model is still computed using maximum likelihood
estimation. Approximation should be used for long time series or a high
seasonal period to avoid excessive computation times.}

\item{method}{fitting method: maximum likelihood or minimize
    conditional sum-of-squares.  The default (unless there are missing
    values) is to use conditional-sum-of-squares to find starting
    values, then maximum likelihood.  Can be abbreviated.}

\item{truncate}{An integer value indicating how many observations to use in
model selection. The last \code{truncate} values of the series are used to
select a model when \code{truncate} is not \code{NULL} and
\code{approximation=TRUE}. All observations are used if either
\code{truncate=NULL} or \code{approximation=FALSE}.}

\item{xreg}{Optionally, a numerical vector or matrix of external regressors, which
must have the same number of rows as \code{y}. (It should not be a data frame.)}

\item{test}{Type of unit root test to use. See \code{\link{ndiffs}} for
details.}

\item{test.args}{Additional arguments to be passed to the unit root test.}

\item{seasonal.test}{This determines which method is used to select the number of seasonal differences.
The default method is to use a measure of seasonal strength computed from an STL decomposition.
Other possibilities involve seasonal unit root tests.}

\item{seasonal.test.args}{Additional arguments to be passed to the seasonal
unit root test.
See \code{\link{nsdiffs}} for details.}

\item{allowdrift}{If \code{TRUE}, models with drift terms are considered.}

\item{allowmean}{If \code{TRUE}, models with a non-zero mean are considered.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda="auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted values,
a regular back transformation will result in median forecasts. If biasadj is TRUE,
an adjustment will be made to produce mean forecasts and fitted values.}

\item{parallel}{If \code{TRUE} and \code{stepwise = FALSE}, then the
specification search is done in parallel. This can give a significant
speedup on multicore machines.}

\item{num.cores}{Allows the user to specify the amount of parallel processes
to be used if \code{parallel = TRUE} and \code{stepwise = FALSE}. If
\code{NULL}, then the number of logical cores is automatically detected and
all available cores are used.}

\item{x}{Deprecated. Included for backwards compatibility.}

\item{...}{Additional arguments to be passed to \code{\link[stats]{arima}}.}
}
\value{
Same as for \code{\link{Arima}}
}
\description{
Returns best ARIMA model according to either AIC, AICc or BIC value. The
function conducts a search over possible model within the order constraints
provided.
}
\details{
The default arguments are designed for rapid estimation of models for many time series.
If you are analysing just one time series, and can afford to take some more time, it
is recommended that you set \code{stepwise=FALSE} and \code{approximation=FALSE}.

Non-stepwise selection can be slow, especially for seasonal data. The stepwise
algorithm outlined in Hyndman & Khandakar (2008) is used except that the default
method for selecting seasonal differences is now based on an estimate of seasonal
strength (Wang, Smith & Hyndman, 2006) rather than the Canova-Hansen test.
There are also some other minor variations to the algorithm described in
Hyndman and Khandakar (2008).
}
\examples{
fit <- auto.arima(WWWusage)
plot(forecast(fit,h=20))

}
\references{
Hyndman, RJ and Khandakar, Y (2008) "Automatic time series
forecasting: The forecast package for R", \emph{Journal of Statistical
Software}, \bold{26}(3).

Wang, X, Smith, KA, Hyndman, RJ (2006) "Characteristic-based clustering
for time series data", \emph{Data Mining and Knowledge Discovery},
\bold{13}(3), 335-364.
}
\seealso{
\code{\link{Arima}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
