% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.ani.R
\name{cv.ani}
\alias{cv.ani}
\title{Demonstration for the process of cross-validation}
\usage{
cv.ani(x = runif(150), k = 10, col = c("green", "red", "blue"), pch = c(4, 1), ...)
}
\arguments{
\item{x}{a numerical vector which stands for the sample points.}

\item{k}{an integer: how many parts should we split the data into?
(comes from the \eqn{k}-fold cross-validation.)}

\item{col}{a character vector of length 3 specifying the colors
of: the rectangle representing the test set, the points of the
test set, and points of the training set.}

\item{pch}{a numeric vector of length 2 specifying the symbols of
the test set and training set respectively.}

\item{\dots}{other arguments passed to
\code{\link{plot.default}}}
}
\value{
None (invisible \code{NULL}).
}
\description{
This function uses rectangles to illustrate the \eqn{k} folds and
mark the test set and the training set with different colors.
}
\details{
Briefly speaking, the process of cross-validation is just to split
the whole data set into several parts and select one part as the
test set and the rest parts as the training set.

The computation of sample sizes is base on \code{\link{kfcv}}.
}
\note{
For the `leave-one-out' cross-validation, just specify
\code{k} as \code{length(x)}, then the rectangles will `shrink'
into single lines.

The final number of animation frames is the smaller one of
\code{ani.options('nmax')} and \code{k}.

This function has nothing to do with specific models used in
cross-validation.
}
\references{
Examples at \url{https://yihui.name/animation/example/cv-ani/}
}
\seealso{
\code{\link{kfcv}}
}
\author{
Yihui Xie
}
