% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_2comp.R
\name{simulate_2comp}
\alias{simulate_2comp}
\title{Function to simulate two-component test data}
\usage{
simulate_2comp(G = 500, My = 100, M1 = 100, output.more.info = FALSE)
}
\arguments{
\item{G}{Number of genes for simulation.}

\item{My}{Number of mixture tumor samples for simulation.}

\item{M1}{Number of normal reference for simulation.}

\item{output.more.info}{The logical flag indicating wheter to show True.data.T
and True.data.N1 in the output. The default is FALSE.}
}
\value{
\item{pi}{A matrix of estimated proportion. First row and second row 
corresponds to the proportion estimate for the known components and unkown 
component respectively for two or three component settings. Each column 
corresponds to one sample.}
\item{Mu}{Simulated \eqn{Mu} of log2-normal distribution for both known
(\eqn{MuN1}) and unknown component (\eqn{MuT}).}
\item{Sigma}{Simulated \eqn{Sigma} of log2-normal distribution for both 
known (\eqn{SigmaN1}) and unknown component (\eqn{SigmaT}).}
\item{data.Y}{A SummarizedExperiment object of expression data from mixed 
tumor samples. It is a \eqn{G} by \eqn{My} matrix where \eqn{G} is the number
of genes and \eqn{My} is the number of mixed samples. Samples with the same
tissue type should be placed together in columns.}
\item{data.N1}{A SummarizedExperiment object of expression data 
from reference component 1 (e.g., normal). It is a \eqn{G} by \eqn{M1} matrix 
where \eqn{G} is the number of genes and \eqn{M1} is the number of samples 
for component 1.} 
\item{True.data.T}{A SummarizedExperiment object of simulated tumor expression 
data. It is a \eqn{G} by \eqn{My} matrix, where \eqn{G} is the number of 
genes and \eqn{My} is the number of mixed samples. This is enabled only when 
output.more.info = TRUE.}
\item{True.data.N1}{A SummarizedExperiment object of simulated true 
expression data for reference component 1 (e.g., normal). It is a \eqn{G} 
by \eqn{M1} matrix where \eqn{G} is the number of genes and \eqn{M1} is the 
number of samples for component 1. This is enabled only when 
output.more.info = TRUE.}
}
\description{
Function to simulate two-component test data for DeMixT.
}
\examples{
test.data = simulate_2comp(G = 500, My = 100, M1 = 100)
test.data$pi
test.data$Mu
test.data$Sigma
}
