# Implementations Based on _pygls_

| Name                     | Maintainer                                                            | Repository (optional)                                                      | Notes                                                                                                                         |
|--------------------------|-----------------------------------------------------------------------|----------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------|
| _Anakin Language Server_ | [Andrii Kolomoiets](https://github.com/muffinmad) | [anakin-language-server](https://github.com/muffinmad/anakin-language-server) | Yet another Jedi Python Language Server |
| _Cmake Language Server_  | [Regen100](https://github.com/regen100)                               | [cmake-language-server](https://github.com/regen100/cmake-language-server) | CMake LSP Implementation
| _Codify Language Server_ | [Open Law Library](http://www.openlawlib.org/)                        | (closed source)                                                                     | Used in our VS Code extension, _[Codify](https://marketplace.visualstudio.com/items?itemName=openlawlibrary.open-law-codify)_ |
| _CrossHair Language Server_ | [Phillip Schanely](http://github.com/pschanely)                    | [CrossHair](https://github.com/pschanely/CrossHair)                        | Supports [this VS Code extension](https://marketplace.visualstudio.com/items?itemName=CrossHair.crosshair) for Python contract testing. |
| _Esbonio Language Server_| [Alex Carney](https://github.com/alcarney) | [esbonio](https://github.com/swyddfa/esbonio) | Language server for [Sphinx](https://www.sphinx-doc.org/en/master/) documentation projects |
| _Helios Language Server_   | [et9797](https://github.com/et9797) | [helios-language-server](https://github.com/et9797/helios-language-server)   | Language Server for [Helios](https://github.com/Hyperion-BT/Helios) smart contract language |
| _Hy Language Server_     | [Rintaro Okamura](https://github.com/rinx) | [hy-language-server](https://github.com/rinx/hy-language-server) | Hy Language Server wrapping [Jedhy](https://github.com/ekaschalk/jedhy) |
| _Jedi Language Server_   | [Samuel Roeca](https://softwarejourneyman.com/pages/about.html#about) | [jedi-language-server](https://github.com/pappasam/jedi-language-server)   | Python Language Server wrapping [Jedi](https://github.com/davidhalter/jedi)                                                   |
| _Ruff Language Server_   | [Charlie Marsh](https://github.com/charliermarsh) | [ruff-lsp](https://github.com/charliermarsh/ruff-lsp) | Language Server for Python's [ruff](https://github.com/charliermarsh/ruff) |
| _Stata Language Server_   | [Hai Bo](https://github.com/HankBO) | [stata-language-server](https://github.com/HankBO/stata-language-server)   | Language Server for [Stata](https://www.stata.com/)  |
| _VSCode `autopep8` extension_   | [Microsoft](https://github.com/microsoft) | [vscode-autopep8](https://github.com/microsoft/vscode-autopep8) | VSCode extension for Python's [autopep8](https://github.com/hhatto/autopep8) |
| _VSCode `black` extension_   | [Microsoft](https://github.com/microsoft) | [vscode-black-formatter](https://github.com/microsoft/vscode-black-formatter) | VSCode extension for Python's [black](https://github.com/psf/black) |
| _VSCode `isort` extension_   | [Microsoft](https://github.com/microsoft) | [vscode-isort](https://github.com/microsoft/vscode-isort) | VSCode extension for Python's [isort](https://pycqa.github.io/isort) |
| _VSCode `flake8` extension_   | [Microsoft](https://github.com/microsoft) | [vscode-flake8](https://github.com/microsoft/vscode-flake8) | VSCode extension for Python's [flake8](https://github.com/PyCQA/flake8) |
| _VSCode `mypy` extension_   | [Microsoft](https://github.com/microsoft) | [vscode-mypy](https://github.com/microsoft/vscode-mypy) | VSCode extension for Python's [mypy](https://github.com/python/mypy) |
| _VSCode `pylint` extension_   | [Microsoft](https://github.com/microsoft) | [vscode-pylint](https://github.com/microsoft/vscode-pylint) | VSCode extension for Python's [pylint](https://github.com/PyCQA/pylint) |
| _VSCode `ufmt` extension_   | [Omnilib](https://github.com/omnilib) | [vscode-ufmt](https://github.com/omnilib/vscode-ufmt) | VSCode extension for Python's [ufmt](https://ufmt.omnilib.dev/en/stable/) |
| _YARA Language Server_   | [Avast](https://github.com/avast) | [yls](https://github.com/avast/yls) | Language Server for [YARA](https://github.com/VirusTotal/yara) |
| _zc.buildout Language Server_   | [Jérome Perrin](https://github.com/perrinjerome) | [zc.buildout.languageserver](https://github.com/perrinjerome/vscode-zc-buildout)   | Language Server for [zc.buildout](http://docs.buildout.org/en/latest/) profiles.  |

## _(alphabetic by name, maintainer)_

# Tools Based on _pygls_

| Name                     | Maintainer                                                            | Repository (optional)                                                      | Notes                                                                                                                         |
|--------------------------|-----------------------------------------------------------------------|----------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------|
| _lsp-devtools_ | [Alex Carney](https://github.com/alcarney) | [lsp-devtools](https://github.com/swyddfa/lsp-devtools) | An experiment in building web browser inspired developer tooling for language servers |
| _pytest-lsp_ | [Alex Carney](https://github.com/alcarney) | [lsp-devtools](https://github.com/swyddfa/lsp-devtools) | pytest plugin for testing language servers |
