; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; RUN: igc_opt %s --opaque-pointers -S -o - -types-legalization-pass | FileCheck %s
; REQUIRES: llvm-14-plus




; should replace store of struct with store + getelement pointer on Single Value Types

%simple.struct.type = type { i64, float }
%nested.struct.type = type { i32, %simple.struct.type }

define spir_kernel void @cover.ResolveStoreInst.with.struct()
; CHECK-LABEL: define spir_kernel void @cover.ResolveStoreInst.with.struct() {
; CHECK-NEXT:    [[SIMPLE_STRUCT_POINTER:%.*]] = alloca [[SIMPLE_STRUCT_TYPE:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = insertvalue [[SIMPLE_STRUCT_TYPE]] undef, i64 42, 0
; CHECK-NEXT:    [[SIMPLE_STRUCT_INSTANCE:%.*]] = insertvalue [[SIMPLE_STRUCT_TYPE]] [[TMP1]], float 4.500000e+00, 1
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[SIMPLE_STRUCT_TYPE]], ptr [[SIMPLE_STRUCT_POINTER]], i32 0, i32 0
; CHECK-NEXT:    store i64 42, ptr [[TMP2]], align 4
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr [[SIMPLE_STRUCT_TYPE]], ptr [[SIMPLE_STRUCT_POINTER]], i32 0, i32 1
; CHECK-NEXT:    store float 4.500000e+00, ptr [[TMP3]], align 4
; CHECK-NEXT:    [[NESTED_STRUCT_POINTER:%.*]] = alloca [[NESTED_STRUCT_TYPE:%.*]], align 8
; CHECK-NEXT:    [[TMP4:%.*]] = insertvalue [[NESTED_STRUCT_TYPE]] undef, i32 42, 0
; CHECK-NEXT:    [[NESTED_STRUCT_INSTANCE:%.*]] = insertvalue [[NESTED_STRUCT_TYPE]] [[TMP4]], [[SIMPLE_STRUCT_TYPE]] [[SIMPLE_STRUCT_INSTANCE]], 1
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr [[NESTED_STRUCT_TYPE]], ptr [[NESTED_STRUCT_POINTER]], i32 0, i32 0
; CHECK-NEXT:    store i32 42, ptr [[TMP5]], align 4
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr [[NESTED_STRUCT_TYPE]], ptr [[NESTED_STRUCT_POINTER]], i32 0, i32 1, i32 0
; CHECK-NEXT:    store i64 42, ptr [[TMP6]], align 4
; CHECK-NEXT:    [[TMP7:%.*]] = getelementptr [[NESTED_STRUCT_TYPE]], ptr [[NESTED_STRUCT_POINTER]], i32 0, i32 1, i32 1
; CHECK-NEXT:    store float 4.500000e+00, ptr [[TMP7]], align 4
; CHECK-NEXT:    ret void
;
{
  %simple.struct.pointer = alloca %simple.struct.type
  %1 = insertvalue %simple.struct.type undef, i64 42, 0
  %simple.struct.instance = insertvalue %simple.struct.type %1, float 4.5, 1
  store %simple.struct.type %simple.struct.instance, ptr %simple.struct.pointer

  %nested.struct.pointer = alloca %nested.struct.type
  %2 = insertvalue %nested.struct.type undef, i32 42, 0
  %nested.struct.instance = insertvalue %nested.struct.type %2, %simple.struct.type %simple.struct.instance, 1
  store %nested.struct.type %nested.struct.instance, ptr %nested.struct.pointer

  ret void
}

%packed.struct.type = type <{ i16, i16 }>

define spir_kernel void @cover.ResolveStoreInst.isPackedStruct()
; CHECK-LABEL: define spir_kernel void @cover.ResolveStoreInst.isPackedStruct() {
; CHECK-NEXT:    [[PACKED_STRUCT_INSTANCE:%.*]] = alloca [[PACKED_STRUCT_TYPE:%.*]], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr [[PACKED_STRUCT_TYPE]], ptr [[PACKED_STRUCT_INSTANCE]], i32 0, i32 0
; CHECK-NEXT:    store i16 234, ptr [[TMP1]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[PACKED_STRUCT_TYPE]], ptr [[PACKED_STRUCT_INSTANCE]], i32 0, i32 1
; CHECK-NEXT:    store i16 234, ptr [[TMP2]], align 1
; CHECK-NEXT:    ret void
;
{
  %packed.struct.instance = alloca %packed.struct.type, align 1
  store %packed.struct.type <{ i16 234, i16 234 }>, ptr %packed.struct.instance, align 1
  ret void
}
