#
# uspk01.rb
#
# $Id$
#

require "numru/dcl"

include NumRu
include Math


n = 400
x = NArray.sfloat(n)
y = NArray.sfloat(n)

#---------------------------- DATA DEFINITION --------------------------
dt = 3.14159 / (n-1)
a = 1.0e5
b = 1.0e-4
c = 1.0

for i in 0..n-1
  t = dt*i
  x[i] = a*sin(6.0*t)
  y[i] = b*cos(14.0*t) + c
end

#----------------------------- GRAPH -----------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::usgrph(x, y)
DCL::grcls

#-----------------------------------------------------------------------

