!----------------------------------------------------------------------
!     Copyright (c) 2010--2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtq_mpi_module_sjpack ƥȥץ
!
!      ȥݥƥ󥷥ζ
!
!  2010/04/17  ݹ  wtu_test_tormagbctau.f90 
!      2011/09/12  ݹ  wtq_mpi_module Ѥ˲¤
!      2012/04/02  ݹ  wtq_mpi_module_sjpack Ѥ˲¤
!
program wtq_mpi_sjpack_tormagbctau

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use mpi
  use wtq_mpi_module_sjpack

  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=8        ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=10, lmi=15       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  real(8), dimension(0:im-1,jm,0:kmo)           :: xyz_TORMAG
  real(8), dimension((nm+1)*(nm+1),0:lmo)       :: wt_TORMAG
  real(8), dimension(0:im-1,jm,kmi)             :: xyr_TORMAG
  real(8), dimension((nm+1)*(nm+1),0:lmi)       :: wq_TORMAG
  real(8), dimension(0:im-1,jm,0:kmo)           :: xyz_DTORDR
  real(8), dimension(0:im-1,jm,kmi)             :: xyr_DTORDR

  real(8), dimension(0:im-1,jm)                 :: xy_Null=0.0D0 

  real(8), parameter  :: Pmo = 1.0           ! ̤μץɥ
  real(8), parameter  :: Pmi = 2.0           ! μץɥ

  real(8), parameter  :: pi=3.1415926535897932385D0
  ! Ƚ
  integer, parameter :: check_digits = 11
  integer, parameter :: ignore = -12

  integer :: iproc, np, ierr

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  call MessageNotify('M','wtq_mpi_module_sjpack_tormagbctau_test', &
       'wq_mpi_module_sjpack  wtq_TormagBoundariesTau subroutine test')

  call wtq_mpi_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

 !==================== wtq_TormagBoundariesTau =========================
  ! P_10

  xyz_TORMAG = sin(xyz_lat) * cos( pi*(xyz_rad-ri)/(ro-ri) )
  xyr_TORMAG = sin(xyr_lat) * cos( pi*(xyr_rad-ri)/ri ) * xyr_Rad

  wt_TORMAG = wt_xyz(xyz_TORMAG)
  wq_TORMAG = wq_xyr(xyr_TORMAG)
  call wtq_TormagBoundariesTau(wt_TORMAG,wq_TORMAG,Pmo,Pmi)
  xyz_TORMAG = xyz_wt(wt_TORMAG)
  xyr_TORMAG = xyr_wq(wq_TORMAG)

  xyz_DTORDR = xyz_wt(wt_DRad_wt(wt_TORMAG))
  xyr_DTORDR = xyr_wq(wq_RadDRad_wq(wq_TORMAG))/xyr_Rad

  call checkresults

  ! P_1_1
  xyz_TORMAG = cos(xyz_lat)*cos(xyz_lon)* cos( pi*(xyz_rad-ri)/(ro-ri) )
  xyr_TORMAG = cos(xyr_lat)*cos(xyr_lon)* cos( pi*(xyr_rad-ri)/ri )*xyr_Rad

  wt_TORMAG = wt_xyz(xyz_TORMAG)
  wq_TORMAG = wq_xyr(xyr_TORMAG)
  call wtq_TormagBoundariesTau(wt_TORMAG,wq_TORMAG,Pmo,Pmi)
  xyz_TORMAG = xyz_wt(wt_TORMAG)
  xyr_TORMAG = xyr_wq(wq_TORMAG)

  xyz_DTORDR = xyz_wt(wt_DRad_wt(wt_TORMAG))
  xyr_DTORDR = xyr_wq(wq_RadDRad_wq(wq_TORMAG))/xyr_Rad

  call checkresults

  call MessageNotify('M','wtq_mpi_module_sjpack_tormagbctau_test', &
       'wtq_mpi_module_sjpack  wtq_TormagBoundariesTau subroutine test succeded')

 !------ MPIνλ ------

  call MPI_FINALIZE(IERR)

contains

  subroutine checkresults

    call AssertEqual(&
      message='Top B.C',                                            &
      answer = xyz_TORMAG(:,:,0),                                   &
      check = xy_Null,                                              &
      significant_digits = check_digits, ignore_digits = ignore     &
      )

    call AssertEqual(&
      message='Inner B.C (value conituity) ',                       &
      answer = xyz_TORMAG(:,:,kmo),                                 &
      check = xyr_TORMAG(:,:,kmi),                                  &
      significant_digits = check_digits, ignore_digits = ignore     &
      )

    call AssertEqual(&
      message='Inner B.C (derivative conituity) ',                  &
      answer = Pmo*xyz_DTORDR(:,:,kmo),                             &
      check = Pmi*xyr_DTORDR(:,:,kmi),                              &
      significant_digits = check_digits, ignore_digits = ignore     &
      )
  end subroutine checkresults

end program wtq_mpi_sjpack_tormagbctau
