!--
!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_deriv_module_cuda
!
!  spml/w_deriv_module_sjpack_cuda ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 w_module_sjpack_cuda β⥸塼Ǥ, ڥȥˡ
!  ʬ׻Τ Fortran90 ؿ󶡤. 
!
!   ISPACK  sjpack-cuda  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/sjpack-cuda Υޥ˥奢򻲾Ȥ줿.
!
!  Υ⥸塼Ȥˤä w_base_initial Ƥ
!  ȿ, ʻ򤷤Ƥɬפ. 
!
!
!  2011/03/11  ݹ  w_deriv_module_sjpack ˲¤
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
!++
module w_deriv_module_sjpack_cuda
  !
  != w_deriv_module_sjpack_cuda
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_deriv_module_sjpack_cuda.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/w_deriv_module_sjpack_cuda ⥸塼ϵ̾Ǥ 2 ήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿 
  ! ⥸塼 w_module_sjpack_cuda β⥸塼Ǥ, ڥȥˡ
  ! ʬ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ISPACK  sjpack-cuda  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  ! ĤƤ ISPACK/sjpack-cuda Υޥ˥奢򻲾Ȥ줿.
  !
  ! Υ⥸塼Ȥˤä w_base_initial Ƥ
  ! ȿ, ʻ򤷤Ƥɬפ. 
  !
  use dc_message, only : MessageNotify
  use w_base_module_sjpack_cuda, only : im, jm, nm=>nn, mm, it, t, r, &
                                        w_base_Initial, xy_w, w_xy
  implicit none

  real(8), allocatable  :: D(:)
  ! ץ饷黻
  !
  ! ڥȥǡΥץ饷׻뤿η
  ! Υ((mm+1)*(mm+1)*2)
  !

  real(8), allocatable  :: rn(:,:)            
  ! ץ饷黻(w_module ȸߴݤĤ)
  !
  ! ڥȥǡΥץ饷׻뤿η
  ! Υ((nm+1)*(nm+1), 2)
  !
  ! r(L,1) ˤ L ܤγǼ֤ΥڥȥФץ饷׻
  !  -n(n+1) ͤǼƤ.
  !

  private

  public w_deriv_Initial                      ! 
  public w_Lapla_w, w_LaplaInv_w              ! ץ饷ȵձ黻
  public w_DLon_w                             ! ʬ
  public xy_GradLon_w, xy_GradLat_w           ! ۷ʬ
  public w_DivLon_xy, w_DivLat_xy             ! ȯʬ
  public w_Div_xy_xy                          ! ȯʬ
  public w_Jacobian_w_w                       ! 䥳ӥ
  public xy_GradLambda_w, xy_GradMu_w         ! ۷ʬ(,̺ɸ)
  public w_DivLambda_xy, w_DivMu_xy           ! ȯʬ(,̺ɸ)

  public rn                                   ! ץ饷黻

  save D, rn

  contains

  !---------------  -----------------
    subroutine w_deriv_initial
      !
      ! ڥȥʬ׻ɬפȤʤΰꤹ. 
      !
      ! ¾δؿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ. 
      !
      ! Υ֥롼ñȤѤΤǤʤ, 
      ! ̥֥롼 w_Initial Ѥ뤳.
      !
      allocate(D((nm+1)*(nm+1)*2))           ! ץ饷黻
      allocate(rn((nm+1)*(nm+1),2))          ! ץ饷黻

      call sjinid(mm,D)

      rn = reshape(D,(/(nm+1)**2,2/))

      call MessageNotify('M','w_deriv_initial',&
           'w_deriv_module_sjpack_cuda (2011/03/11) is initialized')

    end subroutine w_deriv_initial

  !--------------- ʬ׻ -----------------
    function w_Lapla_w(w_data)
      !
      ! ϥڥȥǡ˥ץ饷
      !
      !    ^2 = 1/cos^2ա^2/ߦ^2 + 1/cosա/ߦ(cosբ/ߦ)
      !
      ! Ѥ(1 ).
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8)              :: w_Lapla_w((nm+1)*(nm+1))
      !(out) ϥڥȥǡΥץ饷

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      call sjclap(mm,w_data,w_Lapla_w,D,1)

    end function w_Lapla_w

    function w_LaplaInv_w(w_data)
      !
      ! ϥڥȥǡ˵եץ饷
      !
      !    ^{-2}
      !      =[1/cos^2ա^2/ߦ^2 + 1/cosա/ߦ(cosբ/ߦ)]^{-1}
      !
      ! Ѥ(1 ).
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8)              :: w_LaplaInv_w((nm+1)*(nm+1))
      !(out) ڥȥǡεեץ饷

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      call sjclap(mm,w_data,w_LaplaInv_w,D,2)

    end function w_LaplaInv_w

    function w_DLon_w(w_data)
      !
      ! ڥȥǡ˷ʬ /ߦ Ѥ(1 ).
      !
      ! ڥȥǡηʬȤ, бʻǡ
      ! ʬ/ߦˤѤǡΥڥȥѴΤȤǤ.
      ! 
      real(8)              :: w_DLon_w((nm+1)*(nm+1))
      !(out) ڥȥǡηʬ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      call sjcs2x(mm,w_data,w_DLon_w)

    end function w_DLon_w

    function xy_GradLon_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ 1/cosա/ߦ 
      ! Ѥʻǡ֤(1 ).
      !
      real(8)              :: xy_GradLon_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xy_GradLon_w = xy_w(w_data,ipow=1,iflag=-1)

    end function xy_GradLon_w

    function xy_GradLat_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ
      ! ʻǡѴ֤(1 ).
      !
      real(8)              :: xy_GradLat_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xy_GradLat_w = xy_w(w_data,ipow=1,iflag=1)

    end function xy_GradLat_w

    function w_DivLon_xy(xy_data)
      !
      ! ʻǡȯʬ 1/cosա/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLon_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ
      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLon_xy = w_xy(xy_data,ipow=1,iflag=-1)

    end function w_DivLon_xy

    function w_DivLat_xy(xy_data)
      !
      ! ʻǡȯʬ 1/cosա(f cos)/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLat_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLat_xy = w_xy(xy_data,ipow=1,iflag=1)

    end function w_DivLat_xy

    function w_Div_xy_xy(xy_u,xy_v)
      !
      ! 2 Ĥϳʻǡ٥ȥʬȤȯ׻, 
      ! ڥȥǡȤ֤(1 ).
      !
      real(8)              :: w_Div_xy_xy((nm+1)*(nm+1))
      !(out) 2 Ĥϳʻǡ٥ȥʬȤȯΥڥȥǡ

      real(8), intent(in)  :: xy_u(0:im-1,1:jm)
      !(in) ٥ȥʬγʻǡ

      real(8), intent(in)  :: xy_v(0:im-1,1:jm)
      !(in) ٥ȥʬγʻǡ

      w_Div_xy_xy = w_Divlon_xy(xy_u) + w_Divlat_xy(xy_v)

    end function w_Div_xy_xy

    function w_Jacobian_w_w(w_a,w_b)
      ! 2 ĤΥڥȥǡ˥䥳ӥ
      !
      !   J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
      !          = f/ߦˡ1/cosաg/ߦ
      !             - g/ߦˡ1/cosաf/ߦ
      !
      ! Ѥ(1 ).

      real(8)             :: w_Jacobian_w_w((nm+1)*(nm+1))
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), intent(in) :: w_a((nm+1)*(nm+1))
      !(in) 1ܤϥڥȥǡ
      
      real(8), intent(in) :: w_b((nm+1)*(nm+1))
      !(in) 2ܤϥڥȥǡ

      w_Jacobian_w_w = w_xy( &
                  xy_w(w_DLon_w(w_a))*xy_w(w_b,ipow=2,iflag=1) &
                - xy_w(w_DLon_w(w_b))*xy_w(w_a,ipow=2,iflag=1) )

    end function w_Jacobian_w_w

  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xy_GradLambda_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ(1 ).
      !
      real(8)              :: xy_GradLambda_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ
      
      xy_GradLambda_w = xy_w(w_data,ipow=0,iflag=-1)

    end function xy_GradLambda_w

    function xy_GradMu_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ (1-^2)/ߦ  (=sin)
      ! ѤƳʻǡѴ֤(1 ).
      !
      real(8)              :: xy_GradMu_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xy_GradMu_w = xy_w(w_data,ipow=0,iflag=1)

    end function xy_GradMu_w

    function w_DivLambda_xy(xy_data)
      !
      ! ʻǡȯʬ 1/(1-^2)/ߦ (=sin) 
      ! ѤƥڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLambda_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLambda_xy = w_xy(xy_data,ipow=2,iflag=-1)

    end function w_DivLambda_xy

    function w_DivMu_xy(xy_data)
      !
      ! ʻǡȯʬ /ߦ (=sin)Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivMu_xy((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivMu_xy = w_xy(xy_data,ipow=2,iflag=1)

    end function w_DivMu_xy

  end module w_deriv_module_sjpack_cuda

