* PACKAGE P2IMTX  !" ʪ(2) 
*
***********************************************************************
      SUBROUTINE PHMTX0             !" Ѥ
     O         ( UMTX  , TMTX  , QMTX  ,
     O           UFLUX , VFLUX , TFLUX , QFLUX ,
     I           GDPM  , DELT  , GRHC  , IDSFC  )
*
*   [PARAM] 
#ifdef SYS_IBMS
      INCLUDE   (ZCDIM)                      !" ʻȿ
      INCLUDE   (ZCCOM)                      !" ɸʪ
#else
#include        "zcdim.F"                    !" ʻȿ
#include        "zccom.F"                    !" ɸʪ
#endif
*
*   [OUTPUT] 
      REAL       UMTX  ( IDIM*JDIM,   KMAX, -1:1 ) !" դα
      REAL       TMTX  ( IDIM*JDIM, 0:KMAX, -1:1 ) !" Ԥα
      REAL       QMTX  ( IDIM*JDIM,   KMAX, -1:1 ) !" α
      REAL       UFLUX ( IDIM*JDIM, KMAX+1 )     !" դΥեå
      REAL       VFLUX ( IDIM*JDIM, KMAX+1 )     !" ֤Υեå
      REAL       TFLUX ( IDIM*JDIM, KMAX+1 )     !" ԤΥեå
      REAL       QFLUX ( IDIM*JDIM, KMAX+1 )     !" Υեå
*
*   [INPUT] 
      REAL       GDPM  ( IDIM*JDIM, KMAX+1 ) !" Ⱦ
      REAL       DELT                        !" ֹߦt
      REAL       GRHC  ( IDIM*JDIM )         !" ɽǮ
      INTEGER    IDSFC ( IDIM*JDIM )         !" ɽ
*
*   [INTERNAL WORK] 
      INTEGER    IJ, K
*
*
*"         < 1. , Ǯ̤ι >
*
      CALL RESET ( UMTX, IDIM*JDIM*KMAX    *3  )
      CALL RESET ( TMTX, IDIM*JDIM*(KMAX+1)*3  )
      CALL RESET ( QMTX, IDIM*JDIM*KMAX    *3  )
*
*
      DO 1100 K = 1, KMAX
         DO 1100 IJ = 1, IDIM*JDIM
            UMTX ( IJ,K,0 ) =  ( GDPM ( IJ,K ) - GDPM( IJ,K+1 ) )
     &                          / GRAV / DELT
            TMTX ( IJ,K,0 ) =  UMTX ( IJ,K,0 ) * CP
            QMTX ( IJ,K,0 ) =  UMTX ( IJ,K,0 ) * CP
 1100 CONTINUE
*
      DO 1200 IJ = 1, IDIM*JDIM
         IF ( IDSFC( IJ ) .GE. 1 ) THEN
            TMTX ( IJ,0,0 ) = GRHC( IJ ) / DELT
         ELSE
            TMTX ( IJ,0,0 ) = 1.   
         ENDIF
 1200 CONTINUE
*
*"         < 2. եåꥻå >
*
      CALL RESET( UFLUX  , IDIM*JDIM*(KMAX+1) )
      CALL RESET( VFLUX  , IDIM*JDIM*(KMAX+1) )
      CALL RESET( TFLUX  , IDIM*JDIM*(KMAX+1) )
      CALL RESET( QFLUX  , IDIM*JDIM*(KMAX+1) )
*
      RETURN
      END
************************************************************************
      SUBROUTINE PHYTND   !" ѲΨη׻ (implicit)
     O         ( GTU   , GTV   , GTT   , GTTG  , GTQ   ,
     I           UFLUX , VFLUX ,
     I           TFLUX , SFLUX , RFLUX , GFLUX , QFLUX ,
     I           UMTX  , TMTX  , QMTX  ,
     I           UMTXS , TMTXS , QMTXS ,
     I           RMTXS , DELT  , IDSFC                  )
*
*   [PARAM] 
#ifdef SYS_IBMS
      INCLUDE   (ZCDIM)                      !" ʻȿ
      INCLUDE   (ZCCOM)                      !" ɸʪ
#else
#include        "zcdim.F"                    !" ʻȿ
#include        "zccom.F"                    !" ɸʪ
#endif
*
*   [OUTPUT] 
      REAL       GTU   ( IDIM*JDIM, KMAX )   !" ưѲգ
      REAL       GTV   ( IDIM*JDIM, KMAX )   !" ̱ưѲ֣
      REAL       GTT   ( IDIM*JDIM, KMAX )   !" ٻѲ  
      REAL       GTTG  ( IDIM*JDIM )         !" ɽѲΨ
      REAL       GTQ   ( IDIM*JDIM, KMAX )   !" 漾Ѳ  
*
*   [INPUT] 
      REAL       UFLUX ( IDIM*JDIM, KMAX+1 ) !" դΥեå
      REAL       VFLUX ( IDIM*JDIM, KMAX+1 ) !" ֤Υեå
      REAL       TFLUX ( IDIM*JDIM, KMAX+1 ) !" ԤΥեå
      REAL       SFLUX ( IDIM*JDIM  )        !" ɽûȥեå
      REAL       RFLUX ( IDIM*JDIM  )        !" ɽĹȥեå
      REAL       GFLUX ( IDIM*JDIM  )        !" եå
      REAL       QFLUX ( IDIM*JDIM, KMAX+1 ) !" Υեå
*
      REAL       UMTX  ( IDIM*JDIM,   KMAX, -1:1 ) !" 
      REAL       TMTX  ( IDIM*JDIM, 0:KMAX, -1:1 ) !" Ա
      REAL       QMTX  ( IDIM*JDIM,   KMAX, -1:1 ) !" 񱢲
      REAL       UMTXS ( IDIM*JDIM            ) !" ɽ
      REAL       TMTXS ( IDIM*JDIM, 0:1, -1:1 ) !" Աɽ
      REAL       QMTXS ( IDIM*JDIM, 0:1, -1:1 ) !" 񱢲ɽ
      REAL       RMTXS ( IDIM*JDIM,      -1:1 ) !" Ա
*
      REAL       DELT                        !" ֹߦt
*
      INTEGER    IDSFC ( IDIM*JDIM )         !" ɽ
*
*   [INTERNAL WORK] 
      COMMON    /COMWRK/
     &           GTTQX , ATQMTX
      REAL       GTTQX ( IDIM*JDIM, -KMAX:KMAX )      !" ԣѲ
      REAL       ATQMTX( IDIM*JDIM, -KMAX:KMAX, -1:1 )!" ̣չ
      REAL       AUVMTX( IDIM*JDIM,       KMAX, -1:1 )!" ̣չ
      EQUIVALENCE  ( ATQMTX, AUVMTX )
*
      INTEGER    IJ, K, L
*
*"         < 1. U, V β >
*
      CALL COPY ( AUVMTX, UMTX, IDIM*JDIM*KMAX*3 )
*
      DO 1100 IJ = 1, IDIM*JDIM
         AUVMTX( IJ,1,0 ) = AUVMTX( IJ,1,0 ) + UMTXS( IJ )
 1100 CONTINUE
*
      CALL LUMAK3
     O         ( AUVMTX    ,
     I           IDIM*JDIM , KMAX  )
*
      DO 1200 K = 1, KMAX
         DO 1200 IJ = 1, IDIM*JDIM
            GTU   ( IJ, K ) = UFLUX ( IJ,K ) - UFLUX ( IJ,K+1 )
            GTV   ( IJ, K ) = VFLUX ( IJ,K ) - VFLUX ( IJ,K+1 )
 1200 CONTINUE
*
      CALL LUSOL3
     M         ( GTU   ,
     I           AUVMTX,
     D           1     , IDIM*JDIM, KMAX )
*
      CALL LUSOL3
     M         ( GTV   ,
     I           AUVMTX,
     D           1     , IDIM*JDIM, KMAX )
*
*"         < 2. T,q β >
*
      DO 2100 L = -1, 1
         DO 2110 K = 1, KMAX
            DO 2110 IJ = 1, IDIM*JDIM
               ATQMTX( IJ, K, L ) = TMTX ( IJ,K,L )
               ATQMTX( IJ,-K,-L ) = QMTX ( IJ,K,L )
 2110    CONTINUE
         DO 2120 IJ = 1, IDIM*JDIM
               ATQMTX( IJ, 1, L ) = TMTX ( IJ,1,L ) + TMTXS( IJ,1,L )
               ATQMTX( IJ,-1,-L ) = QMTX ( IJ,1,L ) + QMTXS( IJ,1,L )
 2120    CONTINUE
 2100 CONTINUE
*
      DO 2200 IJ = 1, IDIM*JDIM
               ATQMTX( IJ, 0, 0 ) = TMTX ( IJ,0,0 )
     &                            + TMTXS( IJ,0,0 ) + QMTXS( IJ,0,0 )
     &                            + RMTXS( IJ,  0 )
               ATQMTX( IJ, 0, 1 ) = TMTXS( IJ,0,1 )
     &                            + RMTXS( IJ,  1 )
               ATQMTX( IJ, 0,-1 ) = QMTXS( IJ,0,1 )
 2200 CONTINUE
*
      CALL LUMAK3
     O         ( ATQMTX    ,
     I           IDIM*JDIM , 2*KMAX+1  )
*
      DO 2300 K = 1, KMAX
         DO 2300 IJ = 1, IDIM*JDIM
            GTTQX ( IJ, K ) = TFLUX ( IJ,K ) - TFLUX ( IJ,K+1 )
            GTTQX ( IJ,-K ) = QFLUX ( IJ,K ) - QFLUX ( IJ,K+1 )
 2300 CONTINUE
*
      DO 2400 IJ = 1, IDIM*JDIM
         GTTQX ( IJ,0 ) = - SFLUX ( IJ   ) - RFLUX ( IJ   )
     &                    - TFLUX ( IJ,1 ) - QFLUX ( IJ,1 )
     &                    + GFLUX ( IJ   )
 2400 CONTINUE
*
      CALL LUSOL3
     M         ( GTTQX ,
     I           ATQMTX,
     D           1     , IDIM*JDIM, 2*KMAX+1 )
*
*"         < 3. ѲΨ >
*
      DO 3100 K = 1, KMAX
         DO 3100 IJ = 1, IDIM*JDIM
            GTU   ( IJ,K ) = GTU   ( IJ, K ) / DELT
            GTV   ( IJ,K ) = GTV   ( IJ, K ) / DELT
            GTT   ( IJ,K ) = GTTQX ( IJ, K ) / DELT
            GTQ   ( IJ,K ) = GTTQX ( IJ,-K ) / DELT / EL * CP
 3100 CONTINUE
*
      DO 3200 IJ = 1, IDIM*JDIM
         IF ( IDSFC( IJ ) .GE. 1 ) THEN
            GTTG  ( IJ   ) = GTTQX ( IJ, 0 ) / DELT
         ELSE
            GTTG  ( IJ   ) = 0.  
         ENDIF
 3200 CONTINUE
*
      RETURN
      END
************************************************************************
      SUBROUTINE FLXCOR        !" եå
     M         ( UFLUX , VFLUX , TFLUX , QFLUX ,
     I           GTU   , GTV   , GTT   , GTTG  , GTQ   ,
     I           UMTX  , TMTX  , QMTX  ,
     I           UMTXS , TMTXS , QMTXS ,
     I           DELT                                     )
*
*   [INPUT] 
#ifdef SYS_IBMS
      INCLUDE   (ZCDIM)                      !" ʻȿ
      INCLUDE   (ZCCOM)                      !" ɸʪ
#else
#include        "zcdim.F"                    !" ʻȿ
#include        "zccom.F"                    !" ɸʪ
#endif
*
*   [MODIFY] 
      REAL       UFLUX ( IDIM*JDIM, KMAX+1 ) !" դΥեå
      REAL       VFLUX ( IDIM*JDIM, KMAX+1 ) !" ֤Υեå
      REAL       TFLUX ( IDIM*JDIM, KMAX+1 ) !" ԤΥեå
      REAL       QFLUX ( IDIM*JDIM, KMAX+1 ) !" Υեå
*
*   [INPUT] 
      REAL       GTU   ( IDIM*JDIM, KMAX )   !" ưѲգ
      REAL       GTV   ( IDIM*JDIM, KMAX )   !" ̱ưѲ֣
      REAL       GTT   ( IDIM*JDIM, KMAX )   !" ٻѲ  
      REAL       GTTG  ( IDIM*JDIM )         !" ɽѲΨ
      REAL       GTQ   ( IDIM*JDIM, KMAX )   !" 漾Ѳ  
*
      REAL       UMTX  ( IDIM*JDIM,   KMAX, -1:1 ) !" 
      REAL       TMTX  ( IDIM*JDIM, 0:KMAX, -1:1 ) !" Ա
      REAL       QMTX  ( IDIM*JDIM,   KMAX, -1:1 ) !" 񱢲
      REAL       UMTXS ( IDIM*JDIM            ) !" ɽ
      REAL       TMTXS ( IDIM*JDIM, 0:1, -1:1 ) !" Աɽ
      REAL       QMTXS ( IDIM*JDIM, 0:1, -1:1 ) !" 񱢲ɽ
      REAL       DELT                           !" ֹߦt
*
*   [INTERNAL WORK] 
      INTEGER    IJ, K
      REAL       ELF
*
      ELF = EL/CP
*
      DO 1100 K = 2, KMAX
         DO 1100 IJ = 1, IDIM*JDIM
            UFLUX ( IJ,K ) = UFLUX  ( IJ,K )
     &                     - (  UMTX( IJ,K  ,-1)* GTU( IJ,K-1 )
     &                        - UMTX( IJ,K-1, 1)* GTU( IJ,K   ) ) * DELT
*
            VFLUX ( IJ,K ) = VFLUX  ( IJ,K )
     &                     - (  UMTX( IJ,K  ,-1)* GTV( IJ,K-1 )
     &                        - UMTX( IJ,K-1, 1)* GTV( IJ,K   ) ) * DELT
*
            TFLUX ( IJ,K ) = TFLUX  ( IJ,K )
     &                     - (  TMTX( IJ,K  ,-1)* GTT( IJ,K-1 )
     &                        - TMTX( IJ,K-1, 1)* GTT( IJ,K   ) ) * DELT
*
            QFLUX ( IJ,K ) = QFLUX  ( IJ,K )
     &                     - (  QMTX( IJ,K  ,-1)* GTQ( IJ,K-1 )
     &                        - QMTX( IJ,K-1, 1)* GTQ( IJ,K   ) ) * DELT
     &                                                            * ELF
 1100 CONTINUE
*
      DO 2200 IJ = 1, IDIM*JDIM
            UFLUX ( IJ,1 ) = UFLUX   ( IJ,1 )
     &                        - UMTXS( IJ )* GTU( IJ,1 ) * DELT
*
            VFLUX ( IJ,1 ) = VFLUX   ( IJ,1 )
     &                       -  UMTXS( IJ )* GTV( IJ,1 ) * DELT
*
            TFLUX ( IJ,1 ) = TFLUX   ( IJ,1 )
     &                     - (  TMTXS( IJ,1,-1 ) * GTTG( IJ )
     &                        + TMTXS( IJ,1,0  ) * GTT ( IJ,1 ) ) * DELT
*
            QFLUX ( IJ,1 ) = QFLUX   ( IJ,1 )
     &                     - (  QMTXS( IJ,1,-1 ) * GTTG( IJ )
     &                        + QMTXS( IJ,1,0  ) * GTQ ( IJ,1 )
     &                                           * ELF          ) * DELT
 2200 CONTINUE
*
      RETURN
      END
