dnl Copyright 2025-2026 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.
dnl This file is offered as-is, without any warranty.

# Check if it is possible link against libperl.  Set libperl_link
# to "yes" or "no".

AC_DEFUN([txi_LIBPERL_LINK],
[
  AC_MSG_CHECKING(linking against libperl)

  old_LIBS=$LIBS
  LIBS=$perl_conf_LIBS
  saved_CFLAGS=$CFLAGS
  saved_CPPFLAGS=$CPPFLAGS
  saved_LDFLAGS=$LDFLAGS
  # Use the same variables as for compilation rules, in particular use the
  # PERL_EXT_var variables.
  CFLAGS="$PERL_EXT_CFLAGS $perl_conf_CFLAGS"
  CPPFLAGS="$PERL_EXT_CPPFLAGS $perl_conf_CPPFLAGS"
  LDFLAGS="$PERL_EXT_LDFLAGS $perl_conf_LDFLAGS"
  # The tested code checks basic SV functions and mixes C library functions
  # with Perl C.

  # We need to avoid Autoconf and Gnulib defines, as they clash with Perl
  # defines on some platforme.
  # Therefore AC_LINK_IFELSE cannot be used, as there is no way to avoid that
  # the source file also contains the results of all of the AC_DEFINE
  # performed so far.
  # https://lists.gnu.org/archive/html/autoconf/2025-01/msg00008.html
  # The shell code used is almost the same as the code generated by
  # by Autoconf 2.72 AC_LINK_IFELSE.  It relies on $ac_ext and
  # ac_fn_c_try_link Autoconf internal variable and function.
  dnl AC_LINK_IFELSE([[
  dnl use a single bracket to protect code, to protect brackets in code and
  dnl also do not get spurious brackets
  cat <<_ACEOF >conftest.$ac_ext
[
#include <stdlib.h>
#include <string.h>

#define context perl_context

#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#undef context

SV *
copy_sv (SV *sv)
{
  char *string;
  const char *copied_string = "ooo";
  SV *result_sv;

  dTHX;

  string = malloc (sizeof (char) * (strlen (copied_string) +1));
  strcpy (string, copied_string);

  result_sv = newSVsv (sv);

  sv_catpv (result_sv, string);

  free (string);

  return result_sv;
}

int
main (void)
{
 return 0;
}
]
_ACEOF

  if ac_fn_c_try_link "$LINENO"
  then
    libperl_link=yes
  else
    libperl_link=no
  fi

  rm -f core conftest.err conftest.$ac_objext conftest.beam \
    conftest$ac_exeext conftest.$ac_ext

dnl ]], [libperl_link=yes], [libperl_link=no])

  AC_MSG_RESULT($libperl_link)

  LIBS=$old_LIBS
  CFLAGS=$saved_CFLAGS
  CPPFLAGS=$saved_CPPFLAGS
  LDFLAGS=$saved_LDFLAGS
])

