#include "stdafx.h"
#include "CodeX86.h"
#include "Gc.h"
#include "Core/GcCode.h"
#include "CodeTable.h"

namespace storm {
	namespace x86 {

		void writePtr(void *code, const GcCode *refs, Nat id) {
			const GcCodeRef &ref = refs->refs[id];
			size_t ptr = size_t(ref.pointer);
			void *write = ((byte *)code) + ref.offset;

			switch (ref.kind) {
			case GcCodeRef::jump:
				unalignedAtomicWrite(*(size_t *)write, ptr - (size_t(write) + sizeof(size_t)));
				invalidateSingleICache(write);
				break;
			default:
				dbg_assert(false, L"Unknown pointer type.");
				break;
			}
		}

		void finalize(void *code) {
			(void)code;
		}

	}
}
