// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class NetworkActiveValuesIPv6 : ICloneable {
    public object Clone() {
      NetworkActiveValuesIPv6 copy = new NetworkActiveValuesIPv6();
      copy.enabled = this.enabled;
      copy.autocfg = this.autocfg;
      copy.ipaddrs = this.ipaddrs;
      copy.routes = this.routes;
      copy.ra_managed = this.ra_managed;
      copy.ra_otherconf = this.ra_otherconf;
      copy.dns_suffixes = this.dns_suffixes;
      copy.dns_ip_1 = this.dns_ip_1;
      copy.dns_ip_2 = this.dns_ip_2;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["enabled"] = this.enabled;
      json["autocfg"] = (int)this.autocfg;
      json["ipaddrs"] = new JsonArray(this.ipaddrs.Select(
        _value => (JsonValue)(_value)));
      json["routes"] = new JsonArray(this.routes.Select(
        _value => (JsonValue)(_value.Encode())));
      json["ra_managed"] = this.ra_managed;
      json["ra_otherconf"] = this.ra_otherconf;
      json["dns_suffixes"] = new JsonArray(this.dns_suffixes.Select(
        _value => (JsonValue)(_value)));
      json["dns_ip_1"] = this.dns_ip_1;
      json["dns_ip_2"] = this.dns_ip_2;
      return json;
    }

    public static NetworkActiveValuesIPv6 Decode(LightJson.JsonObject json, Agent agent) {
      NetworkActiveValuesIPv6 inst = new NetworkActiveValuesIPv6();
      inst.enabled = (bool)json["enabled"];
      inst.autocfg = (Com.Raritan.Idl.net.AutoConfigs)(int)json["autocfg"];
      inst.ipaddrs = new System.Collections.Generic.List<string>(json["ipaddrs"].AsJsonArray.Select(
        _value => (string)_value));
      inst.routes = new System.Collections.Generic.List<Com.Raritan.Idl.net.IPv6RoutingEntry>(json["routes"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.net.IPv6RoutingEntry.Decode(_value, agent)));
      inst.ra_managed = (bool)json["ra_managed"];
      inst.ra_otherconf = (bool)json["ra_otherconf"];
      inst.dns_suffixes = new System.Collections.Generic.List<string>(json["dns_suffixes"].AsJsonArray.Select(
        _value => (string)_value));
      inst.dns_ip_1 = (string)json["dns_ip_1"];
      inst.dns_ip_2 = (string)json["dns_ip_2"];
      return inst;
    }

    public bool enabled = false;
    public Com.Raritan.Idl.net.AutoConfigs autocfg = Com.Raritan.Idl.net.AutoConfigs.STATIC;
    public System.Collections.Generic.IEnumerable<string> ipaddrs = new System.Collections.Generic.List<string>();
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.net.IPv6RoutingEntry> routes = new System.Collections.Generic.List<Com.Raritan.Idl.net.IPv6RoutingEntry>();
    public bool ra_managed = false;
    public bool ra_otherconf = false;
    public System.Collections.Generic.IEnumerable<string> dns_suffixes = new System.Collections.Generic.List<string>();
    public string dns_ip_1 = "";
    public string dns_ip_2 = "";
  }
}
