% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_label.R
\name{remove_label}
\alias{remove_label}
\title{Remove variable labels from variables}
\usage{
remove_label(x, ...)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's select-helpers.
See 'Examples'.}
}
\value{
\code{x} with removed variable labels
}
\description{
Remove variable labels from variables.
}
\examples{
data(efc)
x <- efc[, 1:5]
get_label(x)
str(x)

x <- remove_label(x)
get_label(x)
str(x)
}
\seealso{
\code{\link{set_label}} to manually set variable labels or
           \code{\link{get_label}} to get variable labels; \code{\link{set_labels}} to
           add value labels, replacing the existing ones (and removing non-specified
           value labels).
}
