% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createNormalDatabase.R
\name{createNormalDatabase}
\alias{createNormalDatabase}
\title{Create database of normal samples}
\usage{
createNormalDatabase(
  normal.coverage.files,
  sex = NULL,
  coverage.outliers = c(0.25, 4),
  min.coverage = 0.25,
  max.missing = 0.03,
  low.coverage = 15,
  plot = FALSE,
  ...
)
}
\arguments{
\item{normal.coverage.files}{Vector with file names pointing to 
coverage files of normal samples.}

\item{sex}{\code{character(length(normal.coverage.files))} with sex for all
files.  \code{F} for female, \code{M} for male. If all chromosomes are
diploid, specify \code{diploid}. If \code{NULL}, determine from coverage.}

\item{coverage.outliers}{Exclude samples with coverages below or above
the specified cutoffs (fractions of the normal sample coverages median).
Only for databases with more than 5 samples.}

\item{min.coverage}{Exclude intervals with coverage lower than 
the specified fraction of the chromosome median in the pool of normals.}

\item{max.missing}{Exclude intervals with zero coverage in the
specified fraction of normal samples.}

\item{low.coverage}{Specifies the maximum number of total reads 
(NOT average coverage) to call a target low coverage.}

\item{plot}{Diagnostics plot, useful to tune parameters.}

\item{\dots}{Arguments passed to the \code{prcomp} function.}
}
\value{
A normal database that can be used in the
\code{\link{calculateTangentNormal}} function to retrieve a coverage
normalization sample for a given tumor sample.
}
\description{
Function to create a database of normal samples, used to normalize
tumor coverages.
}
\examples{

normal.coverage.file <- system.file("extdata", "example_normal.txt", 
    package="PureCN")
normal2.coverage.file <- system.file("extdata", "example_normal2.txt", 
    package="PureCN")
normal.coverage.files <- c(normal.coverage.file, normal2.coverage.file)
normalDB <- createNormalDatabase(normal.coverage.files)

}
\seealso{
\code{\link{calculateTangentNormal}}
}
\author{
Markus Riester
}
