# https://github.com/FreeRDP/FreeRDP/blob/master/cmake/FindMbedTLS.cmake

find_path(MBEDTLS_INCLUDE_DIR
	NAMES mbedtls/ssl.h
	PATH_SUFFIXES include
	HINTS ${MBEDTLS_ROOT})

find_library(MBEDTLS_LIBRARY
	 NAMES mbedtls
	 PATH_SUFFIXES lib
	 HINTS ${MBEDTLS_ROOT})

find_library(MBEDCRYPTO_LIBRARY
	 NAMES mbedcrypto
	 PATH_SUFFIXES lib
	 HINTS ${MBEDTLS_ROOT})

find_library(MBEDX509_LIBRARY
	 NAMES mbedx509
	 PATH_SUFFIXES lib
	 HINTS ${MBEDTLS_ROOT})

find_library(MBEDTLS_STATIC_LIBRARY
	 NAMES libmbedtls.a
	 PATH_SUFFIXES lib
	 HINTS ${MBEDTLS_ROOT})

find_library(MBEDCRYPTO_STATIC_LIBRARY
	 NAMES libmbedcrypto.a
	 PATH_SUFFIXES lib
	 HINTS ${MBEDTLS_ROOT})

find_library(MBEDX509_STATIC_LIBRARY
	 NAMES libmbedx509.a
	 PATH_SUFFIXES lib
	 HINTS ${MBEDTLS_ROOT})

if(MBEDTLS_INCLUDE_DIR)
	set(MBEDTLS_FOUND TRUE)
endif()
if(MBEDTLS_LIBRARY)
	set(MBEDTLS_LIBRARIES ${MBEDTLS_LIBRARY} ${MBEDCRYPTO_LIBRARY} ${MBEDX509_LIBRARY})
endif()
if(MBEDTLS_STATIC_LIBRARY)
	set(MBEDTLS_STATIC_LIBRARIES ${MBEDTLS_STATIC_LIBRARY} ${MBEDX509_STATIC_LIBRARY} ${MBEDCRYPTO_STATIC_LIBRARY})
endif()

if(MBEDTLS_FOUND)
	if(NOT MBEDTLS_FIND_QUIETLY)
		if (MBEDTLS_LIBRARIES)
			message(STATUS "Found MBEDTLS_LIBRARIES: ${MBEDTLS_LIBRARIES}")
		endif()
		if (MBEDTLS_STATIC_LIBRARIES)
			message(STATUS "Found MBEDTLS_STATIC_LIBRARIES: ${MBEDTLS_STATIC_LIBRARIES}")
		endif()
	endif()
else()
	if(MBEDTLS_FIND_REQUIRED)
		message(FATAL_ERROR "mbed TLS was not found")
	endif()
endif()

mark_as_advanced(MBEDTLS_INCLUDE_DIR MBEDTLS_LIBRARY)