/* foundry-symbol-navigator.h
 *
 * Copyright 2025 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <libdex.h>

#include "foundry-path-navigator.h"
#include "foundry-symbol.h"
#include "foundry-version-macros.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_SYMBOL_NAVIGATOR (foundry_symbol_navigator_get_type())

FOUNDRY_AVAILABLE_IN_1_1
G_DECLARE_FINAL_TYPE (FoundrySymbolNavigator, foundry_symbol_navigator, FOUNDRY, SYMBOL_NAVIGATOR, FoundryPathNavigator)

FOUNDRY_AVAILABLE_IN_1_1
FoundrySymbolNavigator *foundry_symbol_navigator_new        (FoundrySymbol          *symbol);
FOUNDRY_AVAILABLE_IN_1_1
FoundrySymbol          *foundry_symbol_navigator_dup_symbol (FoundrySymbolNavigator *self);

G_END_DECLS
