README
======

This distribution of CGAL includes:

| File or directory | Description                                                                                      |
|-------------------|--------------------------------------------------------------------------------------------------|
| `AUTHORS`         | current and former authors of CGAL                                                               |
| `CHANGES.md`      | history of changes of CGAL                                                                       |
| `CGALConfig.cmake`| [CMake package] configuration file for CGAL                                                      |
| `CGALConfigVersion.cmake` | [CMake package] version file for CGAL                                                    |
| `CMakeLists.txt`  | main CMake project configuration file                                                            |
| `INSTALL.md`      | information about the installation process                                                       |
| `LICENSE`         | describes the license of CGAL                                                                    |
| `LICENSE.BSL`     | text of the Boost Software License (BSL) license                                                 |
| `LICENSE.COMMERCIAL` | text of the GeometryFactory Commercial license                                                |
| `LICENSE.GPL`     | text of the GNU General Public License (GPL) v3 license                                          |
| `LICENSE.LGPL`    | text of the GNU Lesser General Public License (LGPL) v3 license                                  |
| `LICENSE.RFL`     | text of the ETH Zurich Random Forest algorithm License (RFL) license                             |
| `README.md`       | this file                                                                                        |
| `VERSION`         | version number of this release of CGAL                                                           |
| `auxiliary/`      | directory containing miscellaneous things, such as icons needed for the demos on macOS           |
| `cmake/`          | some scripts needed by the CMake build system                                                    |
| `data/`           | directory containing various geometric data used by examples and demos of CGAL                   |
| `demo/`           | many demo programs for the various packages of CGAL. These programs produce visual output.       |
| `doc_html/`       | documentation, such as the CGAL Installation Guide                                               |
| `examples/`       | programs illustrating the usage of various packages of CGAL.                                     |
| `include/`        | the include files for the CGAL library (as well as small external libraries, see the file `LICENSE`) |
| `lib/`            | contains [CMake package] configuration files for CGAL                                            |
| `scripts/`        | some useful scripts for CGAL programmers                                                         |

[CMake package]: https://cmake.org/cmake/help/latest/manual/cmake-packages.7.html
