/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Collections;

final class JTreeAddRootIfInvisibleTask {
    @RunsInCurrentThread
    static TreePath addRootIfInvisible(JTree tree, TreePath path) {
        if (path == null) {
            return path;
        }
        Object root = tree.getModel().getRoot();
        if (tree.isRootVisible() || root == null) {
            return path;
        }
        if (path.getPathCount() > 0 && root == path.getPathComponent(0)) {
            return path;
        }
        List newPath = Collections.list((Object[])path.getPath());
        newPath.add(0, root);
        return new TreePath(newPath.toArray());
    }

    private JTreeAddRootIfInvisibleTask() {
    }
}

