/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.data;

import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.query.JTableColumnByIdentifierQuery;
import org.fest.util.Strings;

public class TableCellByColumnId
implements TableCellFinder {
    public final int row;
    public final Object columnId;

    public static TableCellBuilder row(int row) {
        return new TableCellBuilder(row);
    }

    protected TableCellByColumnId(int row, Object columnId) {
        this.row = row;
        this.columnId = columnId;
    }

    @RunsInEDT
    public TableCell findCell(JTable table, JTableCellReader cellReader) {
        return TableCellByColumnId.findCell(table, this.row, this.columnId);
    }

    @RunsInEDT
    private static TableCell findCell(final JTable table, final int row, final Object columnId) {
        return GuiActionRunner.execute(new GuiQuery<TableCell>(){

            @Override
            protected TableCell executeInEDT() {
                int column = JTableColumnByIdentifierQuery.columnIndexByIdentifier(table, columnId);
                if (column == -1) {
                    TableCellByColumnId.failColumnIndexNotFound(columnId);
                }
                table.convertColumnIndexToView(table.getColumn(columnId).getModelIndex());
                return new TableCell(row, column);
            }
        });
    }

    private static ActionFailedException failColumnIndexNotFound(Object columnId) {
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find a column with id ", Strings.quote((Object)columnId)}));
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[row=", String.valueOf(this.row), ", columnId=", Strings.quote((Object)this.columnId), "]"});
    }

    public static class TableCellBuilder {
        private final int row;

        TableCellBuilder(int row) {
            this.row = row;
        }

        public TableCellByColumnId columnId(Object columnId) {
            return new TableCellByColumnId(this.row, columnId);
        }
    }
}

