#!/usr/bin/perl -w

#Convert David Joyner and Andrew Southern notation to my notation.
# f1-f8 -> fn -> f(w, (9-n)%8);
# ignore inverse f
# r1-r4-> rn-> rCW(w, n-1);
# r1^-1-r4^-1-> rn-> rCCW(w, n-1);
# repeat for other powers

&search;

sub search {
  local ($col, $row, $op, $first);
  local ($ccw, $pow, $i);

  $col = $row = 0;
  $op = 'n';
  $ccw = 0;
  $pow = 0;
  $neg = 0;
  $first = 0;
  printf("	");
  while (<>) {
    if (!($_ =~ /^#/)) {
      @chars = split(//);
      $col = 0;
      foreach $c (@chars) {
        $col++;
        if ($c =~ /[f]/) { # flip
          $op = 'f';
        } elsif ($c =~ /[r]/) { # rotate
          $op = 'r';
        } elsif ($c =~ /[\*,]/) {
          #GAP uses '*', MAPLE uses ','
          if ($op eq 'f') {
            $first = 1;
            printf("f(w, $n);");
          } elsif ($op eq 'r') {
            if ($first == 1) {
              printf("\n	");
              $first = 0;
            }
            if ($pow == 0) {
              $pow = 1;
            }
            for ($i = 0; $i < $pow; $i++) {
              if ($neg == 1) {
                printf("rCCW(w, $n); ");
              } else {
                printf("rCW(w, $n); ");
              }
            }
          }  
          $op = 'n'; # noop
          $pow = 0;
          $neg = 0;
        } elsif ($c =~ /[0123456789]/) {
          if ($op eq 'f' && $pow == 0) {
#            $n = (8-$c) % 8; # used for long2cycle
            $n = (9-$c) % 8;
          } elsif ($op eq 'r' && $pow == 0) {
            $n = $c - 1;
          } elsif ($op eq 'r' && $pow == 1) {
            $pow = $c;
          }
        } elsif ($c =~ /[\^]/) {
          $pow=1;
        } elsif ($c =~ /[-]/) {
          $neg = 1;
        } elsif ($c =~ /[()]/) {
          # ignore for now
        }
      }
      $row++;
    }
  }
#last one will not have a "*"
          if ($op eq 'f') {
            $first = 1;
            printf("f(w, $n);");
          } elsif ($op eq 'r') {
            if ($first == 1) {
              printf("\n");
              $first = 0;
            }
            for ($i = 0; $i < $pow; $i++) {
              if ($neg == 1) {
                printf("rCCW(w, $n); ");
              } else {
                printf("rCW(w, $n); ");
              }
            }
          }
  printf("\n");
}
