(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    251721,       4626]
NotebookOptionsPosition[    248325,       4531]
NotebookOutlinePosition[    248661,       4546]
CellTagsIndexPosition[    248618,       4543]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Sierra shape functions - reference element is [-1,1]x[-1,1]x[0,1]\
\>", "Section",
 CellChangeTimes->{{3.5685932241084003`*^9, 3.568593247555078*^9}}],

Cell[BoxData[
 RowBox[{"shapefn", "=", 
  RowBox[{"Table", "[", 
   RowBox[{"0", ",", 
    RowBox[{"{", "5", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.568580360287612*^9, 3.568580377110589*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", "4"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "r"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "s"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "t"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", "4"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", "r"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "s"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "t"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", "4"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", "r"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "t"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"1", "/", "4"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "r"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "t"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", "t"}], ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.5685803452827253`*^9, 3.568580345283263*^9}, {
  3.568580379364925*^9, 3.568580394343587*^9}}],

Cell["\<\
check on partition of unity property\
\>", "Text",
 CellChangeTimes->{{3.5685932241084003`*^9, 3.568593247555078*^9}, {
  3.568593544123304*^9, 3.568593555551853*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"shapefn", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.5685837063392973`*^9, 3.568583724892139*^9}}],

Cell[BoxData[
 RowBox[{"sft", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"shapefn", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.568584030641863*^9, 3.568584041157604*^9}}],

Cell[BoxData[
 RowBox[{"verts", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5685849313760633`*^9, 3.5685849693467627`*^9}, {
  3.568585115125445*^9, 3.5685851421935043`*^9}, {3.5685933847798767`*^9, 
  3.568593404885953*^9}}],

Cell["check on Dirac condition", "Text",
 CellChangeTimes->{{3.5685932241084003`*^9, 3.568593247555078*^9}, {
  3.5685935720317087`*^9, 3.5685935792220793`*^9}}],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"shapefn", "[", 
     RowBox[{"[", "i", "]"}], "]"}], "/.", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "s", ",", "t"}], "}"}], "\[Rule]", 
      RowBox[{"verts", "[", 
       RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5685849725497932`*^9, 3.5685850099377623`*^9}, {
  3.568585064034095*^9, 3.568585080326043*^9}, {3.56859351184232*^9, 
  3.568593513930217*^9}}],

Cell["\<\
point on edge between node 1 and 5 - should only be nonzero for N1 and N5\
\>", "Text",
 CellChangeTimes->{{3.5685932241084003`*^9, 3.568593247555078*^9}, {
  3.5685935901134777`*^9, 3.568593620894414*^9}}],

Cell[BoxData[
 RowBox[{"sft", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"r", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], ",", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], ",", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"1", "/", "2"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5685925038848553`*^9, 3.568592559010029*^9}}],

Cell[BoxData[
 RowBox[{"sft", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"r", "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"t", "\[Rule]", "1"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5685925651942997`*^9, 3.5685925818347473`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sf", "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{"-", "1"}], 
   RowBox[{"(", 
    RowBox[{"1", "-", "t"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5685839276059217`*^9, 3.568583970116186*^9}, {
  3.568584002725069*^9, 3.568584007802408*^9}}],

Cell[BoxData[
 RowBox[{"sf", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.568583976073823*^9, 3.5685839781694603`*^9}, {
  3.56858401200815*^9, 3.568584020607606*^9}}],

Cell[BoxData[
 RowBox[{"sf", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.5685906781614323`*^9, 3.568590678990695*^9}}],

Cell["\<\
Face 1-2-5 - note nonlinearity, incompatible with tri-face bases\
\>", "Text",
 CellChangeTimes->{{3.5685932241084003`*^9, 3.568593247555078*^9}, {
  3.568593655509774*^9, 3.568593713226953*^9}}],

Cell[BoxData[
 RowBox[{"sft0", "=", 
  RowBox[{
   RowBox[{"sft", "/.", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{"sf", "[", "t", "]"}]}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.5685840456251917`*^9, 3.568584065353416*^9}, {
  3.568591594619877*^9, 3.568591597778672*^9}}],

Cell["Edge 1-5 - note nonlinearity", "Text",
 CellChangeTimes->{{3.5685932241084003`*^9, 3.568593247555078*^9}, {
  3.568593655509774*^9, 3.568593713226953*^9}, {3.568594209075979*^9, 
  3.568594230080648*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"sft0", "/.", 
    RowBox[{"r", "\[Rule]", 
     RowBox[{"sf", "[", "t", "]"}]}]}], "/.", 
   RowBox[{"s", "\[Rule]", 
    RowBox[{"sf", "[", "t", "]"}]}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.5685921859179907`*^9, 3.568592187193247*^9}, {
  3.568592438962392*^9, 3.568592453036304*^9}, {3.568594218081498*^9, 
  3.5685942233389683`*^9}}],

Cell[BoxData[
 RowBox[{"d3d", "=", 
  RowBox[{"Outer", "[", 
   RowBox[{"D", ",", "shapefn", ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "s", ",", "t"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.568580402498201*^9, 3.568580414016119*^9}}],

Cell[BoxData[
 RowBox[{"d3d", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.56858042462578*^9, 3.5685804280325117`*^9}}],

Cell[BoxData[
 RowBox[{"d3d", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.568580459070413*^9, 3.568580461479883*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"d3d", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "\[Rule]", "0"}], ",", 
     RowBox[{"s", "\[Rule]", "0"}], ",", 
     RowBox[{"t", "\[Rule]", 
      RowBox[{"24", "/", "50"}]}]}], "}"}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.568579079535315*^9, 3.568579099538196*^9}, {
  3.568584634424741*^9, 3.568584644161304*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"d3d", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "i"}], "]"}], "]"}], 
        RowBox[{"xi", "[", 
         RowBox[{"j", ",", "k"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Code",
 InitializationCell->False,
 CellChangeTimes->{{3.568578631235241*^9, 3.568578699155265*^9}, {
   3.568578760912752*^9, 3.5685787807236958`*^9}, {3.568579165121344*^9, 
   3.568579165596537*^9}, {3.5685804696863747`*^9, 3.568580470218897*^9}, 
   3.5686389786506233`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "=", " ", 
   RowBox[{"x", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "\[Rule]", "0"}], ",", 
      RowBox[{"s", "\[Rule]", "0"}], ",", 
      RowBox[{"t", "\[Rule]", 
       RowBox[{"49", "/", "50"}]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.568580514743106*^9, 3.568580530171237*^9}, {
  3.568584671621427*^9, 3.5685846729774523`*^9}, {3.568584706840274*^9, 
  3.568584717532853*^9}, {3.5686390037813807`*^9, 3.5686390106520863`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"4", " ", "x"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "\[Rule]", "0"}], ",", 
      RowBox[{"s", "\[Rule]", "0"}], ",", 
      RowBox[{"t", "\[Rule]", "1"}]}], "}"}]}], "//", "Simplify"}], "//", 
  "MatrixForm"}]], "Code",
 InitializationCell->False,
 CellChangeTimes->{{3.568578809823742*^9, 3.568578836263883*^9}, {
  3.568578945570552*^9, 3.56857895491404*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", "x1", "]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.568580494499257*^9, 3.568580496958352*^9}, 
   3.568580543687819*^9, {3.568584691715843*^9, 3.568584692170588*^9}}],

Cell[BoxData[
 RowBox[{"xc", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"xi", "[", 
     RowBox[{"j", ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.568639051570175*^9, 3.568639093647202*^9}}],

Cell[BoxData[
 RowBox[{"y", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d3d", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "i"}], "]"}], "]"}], 
       RowBox[{"verts", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "k"}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.568639124881195*^9, 3.5686391384896*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"y1", "=", " ", 
   RowBox[{"y", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "\[Rule]", "0"}], ",", 
      RowBox[{"s", "\[Rule]", "0"}], ",", 
      RowBox[{"t", "\[Rule]", "u"}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.568639320868822*^9, 3.568639323357224*^9}, 
   3.568639359957038*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", "y1", "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.568639328130845*^9, 3.5686393306149197`*^9}, {
  3.5686393716183968`*^9, 3.568639373096876*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Correct shape functions - reference element is [0,1]x[0,1]x[0,1/2]\
\>", "Section",
 CellChangeTimes->{{3.5685932241084003`*^9, 3.568593247555078*^9}, {
  3.568593738972515*^9, 3.568593753881207*^9}}],

Cell["\<\
From 
     cs.brown.edu/cgc/cgc98/final/final19.ps
     www.global-sci.org/aamm/freedownload/32-131.pdf 
     \
\>", "Text",
 CellChangeTimes->{{3.568580564099571*^9, 3.56858058636662*^9}, 
   3.5685808024103727`*^9, {3.568581205772533*^9, 3.568581223741148*^9}}],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3UurZdd5N3o5Pg5ycKMaQg4kltmNQgoIRBUBQRqSz6mGidQxOhRYRA2/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    "], {{0, 839}, {1442, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSizeRaw->{1442, 839},
  PlotRange->{{0, 1442}, {0, 839}}]], "Output",
 CellChangeTimes->{3.568639737485772*^9, 3.568639838236302*^9, 
  3.568639868523981*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzs3Qe4ZFlVPvyy6sbuvhN6hiAZFAXEhAQJZsSIAgZMICNBBsTMgI4oqCiC
iiKgoqgoJhRBxARiwowRFBNgQIyYc+Tbv733e2pXdd3q2zMDj8//8zxTd7pO
nbPDWu+KO937is9++EMfdcVnX/ngK27xAZ95xac//MoHf9Yt7vVpn1luLd5q
Ntt53Gw2f/YtZv79ptksf95U/lv/8wR/PPD/45+urDcWs5e85CWzb/u2b6uf
ef27mP3Gb/zGrD/W3tjrD//DP/zD7Ed/9Ef7Y+3vX/7lX04Pt+d2Zj/yIz9S
f/2Zn/mZ2b/927/9y3GV3+te95odHBzUz7z+Xcwe97jHba78ta997ey93/u9
+2Pt7y/8wi9MD+/2v9///d8/u8ENbjD7wR/8wdlv/uZvzv7zP/9zdk4LHtkL
dX3iJ37i7G//9m/br6f7D1/7tV87e6u3eqvZVVddNTuo9/Znv/M7vzO71a1u
NdvZ2Zk9/vGPn/3N3/zN7Pu+7/tm//Iv/zL75+ukhj/5kz+ZPfzhD5995Ed+
5Oy7vuu76t2v//qvnz3taU+7jmpAjTe+8Y2Vbf/0T/9U72r/277t26aG5/bX
X/WqV81+/Md/vH726t9FbWAIvqh/D2evec1rpud+5Vd+ZfbP/9wK+qVf+qV6
z//bswezv//7v5+97nWvq9/++q//evazP/uz9ZmXv/zls7/4i7/Y6QX/3d/9
3VTkvFf90z/907N//Md/HKrenf3hH/7h7Cd/8ienZ//sz/5sdtSf0NTc3+1l
/NzP/Vzlmifm/Tm9/8Vf/MXZT/zET8wu6vd+67d+a3r3oL+LHKi3BPp+LSvP
+fzXf/1XfQZS5r1mXfZcBOXVr351Ka399mu/9msTOf/7v/+7k6oRvJOkvq+f
//7v/z575StfuejN+f3f//1aXeNBazbyIFN7ov1V5CrH9iqZdHfkWPneWrxT
W5hXCnN3ekm//du/XRtJqFK6t//1X/+1y335mx9e8YpXrEnmflUHoZSeuasL
v/d7vzdLJX/wB38w+5//+Z+huTu1rLxXtMBu//ENb3jD7Kd+6qdWQOJRryum
NWW/MhegvFUIWP//R3/0RxU4eY8iKZqq/naql08NroNQF+B26m/5+6u/+qvT
c4V0aR6+wdvIjFF8jjptRqxrBj4Hm0QljEoTfvmXf7li7Hd/93enct2L2KVZ
Eb/+uajzXnWPfOQjZ/e+973r59GPfjRoR2rwJRKV0kOwsRUEN0RNjXCTGgtR
DnuN6BXWhxfl//MNNJl3pPzxH//xOTT5j//4j8qS+dAqMkVO0lLFRyhO97JG
9QiuniR3YHvQeeCdUd2BSXQRWPz6r//6CkWCXm0PcomFcsh+ntP28CXqkuAO
cKn98gu8EMxGy6U0rOJlVRpKWWkmEq03cyTHmf46M5rXCxmCNIIdrZfXccGv
470I0KhO/uqv/mpSOz4MQinvdNf5kdHRRviFUvz5n//5Rdc6qQ09Skt2uvId
FUlI7k3Gq/yWdr3+9a+fHtnpXB2B5/9euag/MVqH8onQMgYRnBQ9Kundoct5
XQs1esA0LK1SabfyMrLs8+d//uf9t+bb5LdUCw8pI1geLXrslqcxPmqLR6Ks
ZXMXk+yM5Y/2bKdDJFIeuQt2oxFG816wuw7TZfE7tQm62JmQRz3GTCFa7qXE
pQbYq/dG0IB36cG8o0LHR1QQUnzqiP/O0ZPZnz3sYQ+rLqHPJZdcUkm4WCxm
17ve9UqF9e7sWc961jklfs/3fM/sXd/1XWcPfehDZ5/2aZ82e8ITnjB70Yte
NHvZy142u9GNbjS7613vOvuGb/gGeJx36Qaed3/3d6+y9B3f8R2zL/mSL6nV
v8d7vMfsYz7mYwZnaL/SQOVHR0dVS1122WWzt3/7t69aYd6Fh0Z4/vOfP7vv
fe87+5AP+ZDqHX7WZ31WrbZooTPdYn3TN33T1EMf1+Hh4ez6179+/X6HO9yB
HMaiPve5z52dPXu2EuG7v/u7o/wf9ahH1acvvvji0oBy7davu7OLLrqoer4f
//EfXxkAN62st6vYcu+jPuqjZve4xz1qC+ETVn/sx36s3uNdfvmXf3nVjSIO
BH3hC19Ynf3P+7zPm97xDIxRWhjwvu/7vrVuDEOl2972trMf+IEfoDZm7/Ve
7zX73u/93tkXf/EX14Yr47M/+7MrxQv1T3UiI+bbvd3bVb679E2n3ud93qd3
4XT1GEi0IhT7qZ/6qbVpqKpqDj+sXHnllZ0xR7Mv/dIvnSi9u7tbKf0pn/Ip
Faif9EmfVAMUl2fYWQoqIAFuJvvqq6+e3f72t5898IEPnH36p396JQWAIGlr
240qGV784hfX57RP2374h3+4soBCe+xjH1vblnaq7yu+4ismva8uNPicz/mc
Gj593Md93OyDP/iDZx/+4R8++8Zv/MbqRZVnW9NuMPv2b//2yq29vb2KDij5
gA/4gFqdYk+dOlW7dfnll8/udre7Te7lB33QB1WOf9mXfdnsMY95TG3qZ37m
Z1Yyaq7mhCWssfeVD6SarHsvfelLO4lOVRLQil/5lV9ZZed+97vf7CM+4iNm
H/qhHzp7ylOeUn8rpI7DQPbf7d3ebWoebiv2m7/5m2fxfFgNUvye7/meFTCf
8RmfwSkIQ/XuJje5SWWmjxYiEm0Fm/v7+1PP9ZYdHxmKyHoeIqMAbJIBTExU
xu944hOfWIE2r0/tzO50pztV+WJFC6VP9yaB981vfvPaq/l8XpmhV3595jOf
OTt9+vSEab3nic67iCOgJiJWIdq8Um+nSiOaUtmlpp0uAcw/hf+IRzyiCp3/
f8EXfEGtBVGgC8qe85zn9Bouqx2hmnT4Pve5T6UpQj3vec+rQv7O7/zOs3d6
p3eafdVXfVW1AmBwu9vdrhJSby699NIqhVB8phPSpYlQ7b0HPehBFWYkJN5M
a/MtqqRRKIgJ0R/90R9d1aQyn/GMZ1RjFilgie5///tX5kU3ouQLXvCC+vu3
fMu31O+jZVA3xpK4UJqUa0+B37zbTKTDe1LyyZ/8yfXxr/mar6lVegJPOdzw
9UVf9EWN5YsqKNQVR+R0N9Yoyq1nZ6BUj+azD/uwDyvVPP3pT68uUkw2feX3
6LX0qFO0EfTyGrRBo0e17qu/+qtr/B9P6yEPeUhlBIZgjCJkHPyus1SK+whS
1NoYx8vyMG1qjPKVFik9Ot1rh2mgddHj2OMX3hiTFOWpVlCLWwh+YRVN5Pd7
3etecaF14sEPfnDVz9Q9qaab6VNKiE7bGeIdSogO1kp6u4Rlp7uewT2qmd77
hE/4hCrZwMbSYAPPqrAlekYgrr9MtevMmTO1cUz7bpclXJSEYuQ8G83OuL3N
27xNJSfS+j30jJknR6OZp6FLkJPqFbGuo1TPZh514iCA6573vGfNG6laVXe5
y10qiwDsoOuij/3Yj62Eo+N2e1PQH2LiKDFk6kCV8lxr8W0qDtmlSL8Wf+EX
fuHsO7/zO6uJBhySrAcIzMaqKm5H2EoZVdPTfbPoM92UAmMUGAeU1pxodu9w
st7v/d6vQmvkRlFu884MGGejUODud797Nc1ASlP7rpmYQdziHVFUN73pTWtT
iw+35kyitY77UFNh57Of/ewirO5eUmEyOpP8rZvd7GbVEQGP+OPAqFO3vvWt
a7miqwLiGEEN9zO6sWQpFotoOOgqvmh7/GyNcHlVD3jAAyo5vu7rvq6ma6Vt
EzpRlPqtnUl4EBHRAGVY1EpEQ23pqI8LtYvDWL/zgosqCdWoYdTU4Cc96Unx
KVlmT0Nz9yl93as4VZx3MFvtk6RdUkOO29zmNhUnTKi7lJm4giuI5NxOGpou
hTsk5nQX97AVc70q30qmLsCQQRCQctWoTKhmrP70T/+0epXQTlMzLFG16MTw
USG4d9iRkHQ4qXJxsfRN+XEt43TwYUJvZjmcv+Utb1lZS8/EsKo7BIcYdUOL
vrAmsOryjAyTSDD6nBZ9h3d4h6opqMHE91wDLqdPaKN/RJVS4qm4i+mMIbL6
XVYDjtBFW9Wp/dqiP1QwLV8sW83jxf0ADhaRPi1sC0RZMHbjHd/xHWdv/dZv
PXvyk59cu6Q4r3O4XLQCBNScdnkT+ehFElG6m14BBHPs0XiXoipKR4DmNdyn
ROSK0joc4jAxX4UycQERSRjDNFECWuUXrdAhzidDieEIgVhHvVoeDu+HLlKO
u1JTqg9jqV7DEoI8Io9ZEmkITQDvfOc7196z9e4nQQ90uoQBxGzpeu7UMoEA
ZYpHdNhvk2lW1mci2G7tCfXAN/uhH/qhCplTvXXgotdUBMOCN3rpV+42/wlk
iQ6JDG9QCU/BTtkUWVqHElyMO97xjvgc143EfeAHfmC1T9FOJJDLx7RS5LyQ
KDwEijOMrxlCoFwE7nQwonJhI3FMqnoE6YwGa47vpaxEzS4oRFvoiwDw/FRF
OMrjIR7dIbtCXnQKy+Y9TOOcspp0axJc2OY+d8X1/u///pWgepqqfAcZZosF
SfQLxfSNSxoCwgsc4nRSZfjEwnqcuFL9fF5P4A8TxqcoPUueCbCuuOKKio7D
3iu09RiPB4AZ1QgEEGoFjaMnjDip92+2j3Im5dF6yjrdtQv6a6IPywMmekID
BTbgQXPwQIFfOeGtMOIWt7hFhQ7vbKm5TtU28Kk5BrRTNCCKK1Nbim441d1Q
qH7qU59aickQEAq/cIQpO6gWmYzVkwzwQjKXPJDfC4pj8fCVXtTS8lqUEkB/
/ud/fjUH8UIRi5qMJdPIIn+nu+jRsjSlvmq70MYv2Ay3GsdKZGQEu6lNIuoi
dhoH/8nl8ekAm4NGPGN9WBpy5hJ3MpiFttHQcRIgS5FpSpwEAiD2cG/UZwwV
k+6dohmOOqfijfr5W7/1W6t06gWU6bEh4FJsRo6V7AK4Ih7xSTGDRHzu535u
tdr8BhX1sZDGkNYVgYpuqcBdbRYjxGOXulcUvoMgcjDG3nuXd3mXWmx0gX8j
v0tYp6/ow5QwKYZpCa+4I5oS9+n9GtgX14aD4bfocvREQ2YLcDKaRMNSAMqj
e3hZS0dip7YX2Prgc3dKv7P/SkBkCXhABfghp8pd5HpSZHtteLLYMeIjWY+M
haRR2kyJSx6z6Kq0gJCJ56WHCo7ztA6JMVyl6jwt6sEq8lM0VIYpIFFXfcto
q0skghRpObYhIU1enIaL+6NmFeRKLp7+4wgkT0GR1FRxKylYJ8AFR0nZgJRM
B1pnjEFiitlBRXhPoylsEZ7nIuXUDj+UpOceB5Lp8v+8SwzZei1PCkjy1sWk
7fZmwhwVzP+YmtlGRbCKw1RYtTuQjAMjjZPaoRIiXRmSQxd2gCNUerHT5Un4
TikmPqFPDAQi3+St7VdfI1Y+qkMmhJyEz3wR3oR0Vikm3eZcEDnkyT2aiAvD
lsUigYmLW597whoKs1XQ7hExnWhapf0CR0grq1A0f/rMzKIkU1pUTRqKiTe+
8Y1rJqQogVTGmyFTHNmgTD/1EdHzHOMeOoTiQmq+orAtz8VoM5Gpmp5Ulo5N
DW0MY4pQ/6A/Csy8FtifGNb4yBhqVbl9ppcgmgX7Ngba7tGRECMHlQawxYJ0
nkupNbcpYrJPfxd85zbV5km8KUKf2xJabnOmSo+DUDZXNN2lOIOC9CzkwUZG
0ApXQjqtoXINp4x6QNYC5seWI51QsNAllbLSHmVWhhhUhyAJqaZs1aKSx4Vc
kSCVk32UTal0N8K7itwmOVrFuUAElhMSCAfiKjDqdCU8jjNYWCm8jE/O9vFG
madi2ceBeu4fJBYohEJyBhQoT/OiLpBVShaL6lokOgVzwW86y0jd8IY3rMFK
6ELeUZFoFDbmttdUITYfcEmkYWCUNarPJU6chgva/A9g4y2EsjEfTHvucZVo
S1Yw1SiSY9O+NdSwcDRJRhR5aMVanhoYJPhS1BRO7FQ3SdewvTAolGBr0uao
WfLFD6EgivlNCbQvNGjzICCsD7Mq2XKMEQslWB0amSt3cX89zg/bUfCUOAKG
mHaSy+PjqqR94nbRjFcKt/d76TJhLAuDHhNJhFzSusW5S8aLD0gsXO5IkpDP
IBdnCWbNvaxRis7IPX0nJJyV3NM6Pj/DMB8oCnNYWeK5UFRwo3N8jGJDcpu7
gYPErPz7wtyYFdu4V6WdNJzHjYGM8uhON/yyO65kc+KUDT7M1DfhFFoJh4vK
C5p1OeQ83olZ1AYSU59LNngwe51lnjPa4mKCyWPc9bgvtC4xzuAxl3+T7+Ld
tJOCYnQpsPP5LaROn8LqdB2rt/ktfEkeYedNZA9fus8yu1CnJaTw/0KGOC2o
lPGcOC3G8FxveMMb4rRIQp/PaZFRG7TZCE4KWv65KOv05aR+i7CJqRn9Fkod
m7b4LWmUmBD3OSglDgrVfCUTLMk2p4UqRnGBxWJ495o6LeJNl+CoACMdwgU4
8f84LXxpSXWWoOAv5GQD0aSXcqFOCxdSsgeyBvkVIkpFeTzzXJgJfTUmot2h
HZ3U3ZXZJn/l7ne/eyYLMeBrvsrsfM4KvcSoB6EhWe6jE80tV13kMyLDE5X9
0oPi/6WWa+mlyNW4JMOTJ6DrY6jQSr+FcWGmYFbaTl4mXgpbAIb0fzHXYSZB
ZR1ZoSLzx3spi1qrS+ic5+hm2n1E4gk8lflQu8fUXqL8kAeBoxKuQ08FGkch
Jno4MXoqsSyypoFg0YtphfiVKmGbprCoOagUlKvUss1T4fnKkFCuxT1JCXCl
0O6phEDMLaHSzGMs1fGeymLyVASBqcl73JAVqd6r3rkwgE7lSfEJCqJj87Z5
KqYgTG0+Xc0TF+Et5anAFs3hKjYo/RSpoOaapzIa7/Lvk3gqu7UskaKq6XNM
DN1HVyXNPBeBh9WBcxENGehtDgpnhvjpfuHn9Tc4I2+9wfFobuUl1QvNZegl
SSpJCwkv+pQwAHnijcHxSDpWTyMHlL54l1MrxcCvYJIKhI93QU5VK+01vKfh
dRJAtRpg4aTEJW9JT6SOVpYfMjGhuRetrmN8Dx0eZzNu8j2CeEnJya42p8Dg
gauA9sJ8j8Oa+vQv2l1RyO93I1yyHnW60Hb/I6aazBdtFlr56lpOVzi5/8Eg
XlP/I3Tq9iwxFRjKjQLF1VdfHfKRbQbCVfp8ob6GiY0u6mHwNSh1cuSKLxWr
RcQlZTf5GouOapberBK0YimlUKLdWIfucEQbHOdnZPp6/AwQc2lCprJjpuuK
K65YtyCuYp+vEz/j7EY/w2tZ38KniBOlv5Bo9Bq5xaWGcYskx91gj12kaTCU
dAAfyXXVVVddqLvBSGWg6Rq4G8bDjEnRUsWgnb0uXIvDOkDnX4wyyqAaP4Fs
SqzTwLGyrtG9oJlLPXEvYq+9VkQ+tWqYi87Z5lsAmIsWmNYQHOtbmEIoMcON
LTo5E82P8yMyQT2VGeR19QHaOFAyaEokB+6wCkV2NvkR+x33oMPgMr4Zg6LC
JdRms4n217XfIBTOVf59jN/wgq0Own7HgEQTQ64rlA4DVudNDMMxJ3EOZCS0
+yTOARQ/+clP3qlGonm4jI+sWfjmOr/DsFunu+Qig8xNRlQoS+XSYsoyMK87
FGcyFeP0XmLA5VOOrnMqXXBlcHOQsHM9hsOq9BgDTWKjwEsCUPZMop3OiRn4
X+YuBOPX0D147GMfe2HuQbMY0rpmQqrBWDRjRUye/exnj4uDLtwzgOOTegaZ
eXihXgBAFZFaVAw36UIh/nFpaBZAkgSqn2i+5TwDduqknkHeR2ljWijNvOsW
BhmlTBrimroFrizMPI9bUFh4nbgFO+tuQfpJyHGAMmHfCLkpN8QMv/n8MWon
cAUe+chHntQVSOr8Gph9xu5Rj3pUFCaJBjZp0vjQ19IViPJSAfZyjKK8xI9t
YeGS1XEFsgjwPPa/aaLr2v6bmnCMHUllF+oTUMAFeImfNAA/aRAS5K6YimBu
cww0gTSxqu4LEJgWPJ7973YMDnoX5PuZLBpN4htlUa07Bdd1woA+KlRqQF7U
SVwuUnyhPoF1Hy5ibd77chRhv7o2HD09etKTnlRNWHyB2CYCCvvkhvrjL5il
5ZkiWoHW6APkVSnijHWZHeBV2oOmLa/+v2n+iyBfqPmns6kZ6oXniE6sB4VX
kHLtzD+BfXObfxgr0F/0daMecZmoWSTskg2mvpDhzWDqoeWkpn6cvEYEiaZR
EgMqZOBaBv9ycycM/os0vTmtfFNe3H3xnAurYYwGmpYDncjAP/rRj34LGHj6
t0hYtJ+ppMhpOuW1NPB7nSKmvaEGgOgbTFGCfX+La2Hbtf26t+2oMtgDT8Ue
XFPb3uP9rGRmpbSJAc4eLEYtqLVhV4/RvGfTGlFmNicweYDwAmwVg//Ftr05
tnvTmClneAj0T2LTiXAyysfZdOMocrx9EGCUAWsHXUUfndSsZyjD3GF9YTOE
jWR8b0OH5DdXxgMOq8V3i+RSOIYTMhKlVdKim8x63udok0dF9xUf0/sgQ+W9
JW17+cu7dBm8K3zIyPcFWHYm0XWMZff4NJPt5Jbd8Io+4aChl5AJyUufzmPZ
g7wNlh3bud5vLssOXoMlGaeTutieYoOSa0TnzAnLo4yiRA/1VVpyodaeOWY2
tlj7TIJjoIxdwiTFvsna728QjWFOwYVaecbPJRgkqYqjXXhvx1j5ApU3p5Xf
qfMcGWRqsm52olFtEB6+QC6hPJu8xdIr5dWvfvWb0dLT0wjTM/ghv/ZQA7TO
dRTKM3eMBwXGNNLSkUJGhLLaZu6Bh9AcY+7Zu23mni5VpMWqdducreYen8yp
6an8kYgR0le96lUXavGBNFNGCl5CQeMdKMO85h7xII1C3U0mP0wJqHoA8Oay
8lQmyXYVoblGVj6zHAzRQLJZtROOGsnhCJOKLzzO+nXRndN09J1qZQU7yi7q
d+sii0VdJ68lJv7lnsWAXC8kumTA3foKC3rAGD9GFjWyaYVFA+denaROQZE9
MOXqD1ZE4/Daos0i4eMOFBIyfYprEECL6F3bJ2uJCjqrJZaOcwzaREX9ZZjC
VuzMsrfrcHqAxQvSSOtOAVaGh3xS0mS1UiHhfACCFjBx05q9C/IVZEXNy8LD
ohPSVUMdDAABShs4CvogdilCk+bGVzCQkq7yFSwlXxrRpuVQeEm9Y9dVqIlA
CDoHi40wRJIYTXPL96u/4JI8oF6oPFBjW04Pla/6DztVFfIzrI0adEm0k0Hd
xcBRJthCgCFRRHxwjxymJo8SFso4r1ttBUyEoBjCuEpsZjy9abLx0oWQ30kJ
+qRhUlBFtMZVCIikbQUy6/MZ5doG6WErTDbsjsRiQIvMAo0ygIjCMnhDOxWU
nM+tUJdcckpl8AFNGr60J6UCP1dKO4q+GzsCQJ5+wAMecL7lFFBspvy6d4Fs
5/Muml7gOPIAc88OQplLkAkDdBiVwrkqDEip5iDRTyrcuopik2uxM7kWnh0W
t8S7QMdh4YR5b9xOq5QGjPBQ6QJWJnA6sXdxejIJpImoZ6oLw4bvEu5ovGRo
29mN6NOA27wMvKATaNSiRUM1RXHIVDmtnDgzmVQOAG3AKtFo9Kl/axnx6Uv4
dwbWgNDKKopF1TkEjdnIPSAgNktDvl9rS4jB/gsX5Ku5ONFNSY7I1RU2hyEe
5dzSTwP7uKS8QMtrhr0S6ZtsgpNAKk4IEFAylDhZ15g1PJk9ruRxbittzerG
2sRRcU3bLDaJsiOA6053ulMaZAkHl8xP29wVdJdiR7niLV0Ld+Vwyr2IlbIO
QqAtGZadvVpvTk3IVAQOZLdFEQscsCxFgkaH4Bxv5bBiVI0MCY3jrpoNDIAN
qdrmsUicCsHITUHdZo+lTf+mvBWJUGA/DggLQkQQItwC6DE3iIPoO+0s1lQj
uy9zO62yOazw4GRm3h3O8FiYg0QD4xpOZtC9SZW3ydfaQeFlpTp/iyKkWFxe
8d1EzSBWlWwcj787M/U+TU2l8cS7R5N5aBJnWcgMZ3iYNRJapxkl6G8UuqTy
jzMH1BR6tiUFA6DmRrGo7jEGlGcm1hY5mtcm71fNQY4Vx/jRA/i39HTallfo
ZgCIrMtlhW7cTi2zTLeEIJk2TNODjFeoQ5zJlgqKM1Gxr3ed1A1hsoUc0If+
LCxI8clOdS1gWhZigaKUGmBrug5NM1hbJMwRxoYSL7XbF9fJXIIY1AejTE2n
iK3jyf4eTBcRSqaUb53tGCh6xSMKu4sHzTguJjH1CRD5S5K3dFXmRFFODACr
xT2LXBJvdVKHxbdIb4COr4LWha2jz4T0Fgc0lraRX8aXYS49ON1ZogR6yvAd
9Ps5+5+RDDrFb2x5OI84cjBkzizVcY0GQnpH8uRlL3vZTocx70afGJJMVVYN
DsHlmgtFdAGhr95K4WSq74e53AJv1YU60+0gByxyw9bR/Fn1SRxZZvqTXZz8
gLalBnsCoSCyTLm0udKGrcxZy/b1jDMtZtSzO1aLTlnugxZQ4H0eV2UzQ0I3
mo2dlWytiqOqULAr+46QO/bIPbYqu2XYtY5e4mNEUDQ1nDq11h3K1BjGcp+f
Zhl4/mbxsenkneCpiwmgZEsd847gILQZ/FY8go7NJQ15nl1Pc1NlXDWKjKMS
qYAETZdgLeiI1fEzgkO4bCrcUZnMoiiHqs2OToRPL1RO8blg0wKQNElUR8Xy
3FodN61NlGrwbHQsqtKt/q0e2kz8ivG8iMynx0mg4NEkjsVZ6lyN3VWoYui7
PhDqJnu3qvGjCIjNVn7MAS5wsa2cpu8z71hmiHLJLmHoIhuD8wRIWbHv3F8J
T16arHM2AxH4aovnV5y9pZEXTsTIIw9NyyLrenSXrtj+haZ1USHIAgFZ8tZY
c+tKEr5YxnepDREeliEhG0Vl0FjZgIeGR3a6mJgiI1GN6UNGbQBScork3Fvt
BQ/WlTpjaZWBvFQEuV7uwXQwrczP5th0Ey1DuKbc79nqYTAP5tGgHMSI9CEU
KgWiVL4wmQZM5IMLuMRRnxIpuxXvEj80YhzFeLN6QVfjBCWbHrN/RWbaENRi
ZZ3k85vX+JyuCLJsbOkjH+NJHtT2Qwny8olof6O/5nuV/sXhjBOpK+wxc8/2
4qjwjODFR1vzIJMVhzu+MkpgGAbBHyAU3G9zHqludlKupFBms/Po3l5lv3wW
qQUNkjkF7IcVoRJQdBAh0l0KRqZU2EYAY1QoAL8bZp3Xf7UdURQZ19HzWE6h
xHUMH3EBndDC29ZnKcuzRbriNkptYApwulg834EyWw7RBdJxgpzRbRRzZCrH
mttI6ecnppisoCOuYQFPq8j7bnd/cvwEjcotYXfkCFhO0Ikip6CB1jJbl6TI
vLZ3v3YO82GKK1831uw+Y9wA5pJdlBpPM+CNHWKRGZRpt5vm/Nr0itejEgae
KOqF14yRFrMYjBFeqMhOxshu9I9uL6/EUyS8AKLxglaeKB9EDXWb11a5vkif
U380K/mn3jijghS/DWEFjSlzxtQKc1TOs4NmWkZyN54iTUvcsksiqC5q/YvJ
Y1/azYNpkIHHDqfeJaKaVEiW6SoUKvtA58OJflOqmjCNKB5U71BOjNnwOFLR
v6S4mJhsseZr9lMlMNSoyo0oK1EtxfokbM4sOKQpJJpXWu1UyqFgPy8hQGDS
YBJ3Qdvad1qQnWBTVvzB5gmwhNpCiyBu9myjWejg5LPO9QZP10ZFHPg7cK5V
MTuGqzWHgkgolR3JCLV8KnmgNOCfYNP/8QRYZrKROgY3kCXMqCxLRqgpPSIA
v37DCZaw8fuy6hVrWnYpZ8WCUPCLs6F64iSm4t4hiw1GNBlmmKHTvTssqu/0
EcWrO0hI9Oh0rmEUCwcoSonDVBTPvMMTAtbdQF2CCNrC1Tahb88zpDkfIqIS
NxDldYXMIgePX9NRM5gmDu5la2uIlIWwKVyxrnH/WCj5O5WuUy1NIe+u0f2j
+Gj1zLagrESQJEyyVoSa4xygG/U49dHoMAtw4QjfwjMk2yUpietaIB7E2ezS
CrS0hpiIsBBZileUpgwaY8pfnaqJEKKaOX0Mkcye0EOzqfdJH52q/IYzPBZm
aLEIEuHoo+78RXfSZhKwtDJvJvaZIRn23uLKqpiZouloOMJFzN3nuh525PNy
0I9768JCz1IgMju+Q/lyA9UbVnrgT/xKdh/tEm+x3n1qcKUtKCAMPlL7on5G
h5AzXLrCjef6T1vUtuX+Ao7sdU8IpYrI+5TYPlsDCdE4C6EXRJ4aYvP1gIzx
Beg+MgwZvGJaDXr6wTJx+8gB8aQ54/ZFIbI2NBCLiO58JIkHijqr0ZcJwrh6
JOI8rl70Mwz4F8exeNYtl76obmXWAkbmxrFyd4Rynna/EDElrnl6OcWNjedu
e8N0Iqn1s8e6d+3gFlCvUckG3y5uYB0668c5FC2U6vgIqsqHPsysA4ok9+e9
w3J3yTmN+STmjvuRlDb0juVqoiiBWYgn4bvfMjZIUfnec37jqKJgRmQwbHKk
wwiFAGPyGbm1vLRoPnBpRevWJ8cZA8zClMRrL/XDfFZ6ygJElkJY39PL8k7G
VRBSqwGmzhlppcL56uEzbae8lJLn2JPM+zns9EJTkKBhaUUAoxG9UWQrRJDp
SIOKCGV+jprRjP/CWfVzEdhx3oGfqaWiagPwczNv+ysznbTRk0rU1Yxm8t/T
iMKljECpnBJrhro9qmFex4c6YtBqVnroH6LSCCm1dDM7H0decn7jueuOFhVF
gDUSmUJK5zb5P+O4GT9JC0OYnAG2hELL7GlDmkg1R5jAMltzBnk0FqdUuXUW
4bnNijwZbHAxV3yiToGK/ow8I+QoczCV+Uk5/inKqGMmm8AQabfwpmeuJiqN
qausN+MyufgTeU51qymr/ZWJS/0ko/q0nErOIKP+WY40C5Vy7lPyUu4nLyXk
5Eft9HrHg7JCCk5HlEHUDHSPo1f0NpU1IkJZRG85XL5f9Y4L5LkEab8kSsgq
bzSQfr+/SlGnSzRgmqT4mAvaIL/Jl69NYDrOLtBpmZWK8ooNdSn10qJELErt
/J6O//K9q6co1CSNGiX83VlJGNWDEt0+qCzJPl0+fIh++N0kwjsbih2126rg
7dZ+E4asXm95Js/vTjRzn05oKfNW1rmnlDXbkDzOuBrBs6HE5rHDuAbiw/O4
BmMH4du3bP4/+gCZGrhm8G+ywagfPy25HTPA7XEVP/dO/dFxxs/t+6P0kHiT
y16Yf/dBJw/TW952aH9O6to0mfVmG3R3ah817aUbNOh79Kr5bvy2PvXh1v3R
TZMUAN040XHzH28+GFhXn19w8/6osCJzAEKPNZG6qt/ejgBJvWji8yAArWml
C0TADbuWQBwKDYGh+zpExDv2e5nIS88fA4fwhKyK55Z293g4iD+0fF7/LqZN
G3ze5QIhQg+KJcVEx0AkuUvGEJKWtveCIKLlAoVrDREWSftOABH5hWwDdg0g
IuIS1CEmpJ0PIqNSFYtKQwjopf9u1J9nC4Vfhp9uuAE77zQ0PXucRMEKJLnr
7OcdtuNJjzT1JHhCZt2c17+LGphLbHIrToqn2wzk4KaA/GX9Ht3PhDP92wBm
HEUu7QIBNh9wIQUiAg21cULeawvoHt5v663xDT0vyjnQ2IbFndpdKqtvDDDv
yTixgt7J5NQB+3abfySoh9IXvvCFZzpzs9MkRyPIPBx+YyoEkh2dvXO71e6b
biRzG1jeoHc8R0MbUu7n4LQ2GMIUxnjpec973o17R9yOVisEu0E339wLLCYc
ORVXkfpcoHDbXpuESzJOOwOXoMZ1j3vc4w69xEwglxDJWRw6YrLC4x//+Fv1
Eg08R6fFXaaldcKjm3CcVb2LPmuWQqCwcLbQ8fZrxQyzIDsEl79RxYH22/dG
2FZflpBUFxV82YBajukS3YfVJcwhEzlEHD10uqe8JqeeAHMtx54GEaqXGRzR
r6fCRcHzlB1aVJp2Uq/oGjqFHXqHXrRi6RWJvS4Bs4gA+BuvEYs89alPPRyI
QoBU0cVgtiYHAO/yZnlk3gdQzJFDLtmtuht3u43yAdsgB8qVasoS61EOBHXG
hJInrTvwD7rEmICwJfinJlVG1Dr+2zwgKS59B9mb9NZjHyQATCko4Ad2jwED
PcSPpWap9Kc85Snv0t/WNKrVVR59t65zRc0COurHv6klFaDgbXuvKH6ZU7pi
HdFifHyX527TAHaqlaYxGZTSuiCagtU71F9HtL5JWprNsY7ozBqUoXrsYx97
j95vcQZea7GYQX4Xu4wUFeV5SS8ZeQyBoKgSliBt+3Ak7cldAXIzWOhLYGAi
PrCXw+X0nNavI5LxJnMIVPyPoEH2GR11aiMi23nDRkt8ztS/qyF+ZptQDmgC
eBKxepRqhG3cPeG/3+qul718WoL+0tOAjoZInfu9TkRMUiV4Y4GAVjdK0+Nu
iLXoYQM2ctDywNwE4huw5RkELFrmjt1YUgp64BWv9hlOwRnvkiaEZD4YdgRn
2MgXHueqa6y8lwC7dDQ4U4tegbUBMMUEZ2irsfweYVxdF9KLkwUiSNL4r3nN
a96j95fgyEobICCvGq0KJA3IcggStgCHZ2/RcYoFNKceyc+TDk4qY1XMTPBF
dEVQWi1OAZbgi8rwGi6V+2E8CQBL6XWjHBjd8fUTg4NlAIV/EF+B2lai+4Ws
j+u3Adotn2LLH9ErQfDcJhverlp6XgeQFtPIls9H9mqZT1zxW/ww5YMqKF/Z
69TiFF78gsv7o+rMkTK36u1Ii3385pkPHoCgSs8XVsRBjxHxU3mkk6a2dO3P
E/7vp//76f9++n/up7ZZUksj81R8xB917GB64/c3vMEhMSJL8xt9rdmLrW90
HVbNiBkAvKnNbzyj/rupOWreZ9H/iqIyaJjBTWqXr85q8HhkPzPsR8dRjWMZ
vk9aeWrBT25ogdECI6o+i/r3VE0njNv10uNsHgfKSC3nqLS8NaDNImBtmTYu
mEdlBVjZ8tuy/p/aUD+aZXitZTsPa7yeadIKZzeNsJp8xp9Gtct65Zl5wdcQ
7JmDz4tA+/LcOZX/Zq9XIGwtnW937fcYFbE66jUMHVVOaCP3ihuB2vL1hvIz
oOQ777ifrNTdrLYGWVrT7KKCiWVbXt7a8qO9Xv4BDsNotqpmtrm93K9k9LRP
nbg/LIlmQr0O0llepZl4wUEYTmhBLY6AR+MMqFUPOUal5wmLgRgR+X7llZbY
PVV9HM5Jpp1on/aMdCj8SKZYxGwcq04n7bs2aECgtbhAUmENX1uDUweSa047
Z8jfxTQjt5XenjMY2g9Bm+WQNB6uPIG4UHqR0A/0ElWYryNnMJJW8EInlK7k
Ub2SFOIEH/bStQLQhNJ8dyAq98I4AQc9ofNP6PRVkwQR1xT5fR+nF6/R10Q9
+2H47Ne/Ld98TemLHjlSOXWonkx7d6f+XR2iyQgRDBrxqydgdgpw9ZIdREjx
Z6HxzlBdThkNfWFTICOcesUrXpFHqTNcMtiTiUlYQaFn3xyRnQU6Wpz3KBIx
p8TeFw6Ql0PgaQ8bsOsAnoBpOm+cn//fBmv9XUzVXRMC6wa9U/OK/R5Aek8G
YtH/am7qGFfJ0QnqKbpgfdcZopnsSjFcQZnBc9EHYp0eShJnuYq2zKPmESpl
Os15Xp/cqUTOnILS0zzPHKE5JR3aor3cjqlR0zSNRWU+PX7h+rHFVjIQDAr7
Sl8e9M7LRYqjKEG0RbcSCUWLwZ/JRJIRRZQyIYsakV8HFkIjDycHJFqdjtZp
QawKKbxSUrZVVE/W2fjoEwqbt1UC23GytrclVoqKzNtaz5cwminckxuQllDJ
oBzoMbOoMPzz+6vEBDgzjRVhdN5I3rQSrKkiNlVK7aS0/pFeBYKhofyRIT/F
U4rsbqkusxKFweZ3ERnkaGmfVpV7Mjn0yHQK6UH1TIT9JjLKL5nFZ3qY0idr
1hYqShJLGJfbya8TWRkmOIjCQQ7Tt8wwT+U8Nq/3FYSZi48XXnVbag7RpemE
6wX1sbAkW1ajb2f0uP421oB/5meiOwq46vZ7rT1oxOgu7fj56d4Om2wLJ9Fc
7oovo09SQ6TUBFp+WoiPkslDgAKrHnWnPtns5Vmbe7XjElP4SfcQ8/JOps3I
GLkMq04Ub3voGLDRkunwy7ZM1Iy+vuJ6fTNEWa7Xve51e11Ds4jobXmBub1c
OGzT3dRPd8lr6H65H6KTD9TM+k5UZb41d9p5rB0twraa0+cju3Rp7zjHFe+I
tVzqcUz4ocGTkJWS4swcFemVWDtMkKgVEsBASKVpNAzLN50N1NJsUsjj/k5s
ujmTRrCKVo0TJhuFRjJPk5gt6sxPwBsPucoIS5vf0F6ve02W18G5cHZ34BVn
miktZiBbQfEvYATak12DKQkon6P6dzFN1/G5dycpVNCa8luQYdi4WMVQwtQK
LoqG3//+988kLjaIEeahb2MAD8dMY6ukMp3UjA+1pSWcADayH4OWvuJdlp8M
OxsxRas8WKpWmn9c1cmcLR3LnToB1OgIEA/jd7BKnCArRfI/vU5ko7IoNmzG
nKOB9BlBDellXdHM56j+XfWR792Rzv1Xhw8tybYEKPxsfixVkAOZjL5iZA0E
j6O4gTPjUUuKX1obNM7NZls1y3gHOrqnUGDlRmWyG2zDBF1wPP2bYWRjrFUr
/77eoHBc3VaH3EiqZir7zEBa9hoLtpF2jPqP6t/FNL/S52P7cwy9XmzMCqyT
CinSOCKSfZvavTPV38hGK+4onK2hnTLIFlIVf3gTpcZ4jVom/4kMQY9xpNzG
pfSGJgxZFASfHsgkIBbUbiLTvYeeUbU+p+vfpokyvysoz7ZFPg/oSOVx8kkq
zSbSPXe0bosqv2S2LRh175JKtqDJB+Rppaz/omB5yd6BGKSWAqc9n//8528i
W3QBAycSoU7q/Po2DxIjklk56kKVg9ctkTCwM24MxGxoNfIFeRbIAGhj9fEk
FYQhl8/p+rcdT5vpkouuTy3skjjJxzOFMm9bvyzytX47GO5ZeeXbrfo9lif3
Fv1vVgZt4Uxb2wGcfKbIO2VCxwfkCvGM0byYRQaculUVL05kwAyTuONZc1C5
qjyzujmQRnr4qkYvSv0XdbZIMZEVkxxcmrMYyI0t+hwWMAaSV8exZRxEEo/6
HPVNAMbDM9+tP0dJcCU1dXe4F1V3+aDKOChKmpInTaB4caqLikYZ5lFEmcX+
ioSI/nrVP7GZCZ19hhPEiYcEV1VjE1dbIqt78W3jAVTlJbJ2EM43iDrikbLH
cj7JMWqr7pIAH8Kzdx5OSqnkzAxqj5yrp1iMizrAaUHc1Gba0/ykYeOYTcw0
YbVvY7SVmVrP//A5qn8Xk7foc4f+HMoKUPQuPWIL2HcR/eWdAvJ3wl8+Nxev
pZLa8zmsgVoMRxlhnF7K825V7ORA0Ecu1HlZ/w0iOMC4oo42Yby9rd36CHTn
sDXJA4WRfgtz5tUPaWPqjDCTQOnARXQ9j2BdN2bOF8emeAfzvm1SsoJL3dgO
+LaqSbs8rhrDozlgJ/c9Fz4pXrxCaY28s4CblQrvpGWs9vE5qn8Xk3EceScK
EOcwRePWcLwB1iC846KziKQLltA5IkPCRDKeiTD7NwPG6UgoAROcJv3hXehn
eEdP6htSwo1YL+XLf8pP15UvE+++u/HupUMDKTnhi/hiXJHjRXwC/PAJILL7
d6nwbNe7fDG+mfwgpeg76W4bjLm7WJrjSRm2KeicUVJdns+uYV6lY/sph5/U
b+MEd0X0X/RWjBUVEZB4RGxRxD488LPbcK6rtEPobR8c8tD2Rl0qVAlMKiHT
6TVIOfolfhIxIJccf3hBk5JH3oF6kDbxP4+JTZFyLU1dsuO7Gjte1utGh+yX
kn3yaVqLXsngcPzxuAKoNPcdegme4n+qMeTUKu6T+6WVn9QfzaHfVphkyQbn
AtDCKBaMkUWUs53eFJcJZpSh+S8semlwaAqLnEh9CU3xnvNJVYRt8E/fKAY9
uUYFapf1n6EPs4VEnEj59WLX0n0cI584VUB5LEVJAf1Pii4ZuEFa0KRwNILG
aiIf09E3aJ3dbrCovGnKfdpRugUzcABbD+735BSF9PyVkJUalD1OzpwLLM6A
n6QF9Aj5+SzoIq1TyBr1QhVSa0zNuFGSne2Wqn6nqhjpDu5h6cHlvXSajXej
JTSmCSbF5qZ0+woI6escn220NFgA2aElwVOl+Ljo7JhhHVWm3TMMSUhEZgll
KebtBy7S9GSwtGheibSYtnL2iUmWLpKrEQqH1NLi66Rm5gRm2c5EFVJMxOrS
gZsiBPeKWB8MJHaZDRcSyw67liRuBozCZIkT1tL+0ouQfjgQ1VVH5NaJGgPN
E5E88C2aF7MAm5RlKZwUGYddfzWKbNzznvfMHCVZaNaBbvQhUWkv34qg8wwe
0u9l6GRJurbNn+zDcnOnluvhTdfd8Pu90b08qH/3Vmbb+J0vV6zy4RbSZu/O
Eb0MGv3NwBaluzf0IF7nfv+bjbZTK1lSq9ZfYw5kUhBtwxWlI5PgVC2p4lyp
hKxkCi+VQrQa6aZtDBbT8YGwson26XifK1ZHsosHEVJDM9GC5tzjs2KnkHO/
/5VfysDvGgtmF8oDxpI/J+lb+DGv2N5b2X7Gp04BvclNDnoLtDKLP68VO7xA
syN32CHq4OeyrfFztQd56oT0fs+GDKuKY2c6ZBfrChkfeiwTDqe9IjEBZTKk
5hkUZ77CBeaLt6QJ+/3vuHmPD4YyPlJ1J+VChFHqj5Khy9vM372adBhZwHUt
7shBr55VGUeAYIoXI4K4IBYQZuIFRWeHexQ99yliSfkjr/+HBQnXR90tZBJ6
cGsftoX+WO8+F5oyFcqrd6R/DA+XjInsyfhtOnwTeXnKDBPndt63t86Eep+L
hy5Sw5ycE9Gw/vtz+5PC4lUte1B9Yp2hYgCDSaQ6WOfSkUCe5pE74I2NnWPv
aat0jrsdH2BM8UudUtIxUDpqnAmmD4aOsNB1je+WjrShVo3uU/XjF2MI2vF9
GS1ZUYWpODP8+YOSQJ6J7EIkv0lcmo5wEfiI1Go6QvOgDUYn0wjrPFnASIIf
lxhzM06LYG7vC4RK8kBkQfjNunrnhwC33JcP/qQdDC6PcblyuaFFyIpvcT7Y
I+60oShMwF9loVHiBLqIE5d6xHPjno/KJABFeWzvBwmgEUhA8clv3m/jiaFX
yrc4CWOqgJUYw03sEgLTZRmWy+RlTedEKKZ0Ka33M1Rn03r2bRxu4C/UgeCp
6d89NP3qgXZ8XIrh5v0exStGX5qilp3SEDtsBDvkh7/d2tPuURR451sAD6qS
EWN56MtppujPyWfUfz+uP2mIIsMdb91Jg+Csklb3Kb3LMb8G9OzflcZyXEge
gaiNnev79YcuZx7KYqiYha9t29pEPsFqE1vqjvFEXEPGwBgieTYT2NI+7GQm
tO9tBs0zJaw2tuDre20IwM7TKQIDKYDlG388vPGVvWxv8JV8Fv3vuds17E7T
ETBVCs3o0mUDTdfLGIdPli34uQ0t0Ds2uR4uUv8eVkhMb7+peU+cfFZX7CkN
f3mnG7VAbKWSvK3fchXV95lq/oUNNeO0JD1tnUmF3O0xwYRvPCmUxDuxdmo2
5AhfNLtLEiy7dZxTc2YUUhCZepUZhULrvpnS7HO7VYJtTCfPHGLPsFrCpGJu
Ysl5Rn1KyLT+MjtgCR8yMkOZslI0y90GS+WZiUfPak1NHhE2MmEmphZfuTQ+
i/53HADeGZ4jZ+PERB6MaBHmhyksXkdyPR5nz2EyuzQd99TUTxLgGRPXOr1C
oOGwHCUSBfAodL26qwwGDj+zTFrYXYL8kFPug21sD7d70TL0+EHPmGT3mrHL
I9l/q99DoJDn1NDfkHC+hYTQwCFgf3eHzqobO8vvISHue3yc2+k7DlO7Awkx
xk/+n0VDXgNazAl5Q0e2Q6iPcOX+A4eG0F8akwm0d1mFj5IgV6mZiidjQaTY
DwEz6PrO5obewjnzdZbp6L3aYnaHiOkUMRsmYHIeZYqgdYQQX4rDXfAxznzJ
sHgmYOqMFIfsP7ywUuVeqMtdNSUJCK7uJMu+jzBO40HgNhCpgpaSXD3oC5Pl
X04CIuoCF5cg2quCwV+iORFSomqazdcSKpIxPoUPWcnNd83ZKhzocRgON4V0
gBAauidYlnEsBMujyCz9QcUGQzxDeSx6jK/PiI3egCQC2XlA7wD5xHVqHVcZ
lkKkSo07rwKJNcN81QVIVKPUTk40kJD1HRJ2h/fCu8yCJG7Zn1cXuEeF1usz
TZnycaapaYrm7RWyjzNNuS0WwqZVhIqgxAvg3yPKuKkpe8eGwevn9XsIYWiV
/xe/w/CP9d8jijQFFdrU0zZP+tyNfjajCLDXUaS7XPkcgkb0SvvHHVDMORRX
hYAyrAw+iRSAiJaGQ3YEAzlFOdNIgRH2TecrzmJKJ8NYQFAPh9LpCIQEaWM0
pZFj2p5LKnVQKv2E/hbtKVEFUxQ7kS9u2yYsaYtKJYUz/yGnRRrdiB+GUrAh
OEgsB6IGcAxEFu7tDPjweFe04+RZMtb5sDPcFlYL3Yv45WmYNO6JE0XlhkZ8
a+4WQMVXJ6BgLREfsKCbsS7aepMbEBDkMIWRPcoT2LoKL6JCEFVrMLh0K/zX
Wxwy4c2EMeHKdDxN84GlPpdT4Rd1QoBAUknpGF+SZJDjNISUaLRQZtpWqlEM
EuXhiy35xF4ChvPWkOJcTjejxktFwhyhebiB4/FOgNqgNFIMc4BBTn8VZXQQ
87OFwHC8Uwa16ONhDrBKxz2OkiRBueLf5G1w9zblOcwB9jYRpVIQlTkzf49a
GBwoNOcZC9gf01+l58CMzcpkFmrZevhiu4IbJbGnenmDY3HTRJj+08hplOKw
do3AqcmHSKOpi/PV1lq0YoXfwmAQDHFRDRLoUHLNE6cl9KaUO5JHh4j9y1/+
8jFW0gL/T3KRiyxDZ8BrOBjOIzmTptA/BEYZSKWTc5qCi5QPUkjlSn/VXUoH
Lw41fPaWEtBsAHGll2uS6vCwLjfndIw4zVRquEMbJoZzL2XKThPp0uz9LZDl
w3ilm5hModYjQwTmoKImKYFqPZzGBdsZYVIVxkGHKdRYHUdo2xTqnElCPQ1T
qLGUctUdbg7AISsxLcxJ08m9wV6pvPLKVf1tAEIsjkhgqzGQX2zBmDthHnB7
E2xf1YvDC04H62NklLup27yn6fCKtm+0OcMCA86U2VvZ68N3sjdmQFTNOATG
0CWukx7O9vSCQs8VGI0bfmCjwTVzM4yphL3+jY1tYV67F0nyznhqG7+RMixu
VfaI430lgYt+WM/5oGvCWDJOPQF3UIzOmdK35+9ikAwI4P3JUpn0xgsUYZf4
bQRy5qaTCMOFfE5+v8d1i3+vbcLn49G8nJMuJEvyS/tMIccd5CEYhfmZEy7h
5fLzMCed+MEcR7xAczzVVDKP8i1sCUmz77Cp30VhZU66LsAMhYuxPFARv7Bm
nJNOfRr3L5IVFBN9eM+0Oq9IcCquRDXjJAY/gQ7VRmZZAOrm0o4Z4GfBMvt+
ie7DSlzSx30GUbyCbnkmIYyYJPzEfGXRLqRizeiP/q8sPMUVhUZBmWJiRQYT
LlKinEh6AgtSYTUEYrkIWHidAznHI4Xh0Gqa5ahAO9PYzFRXwUoUCrsC1i7w
0FNUAJdhDjx32sCXb5ldmRVTrro9SyhPF1tvoDruEP3r4Trg4Jm7jNA+VQWZ
u5WxFdFdHGEeLyeoOER7W9CNyasznHcrPgzyo6x/L12UnRovuUhPYdiYWGeK
QKkwYlzzlVOvihsQkpr2EiVWTNS4nFFmnm6W3gSOUnASFPCGbLCZiVg0rujA
56j+Xc0Tvv+gCumoTGCTqGc1vDHt6rw3HdvC0BNikC0MCOrR2eRC8wtAaon6
U1WwJbyhmI8BqvjGvFO6ahuEzGNozhVZA/3kmsS+E5qYt7o8sWjSPigx7jMK
DZDTT86cgE5BuchggF4PVCvPEv/x/EP6lEWd9nJuUUxW2/GuiW8pPlyRceBF
M5FJ0fOBw5UznSvjmO9N+3O0ClcPR1ti5rBGygIlbPAUeRLQ8RaYjZqS8ktL
F07z272HztsWXxj64Sij1HTiwGa52LTygrth3de48kJoTPSJXQIyM5R4pZKM
w+mtiIh1iLgYWOx1iulCV15AmfnxPkf17+oREffq2JCUw2/1UGwG3vaH+tl9
3zIgwgfynLJe2e/JXJvrJCOQSdQUK6r7lo0tzaDhtsS3ICnqzblEI7xzDtIS
3u2AbN44tRmESdRRwsuFrc1J5MFK2E170Lfj38WbpKY0Kbc5pBI6hoMKQ+Jp
amg9MmdRM6KJC4NoNiyIBo3Q+kyndQaNlohu0Sm+9Pgmc9jcAj7fkNb1iEc8
or57j1Ucn7uk5aDaAForIwAkpW5wVQA6pH5OhuO24AsgTH8qxMsKFhGQi1M0
Ea9ZKxEmD3J9BQvobIMoVczr8Dmqf1f327lff45zn9x1hrlMbFqF3EEdgIli
8Ikf1heexYDJWmS3/JOgTqzHA+NbhRqaQxP6FCuzGOjJ8QSl6IDgiL0MNTaB
SDgXapzp1BhnfOc5cX2mlMw7gjzHUx0R9MQnPnEbgozKhomQwzugrnKP5tVE
E3QynkaejSlF4R8HpXEwgJdLNjNaKVrm89E7kUAyjERsTrl/0iU+iQfqZknF
IfJpx1w0zRvKffsWzDBGdRy3P4vusOvZYbW0nsdvHzzPc+HSUviMKvQXQclq
ihxBynUqshTESKBqE+dgHTFYtAkx9+n3CDqPiyM4Hq4ZFDBmEufnwqC1UljE
ny3sidZmD7MNtQ8u4armBQVJD4lLeXTHoSCJCCIpTwK4mQCQqd2y3KJ9vlLQ
wBvDck0rtjhUUS2jR3S3oUHT0N6nHeW0mA5wXKJhvz7nGmfUMniM2XiYsCai
+oAGrUcp/tB50JARUZFVCX3Tf06dnyha/SdVUcAg6GIVy3MxdMgiaJLb3oSK
+/bXGXAeqmcH1USxit9xbQREFkvx0MxZ5n1ngxwmg32OTqCiRBTsb7gr8OWO
t34dh4KWFiSU8gAGSYmpIJZrOy2p2a1eETOZkyFxeNviKP+uydQ3bV8clQVO
Pkfdpcx0f59bDs9JSbbdMJaAp8q8xWEfVzJldaXfJ4QsqvjlaJ94Ux4RYRhJ
HtddASIsRFMAnSK7jGR3WEwhzcxXuf383mX85AH3ua71baiKAtRggi61NS0p
bkaNS78cNV3FbxIKGiJZoBrJKizDOv5KlkGxr1pHD2Wf4GllRQutBW7LEywX
k4eG1ds8KzQI2850to0R3C07cVgYDgsXb/KsFhXMJqDWx/1tO4BPa8kAlDGS
auPgjGvJsEXWSVBJpiJzx4GbYeX/8zAZTwqC7hjWi8lNAWV8eM0bto/dhG/i
JcMnDbQN3yJFmsznqE+AH/dyCb4Na2Srh+CbvSHC8swcSb2NosrJyCaoGE0A
4nGtOcpR8DEAKMFl4NPmXral5GgH5HwzQtJXygbkXmeSNaU8HpCDgUQT3S+b
BgKsuHDbEySW1fZaKSKE2gRo0kdhILTxV2zCLjITPkGizmo4/8XQyWCzNwEa
WsxFJODbAC28C5/OdD6NmxoF0MrmdEJfMY6pmgY2e6aOBg+Abgw9VW03kwe4
oiKJAETCQv4LBBZLMNrP9UV0TJNsmnxw0cbz7ooyjZkon0V0rDbhV5M0lqEG
nc4kOsXLW7ZIv1XJD9IxsdkIaOwbt0SloLKP61Hfx3WcFXyLgSJGprUvcSVz
L58DKsJx0d242I0nkqPylgusWjqOp4KZUZSGsTCbAAbQKMoxbZNrlpqKDy3R
mHSYf/McCVX5ZNtaKto8UFj5vs44ssHzsFGItIt/ky1I54symaWrYRwRBY0l
sts+vdb2GFypR5E0xik5RMsh19QuPacj0pMGNbJCNOqVHuNDFN8ofNIgYF6O
fy5BDmEBOdlZ3/eXfVoHOTzF0ytBZEDuNq08+a4rID+cduYOa4gof9mMDQbV
7xcNMFpH+Lj8sFiHsx3N0EUbyJBlqzzVMH9iRfcFduOUL/+GPBqioC5EAWiW
EqcD6Gxl5XNU/y6m0aIR0EY1iG/bnaqB1r8Jm4Q6Jw3fKqDbJlatQspkmV1p
hes6LRg0w4Y++i1oZvj0zwBY0Mx0GEcXGo3rKUkLJ7xIb9J0uCQM9u37Ooey
hTt9zF5Kf+KUe35TVKCMGzyLEcrek+f1KZ7Y2S4kInA90FPc4tPKZAuC9IAX
XYpPyX6WLITqdbhqRYXrxRtYka7RntnGISEBHGOBqzhBYy5bBE6SStA05iCz
8A1cjccQsKw/oFXsG8cETPPdWkoqA2lFF2dZJqPJVhHfcAXE3JMtLyUnNtRs
4xfLhRF7VUURTWk4ngpAv+QlL8mKzGwHaSCRbiFShVyBCSdSRSqMpCK+oL1p
miU/eQAShPFsKFpMayb4XIhleRpxg3OYkVUyRFU6e1l/EfV0gJ1hd3xXFQSn
evadzhexfn+/J1tDoWpSVsfFLxZ/BHYZtO0R6W0H3gqF9KLo4HFWKQUpIvqw
/mgO9HNv2rVspxokMZmreD2LoQ00jXTBJsQct+yUgdCYaQC/pfhRUkDOFHs1
y079ZrIC5TAsVFSqcQdq8779XiiwdA93qvWmRwyjFVhlLWhdhvOwh1VNbUCc
p1psReAiGQfZGpL+ZiOSZektfwvq1Mh8eFeSliuyDS6EmUpks9n47sKPcMEg
4ZHLdz7zcl38ospBzvx54aA3pK8FE1lIQ4dI3SyPmG1bsUOoiJwfS7CzlE9G
wSAgPziAYYvETnzpAAb1XHzH6aD3cwCT1pKtTLOogLnruYDhWPn/uLZWuCVl
XFqQkCWL4ahYbrX4Hxat1S7IyNpaIMcit4tzOa9uw2JyvJeacVE5Qzvz4oIn
0T5Pe+Q4FmQdVvKpyIQEyi0NPhiAYFBE4/K6aGgdRDjGzcDJNIcrzKlEr+NB
1KZgCAjQNtMyOKnslWt/QIrhV9+iWNSZiYPjhgeAT+FkOBgwIYVKZY6JGdL0
yS1v1x+j/jRDcE3PESv09u9iEtJb1KAh6fbgCFGJAhs0hZQ7VZka5+WtTmdu
t9yXCIN0yLiIOLWnGjvP3HEVVzRgNju5dOinPlHGCa48xxFkYdh8Y110BP/g
NkNZhtjqATi11nay0Tqc0BAhPB84CW1cI+9Bh78kBZBBqnGp3+GAJRcK5V2D
UsFSZg5wpYRKaQ8HHo5GzGzCEcdYvO/bheJIH9WxxFGzOsqH/2K5Q2L6n7wy
j5oAH2C/PABqr+05UEgqv4DAAoiiHwMKugnHe4b6w4ZG8AHbFP+m4og/hULF
xfcdQ30ag/s974nWzP2tH3/bXifTmlBgS7o9QCIMBINaHldJU8HqJMh8p6hW
DoiRQ/fn/oabpomQAd5Ixo7ORUzL2em/GKzo6Hk1jHsr0aUP61LM6UENqvar
SzROW74mGAtZs3aBVTYYw3YG91qGHMvn92u0ohX5CKr5XRyVnXpntxrXtC1Y
jB7lYOTd/fq3rUbM82nr+fD6ouFe4sTgFWzMnuKEF/0STlKDEoO4RVR1Ozil
tsXGsOt3IWjRc6EEyUM9GvM+XUUakAAY9xRH6mX4AKswMDMe6D1wUKpP3cZ7
UGzBIyZSMhzu4DFTLteXiUudeS5rlJnEVaXVoJXTugtmP2IDCsdJx/jKBZvX
pM7eSibIh4tW9G5bq7tfWzCevqtXZHtcHX9SCJLsLHhkIeiJEF7cI6IdIShp
qBX5WMNAJKj3Njtkdzog2keii4AdDMzMu/t97fHoRVwoBPn/PFPKLJwTnbKZ
3KNxilUOZ7xdv6fvzNnSEWyn0OiT58vv9+1k0hwk0mAwhb+MyFCz0yYj/t55
FVysrEQdVysL4AGEYpGxHBUp5eP/Ade4SWbYorkstjJzFs0mZOk+1a8r877r
3zj14+JBYgFVqLTmdJ0fQe18KaiQORX2ckkgkn4OgrYZTNzil+jqSQ3mi4bn
dEkbsh9L8hM4W+oLdcfzIgKATGJsx/EtdSROA9QVA7emhZUDh+u/H94fqtt8
HR2tsCAnfslOximhBUVtCh1pzVKP2xxRZ6sObtseRfaNguV4SYaLXNGmKP5N
ZE4V4m7sYHOufx4y89mmvtY/37qhw3Su4QudS4cNN2WNfTqMkpJndXOBfo91
kOEaxxHgj5fTTlxqckdmxFesaw5AmlcDsbqX2u6WnnsOMcfpB2PPgxBtAUSM
XPb82zb03JOgrtRxtT5rZLgW2ylpwSwonh0owdTQ7/O+z/e4QVYknN9M04w7
iQkIuFgU3tkNvc0qpJwizWypwf9L5BbpcEuM3GcxpO9aK9CsS7o39v3KwVTi
uvZkRqR2EnltpiIUXhCQXDvx4sXJz/uJVU23kEwwTAzDREpRQCxRdelAcrkt
oVK6SnwBTgLLmDaGFnKmq4SJsIkgiuOa0ikBJU1rGuqf5w5dfcQgldkIMG8b
IJNr8i0AFw5xRkb7pc/GWjVgb7hHetnHm/RSgTpnPNAKlHHKBR0h0rLcpt10
TD6oCENt71P7bynLpzxXf7t0Q79QwPgHL2Z3oG8GClO/31c3c219JfAN9Mvn
wIKw3rj3CwQZSn4fWKjzxoM6BThGdOjA3jQ5QPjhRXq4FFqfuWRDR3RYYxSU
DQeM2GdF8v7QYRpEJ9NAVpHDpB4yK6C68cAojkrd/2ZsIFPO3STgegW5xcye
08BsKKFQvZV4MZg2Ffj8AcK0gp4jbd+U7JwCn99bxoobL/JZ1L+npiWh+ShP
HkpUwvh2u57tFREYKkmSAnDJd0q1FvBlvS7OLteq7TPp7+HKWLIPsZXHkhg0
pYv1zKFJuAPCClfJWFmB8L9s6B5fXVrelV0NaKxM0YBGXRMYSdZQpMujkvar
dLKJWU9DOYos6hamY98457ISAtqd+ujByoZI+q4gXrmKCiJzHFMG+f2MXfJa
FLbvJZDr3cqWCSLWTEa860DYzFJuu1+0oTjmWQxP5v070xayDRM/XU0FfVkn
iZaZH/Mbg1UQ+FCf2S5BAJ0zjLKfkHwe56Fly9iVgxqJUI6hg3IMc6BNAX/8
Mw8jXQ3yWodf1X9ioSFOJzOAgn2yruR0PA4aEWSx2pzX01Vc1M7lJBlcQoou
Y5fYzYDU7Wc2UODXB0XIroqri+xnwFXx9DlCRNRNXCV4zFlWvauOtIZvHJIS
Ssc6Yz4/QRbghscTJJMrMt9nGTK0qUSUUj4aHGUFmnBFZ2R6ved1UKLNFBzK
aVqR0HZA6sder2whYGqNfMC0JLSlhrkEyy09mxISLJjPKbuP2eXeOI2rH3TS
4domGBhXkrGI+Yp3PXCpumCHlTKLOjGHxm3tO5d72UkdKrK1x3gAlvrVMa9/
F9MY79I870zJK1MLii+TFD0jISdFlI2Pj9OdBOCMASkL8XCcV8ELGTam5n4z
/suDRtsUPolZI/ZMAm8zlONJGqQBgWy+QEUZ6AAurcXKTcgKHDhDOdZ3v1NS
vifg3Dk/AokaLYrHWe2PAhxiylswKYWdw93SfHASWFIKWULNQYzLSpn3CQkj
hVCDTRqRyCsUWZTe5tGcV7NMnLXlWtgXmNDfahvnZms1IvEcn9WrIOgGNngV
pdzQkxMS57JDsc2w1OOE1tugCCuZJnXQ25ht4TkOPrR1jtWIp4epFgyQ+1AO
I3GCD2F8xG/TOs6WEg1Ps6icBieQ+PrSl740fNEipeFVZBg1+jYUtUV8/Glr
g1YSFxkiS6XZ9SvHSfXsUZw8QCD1XIXg0HAOjCHgfiejlHBm5J8AhyjHNID5
QadpthRgiORsJEXkjIhNwdXu0CJg4P9keQfVzVrwO4YtDeAKMnnZa1saaK9r
2NKAHDA3nXZ5mgkweIsw5d9pBmlQJYF+Vu8B3ZEV7PFTaNc+1XeTnQq8wDZL
j0JnUEcQDZp33wu8WGmTGyZhaz2VW0OYach1uekaTSVhQu6GXQ4UbrBmnHPJ
1kgHj7sc0IvcOdAZdzlQo0C0AGKc686IiomL6ry630YF6WdDdUXKI5WEXL4J
RE9gPzFO4RyIoIYMSW7TWjE7ilVbceZHAuG5dk2poHagGhVs6MnCkD6va3eA
KbWowBE9xtZk24trlkdzyt5yd5d2IiJp5Dp6nJs5HVjU4hM/sZxRX2QIkawC
KJwKofQay327wRYYMYT6soTRYRVXviIKZb4eYDCsPFZ6O4ggVIYfGPWMLzFj
3rWwmEcus8XFGC2nnpJZsWSUPe3MXPFgBtBpImVP1GI56wBxsZqKNgWTAg2V
smEp5ZSNZhAVu9pma0sNb9if3dninGa/gohGznYjXuxAn3ud1nISSc24GJKq
V3v71jpLDQAPhVXQkiwdenO4aQWmWlILf4CqwDC+ij6qgeob9jDQRqRpSa52
b9MeBnwar/Nrhj0MMn3HPCrMk0KkIY0rFs9sPGgV5BC4vPKM/rbxB82GUncE
XFippGHoOce4qOz6G5D5g0Nj6BnIgiIipF9EbKJ3m+VqHGpt2rb5gNro23yg
Tpal7Qy10FaKMOmF5QUqpn/ai6XNntNtTDdcMW5hwP3XyHFPzk1bGDDgWgmD
hcXZwkB/GHA1huMG55aD/y3qA1Vpz8f0ewbahc7c5fQwRz/IlqVamhSc6ZpC
gZB8A9J/uGshWpEBMEtP6teEoKIK5zWptboSJhUzbpi0HfUtwhOAi9ySAawz
Ecu7MoNkmloogUyG1N3K9JZhrwNWVjfZtmnAr60DA7q+n+H6gnCSWdgdTQVP
lkjRakBOibJvSkn91A9txpwXXgXtTDRznnwREMmacPsTM83xf97XJ48Dvxd3
WJFN+SDqbRX/TQvLV8gEaj75FdmL4cBvPNYQPrLiZjzmUr/gZjE8x6bQYUk+
08TQbxYPVztRnPISAyUNTyEE1oE/JwRv+AapB2rU3VJNjY4QBQ6u4pBG52Qy
vUvGScBA2fFvSrWpxdvW7fp2Vb/H+/c4PZReZ1WILM5IHdQHunCDBkwAmDn7
9ANw651edfFYkY52xDMIM8JkF+0oIbk9UbA4uzwTUpxUMhjC9X0SDDoSb+6V
cKItYG/kzNJTSZ4isBELLeJhscnFYI7zNTDWNW0SsFP9IFc/vCIpA4XQctSR
QV0kK5ge90noq1anqcnEAD98jvpmkeNC3Id0dhMT9s1HxAXdlCXfYpq92pKf
QKorKCDoyiYJ0mLyBHUVX1F2S6E5Vb01U+gF4ShJgAgzj9iaIlNdShMi21BA
y2FQCaDCC5qeOh5X4aG/NfemthaxHfdFyAYg3dBNkiEjyYtbbqzcwnr32lyX
VnQ9HbZgTWQ6HR+8N21I5MIoBrAUv74vQl1u2u/RGeHCmc6FZOF9sluFouk+
eiSDTSZAIV8pY2wBt5h444IArAjNxYO8qJ1R8yZmLOUlq4UzcY1LlpkAyR74
liHkCMmFmhTtPu4YUVJQUJgtU4XeUEO3lH6Mx4haWq0fKTXHiPIXUiqJ9zow
Dav8k+dEgiIG44oUtlzSJlKC5sycz1HfDXPcUvUhnT4kh4SgC02Uo/F4h9HJ
tBedDCJSJrTc2d6krCkA4ELrF9fbZ6o6RtIMTAFv5nr6bnCIhWQyil6Ogaae
ARA+Mzuz9D+k4pdTueOCdz4OrUU1j5P/ZSn89pznPCehuADV1RdejVNBka+d
2dQepZzpI6u+ph372sFU9BGfD9rgcn2yvj5EStiMcOFM54KxtXDhA3q5tDnq
Q6KOcPQyJ8k2eGauoXxWImfwEJcoIAgvimpNHs7df+FMxYVJW4m2YILy5VBk
xGyQh23isGk/hriAUFqIkxmzkiAxIcOZc6TDk7TduB8DQtF+2/ZjQIqckHfU
542Miy0/Y9CwUUyv6PfOXVt/aSUxYc77SCoiobRivpPfzfdkPQVpo0++aWMG
cZQwgZIJWbSNs4VBpT95XUqHlqihZL+XZfaatG1jBvwNWc50smRtr08mebk3
6QN/L9mMHSFv2OV5QSQhjn4VJ3Cm6nF5b2qHAiMJFKc/AgD9OQ48IRGJYgBo
+gQPrFW25xznm7OArFvxDC70kFVd53b6nO4nOouqJvT4m53Xz4HKXNouGzLI
oFpE3Ncr17uJeAcNw/C7uJbHY6QFAFSBTykuy0/5fDRJn3+UEpCF5EDoSXdj
qH372pHVLa8jP9BPK8uxsOu7K2gwRORYWJbDXABOUMb+CBr9V3TWzgZGJ29i
EiMlxCPP9AvyQ65ENcZsOLlheJxfrk/xjtJZDWeTuZvbGI53nAqf0/VvO6B7
fdZA9ib1+Yr6dzE10xOf1zFPNhgM+YXswr+6GcNBLTtHYgYZyQgUsQ8yspmQ
LOM2ZGQSiUYV/z1Ey8g9v9BKGKYsqhgstLIfjRdnjivN0+K0bEJIJlgTshDj
qk4MOI6RaMCYsnvoneXgQRDXWceCoBzKFQTpFJnnBOChEQFqX9avWMDjEdSm
rmKDMLXu1U8CFzn3vT6Ug4W5IpnGr4VGbkaz5h6v50IPFlYP2+tzuk8HGw/o
Sh3axEDU81f6LmVsekZ22tkW16vAF4TUk2nKHWURlJzqRt5o3xFRfstm7/qn
HzSokGpc+jZCKr5MJj7QznK43g0d9TNcO9Ofl9n2L2ChdhokGju0zdUXmkdA
62mii8UKKTdhjfCERFd1EkngA8eAtWyEwLawkRR+jpLORgh6BT90JXc5AW52
c0cly/uZ4207gGS0WSyhCzUfVjSiEffi/yaQ51LyNAmblAXyDYp/0yYJJuHq
vJBn2yYJNEjmIB/1OcjjUVc5ITnH09DV42a8KEOpFqxk/w+dyu3y/5v025DW
J+CNwQogi0VJ/DgtLSovpXpOiT6lU5nHgMJcQY9/cb13cbVk+g6zatXOcWuE
rAUxWz3VUFhNr+HdIunXFRnbtHcCGcFxF28B93BR3eNmIHI14i2a2TYC59k7
gViZeQpQ2/ZO0Myw70xn33hc3S0HnkCQ4dIhuZ/jV1Ho8uFRverEHvPShBNg
BvbxTbJ6JfPoM5Er7FL62eE3NeY3bA0vhbNZW9zGvKdNHPRMPMrrklmionJ2
L1YSxmJ+Ymp4DOvKHKrFHAKMonnn1Zlss4Gy11E2ccBoNfHacEHmBieAzRME
iYtMLsMdsDZiwPsaBQ6zMf5mA8EkdH2O2saYKymNnIScoXUeSrJI8mUMCz5o
H40WwgKy37I5LPc2W4hgJ1RobzF5ycKrluVEyNwT3dMPbH7svyy8EQ3dEaqK
G1O0QYCcD1M01hd3fqGUpKmMMoqohpRrJV5JUZSehV/4xMMdF7yDqnsk5ulP
f3r4FR4stf2Z2hGaXMgglKBqJYtEWkna0ZtqLhFQfW1exXQxpZl9xnPoSBrX
6+YDpMK3M51vOdxyKWltBQRMjXNf8JLupgRyerJ6EZtRZKiX6eaW3ZTKUv5w
liw+xD7G4qhGwgJx6UHQDSQUo0oMAJd6Fm1/W1CIKYRpRdYaWniB2P2gBz1o
XnPPbf6HmnD/oqGzx20lgeBPe9rTspWECjkQbJcCc8JdJtzYlYBCXh44sDMt
yGGGiyMzbiXRN6ycxCobIvoc1b+LlUNMI1b6C5jswihWgmw9lPPjD0W/UXua
DUrJkaZZes2NqEs3+/N0Gi0j+xO+ETtdbtag3QNFY9LMXiZ2gS+fkCpJXZIX
RBlfs/l26gJtIyng9sQOYD3XNuVTmOIQw1yZ9IhOkTrepH0iNm0zgaulHdlm
go9FXmSRmVHBCnIxc7iHq8NeLDJqpp1p7Xrmyqs3H6gbrp3pXBuXMkSopNj4
Y40m7R6c8elRJUJF0ORiSYqIkfoZF4rjAolIGXKMgiNdChoAMCvzWHSxXzik
y3Vngje9acqcERdIUCcF7J1M9sQJQTJUNKM8HRCPedmjks5eboHRQk5jgZp1
ngPi2Vb4RcmcHMXGko15vbuasBpFi3qTKys9SE4zs0QQajggXvt57pKV02EZ
TRC4x2ZTGeIddwtnmwAccAPmGH+yb9gOMEMqpAMPDQ/LCAJ9DjopVzzmHqMT
tvACCC4bNwqp+uhRyQKwiCuaLWz6UbRf0m/nqDG506Kuwg3kFYbUnaTXxIQz
Me3GcliVOpqziuEE2jFQ4dBFvQi/i11J8Otf//pEzpzsTGDJGm99sMyJ7xAF
Anb6YDj58oG+2Z0gq3kDdVIqA9gqX4okBbEcem1lEF8iJ/UFDaGz8EdzR/in
TqIn0JVvD0/xmv/DxnX4b9vHIwdVQtk003R3GlDhcVni7fvthlcQEXGH9XoI
IMr104PX7rXx0qaLFUW1yRcYL/d7IfK4HUgwnP7CDpyjpVeMwuUgQUEXHLPb
0jB4yZli+0JzISOtuTTiLVOlPHTMfud0gKRCzs71G6PH0dqE+2wAAm7QSSal
FPkWhUrRF7okFtJMTdRU/gFKpYk0mdfrruwD3PgQ4wYg3pNEozQS72fLPzkh
dhq5skpd07jU4BVXi2SAMCxkgTqoZ4/tkENbsp2vD3tm/Fz58VOJB6tjfoeF
ToabdwfuU1FmQ8bNytkl5H0Kp/cqpTk2FD+8STSXR9LiTUKgJp4A5vJXUSFr
JCAdtdkOFCcMvrMxwwQfsozokPzr58oKXS0PE1khWsRNI8srSSggJ9OP/Oad
YDf0cqaLy5MtTFgEXeSAFt0z70OFm2bCeJu+BYqIEuKvHjHddilFYAYFLgEm
JNskRwBneoZoFlCQMHIEWOjB73PJJBrSHeVIx+kuTEwGlx6T4pNOn3a3PqjY
MQCStdgYLMMin1koEcsySlOmRyKUCTRaj8GYVyQya2wgjrBprEstpISEjUMy
0KiTWb9Gqa5vkoLAQlk8yWQSXilHQPVccn5GXzJE6rJJCgF0Swc9wiYrnrNb
aDJuC6KkcXejOtGwqHmtywwauOJqJP+Xlik2sYVqBEHUH3W2nGG0qGZcfnOE
EZkHmXFjZrjmLVFrvDvWMWZwlLK9/jz8k1diwrvjG18+8BgXOC7Zx9J3JBik
jPqhsup+tqtSlq3A0P/SgXdmFC+PtWwnFgIZhQ1o/EfBC5BmQxewqRrtfvcr
FKiDCrXl68Il7SNq83yES9mrwrWoSKVVMTr+9LlCtaiUAVNKZNPxcXEeCA/t
iQwRHiO/wvI14VGlxyWx3Mm+N5hf5PF44WkpI9N6eMylmDTIxcwv941aCgko
REgIFwIuhaS5rXI/hGKaPLdfa9dIj5vzJoqCQPezswa+Gu3HKxwRBRZFNh9K
1kegKyyOfNTTsxaLFfnAGTYq41Ze5c7Wjcv7e2qAHGotapBcaPiIgLopbFHW
S7loo6vq5J4llXSuPDQn1KQEartwLHN+gdjrNPF4ao1BTqau475uyTCXUAja
2VJ2RhtHd0L+3vgOX4FaKcbktl0kM1tb831kOdINw5NMMa30kH4vZ1uN4MYY
loN23wbu8TjW84HbXH/tGadRamcHdzjpdXCKXDKT4jXa6nhkt7mIjA9NmhHn
bbDmX8blw7HUd8lQntkeJGXcOIpGpF2xVHeQCpluM3AHMgSQWVpawvD0WniL
mf1clfuuAWSJ6aV+5sIGm6JneQDfghF2E85924ZrGHaNuKZhjHTIlx+P67bX
So6AuuFam9dB7WJNR1DP2sIoojtuhSLlI+IbN7HhL/G+JSWyz8i4C1AomePV
5T8K0x+6Ac6hJLtAt5D8ed/ZfEwy+oB2W7q2qFON8F54s1Pv7VYpzLOB/biA
W489edDLGJepbjo79gJEI3ofZQg7mGeETLLK96L/w2cSYG6ydsx7a/TEpWet
l3v1Gc96a5CeRDIiKQ+2h1sxGortTdNcmJCZ7sZ+CLLDf+EDxhCgEJNXmbHm
2w0E5gIhzHgsqEwlQ1zcokQqoySNo5T4DRv3uc99RgfIo22/i3aPgyVztmTl
3kpO2acLXPyi88naztAyROH/BIXjgnWEkX6piJuzDcFekg8+kcSwicQJh6YG
760R4oTiSTHRNEAWi0k8mQzWZkxyMAX+H/HUo1XxbGIspqKjH7ZFNvlu4rM6
u656O23kfiR4m5+J2W1rFjtBSf7v1Hu7NX+YZ/kZNNg4mMleePKgl8HHuo5l
UzZEiKkrGTBLerNUGqrwC1gG7Zj31oirZeZ5p62Xe/WZnDaWQ4kLTMN0MuLB
9nArxjBQ5rFdqGwKJ3R8qZtbMowrxN4X4QlNePwZjY54etT9cb0AqBkeYi8z
9+xc2WzLrOBOcksYsDxxZ68+G3Xjg5fF3h72fmfCxCgaJfg5qVwmPyI4F0vB
ng/05HkWX0zTSNz+siYIuLy3N2WgfaBXZFCoERDSZ2F7BeEFCmm2a+DbZT+N
bNeQafGU3DZBwzQqvh2VIge2mGbljpjZ5OcpB7Lh6Fr6eREYSTCjHHy7zHYZ
BGZbEANudLKxqdL7kwQxwJ5ROiiFOhFeNqBAQLGRb8ej9bDaSckHGcp+Vvk0
SyxojXGTpDYnR5bgpH5ZMCk1LFWMTT4M5aaU73gALbPFPbhA/6xyP5tuAOk6
cLKXOON9agtIsMXYFdacDyTApIyABM/0aQ0kqtQt/p9ixUoeMZo8rW/blHRt
Kk0ii893EoTU7Ih747AkEzyynzqg5YHWDASs4RhqExJ5J8aTOuebtJ4s2Z9d
6MN+Q4lcsSX7FzWSz7DypvRLOin44I1QsueLNdXNIJ/L9jaxVmbPrIgpNdOW
gJpUykEqEfWm3GF6RnSZXhTYdGx0ekaFU6CMXgCWjWW4FOPaVWzt2m5ev7TR
7eTA9jZwP82hg2VdVHeDLdxnMDGk5g3cy+QqU5sNIrdt9xvNtaWfklxHOQiJ
75RH5kQx1gZL+kFHaSPlK8psm6q1R431ykcIfoYJQNIWSUAdz/s2AEgDysyW
16+/hf1SAMZRBA2b2I8iKMPFHs4URUSOR9vCti20ozhjMXaOxUMLlSlGrhn4
kBQ5ako2q6xEhEx/xlBHnPA8jFMth4HbKUNElUI9u4H5h71cTFVvlKd6Lu2Q
QQIheRYmdECM020JiaxVDkgIJCgf/oEu3KwXx0MGeXkhVRHI8nvCa1k5AxDL
PQPbeK6sluTjdBbXfvWxxYxKAR7/V7LH9zbAYDwDg5zS/DHr4zm1WQfKvlpV
JG4V2474kOJTtro24YMU6WHfWyKLdurjRc2SE2k8iefSjJTKk9NaLMruA8QJ
G7MN39rhxNldTYM0ckQEmegrESdEJKlLFwcRWkSkESWrsug/40aqLI5mwICT
nHX5JusU1sAgiWjMlkiVWlfAQM5xEOZv3ltPP2S5tN+WM9nbZBiSbWJeekTr
etb/A4PsGUdmJMz9jr5S4eOhBaLpZpNa3RwAg3bkI2mwUJXXyIHIElxUTBvM
cRJOqvM3BtZfPcALDYRz8b9QG+nUOZ2fvZjmnkJLNlFg3JgBj2Zu4dkBVZAq
dBr26OFi0TrjFLgsufZtTI3207UnPtNOfUMLTYlSZjEoGumnYb8kPOmC3jp9
p8GsJu64We8JzWB50tiTMWOcM6BDWM/T7LRGRkty7pUycp7e3tCYWLZ0h3Rk
nXQh9Lj0LqNgxQFNjZwNAYZvIysfNzgBmckTEoBs5ttePghVAoPsQwbuIEmR
xQ3om/jXbzcZ3o2JyLswUDctfdObxhPg27YRferxNGlsPBk35EXWbIURtUdF
rm+RxMgmOsomkTqS8fobDw3PwOMrNxCKQx4VetehY5yP5frotoot80TvNrTV
oNw5ndUwBehsNoPEVyrP/9MxFiX5jLsNhMru0GOD1/484f9++r+f3sI/ZbWl
BEh2UZ7Xv4tpl5Y3RRbW/hyMRezVHAyXL3lqAcszn/nMTW82BTlr81Hauccu
OYWiRze9cfot90bbQWK3qif5AZ6TUSxhQ1QatcRXa+dWt+WBnmHMuK+Lfo/H
trparc2Q8iyvXtl9a8U20bN5EDQeP8ogOc3Ji17uIt68c8WoxDOaSRGNvhWr
6PexiTxpmrDNgG/3st1eS3W7d7QyI9wnxONJZIal5tOUNOZyg8m92n3tSbuZ
nNLFNEHVKTY5RMUrziu8y+WS3NO1S6g9Usvvui+UVyrfgGXMjj1cD2V5XlNz
mgGylm6GOQxizj7PslhUzkLQTOrKJNBEBcw8z7aV0v5yzzOJud07WElr4xgg
+L2vj1hDX1uG28c+2zbl/HWry2ST+myl1s6j2j5ZjGwHJANhopY2yHgIVl2i
FyNsS1/2sJJBCp0rY7qEeNeqaXE8miDX6f4sIUADPif/lO/If5WAYj/RopV7
qrIAipTH2yNq0vz8VuXzVadJYYfTiV9y5/1sxjqYhEyWWxglmFdNclifq2dK
lzeFKrrl4vr6TbJl0ZsRsHpOtIQc/i9FgUT8qEKm3f44LSfyqcv8CgW4YXAu
g4CK1FpxAheDeBIPQa/5KfxDBFkeRHebik0KNfNZdF6xsgdyprLLmMKfVda4
gxrw8RvlswQOnk+inLOlXqv4XPxZoVYUdfL48gAIz5WWYpBHk43sp1GEAZxC
GAgxM0ndYxmZHRlgGk3wzN01WYLCNyeyLjzcCOgbdsKpDV09jUXucjVN4Gst
uqyijZNt0pdBM4ll+oT0cKAQ08W5h6a4w5SEcixzFpsjVFKTGCPDI9Irzyfg
0hwjBzomXhAojUfCEJiWOGkwwWMzq3jC0eiETfPMyJHSLLqrPX55LU5oCtQo
SCNwpLVUDsM8VuugpOc8l8WiWEkGXabV0CGlB9GGwTZx50Ind807JTuK7Nm+
SYNKlWSzyfj7yqFRXNisCYgWlPs31SDXHfeboVhODbxLHbAiICLvDFwlS2G8
GjNoYoYI9bLNMsob4CBYGSiG8EyV1EZt1h96QYIAN8JsfRX2Ca+1KUvNMgIq
kUsyRy5pl4mGLu/pL7CRPOkkbQkrlrsktPU+dBEd5aPP22DecjeGS2AlBmMU
nGDMvDItHc8/0WoXMz3OqNUyszwKEMZYCTbYpqw0gHCzfiTopyUFbdpzjDy+
0pk5azipkrpNcKF1X/SXBtmrr8/HnxqJNe5LAY2bBbqo6Knmpc+F28Vmj7lh
gxRkY9ppatEUQWkDKuQeb4AiMIiQOBmPYMu9rNonWsGpD23notiLVgzRERPh
Cf28baFSmZMNNUALFIhEDuoirUXMxr0J5Wfb6GHrEJXDEPe9n8fDFAyL4snQ
T+13sey5R34ovXqYRMdeTpphcmW4av+2Yo8E0UOkfdwb4Zpij+F36URBRWYM
WrnhMthUupvBDHkgF4uTJTbkB1iMDBcQXce46r58bjOVLswveja91cx1XKmY
Dh1xJaWgnazmcbjSR3N74a/IT3vs4uoxYSdcwRK1LN85quecAZriOq5mm4AV
2+V3boy5PMUYjSeYuDhkJ0XVGnJefH7kUCfXFDnKWkfOvN5px/mm3GTP8Oc4
7LiK5/TmxU4GcfnSw0ZH1xw7F1Vlk4ygD8bz6LlZ0r9km/1ZA0/U9ibM0Ek0
/zbMBBzHYIYVu+4xc3AN8WHYqYQSO3VK5qION3AVmPLDa4uZ4gW/ZTDjupaY
yb7K3EaxjJw7I4QsnjNuFeWS6tcAsnfNMdFo/L8FEyKf4kXtdO3oEvTo+rXG
RKHtWwYTfP5riYnsRi6qgwv6glHJ0Z0r+uK6hEObK/rmhIM57G3/ruPhID1g
/kY/gnzct9HMHdFMoUp8X0GC23yAYQJK9lkKTgy5eIz+nSatt7F45BTuFDKP
EEEMXmjqD0R8inZfnAwl6psGi3cqaDCFW1fCk2uvORbT9jBLa72z2bJcAFLa
On6UlmlQK590dG+le9DzyiuvzO0gRlA8nRF97UCzU0GDMn2/+fkabpYbBrVO
S4pYTvKGN7whdJQBIpRyIxmfCx1p16mph9OKP1hK6tB4qciAN8ZzCy0lcplU
+bAJDg05aFlp2h+VTVCEq7yW20bMXFzLDcjh4xWTn6dlQSTGpJbKI4trgZwM
B4urLWyE0WmHs1aTSSeSRyV0vwDwpK31HO9LL62jCWthkUlP4roS16/jRjbq
5S9/+TpuIGIzbq7fsUpHSl3hsOibj77o+xlmbuBSOg6nJfZWF2Y6PueKE2Ie
nHxFGsdPg3Uha4moQiNpCTgzDei1r31tw9WpqnVoGrPk+sr3+guVZrc35mVa
U9K2iwZ2oVqSIIyWPDHAcAaKVkqSjInB03ogc19Orm2cJrbCqDUeY4lEPNwl
98J24B5Vvzz+8WwNmcTKLphBNfbGr1SbptmKR93JVhITdZNoV8Fe6CLhiSbs
a2lq8vyyMEr2lhxm25fenYOa1x8jLWk7pJWtKJFISs6ae+CeAvuLK//0Va7X
Kjxtkk9QdoaePcmlkPJkP+mtJVxvUGkkGYDkaBhtShCoAngC5eShtNb7Ut2u
rDTNyhR0h9p6duNW5HJtcAblCRFJXtQ4YTEdVbVE7kFFrtbIdonSZLWJKk09
nWpzUHONHiGqOsyhpJjMzihgOdPlQIwiEcuEwo30kVfgK6cjBapyaTQAVOOg
Ig1DyCeBa9/ndt5hJUcLWoYCGVKdkfmUDKdXNFrOHanBV9LcaIGO0HKyptMh
RqerirRSyqVGNDPYwD3UcoMUMlykIBaMVjBlOpPUaMiACVdN9CGTA0xN2wIS
5gJICNm8suOoQnKcQ4c4ErGIYR9iLZdgJOIEaDludHEdoZPMQQnl8m5IiJKp
CuXE1nBgpfxWQXpqGvmT+zNi4T3MAoe+czmGzjvFPCpZTt/HkZZrlbHCAPli
AVf1kbZaZY2HZhUuusEdz7LPANro7ZNhT1LttEU2EiFR7vvQKJRdTRHUnbKr
R5Mqxq2vg2uyD5g6lzx7qpnOeWjjt6mlL9uebJ5/u09vFBOf2jKVpj3UOp5i
6mqjfo8KIN44PB71RInxbe93v/vNe5E59qO9mD7OVnfd2u3E00wEphgJtieN
svFCUrde6z3ipjt+T1dDwUIozXTL8AdCKT6EeuMb37jG8B9cZTimEHNo3hTK
5bRiapPJNFqRDe+yuY00fVEJaxW1sZ9plScirk+MHivK0cDGNbhlvmWuEzHo
W5Ct43etFuyRjTpfLdjCPo210CnUlFriSYGF50RkazW3Ae7pKEpDtaug2q0l
savs1HoLMDaxbVqAyPQrwiau5WGwFq4i42uNaNOw+nZPu7URFjMYmEmFT+oF
0bKUPR1WHIntBRnf0DpRuu2rYCsFwRiDw7vIwbrnFJTJU8wOtVMPNVt9sv75
+Pb4/5J5Mif/KacH01J8e595X509buhd/148FJGZZjnqmz++6H9z9p4n/qk/
R9XHb6/P1VLeccAsLd/23hSM7VTjRCx5RJkQe24LmuNg6JVTKiHKAPL+2MvC
sube7FU1wlHmcLFlNFd5rBZ1+w4JcCGgwq/hbDlhk9m6fKNMhbhoaEmm7YmC
WHZe4H/0e0Jsg8hGW1a6LLma8zATlwjXJRnrksTrpBbeJ4ei0WDJMjq7qqfr
pBZuCqVI248LJQQg67Vk8qZCVlMAi2pqo0ya2js1TWGwWaEpCRKO5qVkLgzJ
fMELXrDTD3PK7IP2rf3lZ2fI+rD/9Rprp0oIogWEgOIx06ZpzJxo5VmW32g6
/8Tvkj+an6YrC+LUmIOldFHZLVHk3sV1YdEY3zFcumesVtl+54hm7rq31EfP
7g5k6gslZ7Ge2fON3THVQVlUJT4OGx7gPRvNdwVn0VzmwafZVHea19zuo9pk
nMEBRRNxyCUxjA2ykTDd0ZS2E20rj+rXDF0Im3QtdcQZ0x3d0vxwGTuRPW3T
1tW2tQOflE+BeI/1QFIhVt7TnhxImfq0k97TJx9ywuHQjnGDSyWMbDVRK5O8
00cKKGFrylcfjxAs/A6GVAn/J7sggRBko6nwj9921CEaEWTp0A6MhInKAcdx
ASzar7dzhH1OwMGvbGKoTjwtbUyshi2CegYAGT2iSkgq6EopTKcpbmrwiAC0
vBanDzjWG8PZ5OG1NSOrhGxvNV0Lv5hBFkunsk0E25ti87pGwnPbtnnZZ8Og
beihiRxsjiLHb+ZcworW6wnHAI5gRthMHrwTF0i8pxzPiwnb9oqtbZI+3hnb
5peIb0igW2lHplfiqzqjWvy7UHLcIAA8xmKIB7bSAjt9Db/XKUQZsyIGUTbZ
MnPsOapFQeglaum5f3sLUyQeMj3RBBNURS3MyyYC0F6Q1Fpweho8HqtCVODX
cUwi3MvZkkeVqYAbpaIJCUPhBVFBCxVytHQIDMCZpX66N5V9MsVLczVbnfSq
soo+39lA1BQn2RWXJboSXOlCxWkiQaBXNG+3yyjq0UmZzKa5ZJ1OhIvlKsOG
E7pwZCaYr+rB82JCM0nJ2Pxs+b28t1Phipp9k93GqGadae7Mx8GA0up5p26n
VX0su9MEHviVzuTwyKVyaRNWNHpsGR4hDMjl3hhMRlkSKAoOgYIFCctx5Qul
t65XKIWclJ3yYS7lH3WiogSDhznKR8HS/Wg0Ab/uaKYuwMc0CNHWU3h77JmW
ub9szena+nggEiR6SgoIlVoJEfXhvUBIOZiR35mV5Cq6czOZzVFjpumogtfe
xT2RWjFlo+KN5YvWAZdYPdWqsvhuWQ9OdnOKGkCPS8sY5VUe7EwuGxqXlqSx
bqlp+eheFcekr9lBnuMDH/jA3V6SnJgZejI/RdFc1Buky4Q5tobEpUE5wGJk
DfKydPVkiDXHcARdNs+OZgeiJI2zE5XQZL18vyh/vMdcKs8s81iecdDXh39s
JDGsxhttJdK+80Dc099YHh7BqK+Xc5hbHmiVGY3C45JMirPYgejpZPdHPQ2l
0dOAr4n09Og0IgN9jBT/H3d3F2rrdtYJ/rDmXGuvtb/OSXKSkxhNbKq7Ip2u
shONdlVBNd16lapuDFidLqiuar0oO031h9JIbkSigooEvfEDUaSLBgm5USIE
UdAuShG8KXKhBsQ7vUh5W+BdevzGGP/xPnOuudZea+19rNgvzL3XfOf7jo/n
8/8848sz8ecZn/AdK2BXaCFdJEfqBLZyzh7QpasMKhL5vbE3SpRjQTxGmFGI
4Hs8OAnc3o5ffrQmtyo27oZNZxqiKKpRBgpRQpxuOKAzMNxWprR45Wx2WGHG
ItvZrpB/6PfGkrK16gvGFmFux2WMefYGh5jEYYff6qZWWCzlKdhNeKEPVI3p
RWaJY8NEIlchmTxXcLq/5Z9dZipKczM+GeAhAYYKaIM1DhJB+o+dwlpK1/xY
EpZILqErRWbIV3MoHdK27gyGv7/3RhQpHS0vLPyWZiGfPKZWumyGITbMIj+y
TliMTRp1UTz5poMQvNW0pqS6TxBxMGaY8IkpobcEPqikdzLxeuS9bLPaJCfz
ihXjJ03RO4/oFcIabnAhpPmzw2e8r4NIVBCSy0x4X5JRU2XipaEMHvFBniXj
ntdEuS6pK13UDV5A11zGEv29rQN40o2h7puuaB6NgIWgap9xP5kN7SOcz2b4
o08YadKB53QZLgI+CIShXpMEtGkNP111dddsMmdsn8zptpEWmQ+W8tl0nmRM
tYrSBGMgqsowrPjEZVhF/nSby/64u3RO05iKSbW4h0PhllhoTUa56OoEwUlZ
oLTHW2+ezdISDZE1g6CIg0hE1LQBrVlDz486LeQrBU+GMPwdxRg1vqvjFbxE
CDWrUc3sG9CVsTFpGukaVXGVnkF3nbMSd+z0tnlz8sCxmRNOazzvWe9s+5Bc
9m5ol/Zpp78NuQAj3//933/WKb7rNDfcxXsEI9IyNkiW1IgLM9vsxwiX3t1J
b9gKW1wkCBv1KqcGGLqOlKIMc4n1cmfuuSi1EUNO6GxKnfDRwByq6BlKk1ga
YuaFJJueUtI1sfWiSwauG7DzGivUYpEsEUIzai89R9gMXWmxX+mJkl3Gg40g
Msbj3Q+ss3uM0+MH8+M7AjGkDGDcr9UqemfUko4YR+ZG+S09NzQVs2WoCr+U
JfvO1Nn+AdE/9alPpemxeNineI9TQ6O/CEPdiQJXhyjUNtMudcPwuPcQkh5m
KBvF6A0/4jJWgyTNVo/Xv6ErBalEWCKCUgnk6mGDmug3vWLuKY4mEx18M+cG
31hE7o5EG8incAb1NIF6A14ZiaUxBNR9XQWAlKk7rOO2xeflScrrCu1YZwxd
de+kWJaIoWWZJIyJq0e3RQCPO0pg2FSDyRTZ/6wLP0RM1zSZi+4moErxoWEF
jrJVM37+T7v5vYsIZayIy5BoprY6IpyIL2b+XZ6hPMIa6UUejywgmt8i3vCw
iTMsGkI25TmbSQ1V4yWLkGgMYGXV61RAT9PVLUv4rEtuBtNdmqVKkk7ijY/S
f1toub/tBXzVbQSvhZAIyrjGIZMXTY49wHeiTzPiRVk2NoisOcMHxbWv2fZk
t8AMoJNYVOPrf4mCLcPyuItP+M2bEFuYgQmiWbBIMwJnE1SJV7JJkh6ydFoF
JKIaaQakzGAgEwFSmuE9Squ6IB/+wG8yY7sZGQOKqAgC8beewUB+3hMcpHeO
Qds05PtJPMWIkUwQYLBVB6fxk+SEa2D/uYWyGpELJyo8F5cd2Oh/Hm7Lsowt
zJkjA/TEGpRuCGgU9d5uceKEzHzwN1TgV5JLglkerdGZSC2JNyWTeSBazEf2
U0BoofDV1dV5l4l9PWocTkpYzsUScEP7cZONjDGtTCD7QltdsRtIxk7xGJW6
tDw00ggyTWCoNK6qAuwAf5Q9YP+b3Vaqh0RkcCgdlVPzt4kPbBefyrtL5RFE
kD6ewXONeFENpKc6BHCeIdm5S3axTbOZbln41qVwjFUnh4y/FjM4DT4nakUj
MgF+QkPcFuojSJ5hwA14oquL+9S4LXIeuSteWAuIaoYMWN5DP/WublhoKxaC
m9rANuIdKck0I05Ds5O70mMy7W9TvLbDo97dYyRtQgmAAfxFJQZJ3xA6C4Ko
FqdCzRCddUcawkw3JFC2iTRXHciA+fpm4k0cI70S921R9JMuKJQm55Vpu77x
PCyOi4PU1giMugymE0xwRXv9nnwe02BWTaIgv+GHNCmN41j5j1nujB6/bto7
WkG0PQXwZ6YHO2g8jTltKPx8qjBGMaMaAeFlZpp4hOOiLebcabQGsAKk2RQg
Ni3M8zeBcCECE73OdH3SixKeZLqeeDo5U/KGD6bpuD9E+W/3FpNPgJEyZvkj
mEyByEC2BeaDOS0ghUWRj1OuZkst8JGupBRSlmZrE6rkiBD1Aq0sGh0hu9qK
TM0BZrQBoTMttxV7MaWHPrJ5eqsFmUSI0Ai4rQIeOk5qs5FhxjQRlVQDtC6t
bD1ObEkgCAABTbZPogN7mVTxoQbzrniKlzrNirE0PCv+qIYwE3gX9MXDY1aa
6BlTxOBmniNHI0nlczqmjsm6aWKTnWdTrOgt6w+ah9aKylx3ekoHk96JHED4
RBFvE0L53XgIdwk+5xS+ZuMVqWbQCLtgDETGdkXnWGt2mM1GlQAD2JetZmYy
+TnDbnyj35oYJcRkaQACWNEditIIehxiokdGVJSmRqyEpJp1T4ipQo6DYyWv
YMdUmdcyOw9r2DBFotXGlpHyxjb0VQ3Wyce4F2DnGTLLJmciIFulmYBZI0im
L+bsKWzLyAjAzNxpngjG32hLAph0XGeiRLWT5gHMdMDPsHe0/Atf+MLg2oeX
AkvluCg5LpJlzCbLvCzl432rrHI87rlgL79FwBheLQItCFqEDpHAjzkfvUsG
IxRgTpZ5euzlkNzTI3grTiySxtNziAxMpjB7nwNwQVYQbtqEWpwO6QRr9Dvw
CdX1BwWzuYi+M4YMEn2OUDAVZAxsdQl3SLR69CMbY3IK+tu4OKr5Wz0QMPUi
5ym46xUkSg5GszRb85MBJsJ8trAnsxMJRbbuwlnCwgwwO0ioGRlkYEPZXdaN
6dimPLzVy4M5mBt32HE2AeuyZwJx0BVt1wY+WHfZ+Owu0JcB7Maee8iBTE+n
SsIlWViQzVhypLR4iki0NiSjEupz/VQO9XVnanLdZEBwQBCysDGCRn0IIG3c
Brze2wMCPYOo5DJjtD1DiKkXzxRLmElzFIMPUG6S7wRKPIsqU6BGD95xUp7I
MQSPgPKJ0bM4PyDMpUhVnnX396QLgRnImMJ+RdYRnf+RyMv8lxgXv/FJutS6
8rxEYHoCgGtaEEmCPBiomcbEnliMlVrkYr7Ujlh6CIHgD7gQBJKZsAZQWFre
Ci+3EcA3eu+YvzqERIuyUmU62TU2J7tDPViMRo0cMh6tQP+MgwY5QhrMpGoQ
RlFQMVsorCX1UX5hOWQruIFQQxXd1MQsoKWRmpa99OAFIQNt06UANuIqnFB/
WY2EYmKAcWDtoISeA8iypfGWQHvdXeUU1pvP7qcOswWYwM8HBiraa+CJgAhD
PFd9vOIkFVWZDdr9ng3l+P6EM9ASPMAUh0INjp5NJIRfVJuvBnq51MwmUDQC
cYu2uOFCI8WYhmCaKWAlbxV88TASSR2uzPWcmpUTwevh6gSBNriD2r/4i7+Y
EJQMKBogcHFqVZTxvRJ4y1ucr3MbUZg81MFs3RIlUNLHM6rQfM9hNPkQraS7
6vJ3Ig5WlQtH0Uy4lRaCtCejg/9oH2YJGlE2jNJzWJJ9IHKAR9P9GkNam0aB
YuO1eow2jmf4oMQ63BYfEUZUCtIalHMxL6GgJ+r2LfzG9u44zjaHsYYKOZZG
PLEZjssuo8ql7IlF+QddbmWG8BjE5ejGs6lNmk2TQNO4PsoNfbskRebmNisc
5STI7prE/7jzN/tPZTYY/wIRkwPVLL0eDhkoTs7I6+SUFkgWpwjWlJhk/Igv
aB1NLIqdGkI5JNvgUXQINEIzNOQ6YiTxluR4T5QD2si8td8OYtEnXWVcpEC3
M/9HXwgU34Ybx4stgSt28bu+67uyYEBla7vKr46TNoi5pGuG+KJmfstZtQk8
XY0ryRbLEibkiW3yf1+BshuLKDM1hVYFFkYQJEA5DhgmeDtLTzA7vcniRrLU
mhKzBuHRnuw2OncmCvLH1KyHs2RzG60e2+SoXU6txYwZoBbnpRMAH7PSZ+6M
thGXLN96fZakAR7TiLWU6aLbPCMZOfBVfNS0PT2XDWEQxmTsURIpccnerFzq
ti2M9GCfZjtKYCpwHh59Nnuc/epz6iixzfPSrJ5npWrR2i1E+PSnP52VAkJ1
tbFaK1O4656IyhnlPytt1jjX2ndqbDCPKEDjmvc1Jvy78LgvoxkFo5Fr2z9r
7A4TKX1SxIAS8ENrifeI8ISoUoMyO3qV9hF4HCM5R/t+03Ngqilrpt1oX/JY
ZJqARXVkgUyLj3jwAl5XTAbu2cM6DY+UqRnt29/pL5YBM1gY9oD//OjYUHPc
q5qaaZgxBsL4vMsaEcO6epjJ13xXY1huY6mLV+nHjg76IqHkXhQPcqsmlPIa
g3elF0xqWpcWQwkg+gY+xnk3sZlV8MpZHbERwAZbUOd2ArCEUVosveC3gAVX
3/phPMo6M/LbuMy+xyFSJdi11PNJ7xij51IarwodZeSPAAPo3FGyDVxWOuwj
h0Hm6HA6xqIzHFjZoE+ER7EJyCROXZwBgYsYEy6KK+x3h0MIEXBSLxAjE6MF
ZrgOQ0SuBaYuzW70DQvYYzqOhueFBUbtmf9m6nOboaRfM/pIA8RefImMRyrL
SS+4s9aWX3bJpKXZDyi85qpewOscUA+LhKl8qkv0lnu0XfqAguTdhFTbwa+j
jwbL5k6XzyfzQyXqi1nJW4FYon95MEFA3a9b9S7p75BVRIesUtSRN55Swsb9
tbZ2HJ6ckMlHVJ9NRuqi8axkbabhaemEwH4eJpISRbIEPRiC+Ewrt/rPX9F0
ilG2aeOWsd0QQu7xT6LbcSrVuAfbZxv2kN6iEu9uWv+o4zQXWJhQRIerW69I
I0daUDIxh6GT0jykc5vSVIMRh9x6FCGSBsi0wggC6E79thTx5YEl9UEkES6i
NeKlc9JCDDP8mtbAzFDCNu9wAFieZsw9a23LYQQSjS5OOO3Jsa21jUG1bOIp
CkUkRFiEnYo1cqTbsifJL2XeHHsoxjP+kf4IT6XAMCPVGH863Dpu7Jniot2N
gcEweEnN4qu82oKss9IKGGbbuvCyY5dKaDIPDZP1hkaiTcGYJCwszkICxO4T
Uodw0ZSsORHrSloILDWuLo8Mi6E9ChhaEWzRWnWiTBMTxVSF1PRIK1m0ldMd
x6x5bNOBR2tPlxzDJYEUiUuzWfs4E6rKrsgEbc3eqGAgN1adSKE5yJDnqLcA
1pV7dA0Y64PA/d6KF+RIXMySKkQa9EevvULQeIJtZuS+qzDp143PfOYz2fL+
IfHBWut01WU04C7rjfBT3jAEy5k3d40FeGqjueS6qdlNscA8fjLOVTZFdhUq
Rg8mMB2SM+xHLLYSs4EMudVKV0N4twUA/QzD1hl62jzJTQGAQZVmxh8QAOAT
l4QRTfRuDgD2PQDnPJnJn/u5n4sOnML+cGqE6rd+67fi/8FcISxn39h3b+y/
W+MK4FIWnEs2z505Kqo4BfzrYcCxbXUpZG0oh6Wxa2j+RsAvS4H3fEuzclmg
DnXnDOk6f5BnkiSRUnKXQ3AxmgQw20i9JMDPDg7VNr0kwJf8ICzziPXsA2EE
K5qERLBr3bF0gvt0QPBz7LPuiu0FT9nqub0T/X5JHM8zQED6tvZNHpN2MzyZ
sWE4IeeCnMLxZiNUH3UKx+f0xOnMYxYocajbrH+sC3xZobuw90XQPct4I89G
L0gnnNE8ZV4/Bd3hVxhd1rCxPrc9wsaxms0g3wbdJQakxDnG1viboHtlZZOg
sPJlYToGbPvvjy2tMtumwPTsEaUYrWDcsjBNh/wPhRGT+8J03oi3ERauXb53
94HlcqScsOsnf/InIyG8It7M/a7SRQgFMHU1F3VfJM50STdv+rhfo+zI1Ix7
pPsUGBfY1HUQLwnGGZBsrd4IHbE4BbyrhfN5KeA9diihSPJ0gALVhdAkFv/q
r/4qZ0WdguEk6Nik3RWGq0qrp1N513z0ZSA3N0CIecblPM8PPAeOYO5teDtb
lORzD7zNBgTLNNmKS0xWBFkvC3uyBqfCdcCWnLVWByjcA1ozGdnsJP0BJN2X
zyZyvrOMrvb9slDPRX/WAoZXDqjfNx0zR4mogbFZ1Z8paDwCHnNAP/zDP5xu
Zys6162Y+uIAU7tDzpt5O+/Jncsu7klS+NwAtyW1st8VNXaX1SBQD4PbY0CF
18uJyciTYY2CuS9mRzKFM/NQ2ecmJakhe35XqG30GAVfCLXHCRTIZjKNTGb2
R6lYO5j3HgCbFWHn7gCw+Rrg+g4AO/sp3gCwMaR5qwcAbK73FMB2GdcuG9if
Atj1yLXbALaWQBh49dM//dMvANhJNbkWwH6+wDUVgo6y0ok6cahZwJwN+CfA
fkX4OoOFQ43HvQfi6/RTJ/AKmFhD6LsDfJ1STyXNMzuyeqG7AusAEdfLA+sY
DWOO1I9eUcVsMV5Rdd4/habD4XxOoWl6m6sZystpW5CY78ROKjkPOuq/Fkid
2u+KpAFdF4yxjq85jaRNDSffJ5C0i1a126eQdDQfuNSAjcnXYXRl3CuB0U+6
YghEuSAaqWl0S8txh+KTRXmfLFbMhBUdZvZhZBxF8mzmKKGKWy04uC+kJkiu
h0Nq4DAzDJuvioMQiLtugdTNIN0PUl/1sTp/Zc8b1DPwqRb5pQ0TnsbUnK37
rwhTs7ZZ89dQ8G2Yulo1n5fC1FfrCDCUJ7mwiDnORAjBhF1Z+XQKWGfuRDVp
dwXWuuV6ZcB6jAbzghRViCs0SLNO+Y1TqFqeuVL4HqiauczViukynB3o+2lA
s8hMdE+ARDnZP2II2hgdVB3od29s/aSLFp+b3aYorwiInyIrhkUp0DiGbDQv
6eqtefs14eWvA2g/68NcipB2E1/naDeOgtOV23fPd/o99srbFChou8nD2Mli
YNqsHj87IYk3IXBS3wDWeSf2ZR9RSE7J5w4IHB3cDQKXmoGg0zIezoTOsevL
aNmLUHnqQQCYjX5CXYwWeoKEyYJnJMJ9ioMPmZzgPfePcbl0y2jfZbcfpNDE
Mk/dAae/MfUH20mcaMCcMgItK+f1Zlb+JkH0ZqFeMURnlG6A6DGzL4LjDbbc
A45/5CMficyZX89S9FPhu3F41o0dPqsMeeUE0dOkwkzLDjzXAKqQ8jSegmxn
oD0Ysyd381L4/GptLcZTcQtEkAfM1LubAHpSHQ8B4x/60IcGQfadUIjiW7NU
LzmJpXYKOwBP0yg0UvaTnXTdhNGzce0dMHl2ZWR20U9VrJGRAGYZO5Lifigg
J5Brq7sHAXKjqF/60pdeJSD/pm/6phcw78E4/azD88sOQbBUXpiGoRkrby7F
ync/6xNOKaGWYQMXJL3Ej2s9sI1rfuP9oJ/0+r4gHYW+7/u+L3pslj6QSjnT
7b8W4N5Q1X2BO2WQ+GGHMiya/TtI3XaW5f4YuAe4vf1Y/aJQ5sHY/HFvPzyh
b5k8K1yDGdjpOZHy9RPw/FHpa4zXXaA43N0YVyWDmQGTk0J5CDzPXmuYr3lM
mHfUomcE/zZoHja9Iigup6xqn7P+77OO54CdbOdNkEiF0TzIQVPMPpFpNGdg
uM97Q3Ovye+SAVJEvkkZ0eHgkuit0DybRG3NveyWWXOzePevB6q/d3ZOYsHM
Jjxv8G507nnvQN/2vHUmE590mKVm7jJLHJuzNc5nPvOZfSEjKYD+bkbr95qD
UiG56MddJMPRaGuK5ZGYErjkrpA855hnG27kB8gmDI+BNpkEl8dWuuOeZpgt
UadAer3jkUbXbADKETBLLnfEjOCUq+nOKSQ+Iukxo1mRCMPmPzBDLj+g9TrV
gMlt8DtK6/H22m3w26PZNu0E/GYMm549AH5nzf8p+K0rN0xBuQ1+G0L1nXis
7TFuhd9iPVcDJ9lrJI6DCyUvlhkKAcmhwnGK9ZmDS6kkw8wzOR5e0SX1zpjo
Py7+zlkdPLBuZM+bV4m3hf+u9k6d1yPC1NoCLR+It9MJr3s0RxU9FF/neMEm
PE+nmZCeYgzRiFl5YI47ImES/jpY9jSkhidugdT6/yd/8id3gdSyA7dB6vCn
mdmK9U7w5+Gp76su9hADa8JEYAQSoWg2QnheVEQCyXM/8zM/kyLwtp+H0m5D
xIFVJk8xBF5LE+6KrOU3pHhm+juvR77FVA9E1ujnavY6yNrSWdctyLr58vsh
68seWIAABBC/vScAMWhVzqx8+0C1vLurOca3DVQPt+OanEoDJBNhan1ozHwV
mJrMkIkD77DrYpMMy8tg6stpU+Z62c4vZnqa+VcIo3NuTANBMdy5Jam9n9BW
itClg9GpnptvAkWNGXYCxSmc1aVld4bPY59ZgaUyCTCl0XEC3cucZqvD52l/
t3OXLpeZyT5BOUb24MjNtw02AwaUViqgaWtgc4IvICXjKbpCJglZYgK8kEyl
QE0wQyppBv0SnfSNp6+L5F2R8zpScqz85V8Y2nqiNOOD+v1AoVkEtwaIkYpf
+7Vfq+CZ9TPYdnM+e7eS/dvxZ7uDGd37IrZEmQY0H56OysyTwxEyjUfZcTaG
SrdWx8aBVkSSqXEnJlPDG2VvzmrvegMz+peab5t5Itp4Aa6G7DlgjGvO57a1
nUjEmukPd/eitZ1qpMY69qu/+qtx+/jOv4OdrcgKrpl8pv4Fazv7CZmtUEpY
zqiFB83LkaJr7Q8Xr+Prw3WcTZ0z9y2zTQE3grPtfvZ04WyvZZyqCg1qoLuu
fe/3fm+U3UYZxgEYiCzqlIWc2xtmfJc/95eP1BKx0w8NTbfVitMotZDMhrbn
yv77oe39QtvY0TxEXg/gppW3JrzHuRyos+29NuxB5vE1NbsZf+87Psn+QyUs
umnRpqlgqNAcehhvkQdxn+nJYwjOK5+C4GUI6XrKe+y4kYHuCqmv2am7I3I2
SkTIIzdZyetEKOYtjRdWZJeK8ASGuWsGnGPikPal5QSHSHzhC1/YTakOXGdR
sy8Hy5NNNAzX2W6XVP/BH/xBdJhSMgOWSqz9fU9P9AYrGVANao28Cb1X1n7i
E5/I2yh7jbX7hd7pdkF18axy+DcD+PO1UtOQjLB62/tlHGBhIwzfklHwPAsn
gFk+82qlspmKmAT8kqiBdOsM84B4TSsHaJ/C8cC50J2DWOcYDxnlnZmEs/Jo
cPzaKepGKI/BxJIJaAghJoroZZm1D7CH59rQ3H56APNyKBjZVDqtZdiyVL90
7Dq633dnwEBLXTaDEa7JtqTu9OAkwn+08ETdqkbTt1XM90L8pLw3cNcVKY9m
z0SYJ9S/cxSw7/YGkBbLlWHWtyMQ2K9AwJK7smjjVCxgthbCMQNNr9MzisDV
bPs677uJnDtPbP5xhAO6QFFvm1qOgHQKAZdJH/JnvOSF0cHlig7kqrKRHYNM
LoqTOBUtqAWlGNn2e6Tcm/X4135o/Nk4b2J18bJPwMpuQu7IKLBJgM3a5WW3
Ts3h9e8dQuw7VGQoza1pOpx5VTnBInuE6THB05VWW7oiY0vADMC6o2LMlsso
gf/dAoj9QQDRXGkYe2MMMVaNAdXATB6Hm1x9A755j6ni77YTAfYdj9g/jeI0
W1uhHifElCyKPCyAaEStCUpU4pibc8htYS/AKyu/7Pmu44gcZxHisO3EhLis
zZe3EKKuYAWPeEAi01S0On2OhngXKGRsAl9tTxXGmvRWV4mwT30QbCDokBVS
wn9ykFrAON6Ql2g15lF6lFVkmcNOuoAutWUnHx4DeoUau4uYxSaSYAxK1JBg
wrLttQ/KyJvjq9uNGmkEhyKdrvDkxYiEYS0GqeRCs/0/OU2pQjd6pXsNdOU2
FUQchr1BuUg468ZGwbrHcQTFLnEE8wT28qrLHu37jHDW1wy1Qsrb4ggkWvv+
DEvLKdD8hpp2E0wkhHCZDUYy+EmuOnu28V4QMloBXwkQuNm54LjfoXocDS+Y
ForlsltCBDWpWytGavKQbyZ6aXKiCFiy9bBGEfix5S9ujyJYhWaOUiq0g5Ra
sOYzDJUgIyorjgCe0i/wK4/SSY7AOGMLsl8USLjkd4rfTSCxpU+HyVMTT1QW
h9A9PRtnRo1HE0VwXMtWjLR/Jqg3Y7Av0sfY8Iq5pz0sDRbndeKfqUtlqPSu
gQSUKclI9j7+8Y9nYgJiESZkT8IGrfXLZIVtcsXIA1njJBhtrb05nth3GUKW
uW99KJPjnDWsucZIakIKGq+bALZGbQvJxogAuYBalvMdesM3wGlf/vKXczth
BZhRDIAeMCG2DSrDTDWyOLs/vxNaUJAm1RVVMNmuRraQi8tVmbzjWZFNTAT4
8hwi4IpvdVsVppyONfyfRqE8svbUSYFIHOk4PnW8nohi7uJzHFHUqJcMqJ2Z
asTMbY6ACxJ8rBIOg4pGmeOgAoOa3aujreAjyV877I1ZXJqgF4mipa6EhlAF
8JSeIE6mFy2Du18D0bBJGWFKZEGtQh+1sOT4nHuBBOPbKPJkWHG5UAa+M7Aa
zDjO3dpDgTtEFqlItMkWur92+xtWwwxIcl+2H7tncOHi+1sbjoOLmhHFRxoO
7xXfbRd4lRnU+f3f//27BBezDcegTE9SGSBMP+CSJoK5DbsTMcrXdLTGF655
u6ZXpGG80Vx7yMMfGKnkB0IHLt0AInqUEjhnXDS1eW0TeHuI4Zpn0HQPRMbL
cOSpEIPm4rDAYC38GMeZeNt4X1Youie6k3LfFmtcdLNLihP8Ao3Nx6XBUvC6
R2UesLBVfEH8Ntm/7Kkv/cw2KHwIWeDY1gyBy67H4jxxiDs5koskFQccW3if
4KJ5gBpcMMa6P4OL9/T/vqFTic9jDQgCx+W7Y5JkDrLQTXoCNGTckpmUtjBf
LOsc2Cx95NGy5t99vlNoyYaQpPuFG08Owg1RC6Ob4FIboTCytG0ePXb1kBUi
nvMU+bXyBa8MrmfgQ9Qh2SQazTZL6iRFgNO2vfww7tRftvazn/1sZBTgY2h5
ppWXeavbWtTM1CeszRF7nuCQ8E9mXKlZHQJbAiyyzEmPeQdvATHljjrGil1Q
AxWAgyxbYCDNPZ8zMxKPuE05MS7rab1ibzgweTvI5mnXPMyheZwkywR7Jn0q
cyLrRVdaMzKLMcd7qAI+IQfumRAG5qu+ueHX5+NETYTH5eaMeRvISbwSjxmh
7KY0oEM2qYA2s12vGpTO6sy835IgazLEHYz25Fw32LQSp0m56rczOB/3EXzA
go3Jab+4r1m0mKY0q5Ysp2ESrM5ZVBTkrN/ZzrMcHBi0pUSEHXs0S4QM8iGc
phM6CkPxVojw3h4iMkEI4/IK59VHDhqLshWvnnXn0nAf5BwLqVdSnRIHCUc9
B9qtbd13K3NPqKJSjAuWcv2RHAaXmuReJj1quWYKopgJUV52w+elwFUR8XYq
zHmf5IFeJBEEZ6RDwWzUOljj33d1EwDmZityNhN4zRpjuEK3zP0koUyTXART
4F3tEtL6O/bYeB3xZFYiVIQNFxZuH8tT+J15UNxutrKeAhtoJk6CWYhmdgRE
XXoF2pD4QeEPdKZRdzplc1vG2S/iG0AQpZOtolQ5MA61/EbMyVoOm9A8hp3J
IRgxJZ6jPvDLOgxu5CZZIgSssQO1F06tVOD5chuiU7VA1YMKj1YGkWyoPS3c
5h2+3qUbXTkwlEmvKJfsB8rkUGxemdkHdrQ8TeOx4zvXBNDDmOrpVDY76CAo
sXNx6pmumsUW7IZ3155eV9dorAXsJ+nwN5MSiWcTOQvSSK9j4lmyAHkz/pnr
mLKEWjOPtvb8Rg3miFnKLvY3B1xDbmCxHCx5m9wwcdBnDqPEPf1hd7SZoTAL
AGQyOoziGTaiwbwcs1tCmJx1COM2q1pxdrZ4HxsPvHOdhEH6wQ36Rg4sKOLy
QVSUFmapnZUkK6ITltXU9F/+5V+ON05Uxvq1DsR6kWt2dRuNfc+yBiQu+wui
U46ti964D2DoDJvs8j30wz/0ISpNPrKfuYYagsAaSD1VYD+pk1HJjrDZITVr
PlsQPFr+jo5zcZDzl8jL/Gmaq+/Z2oNVUYXftVp2yJRjHAoEZY3oURZJuKuZ
xnjbs6PKb+yaTWBhBZdiFEeZvRo1JODiIMYpyiDbi01ctJ7zqZ6FcxCQ95nx
W7+PX11p2vsziNtNAhKijFwKW6ECv2geo4TmepdkjOaBQmS4sX84isuDA8AZ
J8EyNh4EVU+6RPMLSvYziU6N/APt4+u2EHd4bKYRAbA4EpTZ5uiKzqxAg5JP
pqmk5NqWjCZkHLeW/OLmMLYwkPI32kamlY6krF0gCtaQXzIdiMKfkA4WeS44
ejyVj4hzrplsTWviMjwhoiBguOxV3FJFduqkgI2+gc1yXmRV7cEDbDW4ISLc
ZPG8DxvqMlyA3pow/MU7DnbQJgECuBxt6Xm/s8I4LZyiiegPxidWjF9JWEkY
DSrF4wqc+BXtTYIk6xR0iw/KuBBLTLj5q4QZdNGYW4ug6jw5eoJPrdsJttVK
tBG42eo4TH5URk3nZ/i44iB/a1jdchZPSIwO18Q6mUa8X/mVXzmbmgO10xph
TrwOu4B1LL2MXcJQ0oHGCesaXXJEC8WyLljjmRhxSeJnOs5SIYuLtV+H4u56
DeAwbTmIL8fuM+CPfu/mv4iub76dzXsyCwRqxFruPemuJoLhoxPkl4AAnFyn
JA4mnZqWeXNMeXUQU2oPIvqek0vpRRJWBIXiAxtiRf9rA0C50smXBytHLPVg
cnhf2KV5inomg0RmjmPXE9C1JrG5RDTYKLTvrcvEgUbss0kk2XKSGiKxUuxn
ss1MM41kN7JvPS01nYslg2x5VwTQlNcyAe5RD2r1Uyt9AGaKgkcxQQRNTM21
EkK/8wI6jY540UBd0kBWQBB1Qsai0xZKxA43i/XG5A7RzXxANbNI1sChWQas
Qk9yy3zrMKnKeiJV5TAlTkSoQHOYBniQDGsCjjOijbaZ+JCj63OIN2jI+wqe
9lNdoBj+J3NOuboIs6aHH1fT4xAi5p5GaqKm0Fi0j2fXnE0MrjoshaCoXqIo
I2tcKH7hdQYCdJGVZM1IIrnQRiKTZ5SnbWEokcIB9e7nM6y2oFJmigQjKw+3
DY9ddYXh4vkY2JJVYZgib0gdOlESzzApLv+HTtgZOsVJseDwKBn2FGkRUTCO
2iGJSGbjreXu0JAAuq9fTcUiHbqvek3zE6dPfxn0DLvqikToZGXMVIUSmY1c
l6/AZPwcClHoR/MZggf78otaazgOdVAwOI+E4U525Ae+ePBIA0FOdOgN6FwW
T1dIIymKtCaPG66CmtQWpg4X+Dycz3HgsPfo56MD32BVA2vBZNfTMJhmfpbU
hpTaAWNGukguSYphk7wyQK7cTDi/Hpz1CQg9IZNNCfQTvXBbGZB88+lRipAO
PEM6FocJQTbd5k33R02iPEiqKFOnlHFehDnT6ISUFI4CIUEUKFN9a/CVOiD5
29l92SEla8pJykgKc0CT2e6zuetI4j9UJQkeQ0FZmGazwwxJRq0Nw6mrfI6e
1W3PDj3Ibk2TYtIi5MoR5g6g697TrvrV79YlMajL2tIhQtfUMHKoGAREAIRA
EITZlno97rCSHJFDlUlBwWv0h2zJAzYL8I6JO9AxBwHrqVqb7c/xPWxL2Apc
ebTZ7fgmCQhRPiUjWLACJAMbIOucuhyyirRVKMmqMqgGF3wPjKMrzEUiQ7J8
NsnGSuurJwmY4CmHBGuCoTQcncg8oYjH+Dfk4ocSKzHWDCkZjzoPUj/rJNRZ
1gxOIz5I61f+EITt4zeteS5gdDTzspuscFa6RTwCtsxwJ2llwaoUF20nEFLV
6I0qGA/ENstzMR9HGHtv0A6wAo21HqIEvrmS9neCIp6PfUsDq/esZwpEgeoK
HIqDAPA4wrSWVhFkSpFc/5Ea0AHJnk4Hg830Dos5XcG91CM6uKfIHIJNbw1R
A1iUkJBpQnPmkRpsYvF00OuEii9ilWN9KRdNyCLezfqeH+w9pRmqPuu29XGH
OURDmUxRjhAGhXRLCY2oaQoczBYYy6AWmgPdMLBBllKBHIQKzjoJd+to0kpw
78QEKQezNI11LNEO4vAXvH57LGpCULzNVSIOlgWhayXQwWKNRM+u0x6wgcv2
U7nhMzIO7JBPMt7EICO2QL00PA/Rijqbi1UzSjZ0a7QG2UAKyV6vcKIxSJw1
mrEsyAlSSeVTXMMe7ESTqm88jGroKAQxVmqNfzFcctC3s3kvRxCOpJ97FytQ
z4e+9m0LxytJHI2K7hPUnB8viZ9n9Y1yMxg3iDue11m+Jl2hGlGlGs3kwEht
w76sga/v+rAZJRMrOZKfRjPGpJMko5ovGUS5Wtm1fEQoIha/QrakPvhKq4mn
37Tg+tqdiwMG+SB6wyEZagdJ3AKL+mD9oJGaMhc/tclLaYnfPF7X6rxzPgOL
pjU6V9fnhNZa5N20CKzIfK4ctoJHraw0J0mVrTnnvdUpIidLBscqMlsENa+S
Yur+gU+meucAc7XqMRATWrdio2QhNcb2Ge+bqB/K6P6A2e0TxKSiFJ7XiVPg
e0wksdKYiJkq0i8k1QIt6fOXbm5FJipweM0Apca61d3TwhC/piUGQc9mXOBe
diaNkqSsOsgTSc8ZErWXysgx3qEGa5PtrdONOk06mZ4aZvSZ6uPRjLtuOjwm
Zha6R9zQmKyIpMPF9I4Ophi/CaEqb/JbjskL//LRi0elRyw8hJ0eVVOTFJFf
MjCUctVdy60ZEL9FrSrls0NZKHpqBh2DAErTh37o3U0MuVhk0jQiNrsXKtIw
KuF2DuOOgaxxQ20tWQt1arxwfjvDogAZzh4Jwk0c03LKsDFzd8DMXsV+/sCk
ZiAo+z5Xs5gCdD++KxzMKdAjweDe5YFj8qlRwVfttDNeTY5+Ga1Tcp60cLUO
/h7LRbb25/mY9UhrlZgGtaMLmp2fWlGx9rg4HYBSq1HI0bMRO9SNVzsrxIjS
J9Y12ob5Mi6gb7xfnSqCqMQQ9/ok+/ZQBpBjf6dI15mH+ufnbLF+7DjQq8zb
Q9a+AqwpwU/8xE+cTW5lJKaiDKxxv1FxXygWr94X2F7XtKTu/MIRZkks4Cu6
Ero39Qki9DN0zgI3qFyR0LGVq6C+SBBdPKg8ElS3xM+EyKrr69HLJfg+J1xL
0hHV9dXqI8CxMtIv4jORTapInJYPf4HVyusLRq/b7GoMI94xhnpcjaFOxTbQ
8dyfTvBAYoOGUmc9lD3z2RhlYiSMrAs2NNe9lcgeA/jH4IkwY22sWJCuTxOi
y/kqFStI8GBVTOY+ejVON4agIlHvVYcbi+gzRxc+Nl9+4F5Rb81HK8ZNkRVN
fmTeq5gvIUDFeN8+78nvuliHT857eCd+FnJ+S+GZSXOi3lMb4/xX5Tlj2ULZ
v33C4aW86opi6qvr+cfzXjXZ/6JYIu/NSbr/+XyUSCRnkmqwQ1du2hrjv533
aII4UYz5vx1xhSD8w69pJhJFmQxM/B/nPclnDPQt1KDY4tPNRh4y8e/Neyyf
6c2+/WdvExNzvjF73Jj44fmoBcMY6NtHi0wJ5G9i4nfMewxqzrL7V39jmBjN
kXbKSQXRxBDIt2+d9+T2YlsuTjDx7897SQhtWGF0RWJI/qP5m69/xbz9nwsm
wETWN4zV1Ym7Dg7IkzI3haT5ryiyMfaclVm37gm/v3Pek09KDwOkOVzdMYur
+ZN/ekIM4oclPGVsZLiba/s7Qzq+ZbaQ0HG9BNLAVF0oK5udVUOtYUnaiPh1
KRv58grvnr/xnbYTMR8iUvOtszgBj7SmvFC7vnm+wqNzJJKwMvAE6M35G1cJ
xHnlWJDky+KqI0icE/RTBUle/VBAxqAL5CA1eCxQmadZBQpHjaEaoPmRH/mR
r5vFIK1XkdYcCIL10fkKkyxnTfWacF3NVxBBj6xsiox9fP5GjuSK5eCOZQ1S
NqzFgkfWuOucIRNZS/pbzriJfmRNsQGeIQKYhD9YfyxzdYQtMlf38/2hH/qh
T85iwBcsz8KJKnsitDkTk0IfyR4hNqygUInXKnuygSh+JHuYRhCI6rHsyVwb
YzWOeSx7sqFSyma9FtnjYmWl5WXxtsqefhi+AAUie/9u/mbEiNxoRuTnv5lV
oQXOakYjY2QlZ3Rn/kyVFQNhIUKRFbaJpwbYj2VFdC/5HIb0YwVmcUwzOQD2
my/8yHwFcKBIeQW//8l8hXyA0FrQdDS8zSLlcKLyVofoj6tBoSPeYgyAZWBc
gn3boGtsMGZsxVSh5gqeFEEi4ty5nypvoVeNkbpm9yh6eEuM8Fp2qb1X7Qqt
YcVMGkONN4vkAcImMZFbRYe3zJsWckgGlNim8BYCyUnXTXbCW0pJGXWSz+HB
w1tax+qZe/b5z38+vOWitMAYKUTm7/CWWQH+ZcYRgkSFt3okDp17onykCDKR
IOdeMV7xT0qjoXqdas99stSiJDl1r7Ak4W2OlPNKi8Qmb7s5OPrnM39Tfvp/
pmUTV7MiPmf9310f6Vk7vfj3fP5QA5ytxLGK47V/PYklijUnhdlutnSc2brv
xt8wHRo2FBgQSxxNqfI5m6sTs0mKJ75llso64ya2tNf/93mbVMe19G1kRmWG
bOgGw9TcSG/m/1Rsud9rjWBzOpYcDd0jivxBU4J/P1/XMMNatPm/nLID1dID
qzmoI9s4Trl77f8uWgmOUK+1w9CwGkwfl9n6MajyqGuMkWazjVxwjalWoHxQ
Jy7BHUgQcjC8emSiU3OtdQMrhDZgqbaeTPLbP5s9jp6AfkCHQbTmCDJ8AqAa
geOdkjlsDPlKUQ8apopW1TfP2xprDJeR7fNDwYzdypj4/ONDIpnLJkc7mZyk
BllkGAxxBe4gv+FBV+4xAnO/mUmRIQ/MGvUOqqTmBkj77lru/fP5g5bOVf9r
D8OcQGLKGeMl5/BjP/ZjEQe3wElS/82Te/qZK+fd4B4r/d/XHo9Vq7yGUhPk
2ACQY/bt2090N/EacYpGJno1CB68ne7ivu4ad3xBd8cR8pwROEnUiba2Gyj9
ynxPzopmkenR57FFp/d89JcP4OzQuNH+vxvdThSV2fJjkd3IRWZG6Fgcd3jP
JzObtCjv+kSe1JiyMnA3xGrUmQzqaO9Xl5+oZSk7x6crt/wWYfRIXtuV6twf
S9LGvVpd9PCoyN7kzINRht9xaz9nLlZVab+fl6ytx8YisL7c15OP+41afsjA
lAkg6VffCWYUj78EyGSO97znPRlqqMzBAGX3Jdyj9gw3jX3+3Ls44FNa19c3
H76i5NzLMIFHz0+wLaNfVfKPy6j0ybhjlqT5oMeg50bjU2K3ZVE7Mdtj+xMt
ypyBkL4KYE1U6q37zZK9XoQmr/SKk/FXe5GG/QuEbArCa2meZzw79oFeUnp1
rY21lyn85j5eHDQ4fez7SA3JCTrw6euyDnm6icagb6iyK+KS1phRwR03C3g+
S2fH2RHhx2c/+9k+pjK5MsijNdGv6GWl5LHc3cY9vT8r5R6waTof7/jtFMWS
L/JM0b0MlNzV0qkma2gymX1q0TETk5epPanFHFudY43Qk3i3apHShKW4+wO9
bsSMnoZ3m3k9Pykxla7HRAhdEWh/otysHq88zJYulSjt05uQtlW7W8flSy8z
WnHKHHeixUCGIbP7+yP++SRaq3wOkfcnZCCMiqpUEToyvBGhmyQ7/N+Ve7fx
3kcVz6e9rO4/VR/Kx6CAXB91bPVd3NKjaowz+nhK2WLDjn11tWsRxVtt3Ulf
dAozXBzY03C670Tly6MDfY6PCbWyyW61DelylY/zQprjUTnPpcxTECXPRR88
n8i4kjptOmVcbmzT+OH8gD/pTGgW+t/Oz/Pl2k4p+W2WrpZRxTniVrfTQYRp
TMKfKtkez2NV+q97sf2ySaT3L//yL7M9V+1F+3tXzUdgWC266upNiqXMAPgy
wDFnTj26ZsvTpdH7YW5Sz6z/2KtuknIduCr+A/23hbHFhtL4Pmf937He1K99
M6F+7/U+LF6FX8uE++L3nI/oe7Yl85YAWDQTwRX8yt9LFsW1QJbiatGXcmSD
vvzlL8f6yPhoojmNco7yUULaKt8iSMmA0fjxr9RWZs/mHv4e8n7MMZUhVK7q
DWMK/XXvyRQEca1Un7C5r1Pz4Hmf511Pjx4bgo/dazXXPYnrH/3RH93PFkgo
CfVE/6NVFwfznHuu8uMfh3RSkjSgcQEpzS9+8YsZ09Y+CTIlyScItKQDxsZ1
ozY43tNWtY7i3ujRYBqsRrS0T4jNC8ybNS0a3SIWcjFSZJ5vgdx5Ie+hX7o6
gOBeMSSgaLTQVLRIqgB2k6gLW2Uhy1FAJgscCyXByRS5EAcqzKh9KyqM9vWQ
0ec9ArfGCO9E4nXegGJFr97+ju/4jtdnI/HbXkt2MvEaD9eC9gRA8gPIg+TY
QHL7FNDRB1QkTVUqs0+f0ZbIhDicCRgHEay9dB53FnshmoGWRrqygFkFTRxT
TuSoOjTzj9MDGmLg7HOf+9zZJF9OCvNpPQhVc1Ib+fmBH/iBXWEAezc2AxzC
q02Zm4KKUsbf/d3fvZ/nr5jsbfK4pRCySvoZT6ltRGQ7727MS8lm5jEa1OxY
FuT4jxnMkDBSSEXKt3OWxsxTCbpaBrogpXG8dJEViEpn43qyiL3KZdDGJORR
rvYfty2GEj9Trnfj7WuCQl20lxh5BmmpUbC7vDX2Vxny/ZQVk3oxfEvI9RX3
0DYqh6sSlQYK5I7QpxneyEJsvk8/0GfUJhGZHXjiVVAtqkSqxnzL0WJcOKTI
vmeUJLvYln7qwyi6TqDLrB5FIbLf4iHYEjZCp+JpWjXTH4+yZJJTVibc67wU
Kyn3nkUka3eQQTPpK6MVcTws5UgQjZ7qfXrjs21Sv+sm7Zj39YTsx8WDsRxk
CNXoIldRPRi7f1yWdkUTM8IgAUtuqV3T4+yMgHe1mZYe6IqB4FZdCG7M4lhy
SDOjwo3zAYpSKxDybBafCEDtQIvnJFqNa7XeJUlBoAkVBWgikiBAX5n5KsOZ
LrW15PkaFo615Y3myT1Lz8hupi7S29bqFKlRirjVtE62TRmf914/YFscIzcN
nVFNls8KaJlKKuQtBNOEupgdIYlM+z9WTk8JYO39qbSjZmouXcuMXDpDsNEa
RfzNX3s/1DXexGqYXJLkrIQrDad3rAvXZvR825xo1/c+i7ikXafidbqOe+o3
XDAmso0yRITqqGX4RV6+SjJSeXYDxhfdytG4almbR7jZsL6/P3bMJYYd55EY
ilQMe5HwBk7hQ1WPJAQoys4ZhhXsDg5nkHVgvJE8J8Bb0/e9fM02+vHnf/7n
CRcUyUzRoFZ0VNtUkGPVxgxDlRgbwhkVOVZOMpXD1vSSHAJ527TtMZqhNXrw
xlQlpoXbookEgByjKGXPOcxMUZhiSldDMVGR7NpWjSm5VH34hTBN/A+Ciafd
zhmZMdPOYnND9BrvV4pj4Mg6VAvNW11n07gRTIWadG+2EuFkrCArwifDl008
cG3b4Wo4KNMe9O9iIlH9JKyGlbzPFiqTflIW2O/JNNIkwLvG0fBKF7gFNDPc
ZgT6j//4j9NUusVCZVvsLHNnwTMzw7i/6QLuKybbLxFYXTBjw9ot+q5ZhJQe
sX6JOUgR5KSu5sTO+oPv7S2Th/fNg2TWpBUTHRDWDLcsiGQazILKTseiCE3q
w/ZNJwQapluYCOx+Kzvq52fzJFz7+a+xJvMINWEtinpH96o0AabWKt7ZhDhE
wG4lo6mnxYXWtLvv9+w7NKp9V++NVad6iGd4zesbXCMblppwOuphMMm+MvTe
hSlhRrZKqFEJQ8TWAyL0CuXA0kapuv+Dak2ERzyP6THZt1TUPhBLHPqpJn1G
Fwl0qV1rs87d9xDSuKQiaCCbonaX1ntuHYsxlnG4ZVqEzjJdTXBjgcQ3mY/S
Snk25YvLgmDJDXUCfvI2NKhRo+Ef7L6Fa8NRiFK8J+6lpRb3mqGXqd7k2jNw
gAlbpcH9d/WYtJitv/zGXFFT7DXH1swagui3bJFETakvlYdotJUZpBdZ86hu
piqnkYoklNFUNguOeX3NNXTF4mkOjQagoqZex87xzliXnQ2MRNZ4kdlbpJVE
R42VIdAkccQgo+3KRK7sAwioINPFxcXYGmLXV1zCa3B8/ATjjUvmNq6DvcZJ
M+ZFi6YSYZJ9raTZiI4xzfBWKTGMb20n2pmz1yBKTBVxMFEX+c1QsiQUDdiF
PstrniiLrWgHbD2bRQtM1Kx/iqY5a1vbZ70m86Vww1Q9pgTo9Cunxv7juHXu
QsIteXfVx7BNzkZi7hir0nraxukFO/M6jIlyXNYy4/52rtRVRxsoYPID1025
xYy5x5adT+2GbJXBV/ubsSIy1leTXixtMVT8r2JIBlemS1wb5ZJLCI8oFer5
xG+1oCiUMkNJEWZWx0RpGeDCHWX3MEKoZ1JjGQ7EPFPyGIy4NtUBOqrDFFGf
ark1ppi5S/SvPCP6LvMyfG92IQtxqLzmkGlFENS+vGzzVjTc1Aj8gj49BoGK
M7d99s87UWg3d8LYbvy+6DjepZdxQc0qPJnV6AADQJCJAPYBrLwYkdo2lnrU
M0aZHW1GIBHkt7cJdmOSoSZwoIzJdjbS026ZNZNo0goLpxkbIpkjSYmBOhpV
dqWJ6M1nc2HcS1wdwLjtzHq1pgqiGFfjWVXQEF2ifJk6xNegKnjTfH9gP77w
gFqil+Y/IpqqRpO+qVeJ3XQa8TXHd72GYogTvxSzTqn4KpRGPdMzTVXRJb/x
vHptVk9MOOQYE87zskKmbRJnXdcS/x9ryDoL6UlHNDwMC84D0TnS2/fiap6E
LmqSpiWQAmQxicn66Ec/ms2boBbWiwiZjm7PBq2swRBHzSQRzWyvAlvSY1UC
WWQItVTJ/GwMGbEhNNTP8Jj4xj0yBn9KTWEokwXvwPAJmpSrPZqdQ6Z8pwqx
FXA2TEkYtAGIXme9POtGl2MCdcxexVxF+BUmN6+2Ug11s2kaX604TOesMF0V
msrCZc43m1Mt99yNajDsrW4LQB8KTnZAIRrltay7Js58A1iB/5iqKtCWv0AJ
vdYEhltQJHVwNo/RpOE46bkgGn6TTLr+7M/+7PkkGNdODM379jhLuFo7dlWN
a4CyJort+CiHOQeDrmPrrrqwk0rQnv5hqY7yCsImIpXsIzFBd6HIGxOm6nB2
cEFfHWXl0J1Y4psOsxtzCXyfNsfkuNh8Tep7i882CdmAGACRAod/eo0BtOIb
DoMtki0DAVcSCSJAl/3qf0oENeBjwy6RMuyj5oyg3gW6kJCcZm96l+J4mO2Q
ojH4ZWkLdedrNSGj5ywjiaJsq7oxWoWNdKfZ2eHZ39dr4NuolpqiRmjPHNtQ
h3kOuMo4Hpq4sN57GUcVUuMTP+f+dvjmeS8Dzcm9XtYsHv5QS6Dx8WyymI3B
Q/O1+fl7u0yzsURHU1QtAtEUzWV1AplVoWhEcjF6fsuwZA7RUdbsRlqkJWof
G2OOyZDwo+K26QIf6pJqBj7DlEFYz8BfDCT2KzozHfwPC6GQIKuKS5/F3FxN
TnDO4CoIyXC6uAH35QikQPytjBxmRRPCkefT/tfgC1Xr9BV1QicUdTuncuxl
wTrNPaUSGyq2Y4EGI7IFSwQGHoONXelWBMr3HLXIWo30vdLOu61w6UKaXo9Y
QN4csYB8TUHTSvLrZ1eTyUxD03gWniJk04UAqiwOVytC+J61LrI6m8iObCKn
SdFaPHLWu/Ou/poUF92FItNoL/mfk8ze/H4LvRWHzpAGmO+39IQIcutA1BLD
t3rrvK4VUT5G0oXWtWq9NBDAwBkAqKPWeAONuDRvGz55b/+beXHxHKiXd9Wv
DiLCtnN2upG5HYnsGOPKbwAaP5tHOZ/aI6TKtJBEYXSbq9eVcrQegbUahm42
1xDHrQLySs2zjd2aevPurhrQEc6GFYx2tunI3jVyDRw4fOu7NscauDiR0PXp
xD1knrrKMKQ8724HOr2304xKih/RmrnIsnZNF9ZQKU7J/aggngK22sSwhvaZ
iId3zfMnGotR40FcwILmbix90uN1TVWl5la7zvbCxtn9KyiRWLBKAGksGX7x
0wlQWa4xZWS0JVt7g4N8sTJiYMM1vpSmZNxDlxqJ4wg9KoTOGdEMaoys6hlS
SS9pkrio51PPPWeJj65OxVkpc88xdvQaktz0+snaq58fydYkys7Zs5m9jzPZ
BouoSjNCjdlbGPmwIS6OlNCSPLO5uKteHq2Eu1IfNgm2JSK2Zy96e11cLzc8
rWmOKKCEOSuSDoS7ut8TlE3IwJH4Fd01YpAdVaiXIrcZzY96s5RJYmJQcFYG
62xCHeWxW+wXOxa/pn4CHSlBqnVg0uMeciRvUkFG7Blw1exFNm6cSyw7tI/6
EAYmStIHfmhYIoCHloga4dYWJSR80zeVwUnwFKMQyUz4xi7Zvpl4JYtGQ1gq
fVSkDJqGsvPZzJ3YYQ38RqqjzOq8zfZ7Xy6KsmN9nVqK1tmBWBn/IedC7TvJ
mTyK3sh91ssbYzdJXkKI8zyUvMXHiQ9EQs35J4DT/yRtoWRU1c664xO6kBVO
vsGpJGVJOgYAxvEBFWXNsc6slkENyQzXz/7szw7GvLNzWymARaxvlQZ5v4Cl
MFEYRs+Zn9nYjB/7mo1BMmLi9ZrQDs/MXMYzcDAQkaxzrizU3Hx/DUdpUvC0
qG6zfON8HDSEt+iWpjIHMCNEDe0u/P28V6HXLFImWad6vZZjTFQnM+DeUqHL
lQ+Xi2K/GTuaLLWy0MKY1kzQeZ8C/oV++offjbcJ60AY/hJ0DRdagQnrUEjv
XMY/4hJRR70uAjYtSQjDkJBWC2WicPFmCKjpS0qGmcZyuFfyiVl+ffIN7KKD
cz7ronlO/JLdcR9oQZ04+L5YrMmuwafYuUglIImfhirLUZA6lf2ZmxUfq+7X
WbnsNkPCtmfES9cps4oD4qSadMRncW9s9pa16GyjNhkQYw8S0wEqXgN4pY9o
d9qsYUg6bWuCYm4gU7EuSz+oA7PWWrYvtzlSWtJAbrLdwjWXlFjuAVgxRHUp
TJQkgUnooAU5AeZq3jOMkOOB6gnl6JXDCYgSB2YryWarUhzz4NoOwdutg1Eg
ieg9VMI2Eyn0ZdPwmZhlamc2TqmnMLqnGdiXOumt7gK5YSXeuDzbfGriEe6Q
u4i+mhe4BqJ26zRR+hGMW6Ovdc7uGPEUjyotK4ZDlxiqJhTZXN34rSQKkJpH
zQqYO/NFJnDHxWyly1FWjctzShcn8BIxMuaZ+isfZGVNtLJVmTFRFHYbhmzW
LviI0+S4MMGAASsmvQKgRAxhGfyWsikHcdNvq9G3Y5QP19DlXrbQ4LPqChEA
I9hD1UGedX6aHMvMWNQJx6wV9PjpT3+6aptBK1czBbltCCGutiz+yawceh2C
Z3sROfpMrhcQSa9Jz6mYvCZgenNWIfPFbiHbGkE67z4BeUC6hP9x1eINFKVJ
pVU5Xm1s3zTuyWtlK+jck3iWpYC10nrhiUtrsq5DgovICMoy3Sm7z+SDuawX
41HW1NR9VKqfklpzv0GYCCVzka2OM/eOXUzSoB6YSB8QpQltaEE3+TNyvIDQ
mOANAfLMoQ9NR85tM/Oxfi/HMDbpixHJuSFSDdGUOmMzAI5Bd2VO3GvjQE8m
U+b3jclMSRCQTIjAXQgT0gK+D1CGwcsxjbrLKrOg6VT2WuHD01Lwx4Uxaan8
THan0UEt1yTvNy6kCkqaWbF5FUJlmDJBkGaxklBEszx1HQwYqtQWT2VNm6ET
ZIOPAy6YCOIAnqgx0iVpQe4BkegLf1lJTOfpPhuQVrtwsR5NT89gdTRu+hfR
oopZpR7RqktqwgJpbgohomgEqFst66CoB7rYJlHvOhqhFyKIiCL05yJ3TZbi
PQAx9j4r2BHp937v98JUOSA2XvgXGbpuB8ceFPAAf9hoG4+CvxCKlGP2b2Rq
SC4pxrhmdkI94QR16UeBFzJx3v0I1nlPfj5cqHts8r59H/gRJSyLrErV4zQf
QY5SvnKz317ABbmSP6ARUkb1fGQSk71ny/avJD1ZkhAPUDS8u21oPmZliTNc
ISjfmu7kXYIHnRtlynPIwMAIYWJ4KKuMF2o2EQi00RT2P1Ow9cBjetX3WR1v
y+Ngr1a2kCGykj1+mPnW1zqvnZnCEpiZ+VozZMYCK80b0+RGSfwJS86CN5MU
9epbWO/Ghtx14uExFWI/xpy7TSBcwsFQAQNhCYxvbvU23tJGzp60aoaxlizZ
dnEA9GadAXjRDf3cS6bfkRdqXjqNNI9BZxi+UBAt7NQjIioN4vIzA+j9/d97
A3okyYljDYUG0GN4NjqayY5O9G1a5lisyXwmRQfENvAZydZNF+luolQToswj
gjU1T1c4S5c23w+873sC3MgdWv/2b//2O+ajxC5LUzIkl820FJHNmY5w+mv3
BeoAtyypUJL9Y244ROW/PFA/7zTnMJky5W65/otl4oLWOaO+Kfoo7jpaP7S3
8WWUIDtBQRPuklrAkU+iTMHp4ZT8dFKLrxSnD3cZ3Y3c4FKOFW+wI+Fg8i+U
KWtvXxtrtqmliSLrmMCXweHDUntvdiCRYIHd61G5DfNBJn55O3H3wFSowLo2
LHk2F32R/qTf3jlRAfBK71h+OMBdbeUxmBw4gXlFkgfgb1XmrMZXgb/r5oE+
98DfmAXhSAe0yCee/hTWjkUxFNPiqfTbeI8L1mha+TZi7aDXfO6AtbNyDHCG
KlwozGe0otOIHH/OSjfHFZG9G7Qe+9lmAo6+ZXiIGmcgUrQuLWpOAgsC2T0r
JJSpl+VqrYqxAatcEswZZ7gPcGZfK73uBpx3fVIHkXW9eaRkFSFri256tpUd
hJxhGromqGbyb0PIkAHh4VmbEbwJIeth3+V6lPRSCPnqJELO+UIyZkYoYnkr
PH7/vHcKCusUvsCPRH2DwiPOJU7072Mf+1ikgp5hG2uXYyfDGmrqcVcClbtC
28zxrxbmrtCWfYTW6UuLw+NATkLZ3Vjf2npgpCNbDashk3fDTgKsNq/LPQAc
jaVhE0RMC5m2Bk0idqcAa10NcT/AOhKlmVMTHkBF3B+JggbxIMgUDdBcyrOJ
zE3IVHqp5P5OIdMMKRsbbcr2t/rtO6PQzEryNxBAbDPedAxBk4YjI2qjotA4
TdAi74TXxp9OYM8k+2/Anvp2X+wZSHOAPV/vusez+kBCEmMElf6Yv6iT2Rzl
5fDnZXe5mYNlQMA0M8kFdq255OjTQyBo+IOPOceJ4UqiocLPUPOumFOZPIqL
nXBXvsh1E+YU/2RN3yvGnFl86hN5EXbJKbgaZWMySLTrBszpaqryKjAn80Hi
XA0N3YY5qYKJadOxv52Yc7gZNokiZXYi4tNL/ZAdGqrwdIzzNASYfeWAeL/g
Izkjur5DEY1ZD8CddRrKq8Cd2Ycgn3vgTkKdmaIvwJ3QMih4A+6kzc3zvo24
s56A4nMP3CmTagwYJyRtjSX1LQJGI7Li5YG4k9plHnHIcYg7x14ZrAHqNVSQ
XZBjkG6AnMiQobz7QM7jU0HuCjk50FynIGcMUpbIGHVKndwDRI3rxlRQBMqm
W7Hp13Hn47UHKQmAXriEwOwCPlP12wA4UVbi1/UQwImqsa96XAGn+hLzL8B5
0R0BjcnYq0dai9Oh+BXXfTGn349x2V0xp8FT190wZ6aWbpjzzTU5Ss5Z50wS
o6RUzIQRWsn2kVBeme7wlgAHu48vYrA5FfA2ACpgOe7oXQGotGeu8KQfq9pi
DsAb2whig1XPi/+3pIRO0s9ofAWhkZxTyNMkR9fLIU/aQl6hGu6TBgNZkUGe
MEBLtA3MawnT5q5We7b5jGPwaS5dc4777qZ3XV7oPr93NR99ASCtYnhfQEq8
G2lSO19hxhfqPi59B4H0mVXgL/WNjpK1uhXWAyczZOTG6wYG5377awISn8Nd
mSLbZCgEeBmsmsM+TXTxrNnTmkeGMrHhZbBq1h++CKuyy7Edrwirvnsy4+G4
tJ/4OQr+/x8ufdxT5XjO4mXiPikWpbIpJLg1aLD6WY+SCDtWZo4fk50tj/3v
Sexn3hnatPQO+DQY5yFYNJudPBB7NtcQzedomCIdy+6+D8CjAFjzBm8DHr0o
IvEC/Pl86phHLbIMTnOXTBqmb342XQoOnasJQxFZIAQcJ1feDZsek4N5bfqW
InNgCF9XE4AkBIhrgPmOEJWuZGuou0DUNPYhkHS0ft9NE3uCMI1JkZK7IlU9
ckGj2QuRdqrqFFLNGuOs7LE8Ek4Bh0gkC5sU6dcgTM1WJRwJtbakgHWeUPUU
Um28Dq1lvQE3xG0mKjTsixR3A6MkFcH7bSdzHKLYFGcmFfHAukbLPPoicJuU
5n2BLMO6NOmyizzOoroHXwBsmZbx6ltdrr2u4Z7itgkDWUR9qUsEIefSlJkN
kQMZMVgrA1oIDO0jgO8+gXKPlfo+iLbqSY51WYDvsvMrBM+GhRJ8+NdcdbbN
yKQ4bkAyhJsg+sbr7gN41d7UK6aHYWaJ+cZ7zurNvvO4T9nIpmsDvcOKUWbW
ut0PS1ljAuLb2ZGQzKxrZAf2wyl2sMljsC+wo9AbsC9EeF/si4/M6kzGpstZ
NgUFPp48s2ZI9EEEqaO+wPaKXX72JWHvIfRqGOQ4QpgjYCn1Iag3LORItV/R
Bj0fgnIZsUC1nG0PJVKtm1Au9xKk9Tag3Bz63GxSUC5P4LoB5dKk5ktfBcrN
oVCuppC3oVyD8IHfP//zP/92otzdwiBARxV915xUnYEeE6YUy8a315L6s66A
cWTOs80npMnblAUuX3sYl6i5zyusGc2DJeygJbG3YVxGXTx4A8blSJsB+FrA
uPsey9ByBq1MJTcEmh3qQhVb/LhmvjW95TJdSlkrnO8OdRFV5TP1GgoY99Yt
4XzGxuUqEY88sVTQYfohDlfMDXhXxELr3y68a1gh59GFYZprcglb0bhwCu/W
NV5soiKay6zpkOh73+h2M20TeS7TVpHv1YSOftcBFptyvf05WeaRwQUqwJy7
gt3gUyzCdboLZiHAqdysHunNxz72sbRSVA2mcrNrqvCuQ++sPwz9UN7EqW0H
sbHl6jwYcHU8EzQx8G1EvUQdDp3p2+QB2V30zVqDG1BvUojSuePV93TYwS6Q
5rDFlGCKQ+qZUSQEJrL3u+cQxHwmughHYZfnoLhGgBzp+jKA15yWY0XhgnEZ
nZtXCuBFIz2wu0pwOSL43lj4jmkVsrWp2erx2LcB3JxtNTO6dTGEPsO9TeIP
MO5+YVx4sWGp9OZ6rnfs355I5az0MAa59TAdp5ygISErLOW9CMW2w+m+Z4Dh
Ph6s2ey02pANeUTiJjtBvZSBhJsE0GKF1McgWICJJE0SU0iAL+lqfjrNOLWC
jadHYE3heEUb1ZOSd0vK6uYjBJZ3bXY3rD1eInUSAO8XALYwsR/GNCr6j4OB
cw8R3cedvKubPOuGhx8tPJytqPURJPNexheruW33k2BUBUzLDKo6MywZJD2h
xw0aByUb8qBTAtg8egtK5tvvi5K1SHpTJ5vFiY1CdW4wfITV2G/GZi37GKf+
cnsGcwtEuI6aDynSlDztPLVkjU2wGMsFwKJOnmcnAjlT3SlEzfIx/UYMvud7
vufhiJrkqOAVIWqza1gibr2vVR/0hqi5CrFmFneTK76yb3M+3r4nomZkx3Te
ce++iBp8LjDzFKLGK6BdEY3O6T3zQax43oYRbgPVzKqNEo31tZJiza15FonK
5q11yHcF1ZcLVM/sab8ryhIBNI+QLr0IZDcIdRvIzk5u7NiaCDfAJYC4TbUf
Yx4wLMNVshscDPc4t9nMHIaA7IwW6Q593HbEOQW6hxnHeSJmJXc14+Fozb1K
KIEu+GSSJ2lQrhH/zMOVwqG5GNRi+CBwLpiHMqSc8biHIHCcu23BmvRYMoDN
WYZw1kLyC9ShyettIByG18G5E3YKzrHI8PlajD5WEwKVkEFMPm0V+ElJZzcc
A7F1q3Kk1O66YX6drVvROVIaUk9nThrHe61jcy87C8AyKwx/MUaPDWJWMxtc
JJy1SgeJ6bF8jZiAWcg3zn3bmELjFLMAx74rpkc1rmGcUAyYIRl1f3pqku0L
/uIv/iIFs0hUHjxvhI74kj/D0rTIHW1RWT0G7zqC33c5TEqvrIQ9BeI5S8TW
3QV0rjpso86GjDI95gjIrz6ZOc7IMDZNmYKV6CGQqGR3srUFNi5nermCveyq
ZK0bHM+7tRojalJk4eipaRrHeL4v2pj3Ti1ikySX4WSc1kDDvku5aAw7Fys3
lMburGlnI3/Ek89F3VFSakNVxrFU4971eRtPu4lxD2aOiSEsma2H4BwP/qzp
OmPfaTrA/jcrdAPid63Nqgfi16lxPNK4p17GhCVNlzAWnfR2Ac999w4uKHyp
6ohSKXqFK3zLnNB9gDNxCgAJxKZoMk4cTIttavaByOjdcs4b1p+5gmOsbwVY
SsBuWgN0LPQ9OC6zxXi3gh+Xpnkbw+JdKXKELVDlFpiPtq30Y5jPce2KpADZ
LGPzKDE2Oou71EdsMY7LG8W8zCwPLoHBZX6CtxgvQASKk5c4xvuGON3hmw3a
QeWn8P7CDGM9LHsvhm+CW3mlo5Do2vFi0ABl8etLX/pSyFUQ/zXIzx5WyE9b
aPYpyP+eogCZ5bCC06teO2vG2WSSNEUTfrM3dVSHH8QS/m1tbfNi3N+gU8X9
RJWupv/QA9s5pyzWCFlqkjUqwXRF/ZXeDIgSjghL2O+C+vcdQgArLGpT5dQX
4C9tk16gCW7BBqkse2ki8TohbqgtmAjT/sIv/EJKMContjaVa1eYCw+Ob+P1
OyP/fcd/LoOEhV4B/33DpnnvNvDvWjtJDvBPDGhYGgWagWs60LhUYy+N4GGb
Ip0C/6E18+QxQrZc4yAWw8sdNmVJG+4L/nFRcMJ3mNEIWDQ3elfwv+KZAf4D
GMJR3HRxyM1Wx61DAJn5E2Rm0jp1azWlRHGZEQ/hROBMUD/j6A7qgL5k9xTq
T6MBDLwxIWkFlcOgi1gY0KaGUXRRCR7IITHu2emLVQLcCEWwv47wS5SqHzG6
ATo4j2lZJe+P4f/N6H+/0L/CS97NxTkTwpSKe9k4qnGxQkKyy1410x1LTHt5
MRZ+rZofjoQVNulbuF4RItgHSQq2UjrUBTiDgmtPiKddgthYlptV4e5JX7Zf
zTaZoHn7/6xIFXVkrlvPE+NmLFLic0Ug+x6vZiC11Z8mWaWlZ7D5ghj742ig
4hQe0xvN4UZdsqPSFgxcHQQDPl4V1cmdTMi+aJWk/QZoRu+oF5f2+c9/vmZA
sJc6rd36dl0hsRKKjMKySQLmuqZJS3Hlp37qp1KioE5/yP7Kqo0ogCpl1xmJ
YCYCwH5RFJBgp0nQcRRgckVqzia4al8HoIzBBV0kDqHGDZtbIBIrx1U0VDdK
GMcO1PWcgoBm0LM5AHnSjpywxtZItlGfsBQ4C+vugvy5kWPkv513MvRNXn2u
jchtaQCjSoS2KXf6pWXsP8C9eDIO9eQD5Fxy6ADAS4HoVd1AFTsZI0UFdIH+
MQbsGCAMgOFxGAV9kFEeN/Win3tkem5EPoD/4wX8VWW2Yvbs1kReRdBfjmXn
gaXktv1L952coJ/AfBmXt/pAG3vOHFEYdjhbRyhdERRawAhhZuRHC1hcri5W
GGeJDiiGOE9mHeSHJKgDUM7zkJ2mqlfkmL2E7K1gN56MyWg2IiZ2ghaNOG+H
EIxp1qIV7czeYLIA/byt3Vgn2spPgCKXBo/Q6EWNq64/no5MGuml8FQ0ixSz
ZDQDWtxUVLEc8ORVxBkbJLv3zjXTC3LyWg4U1QqdhV2yszHB9JuW0skQo4UM
YSl07zar3iDbbUEDK0VXsTpbxyI5v5Jty5If0GKdJkEutWOJd0FAIP3JdCr8
I9uJaC6yCwqkDoYHmgQHFtDYr0URNK8Zz7PJRO5bklHfq0CYcqMWbHjttcVz
jcz4KD6T28gI72bYtYHPMIwVwGD9QH0BfxP35JmzO5nPwDBv9AZQbc5PN8Kw
flZAC0M5L412DwlZeUxE1i9+8YvpF8iiq/iOuh4FOIQFEZ9mSWJYWbBKVARt
YU0ki8ED6raA8nmHs2wMg5qBPrib6kA7+q5GZjyS1KKPUeOTtXLAQCtnz7ZG
+IQYAdUC6Qy7Ad5wZQlD1ibMmgcJgk60GwESmAl04A6jstuOvU/X6czySmJG
dwElmo4SLJV2MsMNWgwJ/GDvLTfNtbgkPki7LmiGfEOGf3Ian6mKDAxpBvoC
gaQ8dCkT5jPCizQEiqBgLfeCVBGd5PA2ZHG1BjF4atLPIOou0IzvyJAF6zlh
EIrDHZI5YPbzg9W5IQl28Gf66bv77AqESOPWKME4bQ0oc7G1WeokaAPrOaLW
tMfTBdM09TJmLqbcd5Qk9BF0Igm2z1Hifl/+kz/UehHbGlUYW67FUjV4E2Tb
e9g8HjolEBoNf73zFN/85qIUbKOZkOivU/gjrFEO1whNjVMgu46vjZ/zqRES
SyBsiFaJcyTGEOjpNAJCCCURZY4NViKikQkOh3gDRoCwhAHq0Dxyx2VXsCFq
wISVd3jeuxgTQFFpGDvGVxJNT4mQNSPRcYsPRw/f17FXtiYL+szO6DngTXKI
Xc5mbrGqXDFtYSNcsGfwsUm8Lib0bDtM6s2OsAgDLbUvSHw54ZBbFD9JbyAD
pyHThGwsKBbJeGm6SKMJztWUBNrqNu7OXa2HBsTWJ+hiDczGzFE5PDI11tkS
WWSnVXRYs5TG0DufrbrWwmy6LmKIuXIhNJ8c6tFZDKHHoR6d1zHBuo6RK/ni
VMUz0h4MbuIffrstNRDbLnRIjoccJBeuA8AmPNOsXUolkV6X/1ndfVeXGILI
QaoQKXNQawCGRgIWWIy9MSxEQOQ5geEayhYuRQEzXBOrQgrgUFylEL4zcOrJ
OYLNEI0o7fJalIZpWUTVehQAXAO0ce/rO/nJFfZIdrgrq8YMkwW9iOfV66zS
wBohTuQThXrY1igkIxeMiM6MHVvYMObZJCjOsUice/bzZjEQxMWYsbRYp8o5
VN6f0wxdycFwu+kl4lSrl+AdsB37451YNQka3sjf1ZQTe2aB883kY+/RU0xa
0yWvBXOjlL53dY8w2aaMyxATcsxHJqUM/EvRbYvBL7tigzwJ6fQeb4VsJUzm
HBBkkHJIUxwLnlHwMeFhEKZuehbCJOIzY8hktfBRwBRZSCYOD5l9TFmZi3d0
+kEFrHyQtwoBCELNVwGhCaYUKc7OUQlSEDlDj3mhinUFp7kE6M48b8frXPXv
QiZmycWWqSOLhbYF/+McXVkgz+fYbdzAHczDrYNY8PJgaYM7pjaJzHxvhiyH
JChZCXrkA1LhMZ7XQSKS5HPW/913CvmV+DR52PXbj3v8FR7xUVhO8BlsyFhR
TVifz9o1Ukl0QNRNCHlLEhPQKWOiWHGxSuiAvrO2eIdu1HQ7cGTszkiUYF2z
jvAJPfuSivkMk4Cv6TkJFiD3Yw+mODJ29JnEoxLsErTOswt7+UPtYnMFB/JE
7ALiN/t7MYvSDRLM4QNmouKz7pivetdULUYPSKMdXK+iecfoKzuKiizbms50
Kpp71AVea1BAD2FZOi1mygQs/Bfz47uqJBUxDTdar3MiBwNnQzyvewzK1iqh
itEkwtls8qMZmpAeptVPSsL6BuSjidiuUuC5lZbo0y3eWAWQIeoDAvAWDdpw
30W3O8IFYQgtZbCb4z+b+5Sw6ZHDN+crQm0NCTkwulEzu60as8MYtXmMVVtn
IQz+ESlohhoy3TG5Goo6XlM//pndE+pY99NUNDNu0Zxb5DnOelMuu9NJaKkq
jgg9YPX2+sVkF4ElWNiFtR7J6N2aEXreBY1Q0WQ4bwu6Hnc7x8YoRoSBqnQO
C0nQHIq+mI9zR3C5xuZnJk/tDs9RTFORbBpBfg5txa6bHZhHa3bzXmIpZBr3
nq/sJisKaxE22p74Cs9BEqrDyuJ5A5ipRqcO/cPlwaoLDtB3r+t4E9KcVSoF
RNkyMNbX1vVin65dUPM5WozRFZJtYeYaUR5N5VObYEEncIsAc/1k48lsHUVT
CVThgr18R6gmAMn+slTITeVZPEX6Tk6iUsCu2ZF60CQ3Box/JCOsjlc3dPZ6
d8+MG64SQqTVYuiXriB7Zuihl7CJT4bpB82fdXm8KXSi5QAoFdZk5er9sykq
8NWxW2EF4zuaSgweXB0kXXK4drUtMFZyHLpLarxJ6phYXRdRZR6LMEQzJetc
zZdHiuZ2lkWKxn47LJ6oBS+xXyBnVCqoFIQ4FvycdyUS2rsX34M0lApZtE2B
h8fLjEPExVwAuzQPnOBvRXtXPJe4SLqV//K7S+S720zr5cFiEI4SfxGPg2zq
FrvNDqCnTqqb4WoGIF5AXquaDqZF32I62LvWlJAE5Y8ZrAHhZPu7NzI9hqzS
Ah6b4OE0v4Vb2+73j7rGSkJzIYQXUPQeVHU+kR1vraMsOr3g95hwTfYOqmfv
FbrE7sit+M0727Gg531gltlznyQJLuK3vC9REsMiUOC+MwdrG4l6dBDjECuD
n4I8/YwvrwFOfDmfIRUGvukz68NGkpIAaj7jmN6QS6S+mZvgtOwnlw9OIp/m
M2QGJ9ZQ7hCfeCNuk9UmG7zWj//4jwebIBAtJ649ohlqUCduxTDXFSbQHIkW
scg8NskOPGVseVYeF4ak9Lq9pcuvRTChmLRCTA+OElqcN9kkEioNjKp9qwRP
nXUn9HitUvYB9HSBkVeQpsI+DUe8OaXDlAEGQbbNJdMTIwBHHPe+Ljnh1XQp
sWSzTVHHilj8RL/WtJFd7+Exv8lgBl8ahgoL6gja1WwEkUfb4CFipTYByzpe
66rTi/v0MyfG5DPTOEUb2KF4Ks9KFWps0CaNkrn8QI1Pzq/FJ6h8RhSyYFfc
SjLy6dt1zp6T6NzvL722X3PmxV3NY+767at1dkU+vlMavzIQqJDtDIlDqfJR
IZRbhDHHCOf19koa7Gvezpl8OWiLC6+dIbPlfA8VIwiLUFeFeVRqo4/d+rLr
4V9O50sDdd2vWKFWDWXssK2JWqSdd/EYuan31Izaty0dERnr1Ebx0ZSMZ18c
cWbY6vFcOOPzZBJLF8Jhf4+tRq4//6ggtBAvlEqdRCc5ilAPmz3r//bp0pDJ
JMiUDVKbsKfaHKRVYwbU1M1UPVfPpKQqo63VGYcmCck87k50eIroyQ5fzH89
X2uenQ4/FJWcfmK5bNXlcQDqhqUgOQF0SkudxqZUlG3UTNuoblJb2Zckyesw
QsVgMrcgY0tQEhAQhENV3fXaUXsEdONeMjfuj3uPDujCyRIuKZJ6SjEBBg7m
cfGpIqc+VBhXg4FsCRe1ybJ/+EGCvc/cmSYkMp7PcQSgyak3ed+NL+dr2Cxk
IKvPJs+iLwa+XWbjRNAaSQI/UMetmB3VRvw1j6RUFQ4zt+NQH61TWUgeDsSo
UpE6vR34kyNrcOhsUqDufOdzDPNVc3bESJ9MjEt11V5nPMK7fdWr2+fXiE3x
U3Q90nh/JF/1OdVl+kWcJRct2wif5DmUTCIzlI5xjxWv60viN6osZw0BWd1v
0yHPl1XyGLJvqwjGCdQqElxzueIQkCNehopmDgL6QKJQYkOWnU5haYX12fcl
9cUtIUQ1JNqVtVqeYym0p+/hf13nQ78Y/8rCOujYZ9Cvpg0DpVpNOuuE2B0M
QWW4vbpyH++07sfuowZK0dfZyln95RpRjFuvfrkpSD0eVqe1thEz0DIGKAsi
ry8iOUTrwK0YDLYZR8KPjla0fl5oXjtVlwFcN4iDkMkX96VTbl+slHM+RKHp
wCmHldYgNBIi69k0oxHRfLChbzhvZ6ATZQXOV4zeZ9Fff7RmN2uHdSaO5Qif
h0YnOLbyt/Fi1WLmKN2YKiimPHNG67Pm03OwtR42fqblGQqpTqFCcXeohKcR
MCp0jALoR9ipp8fsjLpPwQyNk7n3eTzJp6jaUyauvZoIIMjO/3FXrZ+hIa0I
Df1PIz7Yfzu5xdG/nvcqwPsfin3MPPp/Nsl4BCD+0XyU1RFQ3LS9yZuFNKKB
W7Yy+eB8tM6c/vC8J1H5gu1Bvm0+SjHEo0K0j81Hb5iqqwRB901bZfxf895t
5kAywOiSNIsWU/dT5uAj8x75EVXBKKe2WIjYHmnKx+ajJF1m56ZNCz71MI5r
lRTKHThOnyCUmzj+7sJxMd9mGu7F8RzkfQvHv30+ShmSxPjW0xx/fT6qf9kD
8eJeHL/oHMcVwwwu+dFlww6Z/dFCVqm1ITJ3ZnZEWcyfvaUu7sfsH5glS9MB
cYppFuK/OCED//V8NJIpkdMcXDRXfJ+I6u8UeytPouS1y8TYacQwNML/zu/8
zuPCtiJIiYIYLNyUy8k0iX8wX5GDkouQUG/3Q2NJ1AzphyBV9rK1B8GJdY3r
Pyl7l31wyetcOt0ldwyxUa7mZj40SyQImbZ3Xvp1QhwxM1wb4njVS5SWNKqX
aJChQljGmrIkSlLkYeMPZfRfzuqNa0m6yEc1JJwVbNdF97znowgMKG8Sohx6
is6KDeOh3zrvYeKhW7+X3LKJUtgvkNu3ZiksicEHGaUmuxHd7INhxkij04fn
baLC/ojMmvhGepmlbFDZoFmkl0YGpER65UZzqE7zFJFesp/RlyaTyadztzLD
cnJTglcgn2OhXcaMBCQR4YzlS6e1+yE3zUtAmjiDdEg4S6cei3JOmKvPUwGp
N8YtgWfkGd4Q12TmHiGVx5z7WUeeRRvHzaDVesoAJJqLUFPW5BIj1HorzMeJ
TI7RNDZIcpZgR6gzDXarb99hhhhXKNYEO3JtbMklGGooLcCLuuCcjDraku/3
TssKoCGghIMBMyjDxXwkPsoB9lQT9/HF8zzFR29s5XkPII0HZ18Y8p9cL4oY
pcCIrIOOErA3xxaD/TLHYSrCkR7oUcYyix5kcxAcbSyLHhh8ztNFD5CJevjp
E5/4xHfO2wyNaMXVIsjIPBYxigY5m+GIzKMDUJOp0lXmAWdTcghUdl6KzDPZ
Kkbjdj+TVams0aUsXSHf3zB/kz3vW522+8eyzCOAs8wXoTSTx99zpOrvziLM
MaqtJbf/xyxCcYam9Z0PAjGMXPBcjbPvnA331SQeY5pFFI1Wm2tl7KA5t4gi
USLkmRZdRdE4YLY9zYw9iym3KOjROiEoc6H13fOU8u/NOjJVSKeOxU6mPjSL
2P3D2WTjxplydl3EGHsGjdA2KYmIITTBmQ7ww+VpqsXWNI8cEeMiyxvfWW7r
pdvt768/cbu9FRFTAJttkgDyslURsaNX+vd/UNpU7j8txbmN17wXux8R8woT
a1mdcUgR/jdOVija72bscLzeZdXd/7s3NJXd/D/L++olW97n3thK9yNcuoLl
bN3nPve5f3nUk0n0y9J5tw3Jw1isZBBeejlybGPvDaUnQZNAtBJwN/+t2chv
P6JaptqxZ28WqmGK7XNQjSOJkAW6oEZzUFPIetlH/3zma/SnXyzuOMsMfmfe
M11jnffj3//k+O06EoKGY1HC+DcC64n3F/3y6/ztXx2xScrn/y2Ome73nOWt
lSvMTASoZzf/Zd6SNf26yUjJFVYWQDHVSI1pgeQVTOn/fzPvMeomTfShYve+
8XQLLnv72TuRo+FOXsTwpfmFTckSOInGmTc/MT6krEnT/zqJw5oaQNS29ta/
mbfJmzf4uXa7V/zB45YEXRJG1pJF/sCsliNy5ex4hTVB/9QsnxWwEkB81kj2
b+dtwSQcBmo0CvdaPnD3ah91wGYGTmImmR4AzPf/ZVaSzXI1qVWSujmrTGRo
VKl1vzVr9AjE4nM2x1uTLRzDJe7tD7L0rXfn/fajNVqYT0ZExyTLUZxXkzEP
cPFcqm3eJnltNbOs+QnPAnSxNfd3Ry0dhQ42EeOsNfLRxGZB0znFH75y3g1w
HvfqNgd9VHFcbU0OZ+V0EqHTOaS6OuSQDCRJSZX+z7DD2PWm3T2bqp+XxxZu
gxE1Q9o+gxHnnVJ6quzMNE5za442KSLPhPf7+VyY5JMUZvZNDwmUm/afzbdr
Hxv59qXroV6akrVxX13O5fygeMXqSnK/uhSB8NtaeJ5K3MwwSwr0PQV6WSGn
pOjsqFFbQy8WzTQmHrFvsXC9H5no57EIXpp1SopSLU66jw37We2xPk2FOJs/
J/FLUgq5eufStFpE1kh6r5I4ehMp1Ozc69NcDlu4Ce/FAUciEE3lEpdVzTsr
PDpUuasDA+DveLS8r+pT+lKNyRiAvG5kIgehkg9+bqnUYRp1je61sk8ZlEDB
aiJDkfjM+lvKCJNGR0cZ1bAfqPpRnRmaojvVIiFP6qzMTBkh4UbisVm1VMjG
vd069aO2V10ZxzplMuosg9TrU+lQzUTVEffR7JRNyL0IrDr305xl8W4+Y6T0
8PlKQzQJLE8ZnsPeukPRrtDrUH/HdoQCec62LBSOpEzB35XSawtrL/NKrVFr
D2H1gMSVosqMgfZbzp6r0hZnEY5WSQk1pk5ubcru+VWT0rA4rY38u7VSdAxG
3eT0dr0xqfyiPBdRzNytzB6pHfXLmMnjzuVik08ipGh0n6N03fKeFVppfu1W
6LQ9d12C0fPZCTqmK9cd4oiyIEtJpjXvZ7fsmSpSJPKnyPNip46Vfdqg9SxK
XE5zW31ZjE/fP2JokGojVX1YetSSW1W8q5td+2kfau4pIJBJVaeM8NkJ2t0o
g3Egkatqmde2CLuDDu9KWcfWqFpBdQzENHoRvZnWrhqfhxg6Ep2p98foNNJ6
rD0HZZ6SyTpJ7hTtDkHcxepjLOW0gLUf0bq5WisQX1JSBOBz1v/drTNVx6bH
7p0fjBNIbIqh9v23p2thYD7iP8lIsZ2gQ2JBYCUP9JWvfCW81mijtLIgFiQw
setQnouuRxblCPvVZnyqbEft63HDBZcZ604t1nsYTDMb1LCLIZjWkLxyfbfO
EbdIy5hA6zWNE7zVzXr8LUc6Shn/WtF6aAQv+/pZSV3LwSU30NGaQUmORYs3
u9TJbgvILHSxxswghqYYEzOnFVkJhKhWclLWSbpWqI3ESG39TdlwNbNrNyI9
7mQWFJsoboTSyA42KELo6H6zHPEKWiCT7OX97GidHpLVPfRAqtAImRSlHJei
zPfwFmK2MDcTkQ1gpmU+OGzmqNTVJz/5yd0ULTQ5dvXIqQaRvkajj/GkNUlx
hHnIR3Y8gvJ9auFXBQejEyaoG+mvnGfD0EMqlljmyEG6GcEjCceCl03Jxu7q
7o2T192TUrPQX11ym6RJm0iAuB+BE+LSGpQhJYR12751pPiP69VGySOJyNGv
5ysVkI/fSKE61U8hGISccIGUf/qnf5pwV7YAaTxO4uSsnk5fQUqN+Jmk73c5
ToOFyGYGBP0jmcH0huVCbl3KtK2kprkWRsKIoG4zEshvbCgxg6Yfd1tdh6by
cV/wo4yIMc0gKUYQyKAp7L/+67+ebBJXiRJSqV7xeNJwjeppNfXPEGomjjGP
VkEp0e9a+Lu/+7spGQHoGGlGIKXbf4RK/9Ef/VFW4mgbyTV6TEyNeErFaVjM
v6kKx32nKEDo6LV/r1YAIX0vpZeRH6NX7CR9zcQe9DBiwgixNgzgb/zGb9Sd
P4+rpNbxKnnOEJz73GbQZpZ0VpuIxiQckXKPtTm2uUSLKDB0pFrTUbJOYOM6
jT/X8j2jfFTeTSNFDGUF2ehmdsLLLK4aa7bce6O/nqbw2HLTljUqjoLwFpoQ
pXcPtSljc077aVN5QDaVPvMciE6YY54wsrU+U4Hw3JDMNnF2iI1G27eBufIq
B8xMNOcRGlCjY/4ws9QW3UIX8hwIEhrriJZQb3KP1viI9pkwQvVI6rbMaNdH
+LIYsR4Gd9wO1oVKj1Xzm0s+hLRje1H8rXz0C/jUj26c91hMzm7s0TjuZduL
zcfuOuXTlov5HBImTsyuP/qvvxQXeU0DMMHVc8jsTfK7Lba+Witq3cN0Gq1/
1McQCw8a3mg/w7D168m1RZzoy1tQY21AW6zHq/SHFHGXtT8xQhUd8g6GvnmU
5E6pemSk9S3RBgMUEp0Xi5wiMzc1KsbxESeO0HcWPRbEMID7ygTpjN+27pxN
7UPJhHDt0dRWw4acQ2641cooDOFTMHqtfB7QA20q9EC/FJOpjEwmPlZb3vQh
jtNPx6LKizFX2BXRyr6wxypDI3kQRbMdRNBwRYISgxLYWcW5Lk/NynHmjdij
G8/IUrc6QzeSgEg0qDUvHdZ6t8dWzOMemh23FJo2bGtoJmYH5zYDfdmFCD7z
O+HluxMet+/7KbN1YoIPoWCaoEl2XCdM3Rgzz0cX2aBjItMlxY/dHkfZwG14
iF+MqWYGFYXAmnQwGvG0904hJjMKsDUjLpvHd5SyYXWTLJuKhjCcJQEz28Y4
tqk1Xt0096pvuWFohtUwqSQLIThSE063syEGaNFa90Fw1gzsxoBsxwGOmo5o
thl1AU5YAvMJjPfUcyJQkrYbtDLNAYbU3s05DMuFoRbZidgsIyY+uGHdsAtp
UHSU+45ujQAr/RWZeAe1eQCkzOLMAKQc6Khf6LNtZnzV11WylsSaRqIdpAA8
6ONGnw91a4rL5hGwBWgJBfD6prVYosixET7uFQstMHePWmZasUhAn1naDCJw
zZmpZSEVT2bo2tQb8zlgZmV4Nzw0SE6qtDHD3iwGGqC1vgFOZ73Xh5Y2wQ2v
RD7QXPvQwrvmRJgChK9rb8Wn3fUjpykoDDR/j1ycNMvpgtewvTmkLHbNmnhG
SU16wAfixNr6/aILk0rBL49QvbU10EXvRTbhN3uUDPzhH/7h2ZFoJvzBSuzR
FmrgXhbqExviY3CT+ihaWO5X/TAMS+uIXkAd42uG0lkXlIu1eAjZYNy5aXRc
AOnTStDduLA4uT1yNiMO7kytNuJ2mWyGuiIJECQb/5m+5bnNdT/tLTJBRRJB
CygqIQNJGAKWUHXse4NAdd9MOsDaeY23bjYkG4zlJGSTK6m9R5gJrfKaaThC
LrMeGVJODE3QUa2hI5FqvQv8o53ooIPCAMWiB21vtvfJbBzfAba5CLy+tH5k
D2VIyBRJ04iU4DvoKpAzs9FcJvYIk5vbGnx+3sNTpWmn11SaPZRIm1qyf6G/
qfc6g+Sqax0GaJwa9YXMGnTW1e3ImaseMLFYNNL4QxZZqI51YFFjRZGXqHJ9
rIWmEHZ0on0bsx/1CXlcn6WVLKlmUjsD5E+mFidMorUsJQGF3LEJHEfY1q26
ZatHqCTJJSu6htt8jCm27fW6ngOE4J5ceo4ysrBBzWrRIy0/nyLOn/A7lMhF
obwrftQEVRMayua+ECR2SZ4D8/Ccz0BFCs1bs0kmov3mb/7mePzv9zQG849Q
TJ6pW4oEirNnD43ym2llipxHpvTi4iJU5z1mVsksUXZkNN+NLYF2ElXROmaf
+cZwABf+8A5m8d5IIrGIIRiec4nsBuE57zHzLB+RFmLFtgj0yOScFRvQO3fi
LGNRV93O8DbuMwiRP9yj1qK3GB/kyMbW9gEgU4yO2Ci7zzHxiVW3Md3Hvak8
FM+qu7iCO6wxKaCBZa45JqKcRwOpUAyE2kaon3bTQEzhnwgZK83p6lLfHKU1
i2w27l1No0WrQHr6j7nx8X4V/WFgdkxXhN94IOljjK+Gq0VD2UULr9zyQRy8
dI0tptz9+g5v6hwAf8s7EPPsqGWuGxkgN3wN2IApZC9jIiIQDOIkyTAMjP8I
qTwy2QxKNldLr9glG+sgrgZlQn8QgE28vI4BWb4sMCIHmb0BraGC9xthz0Cb
3UQLdaVwzVOw4+QvcRkYr8vTWSXJHS3weKaDf9u3fVuwCKeS0nM4mNYoOVkO
kiUE4dBhIwTZT75D355ncUkfoiK2cskBuMySwnWJ2YABtaOaia7EzfdW1tPp
L/hAxLVhh6IYfbLAjLEfhDxL3hTLvjSbc2aEO12r4/4J5GATU0w5j/ihdi8O
XU+0JptdJL3Fgkp+s+2En5g0vQusEm4wrgQc4AwaEda3lj2ewpz9pjTASDwt
TQ2jqPetrCHNRnP05E9ZCl4l9BLeoT21zECFKzqkJ363XV+17TIv8ZRS3XhJ
V0kf/sXYgTbimmw9JDMhBDUlOgqlqww+ZimXgmhj0e8YK6GJKc+azm5ztLrH
SXIhnGvj43j8Pb3kmHst91pWo0HfmRDvGX4+rM75NVlYE0Z4p/XwYJ+OwwVG
MYn17NhTpzjnHuTB2QzdG/cYl2z0FZ/NAtAD9KzyDxFkQREes5t6uk40Hrt+
9JD2yZPtlI0x3QmUogZrveS4zarZwqoFivVQHfI2p73XEzIQTzjY5D9TXbLO
Jx/fXZxCthFwkUI0Ts+xEEW2s5v3XbVcYN06P2rsd6WjiogHh6EFabpF2OOL
SEz28PVBNBewmdFGblAvmoTVhcK8KoORFAqB8xhdyKA53I034re0mqaz1mbO
N+cRdsPbWg1c1vMOwTFhcF6nUtnl8gd/8Afzek6b3STjouNIYUwW2UkW9W1t
tsa5WKoqEYLJeW5dbntTv8jtOkltLLWxtvL4wB1oc6w1H/dgclJTRRlwYf45
qwRSlNBz4szgrqZCeYWVd23h3a7nMl2YmNYCE0KYeRhpTC+jQ4RcvDKqSoJk
zYnkR99xvDmNhpPT+LrbU85ZzuHbUPySvCddsoJqIk0ccWaWsEfUXCuyRFMr
8J1kriGsse6SPdpcy5ii6hL0rb2axsTMrLVqcWJSdWQuQEY+ALPWkUUX3ZFz
AQyYO6LUJulnpVB2zlVO9mGUTVpmhNYO6JfdliEb2535K/wCu7aikXFWHFRX
SYkTXtWpZupTEfHgB0HndfDp2DOGtDFmCyXvV1SkaWuz43FSDrpypuvwkX23
2+w4iN68W92+QwGYus4B3fUwPWKTCS1sHgJCXnwuUxGdZ36Sg9oVbtpEbTus
fd8tGcslYiw04ioAPbJTk+RkxE4XeY6sSU/JOeceCORi/mMYEu9WGyJ/AaNS
koU3R4YOFV1sRpZrZot3EMilmlCHcSTSQp80gygJz1Ai4wFQB88HXtUFwFJL
ns+7UEf220pzqY+Lci5ZGAaXQUKZ8JB1xBBmrwlfaC0GEIwh7KL1mPnG3pK/
BnFSiDa4SG8zY2EsNy+EQrW6B3o52TC9Faewl7BtepYjtwWkYSxLZjEg+XpX
KVKA6GpaEDuRVargbpOHGDXAMBsxMrmEGM/kGjxBykgYb/NLv/RL6TkHBFAT
zHU2yzDUVED700UZDmSe26RUF5gx3ASr9E3TqUXcIv/FeW8TPMcaaxyyKrGZ
pGyowhTlLMAWbsdCQOZcGeaVU/s4DniQlfj3OXl1rLDlf5iidTD0vodbPDF3
1eqJCAp9JZWQLsZES0EPjzdxTaOxH/aUiivn5oEATAHX//q0rVhft8IUbP9/
7N1brLXbWR/23TXX+tZa3/fts719Am9vQ4KDOaVO25SDwXESaHFapThJE6c4
cRKLtqCmMq7BtJUi1RdcGVkIUCoLBZAvQICFSJCdSvaGG1e41EodyzIC24i7
4Fz0rpVaOn5jjP/7PnOuOdfhO+y9K/mV5vet+c73HYdnPIf/84xnjNFsWkYd
KswIV7jEvmlfOeK3rxVsWhqTNDFMs4MBV0W66fg62Z2BbNQlDWpnwnKCGMuv
Kyja2pghxTMuCjZtzZhwk0IJPGb4zAKU8B+Qnk07fbiQPFwMtcR2T3s8qTpO
9VTITWk3maAdmpCmYvFa+GCuN0sbXfO400Uvkfisbk7/NCQ7ldRNDPWNGdra
BPz+wDvSgCYV8cAaNglZVduYCnZhz9wD6CmLQdWVD3I220/+5E9mfMkrRU6n
LM7NBQAf8uExOElQpnl7x+VppnAHwBNS1ZkbaSMeAA/DZOh8DgF4pm49dPG8
x8/oWS5NIEIAPAqu++qddTSzD73DDs2onEx7pWUanqYcAu/UTwaGegAH4IvL
kHuO5sYv4RVxM00R8rkpbNd8kkgPt3Lyep2mDGx3kflEH5i/JiT7YHtKJ2pa
wED8zM/8TNiDU0C0SOFy8OPNYHs24MxzoAiBoCsC2zWWPqhbcDcddq+wnTkr
qATrm1U9BNvpklSR4ut2FruYnVZYjjW+072CTD+GiQ5h9tCViRY7ws/vf//7
M5haxgT6dgPM3lBxQDnBuASzu6jyBOxA00WzXsDsuU0vG26zPW0MklQKZTGr
wGJ2s/mhH/qhdAZ0oSiqFtI8TIzhP/axjyWaJ/AnbCoYFbnbAeqP7CJ1bNlG
IZlvKMqoJRSdJSMQWqZE2uAnCQByJImkL0kZBacHpoMxvFnqEfD06HVhes2V
NtYanDIyioJIOFbgrpxz/DDh+nIQ5RAMWvWmcB09OTBpBs3LrlEsAbBmSG2f
sgvXBT2qOgA2oLhVf90IrtNbiTsuCXxjCQLnFzc0uJCZwZwnDI/AtAnJIwTd
BRowLwjQ4EHa/dLA7exZE9Dgdm2nsa/C7YS2DVAok2Af87IosW3cnrUgpI5M
cxjozbrOBjrKIu6rwLt5WIIRcgrOSHBVxgHkHn2hCTqlacUsBciIrLSxC98Y
Xoh0IvfQGuEman/kMthOYgizWGTzRquPJ6ysiCYll8F2F12W3B46bDlJ4Fqw
PbTP2U0u6gwhKv22bdN+7M6jZngmdk8rDMfE7Y9cF7hXXYb4JIFJXc9AGKuT
Yrx8aJMcYd1sZNA7VWfk89g+9B5uNM3VRDkjwZh51LAv52pdH73z88jl+Db+
RWfP+TxA9A5UZn1ADdvCuIBSY5K0YB+AJ23BQhEF3mqmnlsxGWQlGngaoimN
KwA8zYpBXa3iSwH8ZtmViFKIQB9C69SqJgatQ0UuiQCedZcfDikRSBQMWsf/
Fa2zGagH45XJBlIFs2LephTDUPtAu2kikcbab3yLJE2GX0jcLn8jxyc2Fsgs
3y5Gxx0Ny16G0TEYRjMP3UxzOEBfXXDV5z73uZtidH2LRgmlk0oAezUaHYLp
JLzBsZvCdBk9QqRYto1jEBwzHoiuZMVEURSInpJzBNaqBdf9xGYjg3NET5Ij
5Q7eQswsNtuH0EGwoPpmebKxzAE0TvdBSSSxIYUsI6lIXCPWjMeLUFyj2jhc
AcWjLYxM0++B4pkOYgYAATPqjRdqEIi/SvSbOgu54DtKkYy2p4PGDYTCTBUn
D3A/Gt/ejiPvE8ioJMks7hp/Exvi1YIvweFwQKxm1jAWHJ7t2NEX20OU+B2S
XDYTvi4UHyiD9oCjG/TOWBsaFyxX4vYPGoXj+5ys18BpuBNWNV4uKNxg4c7s
L78PhYtQ05bryYNjt0VT3JBqM3NBpDxdg1yBuBShbC1XV+2qHkB/7rnn6sSd
6xpYPAdiuBbeHEkf/EAs0Zh8PH236xxDaig9kkUouqa99KgpeVigte2lgcXh
GwzFQDQVHSyOPRNhyIbWhjDZxcHi9FJTadEa7KUAJfPQ2PEwFh8zTkJ/aN5G
KTu+HoLcLlotm5AdgNc4MmdxNnuREZNeqE185mUe877hNUPICYWhCiTBwnIm
p1a9CbzG8U0b3BheD1mBbnBRq/ypWcILgqLHaKAOanzkIx+JOj4AmJnQuiXP
RcC86Wo5ZjYNR0Hdpq5acTdFy1yehFlDNtaPxsaFTYc8MMB8viRREm/JVDIG
zc1QHLGglyFmLUU/eulW9+Fvda1i/HF5jubag5zxQBO5K5Azq0rvuK5Gzsli
uwly7u0aRxvf7draI9pPkA0wtjIBnhVdBTYnh4niiXRQpKbQpcQBfpSt70sA
6PG90BmrqYG3z1KDFujJcusWdMAovHAYemQAumDoJIG7KoCeOxlcBqAxDNNy
AECL/jSevBmAvt2VO4JlczjLQXRA4MX7BKYpuUMg2mvt5+uC6PhXBCKATNwz
QcyKolPmvgB3dcFvTzCGM7VY0p84kbsFO2fU9sFl8s0+uQ7D5Wycn0QwaoyI
QIlHZfwj8SdlrCtWBpH6hmWjlgNYGee6trDyo8ttvWLSEsbS1hzoqTLWDyxg
Y6OiBS/Ytj2I2QUaZB+ImyBmWJWWZPVBQXfRx3UIMYtSZRZ0D2I2foqDi1TP
pDXlcVPEHA1xADGDsv1IjFHCg0LMWZFGtzCyFK9Z3+zwUeFyXYvtWmHy7e5R
ZM02AtA95qPQlGWhn5roHobK58sMvAUM7uMO04aUBSHQhHvAygBIrj1Y2dVI
H6zMFxfhNqj0cjYLl2fCfOEJ84NWijXZeHGx8umkHLM79xfvK2RRZxco11Sm
PQCZDshJ9c1GXAaQzUu4HixAZgPoAdcegAzANb57QAA50fxLAHKzPTcByHPv
vHsAyLSUcX5xALJYhYvENHRzBUCu+/74XADIR7PHNU83VQUlT5t5M5R8vuwS
xFMFrtQJ0BlzQIBReWAweWzYIUOGqAJDQBZCM5hNcaa4ipBzj78v/cHnuP97
q/PxNRHyhz/84YeCkPV6NGfTC9QrlMlzN0LNSZjJh1dg3TXIxrKhC801UXMW
H9PtfWsOerJ9UBUDGcCaceaaUPloDgiWZFVcVJJXxb3wQvst+7e8OCB5PBeQ
XFPKXTdAxpp+A2Qcugp/ZBFuiENtWgySXUAqHM7WGFdh4JNCfL0xpBCZ/A/m
fcryPvj75GyaaCurSseJRSs+TvR1cW7TD+HczrGbMcN9Zz/2zWmhjIRG0o2W
CBly18S8FQ4F8qbym+Dcu8ttukWlyWxNN6M7mKGmHJJvcgXEpabvF+JaDnMd
iDtPEtqFuHmMPk5edfxl9t6YLrvpPTCo63oIUDezp9SwfpvFEROUCsNzdzU8
sw/lRsyQKGuroMSoL25hxKxC22xzoguIUJkBvyNEnThzPRhI2wQ6a2wYbJk1
dH72rxDRJsN0gpyQ1CZyaOpkFPhiYtuzOVq4XX4J/iERdGmgwZIPey1Y2wzF
dWCt8WmiFn2jmYwYLskQ3yPUTe+z0Nsa4NR+DfjbrNMLB3+b0T8Mf4dcBf7G
2t0D5nU1OQit0Qo3Kjl29SWFg9PVe8a9H/vYx26Ge0eyB2iGX6vO4R43M/XA
VjGedftI0GkqUWEGHyQC/hq+2wd5w1GqzQk8e2CtkWkI5wpYK4aQ3VZ++qd/
+gpYmwwNMlwXqqlrNTbXhLXzHkCICnV/cboKJXDMVgx4bM3DwlI6iA7ZelQ+
xNHqDj62N/oLbsCuMA4VZZbdy0wbmPyCYtrjbuawFUzbKH67PHodWEs8TRkf
gLXs7LIS5roB35HaIgMcV9Lu6Kd2uppoVih0L/A2+/NkjCkU16GQ7stmt5hP
gZa5lvYyGMtdjelvr6RUwBxKgBYOwNjzyYSwvezVkP3e4WvWou6Br8KLQBCW
AF2NDB1CFas4u0C1Nga+Gn4O2AH4atIPorspfDV+LKF7uu0uVcMMHoKv0rOz
i/oF+DpMO+Y0Nk0qw4WAYRbBZFyuC2H58QKTByCsn9rfDxrCJlmaJtf3uGCX
R2fH+fJwJTliDaJr4LSjdRPkfXHZsx7OQA6Dh9HCDibKl727b4RfNSdgZw9+
lb2y7KfXDUfHnhZzZZrUiIIqCMo+pzZFZA/fFxe/ZqtyqgTcjNtwg1gsCVhS
H/aDVvAGNpux2LTZHj6y/A3TAwKt2sqNr6DVckN23LUHtGpYk9YHBFrNSlA3
l4DWBloeImilxLLjVquxyhtaWxD/AoNWnYzRbSrypqD1kc2yHHVfNoNSW603
xatCDSZkyYb0YeoCMOG0Nk1zT3j1bserqKy0nC2Ho7OuQAKhsWVRFou36QCP
EIxvh/Gr4hKO+amf+qmQgonDn/OY07ogAN9rZPKwkULl4sYaCHdRZI08Vyze
o9/Ui4H6IeqrLSDu7EPiD8Gy1HSoQMEKCN8t48Ra9TWwRU0Adiz8srBh05EF
vhvHFYx7pDMZwnVBnP5KEi8InAEAdX3LPOBlm3IgiSqXdQSDq7Pz24NMcxDb
uQztIg5JAns+/vGPp0g2TPVrsv31EbDEBGFsOqqZz7CQ2IWWM7kL9jheEPBW
qt4+EHy87MjByDfVFdIZNLYJtrgOBrbA8HCawzj7QRUUas1UpPRdB8K8camE
eQGllRk2W7t4RJCDkSnnpCIhLbL7m7tr0hm7NpptCnWz/L9B6pwlFcjMk2Q2
sRwMhmPDfoSETusnZq2lue4dSvfZpsakutJsXLCSjQvwrelj9XPwwEaQelkP
v+mC5K/x0igRfuUmwYTNbgQO41zRH5G5TL1dZ8HeYmJud5VkWRxTA4bUA28E
XjDXUuPgVJoLjtqzYK9qM4tVVdYsfrrG35lr7JZHA6op+WYGwx77lvB5TTSV
FOly3Yqgo9U2/rRfWSEfcE2UyoY3wdfrPh7XzYYYh+UAOiszj8zuAI0DYeIa
SsQY0+ylVJ5LlmQfToQ47lMb0A9dWoBSnXLbXb+3sw/KPtANFZBl8KWpvLrQ
nEXEHE3uUlk2LcUEqUypgLS2NYaoCYGsxqo0jxfMbbia8UkJ14bdxwvsFhBa
tu25QVbEON0oa7Zr5CmzNXuix9pVVvDRTyqjE4rfuG8FX2Ynmc55ZtfCTeg1
9cR9ofGGQjZjHWsHXYIPFY1rgr4JEjbRCTfRNQaX+1QU2LXR+GkHJ9S1zSLd
oT2JOVkN5oSpYbSJEKuSsBMEVblMSVwXnR9vofNl/7iDK/nwAcvMqItfjqOB
R+lZsEzOHghKP15Q+twNqkKa3cV8KEVXGhrq1VCl6BxoUtn02gj+uGsFxdI/
ZQGfuC4fDCLZWcBHMcBch0H8cVcSeAmXFLhG+sRYfbunXIvbnUlcYC3tZWA8
k32e51Z6KUK+ojSm8W38WwH8Y8UIQD7coaaQQh19EyRhTloLx+1HFwCPU5SG
3vx7wp7zbBh+sSzWkW1OkdQdqu6geMyGioS92bu0NfsWijNlEV5QPMvkNUJM
8yBJ0xs1o2BORywUpQ0x13o01GgQt0Ljy7Im/RBkockb6s4Q1p31qlnMZn9J
t7hid730z09ANyfr/sPVxwuAZziWTe0GLWzMblAqOAVrXM2wVeWgQyjaBOa6
MD7jiI/Nlk5VVEedV4sblu6vMN71m7/5mxXGA2j1BK+6sV6dCURg4ngdDC/O
WeEAKwTLpJMSU8wncDp2wxawbpnF2YfheR4caco9zRa/wlkWMiWvNxjeRaFC
3ICkQc+Gt+5x2E2zcPpSHo0i69kg351QKCje3B/TYJQhmqB6T4k10Q2NPCG+
CDzsZCK75GJeA8WnBAp1btNTt8ij5hgLJMsRx2WLvIyAiEYO8UhQHPCnjk0F
lS3yUBSmxhj/xpnK69hcsUXesl//wAJULNIU1jQaONb+Ess2HcOfgOAQsZxO
UrfIi7Y3PnCAq5+ZPB7FbfHvU2qgPM2y7Ne4Qvl1QmcgDJyDM5bo5qYzGNmk
9VJqIDyLtWyfM5ZgGgfKoFne0J1hQhozepeheFoayrAldLWsuk+8y+l+190u
T3CLihp8O+7tW/ZXt8tLc1AZLKnkDH6nBhcks+J3nzwKUbLqGKMxZqiswzqD
pAsoH6FZ3g9Vv4z+4CxPko+FPcc+8Qmbp75AeDZyWQO+Qng/tTG5DoTfWiO8
QnjsdQWEp/JZ9HX90egwRcWsl+mHQHiMsaj9427BqSAo64rN81g8GoykL48O
g+DCNU2pXQfA04H7AHzDbpuuBga/7kqBIAE8inEKhqFJaSIyXgDHDQH8jKf0
O8gKp0AWAfDMJkUKKTWBCf1YMBXLNiizOvcC4D/4wQ/uAnjzeU11VCMLNlOH
jYZ10QnSgr7N837A8F0RzYbuwne6Po+SYhwLfTV7lHYxjXjbDHVZI3MD8K65
KmPzy955XDXNmpvjVBCkBGsRdsG7+1FS+/bOM7RRXBO5P9P/O+mzwlQlrsiU
5nG/s+njGwQ/inqqh2VM0+EofoK+stJkCfeZ/vEk1qH75ZOx8ARXh8W5Ww/j
tUHGNHq2wGDdjmb1ZsmzVj2HD6I6HWiISQ/BVz38zvlY9z8476KcpAbgAuAz
mOrStbq4jFfL07AWkhZTrhlv0DpbGjTxyzSHYvCIomBqj+sKkNiIn1KpAkQh
gi68gjB6htBm6hbMf94f8ThxY5PQzFRzThwgCumcBptgoXZ5TzkNGPeopjot
sLLWmcjozsCwk5QYvAj8ZzyANvJSwX+4DeKiTSGflEHE6WMeQE6YZ9aMIF5n
GpU3xvR0cfRAIh6QcdnddzuHGc19t48nMangEJINgnwQE+05ioxdK/ZkMirI
ilOgO49RTMEEiOspQ8czT2Y5rkD8HOG7bEN03DVjam8eQ9YlYG/G0CpetNAY
kR6kVvsqOrc7j+qrflHSGg0DoiSbTxc03suocVM1hGT1aZtBcQqPjeA1RCpI
gFHUD6oDb9GZXicFWhn1Etjv+UbCo7mfo0e5oOP06DHg3Db82HfQm9XDOYQU
6VIkHeD9eWrPZspvtjdb5fes6zr0QhcFohlbDjK1Does+oxtkAqgZrEhByhz
zkwuvmq3t00jkQZmkRQYVJageWhDuB4dprppAxfq0yRQTmYr42pIeDCB1AOY
s9MMHkVoFmU08fEumPCFfB2X0TbC+k6TJHnbOGEeenk6II+km9LHGEjNNQy4
hwbjKDD665lDZ0swzQB4Vss4Oby+t7zlLQOKPd0XLosN8gcwlyJhWcBbRCaz
NHAFFldkgsWorvkgM2t8NpEuJUBAkS8jQnURZmRTD94hlcs2s7d73EtrGU8e
kdZGWG27Spc0pBojVX2Tce+VXf2yGCSPWqDdEpr3vFqhZ4Ir2JIz1SHtqDF4
gptMbSEaasCKDZSmpTqYU91ybJCWQgmABi350Y9+9GjS2FAIpoceVIqICjPL
Mhg2axfZP7Wqnf5Fcy1gZ+22RocnSMiSYBPlbbsyZ53WaM5Wu69pWGZuex23
Y99khDEgxoa5I7hRrjAeAAoUBNOyMEnvD3bUeQt7DJ03MR5tsHp654sXowc4
Qi+1EBLA3ARllPe67lCq1/hwJj2H2NKGKDWblcwF5r0bvAQ9B7RwJpPFDGWC
gsbBtUrXPm3jMtBalKEMAL9JH+nHwcACp70ZNC5WwUYm7jC9WZ7bkwAGVHIb
1otvM6h6qw+qd8JiPKj2+1HvzzhJOSfuxkXCmezwurnfAb/nrHMgVoASYtaB
dwC0qd3EUuPzQGH6SkJ1iEol/cxrM0VR5hednvPeX2RmLzCoInNiBk+FfgzA
P+TykBnfDmQQhRGNqAk0I9kkOMxD2+UQrzCEWtlTyh5DjNbe6fdiFKbf03+B
iNErml0L0kPqML/BIsSGiNKwohjqH715rJs+Yq0MMoPZ0R5T6xH1Bkl4WmAI
Qza5OlJBMGuQxRCf0QbxDVo6lkJ/YynUB2cGI1SXSTobdW1Qg1vB7zZqwaEY
kXolTwE5QoMU1q//+q8PRPby3rMAfT1HEcrJdwGMrPeHDULh6UT1+2aRQsV4
UkdzVFCCmogssJtV3RpBnAsVjWY/0YXAfapZ0/XSs6IQDBFHMsl+RJoChDJd
P/iDPxgwOU8K6r2GedMEwDOqnV/PnBs8IQkMRj/TvzQRtl8mxsYGzOmpn3OW
aTJjWeWmNCNUMChJp08rrKYfxa9eu+1sMWeMcFau8q1P+p0hS+I2njyaGJYs
UqPkkcrDiaZMdB9dskNJ1pYaY0Y9x+7CeE2lB9xrLcbO0RG059GsnsbI6WfZ
QkMgWbMwK3Un/rUk3513eshDNVpcFBoTWSlzcrCehHfWVaJeGO2cQq3Y6VfF
3mB/UJBT62cpS0ZIUckIxXCKQwhtF8cg5qrVaYx3d1broqAodx/4QdmI1zyh
VEt0gFi6Ee1ACcX1g0bmULOkbMA4EdFTY14RJhT3DZE1zT2mi1dkbJLBZSxx
mLd9UMKYwR7xntSpW7Qf2zMWaLlz2rcd85SBMh9LdoHxGiETF+W5kbk2/hks
TZdZw2JQ+UTed8ZG4X1/4Ml2xBNJsJLx11QyBR1EJZA57Ji5Q8FbbK0sdZQT
alAhLVo2ox6rVnWe5FqgCechnBygtJrSYLspK46MjtNvFIKajGkGCCpjMnv+
0BwgBIYXyOTtwj+okdwaQshWKg8x18OszhZniStDOFkw99TfNEk2AXEbu2Zc
PbK4osddrbnNzHZwO0SuLhfKuXA5tDcl5eR2HU+KDrkj2fYNNHw8GfgA5GyI
9XgWBbwmsqNI/aUNMfKdWRQmAgw0CH7wt3eMR9Npm9k/eImOT6sMR2Oik+kK
wTkEOvukU+EcPaVqZPIw8BxmIOGCKqQ6i23AMVTFT5QEfmtmJMwCVBpcekYL
6BmMgDaPFin2vSoPyqEqD5aLwmZNxDoMPhitqaSZpTyblo0Y8OLYXN3AHHwX
TKsduktrMCc5rt7fyoFPjA2d17ocHr3o44yJFtX3wyP7v8fL0gdQpuHywTF3
e4sMH1eYMLrLs8I1qGPoiBN91MBmFqACMRS1iUAjq3GkgolNXA+RcDidT1AB
MjEkBARSvEc9MoZB2wbAQERlNok4nlqMdTfUUASNt4ajTrvVmkcJ94/hRlvj
l3jpxfW3m656lDnCEUPA/e0ZXnYcGePJVNG84R+sZxxZYG8KFsCNJDfCXtcw
UE5IgevxU6P4aWk+4hs3VOHKkhsaMaEy4hpjH3Hnt6JkvedpHnQ/zazfe7Tr
waQhkAoQBHrhn9FdtK5BZ5FZ81WeT7qYIJ0cPCy7HjB7p7fbsBh5NeW4dOxM
XDwPISFbvBYkkRZq+A54LRlxrwWCZivvjBJhxnT49NaUxLpvOn7VbN3Cv2J2
dUVA9V2i3nRbXEtXSJpRyvGgmdKuPkt28OaEedZc6iv3+yybqddYIhROxMGr
upg9vTAk6hkxTdN0FgyzHU+qoyhGojJhrEC2nDhKGVESdGj8fUrHb0acoJBB
OpMWbzKX41wFvjAZvU/8iOwSPzzpBEachFn7PNDkOyBm102JFs9ZyFWLg3gw
btyq6qZkIHKOMgqs26ifdaVF7WZTKJTSK0ClUTA+CqIaf9UJkGiyKnw3XnHl
JV1QPIgN/2RzYYoJ0Sg5mp8ohPU9wwhFZ4IS0Zk4VFk5oSIaCPmkhhiEwcfn
vdz4JT5yWIi08JMLDwWrqUu9mIR2om0MNt6OVvIbTOg+EeThgTvaHgcGP+tX
+JxKoMxjh5G7lVP3NyCxUJDoGKoLhTNKn/jEJ3YcEkRnkxBH4zlvJ/3OOICH
BAwRGSxHuN2n/eFsDS2rFqgGzK+Ao1kMixpPPc+hNf+HKspz6J2E47uzeein
Ok/4oH2Mmo7S0rqQbmgSGFhZT/1+066dNRi3ZjW0m57ksfUM7NOuAd3XhTyj
96uWHHMCWVCckJKmaX7YSdfSzNrlZFdF1dEPqSfPYZOcclMTko2Gdi2zhIOj
Qi0fRaGaYuNhaIrfxOCFLsHSUdXpkvCSj2qVoZqMHiqiNMoG4io/93pqwWh5
hHNwz6g+A5KPoqPUUQ8lzQOzXenCGikdZRol91Jmqve8UAm+zW/+xkSoZWT9
HcpWYU4bcMMuCXVZOXcLV4AtgiF8iTxX+1KXH4dknvNu4GK4JZ+5QCZM42dy
Thdu9jT5dmGuyEm6Fmd+Za7jRZ6Qr/2eR8ODK38Nc15bh3o5id1v7mGWVBt+
32WS2qTYvrVJA5uauKUCmeuMYE2SzegS54yqumvbVl9ikINs1bo9n0TbRy+R
+1g4f/tNUBJUECth9ar8Z1JL3dl6vqrAqR3rvGia7HHNvMwxCPnWbhwvo4/U
rfjx4nBVQlk/ZR4MFVEzyhEls+w9z+Wj5bem+vW35zMpto9S7qNC3+d2ELme
Tz83DBsxsX0cZtR25SypPxX+J9ZWyVc1YxYBJoUSWGDQtT/kVb+W7ApI9nsO
8tpZxryMJFq24QrpDHhtemX8qugjs5q4e8/TylHFaNKYx60q0+8EC2mi8Ktd
zXP17NYIT91BxBu6u0dNhmp+5iDh8SuQvloAxczv6kF6lcNYVhE/2V3o3FuR
XtT9BPfNVHSGTOGxgQOdj4f3QXxokxUR7bsU4p/2+qGzzNaivnANpV1Xd1Qh
MppJcYroT1NeRdftqpUMosFE6X325+4sstrH5Qjc1WoL1JnyZLmrcksx5zuK
lTO/X7GebMH4iHnK3Ge69yndhNUq3/NGTMlzVaPt1ijMSjXiV1KcQqEaOI6W
Ut0ebXZIma0u2PHixpmubUC3ClD05lEZt+iELdZL2LNa09Sj/J5WMx4N2K2Y
wiNpeVqPDxR7yZro1817Oi+SIs77TbPgHSz7dfPRikW/fd6rKfnfMu+JBCQj
/jvnPdMw8gQObaLyinkP1YBHE2g/MO+Jmibv+i/OJu4kOL9hj637m3sU/qvm
PVFxr5o/e2IWuaOg31G0l1AQMb5Ue236UAiP0F5Jud7RUIFVVRG95hJ9o6Fc
VjrmCn2DdFoQA0oB8GKRN8O1L72STrps94Jn572aFhlOUScv0szfF7/4xb92
mN9q6lGyNdrAvXo+SumblPTtjddnw+fmPYKRPWSfuYQ1s7ES9omsMeC0E6Ft
f7+pYAIx/kMcG1YS24pM/vXChmLedaUAzVM25v/W6zPyX5r3vIlsBvjJg8w9
kj9lPIjCNYLkfL4d/n5z6b52+bm161Wl+yL/GPUKtkc4IQTDfQO2f+VUhdSF
8LxQQnLeGntn+bJeC4UzNq3ZB4QgIyTODO8zF5cxPeZBn5swfZhIXNr4rFp4
CAImnPj9L1dBGOo8AcnlDN4xewX8iys1lzSyYCIgy3lvIAuvK5hIhDQz45r2
8mlJdVGCNr88Xhz7pkpzP0Y4LKhKURSmM0zsfboC03/hC1+IrCTYhPqXyUoW
3FVZYZXFoY1YqjHJTygE0xoHf+tsPbsujiUFIaYwoWfVaH0oUwXoLZMypFzQ
CsU01/OJ5+4TJDIgD09srj17hSAxW0kka1L96nmbBhctw7BlmeyOLFV0Z4aG
l5EliDeQJfIjkmeMPA6XFFlCFMFyQb6mjw7IUuSBbIgfG7XvmEMggUb2I5kI
NMRAIq40pW7FdkElMhWM7GEZO+thThNmQp6YlaZkVAxrU9h/br6aqeUqdvje
MKD7888/vyV24ygVcVZil6Mu/YJXJHSgUKsocpdMNN++cbIMiol3ZnXpanTG
ZllZJ7grhOL6uTJhFCHMnsfsepKWCSBDZbLKDE2EkEFDszX0ODaJy9Ww0ZvK
o2R1jZ2dLIlr2TC4CmOm26owapr0W5RLdaYGXJLl2vBGGI26YKs4VXphRgJR
5Q1hqtfPIkwnmKGY2y5HHt2WNeeC62mkx4oWE+emySKXGSh6ABv3tcjzeSwt
EF1d7EimcJoL0zZCV8nUUmP33ve+96hT6rjjeebC9cM//MNjInDsX8PxIJmJ
8ohtmxiS9RIXNG4DBQW5ihnoJDFNzWCI+XHW5a1vfevZ7JfJHDE5gvWKKdGA
kQaYVcQwrvbKyWws3hSqp9CbqvqOwmI55Sl5Y4KJWIwq4caeXzLmRNm0EIoV
SSWV5iRZQBxJQ2R9ZhO/SCqG3Q7vD5WeDePb+ExJfdVsr6extWikpAJQkO9s
EpTGphK+dxKWaZTrLjlxVyS12W/7RBLXaDyLq2wi+czsmPLRB441AuyeXD1M
22To23YUpQSa5jp8xyyZwKo1vEzK3jtfISJ8ajNprZZvmxXSk5IrVMK8mOvz
t6maVmEERxJKFlkVwSHW5ruMOg2LfBGEHJCYpHCCEw8DHMCrtHh4WLpCVh/s
Cg4BmwxHtVTBybxUq2bstr/pqX2uEVLevlelBuemU7tSQ4FltZ2r+kcGjO01
TReUoSlmIWHeGEH5H2rPQo+pvMbm9cfLbfqsicx3FhaQjAI5g6NYgOEAghu9
n5x9lx1TCo5kJE0OPKHDGWczlhiuiUMYiDmJKWl8PKXga/y36dN3m2UzDJ/v
K2CBtfFEG59gHF8ZEkP2XfNRk8jm7fzWuvCe+agEOrfgi64OjmZ1oFdCqCmX
6oJNPREvGo/7bgLwa+Y93jMdDoMF+GNFzzFo7e/3F/xKEVFx7fFgGNCcowQ+
fH0BhCCQkMG7C+4kIkr+uZ/7uZfNR5k6lHY7IpPH8H0T/wE4H+n07P/80/ku
FacDvn1i3mO1g7z7w8/tvr3+809eUj/9fFHmcAwidlJ+R0EH7Ovyw4xXhNUS
daRa/Dq96f5jlhZT90wec3/UOWTT/yaQKv0X8zn8kEYczboyQVLr0ia/zgme
t5XXs+nqP5r3yD2jhYdG1cfdupJYst+K+p+3KWEsaZ2x4Wr7N5TQQ3Zi+eGR
sXQ4rQt2wnPSLzAUoexTTH5712y+AAOwT9x6KizdcNxn4820M+6Nyf75rBa6
pR1UeDSrZWp2ieI5/oJimroIUUgKi+7bP5yPGiNZRiIazQyMBpz09nhbIhnp
gNT+aSXOra5mVURVWexAyTX7O0g0pnrRr28h29QkLcY8Q/RJTDRoWZcsBZNm
aRqwd+bvTxLCg8aAGcMQ65K/EXTGUEaQq0rufnOWbUSlMDLVoJg0r+YNZGqT
doCFBBSZNG5nK+r7J6n0V/8Z/H8wa1M7W4JcVNk6rTImz8TetEI6OrEYa1Ue
+WezSIZRQ/hXb573eBYsQV97NwlX3RsprjoseNGzrz3z9+bLYK1C17SQEYkx
lKjaxCWMU3dUP5sUiNshViIZk/FqhjzMIp9G6M+3d817HF6Wcp0jHnu2sHHg
0D32GKuAhfRCVjAgtqHb6rFELa6EHqd+4yr/DAI43N1x1IsKGJvMa9AEOP37
S1+y10z6jGcxCYOWOvGpdTwiOrPPb/XfWS9h/I6cY0zavyfzB4RjxsjOptyL
AIedNNCvPvAnI5UYM4bPb00bZ/JD+3LbR7GZN+AR04ajwvFvsjuGah3rJVVF
IczZ5bG55tnW7IJPHde+190osc4WJRahlrRoPHdna+rfR/HZF1EoMwTRkpRd
mxDp1yuUTvmeCTXq/YxG8gMqC2aqx3P+D6gQ/MihXieFirisUhGbZpJwuCl3
e/tTd2au/ZI+4sRMX/XTukZRCRsgQe4pKuTJPc8khSD36qROVoEZ3F3y9Mnw
8Uqijz5JTVVMRrGmtcbwBmHXHvp474n5GxNXfxuTdmtZ29xwvGQlGO2+g8Ro
Xp15rUkflaHWs0FX6pGulKHoME5SxAyiqqp0tS5nilrvDcA6xuPFHCzc/q5j
kxZmowqtdh9b9e1uPHqrV1InLOfQpJ2GAtnG0oJxL+ClaoVJoqXv6x53myUV
YqXXmG/P0IVOSZ1YOnjU+3WycGcd09ulIHqicn6yZUbu7bhHOhB4rDP80gVd
mPIMkk4P6lwkZxobnbXyy8mybT97I24guHEyf6PboRVrakQElZkJ6rQ/PDkm
mscIh0kmcdKdC/kiB9g74hPGGY0ZZeTs9zouEYO+C1JRLuHLkKQqioRfo6x8
2vOh1EW+3daZ8ex3de26oe5my+hESyBBUjuqAsKqRvZ4dhZHo14UETZNO+r0
fxZDVAsdyxUxCEtDj1Jg14SGwXXhnJSfkOwqKqdLqkkh1WJronnSVn3pyUqr
1tAVVaXLmfbH4Mfz9aRZs81FcV0UxNvL/FhaQz7qiPm/bJODbd0SQsgkndfD
CzXxLHk2Uc0VHfjQSDkXNKKZ36ZayhqXSq/kkLXXQ65oWK3oy+hHf5EFuSrX
KDgKLJuPAXbcGbHOhp6PJ6cHplu5CGaJKLf+p/Qc6121Qo41vazbWpVuR2VG
5CYfpLGVPSNlWAJlp4ORsYVcEuiIQUnuRGqYiCD6oqrOL01Y9vj8bTLeMhZY
IhOiVUWm+trxEdAK7BRQHGs0tyYVj/sPxz2Tgo/ERX3b2962mc/ncO+VVccp
cmA/N9Nw8TzEH1c9N9Ks8abfuXcirUuO9+0eGRT05LWBioIzkHZCBSjY9ygZ
rRAr1/Ox8ns02Iy/MI9+NyU/Hr27LEDNR+nWAfAd9Y+7xBfgE5fJZQFuBYz8
d/8+1j3yFKNvauNaAIVMB//QWKEF8unnsnnESR8u81paoHjhi2TTkAZeqxik
lQSWPfFS+IePTbgQDIpGwtpSPpTFfxQO0aSE9Dlq6LkG14d/ajpqkHD8q4kx
99lM1FBxzLGG8i3RZDmxpNiiOCcdG9bSjgyMzAX3RG5zzzgK38mlyb0oQdOc
uZd9llbWutVjLXA1vxXN5PO1vh3NV2iAbXM1MvEFp0lRtB4DjySD2KuII7GQ
SBbaNvf98UltbKRnRsTP/hZPiIXEV5GVbIIkqNnYMMS9iLBPe/gPv2AEoXRw
hNu8tvas8w9DicgiRqo3I4G4yxrM0672xFrQxyPm+/AFXsqeYllOtI75eJv4
CZUK447VpUoYod1M3GTbCOOE1Y2hJhmz8fytzhtCIekmoWzd2pTxYa6BrAyz
KnepQqPrCmqQKJNXMsN0JSyNYqhSUZEYhEmhquqpf0kAlc01nSiZTMs9Tvq2
Dt8sOyrVd00H+5WIpQ94RdvkjuQ57YsmDWgVXCIy/SDA+VxdI5s25zy2Vduc
dKWU55DYpMvJZDhg1Zp+tOrgc7A0c4t0Jn0wjmjUb/zGb0RD4j0PTgqlM6b4
UlH0EeE4xP3JrxWdS6NPZlmItz24Y2NXvyJaoCvimWathCEOOTUhQipYiBB0
kcFjQprk1d2UxRLreFV2zLoyNtk8W1bBWyz22c9+Ni0kJdvk3/QcEHBtLKdc
tZagExofz37jeBFitCZVpDDShD3MB6zq6WxBsYSZqqIMaEZGs1nBcCIbzySp
LkDWVEw2TE5vs5BvJfhjHQeIHJvRVDyiieFS9Fwfb5qbJhXeMIHUVFiKxD1Y
hM5PzxlaKEWcMFovkT526c1vfnNe1/VdMKsmRYhrk3PEQhgpU95iLpbdiEam
C2OLVs8++2zwLFCQaapodqUkPh2moU8Z0ShG8LHRLtiOnc0i2OjNVuxmUg9r
kltk8LP2CvgRLnu8aa+gIt7zhonPVlsoldUjlZekiVBnHo9mZk2FUa0LOp5y
YH7XZLVtOuAubNvUVIpmeLcFdYw/rmZ+EqWVUWVyV7aUHjDmTYs9OuuHCZCR
/Po5msKvlJPKsIwWJBXajBWIYyCzLZt35YYZ/9VrPl3yTMgtNsPGJiZgvEBc
FPK+32fzllibXht9zUdo7WSXRgB0dDtYqYoCvLMP6m46xtv0iLPLZPvRvKfc
4J/E4vyibhcDhgGoThODOWtBRonnGo2yvEaTzWlQc8ADKVQ0LJIctyy2YlJJ
pq7hK6QBHkb40jPPdjIaGrlUlAVllEVbMk6S3w8aIx+E0M/H2IwOg1PKMFzs
ob2CdN2KVLqQrSPOSZgjg94zl5A+GSKXheFzP7vu0GAP+wywodlRQX1UuF2W
zNIrq7FTFqzSo2bXoQ06k6aHJOxko8m4i3lXTIr0XdAYg6saszfVndYphhAT
G4zLt/WYyXnixog9OjVQwDPx0pOctYVy5nQMbGO8ROu1dCYXL0svDaBi8DXj
S0p1kh1bPPE39LEl1HJYeARq0ToKXhKEGXw2CjtxARQLctFYxk8KumKDT7QW
tnDBqgwT0YSZEJNykfrADnrPOyhB01NzLj30WyNgXTvfM+yao4JgviuSRLvn
okRo+WQgYlVNIR3LabAjRYkIEtBbk1imSmUB0fqZweDyIlbTxUMQXtF9EsyN
aXADrRgmxzGBLJiSr5KW6RjryiaZxNd5M4awro6OBTlj6FWvxZqDLQyQ3wE6
KeJ62YQoxkf2plkkxrkx6dEMDxsy8HTdp3HsWGom1p4rUA76eNr/NAt63pn0
5i+AqubCiA7zkuEy+2fYIaxxAsqoExVwG/claJxKgYbc59KMGIrnn+zmiahm
Wtldfm7f265Rh4ijKoOPs6VsurjOqNtPppx90344hXZWp76C8tKbDDbvI8BE
u2eS26KhSco8XOCR7LNPhXHdsboLqdEAnahA1oC6kx3nvvpGv8eGX4x9dr23
I6RnkktBlHwnCrI6qS5tyNIu0uzSz2j9HFRLFPXT+42Ze85TrEaOB1nh+q1O
J+NOnImsuporGTgprJDr+JFRGOYDNNZjpJ7umpTrCKfRZaADYYCSkkmmEeCl
N0K+5CaKffmdU5btha4jUEHFVK73fahhV8OXsY013JGu4d7eoaaxn5icnSS2
FGWLQVdCIO6Bbmz+rSmTuIfMGhU5QrgLCXA040Hr9ImnYS/BDq1ldm3LxGYp
1pR6YB2NrmohAj02Cov9eWXnQ2OWcx6iuUVN8C8jQi7JVeSSbJEfwItF8L/f
mFWERGQmtKGpiKyfjB+nKoEbMJbWd5+ayGwua8kewfgxPFgVcf2ffQGSxsrg
MDxRHYg4xv0b+moalPEbQhIpdUEYRIICZE5ZFXxH/ClQGboS4uhw1gQqoB44
ctL5QioImAiqJyE07I+kwd8SC5kPqkC/mG2qLbsdAm3UnDIgHXTAZNmeAz+z
dtB3tHE9cu+R9WQP9oCuZwcChZEZHFgz+sfOWIARpG20kUa1Rg/SoNWHLfr6
bp64DLJtcUTgBDLLysMNnhQSp+nwKUPvGVBDjIQGk+5H47oHZxtepCf+fTPw
Ru6IrqHQXh4gzUfkAYXFRA6HQibnqk3Gts26niXknpSoAJfpKhxKqzA4UdKe
xz1CatmxRoQKPJcOme2TdEdcBXmUmd2GiTkSYnojEtLAlxS6NlHOuuNdsnk+
61GO7uEOISqclBXEuguTxvDgPpxneA1TZiyQUrlrCs2tPrxIidOyOLzpiUdn
UVQAlUCmyb+iUFwzmXiwLCpGVyhIeamaSjEbIbZ3bjD/Vyclw69kPJEeEMq1
8vuADEHPdeNyzGWEGmMmAEQHZrIkZ0GCUIhKRDK17TnOhL8NiEFTVOOthAUl
mCQjxof1sPZmZKGO6hhW7Ct+lHto6+rn8MzW9jDGBOfLCYUny3ZXWAGKqjOC
OfyJNKbTmuRyv41Dgrt0VI6SZ8PcXY7DGcFDWlcMKKOUIK4PkwYJQRlUT2hJ
zvJMLHzgP0Zv1j4dCTgQWzOajEH6TgvFCjc+jILGU8QRfySDKodiCWc0RBqI
rVExhu7gBxKZuDCYRofi4OSrs3QuurgNemgBqUOZnMkM2MWj3cdKa2odOlp2
sRnTlmpxNb8xaUEwk1Lh2sYm0blEBUXo+HLwHoeThaTyW9lphhYnFlIP3zBT
NE8EmBsnrFAwp5+66LB0kzGlo7B82k6m6SgAtolEqqXG8B81F97TReBofBuO
iCGGJoT63cnRdXrSpCdMQxVkdjYhGsrc+CFTqiDftN+Y6R33/I4R9SQT0eBl
ol0ZW00RMNecpv1S5NzJuTv16bT4m4vCLGcgcV+IBC4qxz4BCEgth3xZX3+7
23IpZ+xxogF+oWj0jUA0XRbOJmcuTdwUsmAD8OGx0l0Xuxry4SLSvXpHgxfj
YTSqP1GKzJUNAihlkU1KeTkJamxGakzroCQRnteX5wApF/ZJiwLCIc+65JZL
zsI3oJFHuWaJhaaT8BbNhxNDIIMB18BUL5tFcp2CkZbF+yNFlob0eMMN4QC6
tZwEW48rwmjE6MmpHLVxnhvT7/BiG3jLK8CK1wYqWC28sRbTyD0+AFavB0FR
HCzCmMIa92g+ps+95NRT4cUARWkCJPBNRGPd9GVoQt4XPd3YLZSjLClNg5IN
Wfr4t5YZyGAYHJpzU1DbPaHGZevVEYkmAuxyiCEKoIqVGCPVAjuJEi67OG66
Njd7op9hVIaEtw+b/uIv/mI9y6oDk3F2ZC2YW8N+NlWYifkYdpJMuMaRIuMV
NtGws1TLdrHHfVIFZiebjRvSREKejKUoVMBM4Edblh3Qx8ZO8BRJh6ey3g4i
D0airl08A3eYx2ZdQk++sEHm54SeisR/Xo1AUN5GFppNfobQlWLn8bdJpORz
ojP1DBQjZPqMMfR57iNctXkmz9Jn9iYx2wZY0h+wwMXMuUMXNnmK4g3UBBez
4wZvgaGlndxBXW2ep6GlEVBTZicruwFY7udeQg5Dy47GQsyKxHLlrCsDwwwY
/XLiG54mD3ThWMrzQMAlyeRJcDZbv6Lf4Kzo/qhReMtFHQZcBfH7hhY0MplY
V3aedsNU8wzvHV2OmSJmax2qsYkANsPJzaO/Dqrk8LQhScZj+L0gyoVo2YF6
lf7T5RAxn77Eq/1OadSdsmMdKgUDKYUP6+F10V/LTtW3ugCImxoXbCvU3x6N
Z3YZpHSvobdASj4l3fsCQMooL7o5MKDRKqXCUYDMDqTUPWucRWgaAozNMOEK
wMEDLPK6L9nQs+ATVmhqODSHoHbVIJzA2OO2j3/842FKUpbEy+tAy5ocjGI5
0HrdZGrs5Y1dVJUcIvGfsQZo6BU6H1rCldlaGeWBrqaO05MspK7csw9bato8
Z3NrRNhl/1ds6X2ym+HIsedCvOV48Wtgy4wzfid1huETn/hEFDYUQ2Fz/Rfu
uTPORZzHmGh3koGEUpUikMIGGNzw+UsNYN7qZNGxpPTTek2UMgnPQLsq1uTU
XQdrqhHtCPZnP/vZmogYVr0MaxpjZhjvXIE1cTDyYInlwKn1vEvB+kapy7Cm
S+HJnKRNlmNL7w9rsot02Lr/64iRijeDcEkmqcm96UFHi7fGwtrlDPaTjkQo
Xk1Ccax4GGiOkBkWw1bLOZi3uiV6WDjzfAtnupNNbKkUo7KqmrGWEVbq58DO
e+glLWWNcJ90HcJmmsk1e2wIo8rABeqNdlQe1RSB12xEYQlbeRUWZOVGVIvY
EpGGu6JdqSOcofoKMtE4goQN7htk3upDq4i57qTLY5PL09mRA3iTBOM7As6z
MhOQ4SFvaiEF7ZXDfd/GmwtWu7Wok0vwpvYQktgOismED/2BenAbLSw8mxaQ
sUzshEyVe3OvpjOlpRwWthd/NjaOyqH/qWpQo1WbEh4K2By5V5BxF695bx+q
xMVxYqFoqspaxbply/2iyKwsy1Q9a4I4YstJIS4Qsu4nDr6plqNS14km0yMw
0jgfhpG3+gRJxilkffvb3x7K1AVkGS/zdCYDUKO5VWE4JpQMEnM+kZY13rwM
LaIv0DFP4A1ahH9AuaBFIqX0rK15CGgRu8dDa3bgUrR4p2t8U4B4CfJxN7Oi
LpqLO7yef3XcQ+BawjNpY54NEthlStQUYVMbdRuvAgcPo8GBQ80AzPmbLDjO
WakCje7MU4oSX8xJpGaCsCLa4gUKqfFJxn8f3iNp2Ap0TO9wPe41+9EseIV8
QhR1E0hqj0qnQPtpmjeGfD2voD2qYZ/73OfCl+y4Cxu3NwP5wDEXLG8KL7ma
zA3IL/sR9/BuXqqQb6TaCuCZ0hjLHzaL0zskfzx3P9gvvEi2vvSlL2VnwIrz
Xns5pssKd/zY+pkhhwr6cQetlCaJN8F0rF0zuQ8C07HK3KCKMWggg0eil1zD
/bAOhkgCc5OcwDoEpCERFwzR9ctgXf+9PT/Xux+Cdax6w2gPBNadXYB1+hKX
t2nRMEVFdGNHpbudH9mzHK6WTek4miAVG0bdzzMSQ1iPRRgbFEouLG2p9+BQ
mMZ46P6c0ok9oeUrNuNSLLM918VmZ33UIVfPc2wYTuRAyWZjw/s7GC0pM25H
gdDgrHVTGMdlMF3mxxtrRqlTyQQVed/1rnelR5HDQDI2rfF5hWT4c3wbrecN
gV+8W69TXgIpQjKt57f3MFoIJOK5i8C8brbF1dR4Oh/bzHR/8pOffMgIrG7I
dhCBHZVDg8yduB42/MrGZ6iZNb8FfsVHos1Ey6hJcpkgVoVeqWYf5AqM8cGZ
risgF9tEeVJzTbOHoeJBRGmQz1b7PsiVI02lKegP+EIE3C14K+1+CBALoI0P
dhhiPT7VDsUc6ReeDIxxnybLfCmV1ZgsagfoJBs7KCvbVerSl7/85XtAWYLH
SSteUNaTC8oyt+pOVljSiCY+6GGGRMwphxAbf1W48MdhrHV7WSsfBKc8YiC+
ADJi94bDzifWQUwWEzRjHqRDecWj+Mff2Nfv9wC8gAuseQB4wZJtCI/mEIpM
5axQ5ozcx6NSsH5QgQS9fX+pYq/zzn8uzrgOGBDqnf5gclDzQeCvyqX3hr+y
LekB/OVqWuom+Guelnz/+Ot2V93Z+oDqyUIIVofM6n7jhX0YLFRLt6nYrH/H
75xIJpK5oY5RmqYLT10EYuedL1g41gJuzSxbRWKp9wHDL01WtesK+JXZIoaW
MsDJfsH9ehT3k3JoAhcBzmGgO/ArCfn6myQ3QSv0Upp0yuzoVvFXWng90HXe
uUbOrTHhuZAY5aZ36+k8B5DXaZ+tZKQIQ/Z3ScQ+vUwCxYRfT83aMZlcOQdb
sRs4wS8Vfw2Rf6wrbMXTnHACJc1qCRHRirzXBEFlJ7muAF71iJUAL68Lrbn2
AC80bXb/BQRex72S4z5qyTH/gz/4g2RvVjyWxgaGGcT22ihh07Pe2Rd4Mx14
WMjMLPEeZJbHsJn8LVVQHwiSec3Wo32gLPcCxJSYnmEvOECro5WuQmet1Uez
NRJvs7lmkh8JFdlsLFotQVBadvCiR9hlISn3kZ4Ccb1EINoIQpjzNojpM2NM
SilL6z7d5YEJrJftvAPT5vHnITgBE1kUDU+GwkOHbtwpd/QSu2cvVDlQrCP6
xzZU6GbMIkW6TQYkADfoFym6iOhGYh9Pr5/11voK1mAc4tKey3nZTAQyuIA9
EuExqq7VkFF8cOCNum63I8EGVdNYvjTdFAJnnVvL6CMsTc9uNeMfxnwRAFzI
AanpkG91RrOAupRKxPq28Y89JgEqtwF30UkzKk2HPkhYp2/vfOc7w+zkGY+Z
B4xIXQPqbUqLcu5TGn8N+NfsxmH4N3aIDvwLeLp3zDc2+hV0SCeYZO8xGs0c
pd/Xw3ojjRX3jVXK456kNkOwjvm2WY5OZU9QnqtGP3LPIiYvPs6TAIHnLDZx
B9ca4qQQp0hYpvV2F+fBFk3bhLdoDPtjE6OghIr97kyaKA0CyC7l6OK6OeY7
7s9RaJq0nNqx6StjNKen0uyHfCGf23KcXQkzmkGgIBrG2UV9zHKDeekzvnAL
u2XvLUaO6tA/S9Ci7CDA8cyYqwptjErYE9/F9a7oj3ZIndAVezEOV77Ie6HN
NeDfL/3SLz1k+EffJq+/BrW7CTs+vgr++ZsVmlG4SD2NTnTh9YcF/2gfw4vF
ssVkgX/ZGQu3U9BZBX8oEJd7OarBOpsKi3C2oi/DfH33mbki6g//8A/TcziP
neNG5J4WZ9+KfaAviz3gJbOGE44/RJynReLgribWB3BemJf5oEyQZEEIZ90e
saviyclJ4JxZ2/OFL3zhqPTKeM6I3HGhPfqhbaCenpISbNJoeg9Qz6NJ1d0D
9UTS3THRyfRSVVQCxMIKfmluBjm3g+v5yHAa5gmR/E7tcxguhXrn/W8xMS4I
IaP38afkGKDGMGSnCi23m4ViaSPjYGbS83QgZHMPoM+chfjKFug7752Gvynh
bNtIFWTSYnVnxwYRako6sbtQH7Wj+JoS9CJCP36f4q4B/frB9K03tH3TarkN
54RTGjh4ENAvHD0jepX5jQgddwPoF4VCyigOKjXjj7VdB6AfUNOo9sJBv3GK
PeLzr3QY76ChCCpuXk/h2D/fyrtwzyiVTXYICrZ1Lc72SFbV0vW8+21LnH0I
9EgrMlnzENEfwYB6MHa7vw/9PTNpJa8LRxoqudLu6j8zT4PArOkpvMIQom+I
QiO4ZrivpigrFrBsVQQwsBpGi0TmlBF9wtVG8N4Q4GbhFIg8z3H8XazEpfBv
LBZhpQhM8UQpYS3wLf2lwF0z8Ff7S19bsNIwSBIQqXWiJnEp6C/xPwIi6Vf7
xAzDpQx5tkL1JP4SHWWzFpM5NglE4XUl8H4A6PWcZLIHAAqjLCtM7xkAoull
6yzYkeTzf+Yzn8ltwoh35ba2Ll+GAVELtKHPy+qkIJ5xoPt4NBiQQH3yk59M
uwIDseRVMFCx+CwMQnNktfmyGnZ7kUWKpPkhn3p4eebxL4eFw9VSDZesif+m
0IPU4O5dZCixIK1EhJiRBurzugFjiRn13BMZg8PGi/49XVgCkcz+u2v2THZo
3sPQck5XkRj3wmHV/DA9OLT9ngEPesSoTV/ey8oK0xIMSBP5K9AjuwymwVrL
aryzbtURGQUTMAe5RAabUNWIJNhNYX7kIx9JD/ChgBW3pbFsACRspmA81zcg
G3WxcnUn/gooG1q9aqkFSnP+INh139qx1aaNeLyTRWBAOklgorU93TXSKKGF
6Gdk8RcV2rRW+kULC5FgioZ9DoPL4+7t4V4lLyu3xgFFmbvLcfdZ1MsKx/KG
baC+7PWXMoIvWZ0r8KXXs2but37rt4IvkcAt7kxG15ixEGw6MgYnYDcayW+Z
PkcifryhGJv/j+qCL8lbG9F04iYQk31Y83yvBTHHUXNjb0VMYJFQ0rleQIh5
d4GYOQQEaemGHN+Au8AzNZftJjGZifg1KX8f3Dxf4CYbw4vTa7xATxCpijep
I6RkT5o8ZYCAdwMMGi1cebo48NBALKrdiDQ4uvQi/jzewp99R9CbQNCxcyhD
g5ZlLYk+Zxu6yzL+6CYaBj2WxUlDqwoQAWutMylVMo4+VWXe53TOzrr/lMCF
RteTIoAWGtm9lHVoDpqcQFx1iUTQaVMvVY1cY3EHKbN/CKWlleuZ3ftRao/E
boYpy84eRrCfVtdMW00S9ruIm+h2COdZ0IzaavWmtUw85sDVzV4H1RAh6pVg
1+XeRqju3EEFQWsEeVd4VhQ74pPoJ3xY8o4fApDFBVQNn6wJQWoyKgKF63E1
A7FKXhDzWRaDHneqoSjKNpJk9R0CIjK5T7tYlW1QOw7aNKCgM5KtCwROO8CN
y08UCTkLxsqmeiRlyoHdT3/605cBW0UYZ9U1zzfEFsogjVRme+Q+ga340S6w
hSfSXoxMp2PYZitzm/Zgx1iLYk33AVsl2FGF8f3ABz6QEiwDw/Ha3Qi5i239
9KEPfagycs6GbDKWFlO11AjTXHeoceGHZVLnuIuAwNTWmq99CPe8x9VJjd5k
HwJ2gIArZl39vB/lekd6GIO2pBSO2RTDjk2yoUJQLsds6dc4UI7jYnK6lZYS
+PvzyUVuESr7pCe1dSf3odt7c6hztX76Tjoo5rHB4LjHTopIMlK7WNf1K7/y
K2mkjH8XFi+zZ+CQivRhH9bN6xQNZQyNN1Of2xBUIghNa4ZQZA1fUjPL1rwj
3IPMq/0cOA2C9S1sBekQGuZtWTw9kEyocKeMHkPCCjb0kky1fsptYzWjmLmL
inbpvgp36RizzFWQxABxQPOxQxk6wqPMUVrFaOhrHVJIWfgrJ3UoLotKGl5N
LXxxrbTBcVM1h1HumPADXeq+Nbg2S9B2962hxauxAE/WFh4v0JZRaVowlA+6
pfSavs3TFHkOI14cpbHFEn4yC7no9wFOqUGSWXRech1Yg9Be80UdVhlZsa1S
v/zlL+9iW0x0FbY1zza2xR9FBtvq8UFs29p2NP8EbD2yQpiDAJcpotwnB+U2
DYRPQY3mE90rwKXsoFUulhqIJG2OoUwoYPv3vOc9GRBzT8HFrY2HMe46q7zT
97NlLj0flpl2RrvmrYUcYmA01swLqwA3ApYTM0FmAnldgNv87wpw6UJK77Il
LVQWKAo/5jmDmP1n65Y4Lpa6bIlDqiAPVWHJmhZsJQJ+YqlStI1iyLwQR4W4
LuycIzjmWcGLiweHoCM1FFsFYwjf0eNcw+hxsubiJi1baY69TjGVq5h4WYFK
5vk1Tk1D922Xo2KDTMV88IMfzKNMj+ki6vzl81FIjc0k5O2VyvNJ/F8WmG06
S7i9qvKh3lFPfLAiSDwBqUWPsy8ohk2bQORRoQE4YHVUNz3kQsgROs8Rbv1Z
8yYGzo0eKVGy4FxRnugR1o9+w4EpUnqAaiQLXoFzNdy1AwAEL7Kbfg3iooca
azIHUaJ0YwPgRuNJAPIc4TcakhXyXLbLWfeSOOsKNhGzSDCtRVl88YtfzCgS
T3mElGpZYFfBbTaOpoKUgG7LVtmD6cBV7LEsedoLbr97/iQMuX124j7Ae74A
XszISlJsMChKI4MwUybFGVaqlsJneAEgZRKFJsx3powDQCxmVAC7fdTt4pN9
BOquOCCDqqAdZov46I1AEOuaneb4E9QQyh51nn6sN9fEiZHRZJqQrhCf0jQo
iloSxMWy1jgvEYI7nT2RmihSH1S5jBQ+KXtLeKQmkoJQ8CIsHuuhoU9UEaNA
GeVgymUIby1boOAzOJAUNKYYhLm7dVyUj3iVEigsNkzJaoLgGvcPrvwz3R0n
P1jLRa8yQgKQ+k2nGh5WIexAZ5LJpKBkAjhJy9xg4+cScIFw6EtjlZ2ItH5u
Q9NhtpiHNJV1M6+zLr8IzLHXFhjCmNJey4lWT3VuxO4GFXcZVq/kOByqgj+l
CbjVuNDNrDl5AP+W7J9xjiMwCv4GW4+qbnehwMTQheAJI4ZTNMG0xQTXd2fL
NBhXYDoXIhlC42HbIbmXVIJcn2x8BFNhePhLLKGpn9CD5nCLutQxnTF2Xm+M
Mmp9eVd9HEMglFHHfx73N2eRGOSwuoq0DYPOoA2XNWfbrLPlY3GPziZV2XNa
joYkmSiWJaImBsWcWKycJd/+P+rscXcB3T5qgc4wgscJMoUOfmCaNizRD6bw
QQid2U1goCoVo0H4UY3+p/BNS8IMiU0IJOHtEfDx5IC5TNSaYHO+IHDxBnqC
KOk0RsKPejlU3Bu61RDDog4Ju25wTHFMTg/xpHck+gfccUGxh7CQ0FvuY5Hs
F0yH0fnMLO7MgrLM1BECFzyCuSFb7WSt6LaFR8bOglRdmBwsj14DBNzPojTN
t0wPgZga1nwufHlkPz4f9zK/jUVPZr26YsigwgnPJ5mfWU4dYHDxFXKLvRlK
7cW3CSN7Q9uY/aD0kJXGQ6KJ1EdzXtabg8qhErnmLWX7fFTLlAsRirECxalk
XAIzKaNpqfT8sqh0zkeIpDFsWrZGbG/3ZpEGrVYGBkNt5dID4MXiWZ93HUDf
8tqgExYcP9KxYk6IF9OM17gqyZvyOwLiM77ZutHG7S1Uz0vHNwwZhWASmbZb
suFPeiuZWCp8N4sim40zEUXoO6GJLJN6d/Kae1gcqNIlTaVXdMnggOSQJbGM
UmF3eQzeM/6QUQNS4+fH++t0DpOsiVEy9r5jjkWgmArsRTqxnW7wFKJpUQBk
Zms1xXOm4g3ScgpYn//uU9AogAcIWs0ZQRXTcKSGX8iYxrBSUnq2RJVP+uN8
C7omrkB0kL8JB52Tg9KNibHUU/rm6SEW3U6DAz1Zormi+MRzdBPdSfABDsDF
tBeF7014R3eUxx1JYi+8pXz3NB9FDJxnG1DJHuDZYhzCABcCnWRfuoerQ2Dd
0UVN8YwidUcVTW0eT/aguVk3bIPANCjV4H5AZtYzDwT8RJcARfNZNEG0kRzH
yUSdHA+PItQISkxP4WhqIx1ENIMRwRF38iuWopUMFlaiEnJ4HQjPQuoJTtUz
cu/7j/7ojz46CYAltIJpQwAEYdexS2OrbAWgM3I84EmPgVZK1cEG9TeT5/kQ
OWCFNSS9aGOEwCGqWsNMXIpZ6TM5wIADQA7/L8Z4WMinuwVjzVg58EArla9J
tIK/wyHkQ0maRpTJnu/kjBPwNdv+BW7Ivib7/Iu6f1RiA+Gemj7MMGq6dwT7
miLL6WQek+UCxOAS8tXUbWwgeuY4wJjgo25Ux97HcTMyDQG+KhIBRRx1DM5c
IetT3WMn6VAcxYJQkA1dRnQNCs2enQ6yhs/Qiy1OIxTjwDwKHvmZhqf9QTvB
KcZFcW2sQ6uL3sVph7M6rsVqQAx/G5LjSSjswSapJuC8jUWIse8kWsLOmPNg
JfCh8zxpdlHuOkdFGh5YJ9BXhpmm4P2c5FoTBZU3avbv8ZZf0Yg6mnUno91b
7ycSa0z4UeAPHYSezGCCXtwddkn1PpqtWRTIoOKTnStlARg/UEyXCJFIlHdw
WlZXsXW0urFF2WyDFZUOSGi+9jAmXJcc3GRgtYWvR0lRrcHiixMxDmDTYZ+M
CArCI9hrM+8lu2Zk67h3e+ugV81iORgefON/Xf+jP/qjRB9RBxXHCip9fbSv
boi3sOsx5Kh6oo9aqIBap5PaDAtWRTGUYURQlwqO9ysMrvcorUYUomd1Y5n9
GMLnFiISIEKIL80LRqD9TQ3jN81RVeL8eCySoxrdYvFpxCWD7LT7iBBX+AOO
oYM9mhbXXGbsqvXGcB7pls6DrBSUlhA4j7A5Oh9uB1f1ZOX2kY+Phet4s8zx
AMZzd5ftJQwI84AN/QLnQG66gejqb4OUrEmEZDpxJEdnzRy93ZvjviaRLmaF
gEJh1I9xaeOb9NuLOc13+yuGubJLTs5UPPnHJqixHG3wzHJKWBoMtpI5tMbs
aKsV2bhEK3GdDkeXkkUMjundby3PJFNoZCj9hMlxAzlQFSMTTiOylCGsQTx1
HJdg9PT82ovebnXPqgbqmcwmcgGzzCDx8IHlSeQSuz/vTERP0C3oguQcE7zp
f30O3KfpMRid5hLYAwF12EiD8iFIhfsYEkeQPK3V2fXol3EqsXeFaogf2kes
SDtF5F1tIhPkwZgtpvZ2nz8gmekp9KMa9M8xYa3XNVN3W+UdbzFVI/tmGoEY
aaqLkSVp3CmEiiBjlPWYurHNJk5AVL97R/GgWoyATtO8JJGk4WGKnG7xDvFA
ENyCgLQvZsWkylqDfifdxQMcEAnnrPGCsx6vjTwoF5figZnI8vSkiCpIYlUU
mBicr/cC5ccKxGEEKvcJj+g6Dc/MYlbotHUjp3tx1fRaL7SISC7bmZ0uLeHr
+FkpuAaHnMzhpmwxNtzB0TTciKdjiI14reNPTvTq0dQYBqMMFE89YWIaLTu1
kroY/2hSndhlmSBaY9mqDj2S8eTD4WfrKz3m7g9ZkJcDlPFquIWCpDMen6OI
KAgQGMf3wN8gSDMRgxEe668YbB014BgVpI59DWCCNIQkQPTm/sQKZPOjoWlH
61gEYTINx1swFVowq3HIyQhLpJSgcx6y7zq+B50bYRj2KnRuqBinCg0rOoeH
VY/ODFjWvWm2YXHfhx4JCiH92YXjqP86Ms6Sldnbs5k/JEVtvDooYzRSeJAP
5ei7+0nn07ieGDqKSibnaOGoidpwf24EU5uTWcHDof1Nf0a3vZV3mbBE0lON
FkLSPPVmIPJotjJfO3fSKRWqpTNhQ/wTSvs7nZ49iHpVewZl0PF4oaP/+xym
22e9hjS2/Nw7EXqks3VM04Ossls7O46C8lxUtx6N508u1DeyblfCbZV15FbQ
9BzM/qySd3K7g6ZROuSroxmy7vLVyMZ379bWcPhMOu4brazjyIjko6qM5C6S
HsBwlFURdzZfrsyUXmbVU5Wz2i3d9VtMkTGq7Vm5Z7BFeD3eI5rX533PzGBX
kMcjqXnZDf10Cx5XTtOcpHdnoNKNdX/L0Yz8tinkSFMqa+nO6F7JdNL+6JQ+
rzOer6yVLqs7LJopYiTIUscyuonj+hxe1Hcrpwctz86jRDeF/5S+bhV4u/+d
3vndd62AG1hjTsYyqbJZiLee7LBZ+uy3bEeUezoYuUxq5UnVoUm7ql27AcJl
3eMP+zDlDcZkODL+s3kJzuiwTmpd9FQrNFbXbdFWwRkAP2qsAtMKYqPnM1x1
x8IYK+/ndJbAmRxUWLkREb2fhFFNjartabgrR8QIZGyqdj6aqrXOcvWFE27f
3tpzaf50gSDt7/BVFZmi+09nD6MY0Cf2L0o8fa4KvNAzOgT5Iow5ELVaEd2v
OdbBplXzbgptdlVqhkRTx73zLdYLAtqxWgtL7jOm9f06Bikjz1WbEqOb9ml7
P3JxPIoEaeqTE0GlezFBOYiUx8Av1My6dj66Jvcql4UtolBmbPYmFHn8ULFP
lmHbZZZAqJgC5KwFrNm3I8dHpAQMa0O+z5onnoBUaV8YMF5mws7uA5qSDLjd
6QsS7QBPDCbMsBqt/cCTL7UNPLd3lXjdvMfhEfkHaP+9PUjtqXmPb5F8439c
qFAgxHfP2zt2++/OEqrde9ceA5GjTngywpS+vXWo4bEt+TVUbjX3JiR4i6+f
98T8L1sM/ROFwhHhz8x75g6ocd++Zt67JDeIcyt8uO6Rvn+QTD5l5ca+QXpu
3uPJ8iR8+wt7Bunp0qSUFxJzXhgIo3L7RgP37xe8IBUABmsc+/o94/mWeY9F
FlUk/6/dM8bZRZtq4V2tc4rHyym+OLKN35unXhfCNW2D6fsJm0dHOOAKBuCb
oQzpSoNJJ9t7iAFCHRLLXvNGmwS+cz5Kt0EbBvXOHl758UJc/Zio5Afmo1zk
a7NQXwLZI2uilstqwm0uquvZhVpWlLWfi8TPxbGu4iJOedZS/f3ZHHME8hQs
kfjQhz50b4wksJJZuFbgPkb6nvloTmW3NKe9to+Xkm9rWHXNJGST8bp+XmUz
KS3sZFpSBEJnktxxmJ2CeSlqQFWaVBu0r5vNwbJyxkjGZRxFHwBqUio+9alP
vXPeptAcryHC1wbx9iVMpRa9ERFpjBWmEi021CtTnfUACsVi7la7sTM9SIn8
yZ/8yasv8pnmol5jrs3cBUl0xaXO3LNzIYPnCnj1iynyyWthNRgh9vtN81Hh
CjpZSkJjt3CbBsQzDLfRdRmcxgXximgXMmGyfHLcI2+ev0mAYEJNpsdhDN+x
by5F/vZv//br5itqFUmSRcKuVP4T85L75mpVvmbeJv/iW7rdJwA7H44NA5FB
cpah6zlc45UcdiwppY3cd8/KjUzOFJGgwai9eo6gEaMqlOuTZB19a33MDoW6
S25Nzje+CFOGV6nt4BUTxBTpHNbwpTCcZAb5GT/7sz8bvjTv7ponH2bDU9FJ
rAIGNN4Ma+ZYFxlnn//853+gsEDgYPQd2SBCwoNHHeEMrrK41WTVFm8O1pAX
JurTszTCdW7IKzBqTc7/1rwtNuont9/ylre8b95mUHK2zi//8i+Hm0RVa0GV
m6hFvyGO3yo3mRb3mzn/BtTCTfpLW6U4libcFCGb+7O8ZvbPxIARUdqd/u9Z
l8PM5/qY08sakKZt/9J8FULMkYSvmvcoY6rN43cHIZbtkXz+XOHt0rkwg5kp
AFTaWTORYQaTBNSJyYBmiMIMkifT1fe85z1hBkFeZUM/TeuOjYzHEYbJfTAr
jnZMGRM7Bz18g9QC04bjP9+xcIjxgVlTJhU826gRfUZ2ZMC43RoQ8ElwgY0+
F+ZenCZaivXwfBCgVtFWpOb/nOVK6PMMeN6oM4ZwFLXzzz/56k9f/emrP331
p6/+dOGn3+p/b3IEQTcXx13/brrfmHj1/1iey859m/lvQoo+f3E+l2dGTGk8
V+OH8RVSr0/7u//4ldK+f9H/HkeoS5XgPJikNfV51J2u447/QEUpcA1apKns
P4Q0FrGPf5PzWJsK6PnV52g+x1fJc5kF4iIzNtwr5fbZoN32/vP5MKtn2lYa
AyC17qg/plggCjPCJqL99j/030YUmWXLPkpsv8wfQYRvn5Tjc8nzAP1hPLT4
6Ec/mjg1qyp9dKbR9GFsRrU3708uNHWsiLZyQgZEg6hxm9zmbPQ0p3nPCLjM
b3/XfB0U0Eq4sJn9s9mK7CYPhDPpkEEboIOtUAz/EhZqjJBW4BlAzSrRG7di
5HPx9aANLAT/csf6VvGe+TelKR8uPK7JMPut/u9mmb5YeXfEH/zqc9T/HVFt
jIJHkcA4j43fxrpdPqBJ8ubSJ06e6SMPIbrX+0zlKBFYTnRXC8YmlaNVNU4e
NvV7WqVYxWcu0fP57WSW4flM3tWNRdKkxBs5Z3k3VKnr2uYEzSi6zkyn4ceF
lCoY2zyNe5lgGmdWuHf3wuRlHXbf08AZuk6gRVXbo3Jri4Y+c+L3aNYer2hM
x4x7NXIcLydM4bNM5I4xz20DqJhkTe/wZQ9/ZWRaK7L9qiLEo7g5hftryZv5
b+1HzQDLc/E0w8XpULgXWUN2w5RJiuPScff8lnsZCqTOvZwys/LNrWVCdi8r
b7aHwb+/uEf6lEEDUkm35nZ7nBd5R1X6aHu/+hzNTWiSP6MPYjkyuk/6b2N5
NrdWIGnZr+dWj2uJ4VCokmHEKZv2T4n0Trb6EoKkl49nqxIAriOhe1Qd315N
jAUDo/WRQhlBafnJLEt83dzMSs313EQmqTlfSeUTiMjrIVC1VzUBVVUCa0yN
RC9RK65fBJ1e3CbipjdbFl/fmWnek3JISkQvx71HlxVMu/IpRV94S3w4OUPm
lzFRIqRs0na9j/VEoGzx5iMLTAoTk69+loE46X+2oVhODzjuQVIBOvaq8U9y
X7GyUkVWvGGcPUrSmtobY3K+Jacaa/ZFxXQ4RxdX56hp2kPnharKbCR67dLS
0GXjsNH3cRqOLDj9DdexUZQwV9ybWig24w0+9jve8Y7NLBJfG9o6PGLS5Hsc
XDr4XVhHZq0i+maabt/pHFBHTVEoLXa1IwNLL6oQHJDbO11uIROBHZ+sWhNh
yJmQKkCOQBXzYVnrJcYlItEgVrgz2xyMOPqIchokuYJMzxjjp3uEAqVNsWUt
qBRKz7qsk5BjmviM0CSVYsGU2QvbIGgGwJY8VipErEY0TMRF9IMQYw7qiYSM
SYfbHVWm2+kOBKY7vqurbDxlcEVqXE0oMwUKdKcEvRGB99jYFtLdTeePbaX7
2h5BgbKy5IVG00PPKjO2mMxZVCnA7TIoBgTrYyA1ZG9+YWHUpOT13gpKl988
1/g1U6YRex0mMVSOqhRpNc86MfKyTkDV5nhMxSKyAQyr4wNEp0JEwPA7KOu+
gTRrSFzaAMTsMDMQubirbGWvNY0RFUBpWYlGBQB+WISfQ4KaTk/Kb1SAUugb
OFpHNAoQRuMmk3WWQ9+sbG9kSv6BKZVdSmYZ7SDDGzpVaWPRRzpJg5L+q+ve
ozkZALzGjAtNciaIlSotZtIhWoNmxDHiqSLH6vcelaAe/C1GLFwtJGuItATN
hLr12PAZmtbrLKsVcbN+FFMhRMQqDLQlVt75paIW/tkkExPsmpuyxQa6dJUY
xSjghiRNZz5P+dnoqu5/Q6vMU4wyd8tUinSC2DEKVDXTKojblGHdbDliVHeO
QcSBGMfr8ARiI97P//zPv2zepguUKArbiFP3mUFqZG5IKeyHPHgoFe5shhnc
SiZwqTmVUAS3uqxoS5cib5RX+7tuFAbe0DXlEChGl/F3NTO4u3UmHdOAVBJh
qQrIxaUgd83PSXCte5yEsfNelsX5MLiMh8XY7FFoDq/lmUS4I3Ji1ssp9ycd
lQh8myaCVtbUinUzH63/3d/93bMd6uGNUIrIuLD3v81GpqfdctCr3OcsFLMV
AmlLJ806ahiWz2Bw5bxTd1UmteaLx/zPqJaSM4OLndv4huTsI4lSbDloRYNN
6yBXs82dPh+5Hzm61RPYjQgsCoXPee+Qig2ISKVvlHAOBbtMnsxWc18xZBOU
PJpVlZfL0/AZgAvoKfsAHRAmkRa1z+NIIkwGr3LbAxIm2nTZfGzsmpFjZ2i8
JGNdIU0+rd0ZhyqSRZLq5k+UCyMS3kw2gA+LYWKVcLBoIXbOjtwnSNPNDCtm
8okRWKhz0hE0CeCcsAcrJLtckKxfX6h0azkze0eI7l+Gbu/KUL9rEDAOcYas
GnJNEVoyBeiR+5eg016eMBHPjfvCCwCHPBNC3bsYrcdEgWzPlHZEXpL8sFc2
RvKTS15Cpv/uSxC2Y2rZYDopLHMr2X0SsOzhrdV9X8AG11GMsxh4BopQ55ED
TF6O87koB7e2zlWH9hGgFf305exOgyOXVe5f+cpXwu4AgPo5XayXUb2M3fn5
mMWoLRv+XmR3xS2b9d0Pu5/vZffsc+RS9UnhsQfH62edvMhv1wKRC6Nj6b94
SSNoeO5+2J3euFd2z7aJeD0cEUf8IfA85erSjAQ4dnk+no/qOfEyBpAiO/5W
fk9d+5i8Rm/F8F1XMzlHPHuwLicnDFRj0wneoqg/l4qjqVG3dgizMvvt5dxd
2TC2KeQsAQ1+LRxfDwx8kFzOyOVo3Pvl8rSHnc1OIOl65fyYbfyRs9Mbpsht
1HNBmY3YadGDEAAO38hL2ixOmTIfL628iVDYH0pp4yS0UW4S5nhSB/bff5CC
ktM19wlKQBvLLbbCZcCjvGtuPUteduivMpJ7kQu8EMrFRXblVPmbCMu6zXvd
a1eoS7hk2IyLApMpJbgAjcU24HlOc8zC/x+kJP2lMFhGknJa+G9bSkYbk2R4
XJmv+rTp5P0ISQ6RZiVCIJpJ5QhyUyFpj3rNxXikSM12rWP/UOQjOw0LBiSw
vysfWQqjfKzUT71pPThkOKorzXMHttJWQ2arNd7CFUIBy9l9EsGaqq/b5EsF
9dOnPvWpjD9rJtdtXf+1LRfnU88KNomqJWr0kA2HOEC2xV3PjLyWSJwvIsHt
wxui/YJoKpVk+iLIxN0uE+7hkEzWIWgmWUXpOaQasyweHPsFC/qJ2+wTkciC
IKJAtYmPK3zvvol+8w+5vuXwDY2msjV6n+S0zlfJwUe1z5f530ZyWe97u09K
aD8VIfvhgP99XErOdGSGiPPN1lwuS+OYAa0lN1/+8pfTWK6EGCO2vUKccnKb
fMxlV84RwHBbMHYJyI1sSpF5/Jt1j6GW0XZHGE5MuC7SUnkCH3VA9pke4BOL
JsYUOZuprHn9uo63OJJncZnil/0BriVtm0XaBI6OemD8uA9N5kCatB0WtuGO
ZWPdNlq53Tdnm/sqNz10M5h2d0mw0TgRWpYIqMBenkB7ZfEln3/++d2iPH5Y
2o47q9mZFsmbZF0RObYyjz41dbpsoLvpMXkp8uuxDNsC1/qQgcDWBkK78jqN
tm2WVoED95txDYdwdbCCkpdzWy5Ej+P4YAbtIkdZK2o6BOTEy4TnMpnLuTUa
/MEPfjDtNS3BrJlF2pU5WrkRLxFiOpHEMDSsZ91UXfhTyev5qINqphJIXjNk
2ftHYz0qIsC+McCIniVbohimyIzkr/7qr1ZLicfMnTR5TreCvLldJQQPVLKr
xKdxYHprbwz6QYz8itCxYWDzuRFNhWfMDda1TV0OxclYSVAyLkxdUoeEuQyA
QrfDBK/oEFSfsSjdhOpWUuCDuR9Lf0c93ohZglEij+7DQtYsuR+ZDF/BBtB6
5nyFJNQj9EZZrJBt7PPgd+KvPXJL8KX3m3+RbPJ9spljpV1tdLNR+8WNOS7I
6+ms3AZHOgF4JNeFU0OrLdsfP9UfC05zmTtml4TLJQCxr/SLdgu7WMCKBfwm
GV9yX/PfMx8nji8iRI+6vCpZg3rQfeQj6yNH5VIJJu94EmhAYTXy6KyJ0uqx
vnNwhclWRcjOgz8oqqN5GjspDs0yMsrUcvExzYJ0caFhaOJ8Z/YGs+kJZst6
CtrLK8hO06pqPYL1Vtdo7Cmnky+tEeUgQ/QTG0Xz5uKN2093CXbLmGMjiVZq
4Y4qJawJIXmWhbJVFaIYWRJql8t18ehTXWMws8o0M23qlsKBrb0nFuo+0GbV
AkjF5BMjnqZxXHZmH0lA3Ty24mJ6g34VbfMb4E2zcbsu0Ab3FiK521VHQiQ+
WR7pb3wAvGAls9BLJPWZ3nrazVBSvf42ZuYZjA1hFEDyNLai/FGCS5fTZHQB
a2iRbi07NY39WEFxr4hjKZreo5bNU4z1SQMz4SrzF5qC4bNdLIa/TPhhRQM/
Uwki/HXfwQPCH8+u7k6lNPxuOLM5kWhIgCyW0SoQS410DEkHavXKuP/CL/xC
ouhsAjlAGygTDbOzrGghSccOihJl55uhNwKA0BQKJX9A+pPzRufKSVCNj5Fu
/mrMgOlXM7hcV6qLnjnqdQ6bsy3wY0cnDGmUxUOpLjE4gbQkV2AqMiCCg6mY
DMC5Pl+O+8BYKhw7nPp3nEecqttr/RCsbBglToBnjaweQcSqyeZS61l2p12k
ESy9Rwncg/8HCR7r8sAx1CW/+47Ymuwd3cger7AIzd7UxNHcljyLdVcqnXS1
SlSBSolN66Y1531s5Wqpzrj6PVvu35uI3+pNMpJph6Y3/gmFk6YJi4WzNYnN
J1sG1XcsKHZnznDsqTDe9zeFtu6eMO55F744mc3Iurg87/dl5vikIyw/uy1U
rbh6WPquF8sX8Zzng79R7VqyO/RsHvUZScIjqI8vskQhRMzuQ55gE1Gkn1I5
wps1SbgfadVuByPoiacUSw45fr77v30PaDwgokr2dD5I1x6NFsuCVBi4bzA7
upAZiLULY7VBCI/SSs4+MQbfgGtj+3szi6k7Bx3tjO2Y9Bvdr1neHaeUDmgK
iVJ0ur1sDnPSFWPtn8eTDO238EJzqEerzrYSn8lc2MbjbVxqyk8s95JKPVJb
UpGS7n2CYexsU9Eij6OJVk5ZrHz7ynlPpCmHzl/Ko5sONVLyN+/nkkgIvYGl
OVf/eN67l45FukACc3/16NTk/RuN75rEZIeYOjsGGth9PZacRo1f0uM4Mmw+
He/bt+zvcVYh0JIUeyd7aWHWZ9y5DyrEamZrMrcbFIkCZ1hBQYF4HRek+s5J
EEv+TQQwZdmde5sgI22e3Zi7WBztp0luY2McPreq/tbLycLjlvi8kuW4u9Hi
JqBNK+32dSjz4am81M5kG0AfHpzLdFkDKCOH9bjDf1uAQNHN1IZS4lQJj0oK
IaFZyE0secRQLgJXCtEXyGBcGvsczVr0N6cCNCLnNgzFAwfXm9H8llkBIfdT
Qka+h0ycxgTRQqY4Z5LNGo9nv8fsk8wFuYJcI+uf88E98vGCS1DxVr+zWTxO
kKSe3AMxcJQhLqP7PbOtFBXYgc0qgXKdnp4e9aKPl/NQXc3BqbdTayFQ4sga
FwL9d7OCZK7i78ajIQb24lh75SAx+j//6SyILEI8XPcmS//T7JQlE4BIByZ7
C3iB1j1+9aev/vTVn15qP43zAMYhBEAofeh/+nXsBXGrW+fsrpldL5u5Wgv8
plLgOKHstNtu/qOsA062/01UquD9s2CKlmWS7iaqKZzWKthf8EjTHMuLeGoi
H6ZZfPei0GQzoP99f2zTsQFL0ktaCvzmPQWC5NlgX6jEXaaAe/8jP/IjNy1w
hDVF+9mnOGpC4bx7337inkp07ZboemmUeNZLFCDjSdfVsyDHc889d2/jYky4
5MCmu3ANBPLud797X4F/u/878GQ2FWyc24v93w/wkglkvASl+C5YJOT+/PPP
v38WB/SDp2JOraq/M2WGnKgd/ETHHuxfhWpbHgiOuRDmWZonMpGPjnFnPf5m
whW4U0+WrgnU9TWXu/VEkLUVlaC87Cv1EztkEbtp4Cflu51Ne/1vFvZC+f2f
X5k0N75EZUSKeVmb5di2ZWD/t/L2/zJfFKCaZS2b42ES1ULAf7dUoBe+PTvv
UUGZ+/q+2SP35H2IXZ6fnycpQJxYBvbetvzLWR5UlhzHZOqrMxnhOYSbu57I
01lps5Hilr1j3st0v+B2nsPD5hf4FeelbyLKRif39J9SEzb4vnnPM0K+49DY
cQYHZo2OutCxj88XNVaMEtY9Lw026aGAek/MSvj0vHQC5TiIkSYDI4vXZ8Hr
g5swgEVdrap6WwjLdFQr7awUokf4vxXyvbM+ZQrnInLvxP9ROvSx+RAxFvBe
D6MbYSwUrAuw40DjcYFzAd0Af8yd6IhRHpvfrtT3PA9p3/PqIf9RlP42E2eN
QPZn4lTSVqsjf6f3GUFxPZIYkKhGvylX8HlN6x7nIrifZSQ1Fx+ReKfL0pqV
DB4PGdJMaz25pKpKpEQIy6xJ30HkEL09RLGh06jo0c6ZCvOyuC9llBMePSH+
az67K48/HQfAHvWnn1iC5hzhSJIyTN4JfvzptLh4w54Ynvem53/v934v/cEC
JryR5G/Oe2Jr/M71iJpnO6zg7lCjZrFBjAiN56lxmirnbKKb2InqTRaa5MDU
6smxyjKOc6ikpoIzIujmW/xtLsbQhqWkUJjuk1Yf2uc80K7E9tN+rGA1xZgE
HAPKUTVjEC1JkNEtq2vxD0GWTK4RBp7mSFYxHmTczdSRJQqbDeJket4khnBZ
JRJDw6xWOcEXptzxfQYAcU3x6VziaTSWsfVtvPvKXg9taW4zu8PDg6IVc1fV
rlFFIgyeQTRr6x4apF/iOdrpeaGpmRQXHgEj8Ylvf6WoAzZz8aEv0v1uj+vW
Nf3aZP6VMozMmlBDw2a7E0ijAKEHAZK0oR9vfzzykXIPyfCpWczc0zX8id1D
YmpC6MdvIbGyRWI0Yx+Jc7wB1TMPulwCytpnzq/JTXKDSbW8ARKcnaRVK722
3Uvr4GmJY7791VkPMAGJiEyIoMnSaIJ6AV8Nop72KEudRIKxSNI4f2ytR9Xj
2/iXCSah68TeGEWREBog90yTmJkWOMu9fkzbXGp1VEYpadOhKlwqXjP06CGq
DkggXRIHpY6sqK5tzsgRrNwjVBaUrYKw6UYp/Q1dpaHljClIEuRtivAgXbWx
0hW9XLt0DZrPPfDE1Tl03nNhh9pG1t9FQeTMBled90FT6VsUQGhKcV2HphSX
a5emu+1lVF27NM1zlaYU00rTTQ+oAQx/Gqj0r/YQkktWMypeDEIqQ8KVme0Q
0uAS+X/bTzx54QjJgRORXAl50qcoRNbN6hrsrlr89pk9apTZqBtuknhaYm4y
1e/RInRS85Fr1jkNXNsHcRB4qCP3tAXTVcWABgSepk4/WAr9g7hCUwLqObj/
MjUKucimkQcRK5z02EafqFHowTw95BEQxLDhxTe+8Y0Vi8ozMULfO+vRUlMq
CEVFij60kT4g7nc7V6pdD9xBGZxGxcU2ARy4+QMf+ECICnZa81J9fHaFhJqi
yD2vmmYAvZLsIWwMv4Aa7sQZ914gr3lzwrOeGHDYLmm+lIzM34Ig7OGP/diP
HRe6i7mgTOwShSg61CgWgmJBbIqwIShZ1zJAQfIHNNfQ2kGCZlMy4qln3pPl
ofocfwJQAfkNdCdpACD0Go0Q71QzsgM0rDQI+GjvgWbAEMnzUa2xBkBrjnmW
b4awxpcqNTCZncqhMAahEThz3loPs5oGSxKBqTHy9bnPfS5pl7gEB5IJMNZj
0By0FZ/c0IC0DVXFBdXhZfHzrg4d7uadTgn5LZnmUT5EybMBufQEGxH/5F+D
0EH4oDZY5HlCdTLLRQWQ3PueIY+eyaTu3N+uP/e35wipw30MEbiuE/QLPsKa
WVZEtxp0htfzpnSRct00+k5H0FChevUR+ODpIDthx0AYpesJ7/R/Xluo9C8L
73g6ilEtKJ6AqxJiOOdJYstv3j2d5ez7LXwo0xOPJCKRQ4LAi4gPTqAxUTbb
QLtX2+L7qO/23nb6BfXoJc9mG8kLnf/dWamXgkizWaQCl/0pl7f/fHn7f50D
lcORMSdmkPlkns7bCSVrjkGkPEx3GaQmYmvB37anYFaWCs+8nDk6TiO5+/HZ
zBwyBKgnvMTPFb/ru9gtNXzrhRpGICrXZv4b++rzvvlcTgqoz8kVzvl6b59a
gPKjQXjTzaXohfzrUu+nZnkwRa7s42SWUaDc531zVZDe7z6HhICTJ97e/x1H
kbPDAqPkSBt4bzy17HT5mT3tIDO75ZtYVpbP+/q/552iLpjHR1uzjT33imz+
jf7sWa+bYtZ2qdtMnClxNGnK+kBbzjoDZj97F2zBe3Q1vfjjU8AU5TJ0ptS9
wikX0Sfq/VyVyUAgGwsotVsuPTVDhS0blf6rCzxx1ulbr0wY+7+x8Y/NdlA9
6ve4ul0sMuiIcQl+2CKpY3VP1399oerbnZlNsWe/epkswo4y5EAjKK0ph/fN
JrAMXECLXlFcDMEiEJ4jDLNsQ3Qwhs8NDq8TY/re+BvTprczCc6XYCznEVIJ
buUQVjEvdnJby77xQn3nW/WlToFp2JIjRmLfO3mT7UjqbFKZ2A68RlO3hqyV
feOFyo53Kzuau+aQC5uQQHa///u//6OzOmAtmyykOi8wn3zq5o9eVt1mq7ok
dRlMIQ+aK+sN/tui6WmuMRLjeTKQM0wxalfAS63fcEWtyekTtFWyFG/JFKic
ZCgaQWLHYLjRVgEOvEOrbE0c/tlrVTiSAgWOAC/qYS5T+G/mK8RPuLnWSRzo
LklTDY1cv87slEe2BdmiKrBLG68fnq8YOmLEvuacK9QHvHBQtnFeK/66KyrO
Pr6suEi0caIX4bbWm/96vpIpMN8en52lI1RqSLeM8euvqDNLSXkWwmby6vCt
ur/yla/8V/MVZgikq3USJRaXUm7CedM6Tzt1RNmy3ZxnBFWkqv+X8z0oJQD0
iVkxrWCOBZZtoH+t+LkrKr4zKyYE0pa1HkCleDOT/O4yvEAfFZilZHwYVMDu
ByHPvopzEC/1C/XmAB7yAxlr0D+a7/F4mBQ+Qyru21U39cH3aEN8/YpzUiLn
QU+pOw1QsZU0ePwfzvcEW/2mkVmtmoMqqZY2DGvFX3tFxY/NihUgRI6vuCWY
RZDMuP+D+R5Mw+9H8memJNH0UBitYY6ue7lL7a+5ovYnZu1KnWt3u4olxok1
/735XiwEh/dVs9tEjE9H8trva8WvvqLibCxJ4Ulc5BLBE6Ac+vPQ3jnfA9Tz
zKtnxQLb0CuI8/nPf36t+FXXqnhk7OZ8d73HMTxT9rZpqh+cr8IW9IXHXzNJ
Tqy0m2kQJdg2tq+4ogFPlQZQ85JLeeJYV0REgKtpjP9ivooXkqr6tfMe22uU
ehT+2hW/bFacQDdboBEWi7GMIm+ta3GJaEpmwbdsZdAdyOaS4/Lmlax1v/yK
ul8+6+aR4nD8gowoLqeYt9j45+/MVznb2df52Ul13z2G6qYXtg3y09dqwDhE
kQYjXsjqO3KarMBLaklwgap3z7ccP6bhDHmnzLVrf6bUjnOJDK5y13Bkcxz0
/VvzfSgvk+6vn/SnnWgiKHtLoT91RQNeNelv4OjMqZgX2K5brXF/Y77KqCaB
4Osn/VkxTg22QaVtk/34tRowtq4laiJtiR9R7OYwpvl+pB4KFRfwz04KkDUG
QShiS8Ff1YBXzwYgf9zjsBhgL/Jolbzf/7P5PvSWEO03zAZAMfT0BWP+2BUN
eE2hgOk4Rjl7y0p84FVw1Aj8X5/vC/ZohG9vmA1AIekBpjmbFlob8OgVDfja
2QARewykUoNIBzB3kLGCDcl/Mt9HbvaUhXnjbAC5pTUFFxKL7f/cuVYDRgE4
WyGf/vSnE7fDFh73UyPSX5slwBV0ETn5pvmogJUYrA0UmvSuTbh9RROiyPSZ
GyoY2I+IH7fpYQ4JWN48kLfNEpImQgSy6sEwAnuczMY/axPOr2jCs7OAaCKx
3d/5nd+pOwrgOZNwTdy/f5bA9HOXDFiSpZUAx8InF03/6RXteG5WSMvBePhu
ORf7eNkrWntawYlz4j5xfBz85+ejRiZZV0081ibcuqIJUaqUqYm8cbTLKNRi
PkoB0GpikiwYZM/83787H2WjIVD4oVF0rf/kivq/bhYgGKF+jkvZJUNIhlNP
MzfKZLqMBqDAsfGb5lD4G4pgLsy8bBunzRXtGCr29tA9TazZ9azhyXEH4i+s
dMOJOQyR9khmxjcUaclKq0zdCERkh9u/ULhPpJAWamS/flv/zCyAJc9cV9Oj
GTY7FEAwghDtdla7eprAal4SqLCs2TZNycasZgsZOKycbRZQwruksJylIRdK
D3zLaXsoQnb1tgnr2qt/54pexbzQidgIOzWqb0pd0nWs9sjKPlTmMutC1q9Q
ECJDJCJdYsXkN+DY3PM7K+bd9EeYIFMd/8EcP+6O5zTH+wtb/b9X9CfWyks0
F2vVuCvhIuVwDM0OwXMMYdpGK1uj4ttRaQfr7IO2q6BuOrnAOGORKERmQ+hn
tCMSy25O47RDk9DAc17h/1AqlBxygRl//Md/nFe0mHZmtlNz9xHeObyE/7DY
Fs+ZKIpluIpY1bJqApDUOCksTb24DFAb9KziorRkaNTdjXkpeAKWx/LCgQ3d
pBPkd24Js/Q7572zRIIo/l5WYI2pZ9gUp2RKCDJEB2gRx0AJ1Ma6G8GYJjY1
qxW5B/jR0b59e+kz4C9OEjTx/1xBrxwNSUgFk1jnRqTQy1BhLK5c0w6RDRNI
dh1Y+WpssiXIaZI69/A7YrDxoTX+4hMMNTnuISLXBd/lXblDwq/iFblHeXIx
IM7cY2CTEvadk8fJLl6l9VF1wbf/9xXk+MYd1oOXlly8k+XMGAYdDTyWpFf+
jGmUShMjJKJOl+UeR1UAn1a9jCa43hLAuh+YvugXmqZNnslyY/0W1f7u2Q2y
jqN4Rw2dXYsE31QsjTZQ4VmxqO1JTmhwMbspsaBJ7klT8b9kqXoPA0Om/Yzd
S7ou/mfox6Fuq9JQLfeqdl0mnW+aK572PbOpSAHTQccRhv/riq5/87xnhs+U
Pte07gfvWfU3gUwqCs8vyZxpavLEdrvuImOXdd0FRY5vKxdtp6yMrhtp30wT
M7ZvmU1FNvpUBKLhuyxKFIbPioJn573sBNY//n3+ChJl2WySM/zfV3SPZlFB
fY61eWDq05QYRVF7KWWVLNQhYTK6NRnQ3CTrcRmpRGxxSU1ADZeMLcCGVgar
DAllEB+oqeC3zp7QKZlfbSYhG3XQ3bAbHgrKEeXHuz27Zd4jnnATFzv3eGX8
0k7t61A1q257MlSjKi+6ufXhPd4UlxLzFCRD49IkNGUIwOILBFSNgzdMBZHe
ywgKPeArrL6rccw9hKBMPR5lTNXDhjX+/suztcCUFpOg1qHsCW2YDAGPI60w
YcsB9y3Eg2UyrVEJSoctM4yfvIKg3zbbIswoqg/stBENQbNjPm+g2Z6aJeDp
vvnavCesZzNCLlXuMT8QBEJdRlAEFwYAn5Idjxs5IjCRO+pErRwphgXwjq7+
ldlcjpLQgUSd5ummypzt7ecIIHZkMT2qWNMqaTY2hUGoxCTeY1tpY57H7oQ2
oZQ41c0nreDR44yf4kGsYAXcDm6ZNc981yeuOU4MNCPO9WwSVlfIw1962cQ9
uwoxu6BZQpqkXiCPHUrGkLMudLgVka3ria3+6VMbqkHGJ/rbWJ8BZzVUilEZ
1QALnjPsnfwnUSZ0aM8mYdBrXA4GifwqNstAhOjgSehq2ehyQHfjDUqB4VWT
AXimaFA6gxVHjy+NL2cWSv9Vi9nWJl6RU7YJmWg4fEHZ/tqv/VpcYm/zyIUc
ks1w1XjFTUcHRRPURu1sZ4OMQpBkOE4vlmGh+lqXPx15kHQtIUKTxq13iuHS
LwPU5OnuLJUrjTeRxP8mLjIweN8cgwGKOBGlhkL/o1kqEZA/Bs8toOW4W0gx
UMO4bNW36U9L3UTnqB9WkgIVXD4tz4G7OKHCXTMvYxXIuMcz5u/3VQnXIfGb
Cs+gkU8jdxwGEsaKqiu5XtljJ8EEuiOy8dR8z+/JyMswYBAa8j+eVWoj6y12
2rBPMA7acgII+8kNyYTj2aNqU9iP/6+9e+m5rKjCAKxff900NBgNNN4wJGqM
icYLARoBQROdeAt0jKio8TJjzt9QExVNjDP+gI5MHKl/wnifMjIxcYz1VK23
dp226X1OI4kDd/Kd7rPP3nVZtS7vWrWqShe27SaHhudS9cPojiHTwwuZsJPM
jHnc4vCFIHUj3EDCR6sE7MKRpSU+X1KYRWLALjizJnaKoTKxt9N1GUM3wkAx
E4moDNDadadtndz1nGmMxV544YXkKbitf5kLovaCbI12Mr+/UMUkzQDntiFJ
1+kyGTi303Xe6s26HgS8dt3E6NFdv1ZtBiIkXXuxtT+ZJSbSJbzwQRuDf6hK
4BdQQb59aRF/ZoV+nSvLRtQJbnb7NrSCBsCzm+dyucOz4Fl3Yl8qj+Kofj9W
zROXFHFh+mfzhmUjzHzjhmXTb6HgrIYaG2bc2eVeIhWMkR1N2VNyT1hXxH5s
rwM6KeX02syykEpOwlYv5F2HWZ7UaxzKXYbLGgeH0d0GyTG5SCFV8MEqhqpD
YN+erSb5HZzPxm3uisXARFN1HN9rlhsy1NPs+WZvHFGhGDv/4tO5D8kecE3s
y7DQjwprkDH7cWUBewVVEinWG9X4dr2aogTqS4476OI7aMabDGSj7mhjstq6
G7giHANv8sNbj0eH7+4l1F5FE2bREOsqB0wuJz2ZInv9faKqxIrGgbZp5isC
zWrpAO5q1XygSmCgYvGTlcjoUeEQAihqpOmBdYks0A0FARnpLMRAIHjxzaNK
zhh+BSSgXLZWx1aHSlyzd8Lnnn/35EJYEJfwNagZRtYEks0lER0nj++rYsCn
ZJaNNR2XOuF1k81j52nB9lyaR4QpHbAgroj4Q1YhxMXFHWnhSd3IZJUQemOn
JGkTEnlqHPDMOItdcqmMhm4l7YGQZcXic1Us8M0isNlzt9UxaPKOe6a9e3/f
aeZTC+nEUgHVoL7EYVzNQCbrOFnCHnp3vW70sxAki8IxFrVCszaeTGp0tlOd
lPzrThMToKO4zY7pX1NZQVyYTxxgTSAWwshS1XcuI80vFgl4vor0f01khpo3
nyYK2xHU2cS/7DQxgTSSbp6A8m4cFShA/LIDWU7OhYfjx75q+gkXHu5e2Dc1
HKfMsRbJ41cJgHBWr6wHvveZA7evTPeLlcb8NKRfjGq8VjQZ0fNRVFSxv77l
uNsjeyWriNTuFb8Q0dbN4AF2xG1/cwrjcmfV3PaXLqq8NTJ1x0spA9gJsqb5
akSKIK3rFnC5r0HjwPiFpDlJ3t9SH0WQTvUD9Mbt9QCoOQBXeqAmaxEUSAf7
BTiByhg8aYoUcNjI/QOd8ecdNnqk1LM2QG1Yk/qjQ1lFZIi21wj6j8C2/8cg
A6faMlowPs1x0KTzMM3hMZ/P49v99W3u3L7Y4d+6nQof8qxeUUZeefnll3M7
yRrUSJ/4GSXxF3N8uE4Ja+YVHkdKahBt3L7cX8mIIToC+4XozhNQzudZ3/7m
Zr2Xu0BLj8tP2eBY5f2Yx1F34KW/fsBEux1+0nNOUoroZxrUbwQ594UDpvMa
iq6buzb1nPp4Hdnovc8YjdtJgzmg/5We3hrO1CHD7BexQxFAs4oA15jZGWPM
lswtQo/ntaH4eVgbMhuuBt0EqARN6YJpvZoiyia/NAbclYtHkZOkrUVg+qOB
FYeV+77ExeqUgL4yWICaqREQuW85X31ztvFJcvR43dNWDULEGDV6XfyL8M60
j8szEJ9LSMxEHrzccO9qRFAGAhlg6spcQyWQI3ppuHhL8C3ACDqIYjJ8EclE
SY+2MOkSjuOsGvt0KQvHQIzW1UTA4EFgTc4jdOo1Ksr/ATvAsOnit1fJsJ8S
+o71i+rGbZQQAVSr0dPNOa0+Npv2mqigGK4aDKZHe/P/ttO7IPlMJCBPUwSB
nZqmGbzuVk8QOTMEGyFwG+qz3qNxiJvQvIdysiGjIHbn32eqc/xCXpyJfJUK
4RJwYzk3qb3YzRXPR01sxsx63etUkhlwoZahOR6QUJEoHn1BXIjz9M0vdamq
0ewBTNLQ7PHVqkVzwHffPleCmIw2PbT0DUoiOJ6jwjp68Ow/dpodR1I/DSBA
PU9kHyfxyZHCcMsZwJ5mBChfXGOyyQYjVEl7LNE2BfZNNl7NDk1j8a+Oiuoa
B+LPQTce7dXeqn8exUAjZdq7tFVajDIGj9Q3TZfgIMVHPFg3UoXHEYzXluby
spJV9NlqLn6A3s0Vw1WcHhEQ4pwVxf860tDjdyYqeMy/IK7poHuq+YQLp0u4
a228uFBNU7NilD4zy2e4lgQkVofa9u0z9apx4k+Y2xBVltef4zraOIbLjLRp
U/w5wkUXpjGfeusPOz19tDia2hVM5CSo2xL9xghZsSGMZDAqSp/DB4girwSN
4jWLmcP78KB78dAgAkzv21PV0wRsjDWwQ6aoYuPadNgD9SpH2p4ItOOFXsg4
5PC2ekoAeXDGkeuDT9pgpaeIjBCVqhX5YRfNrCbsbDi1UrCz0S6d9GYg2JOL
khZrIS+UtGLIUM20Pliv8u9RH0fE0K/HVh/VyS9WL/CBSCH2WbLgiB/y6fNy
2g5AY05W69pwZE7OyFC+m30bO7TDDEoQiRE/0RGtb1oxnj5rACHPjZL2IEFC
mYyiOoXH2lBkepiQm/fYTsIbJ4ibJRIEajROdEBwLTns14pPGSiCSCDJqbCj
5/AokEc7JoGQPIMPeth4pTfvTzutf6beVS9owQ5NEDayAKguVaX1ggkAjGLa
4wnOoS2459tDi5QkRkUPkC5xBb1phE6Si0oppr5lyimtVq7MOvh1OU8Cy5s3
7DHfetTwU6o88PZ7wodohl6G5OPVaqVqCrNB/3KE1ALINgyfWQw8l7yX3qw/
7rT62WoKXUxTMqDzVK6xXpkztZ2let5NiBBCrfOP28+KZ/3OR+peTgwZ2H24
AcaDRSH7racfXh7Nbv4ZaR2lEo7uzfWF61DP1HvrTSSTNqL16I7GBukQicM8
ZrLm7THNQW8RogyNKYrkM723zBprCwvCa+jPKUUvNutj9QxXHTMmGkACcQPs
eBR3fbn4QK+kH2P42AgACfc2X2s900HnXRO6Dp+EFuxTwnUPgM8OJe+pWjIY
SrbCjznEGYBbK/rh6hVFQG1lsZBAqaV0QMJRvcpKFCSk7Cm61S1TJ87PEQq0
DWCfdcP6gw358GFZRhVvjew4n2Ojdv6Zb20Isq4te0TUkexnPZI1bGuc8mtl
5zwqlk4fWdpkyjj7Kez18itFVaYMmdhLGgj5koPXvl+qqvASRE/7YGTUbOh9
3d6HtcVuZ/3zvINsJse3Vvr9VSEgQGkYYmDAUCIVCPTKK6/01vWPveWLzxX9
0ZVWpgIoL3wiT581SPODPuAwE6SotZwoSCpgU/7IWX/wvKsNTpBvje2yhA33
QU+QNaLgDjANRzTFszX/wZ3mf7UKFN5hYhmkBNn4KjyIxkoRcroAK2+nbV3q
5kDPE3UoqXlrmUSM6CdzahRg5vvJIAbtkHe29/077f1akZutUJI4N91lkoYS
VVPcYcxjcg/4akyZhfDcc9ETFUfC31JkwMtMv1Fju1UhMg+1Hmw3vbf+/etF
HGwBCNGt2BNWalyb7VvQktaRfcRhxr1r3qywgSkzMSbtvFLtJB/YVxtJsCQe
upp8ZmOL/rG3O8DzC2tqRCaJaPIm1NEutFyinsbbxWuYMdaKWIvlgUmtrXdW
U3GUXvPG/ev7cqzN1tT/3MH7sKnfqLbQYkRVPXieUS82nZqOGOvKZjJHTN7k
Ks05oyNjEQnvZsuRHUBId/yWhbn41asNVmxtfminzd8s8hov7q4wA/cGLG90
XJNVM88QBGREvGKWpXFvUuEECnKMI25ld+AGpSIvPQ0Jdf9htvPhnXZ+a2kn
/1VJeJFcL/gS3sl+WwE3LISi6OIE0QAbfhPOB3DYd2zMth+M+aM77fp2jTm3
RtjGWmGIPYEg9v5yKRqIFUyn8aWRkF3UAVIM5uGSpE/s1Pyd6go8BlGKA4oB
Egxs4HtrVcKflAnBYDOZAOF/XEVBC8n2+POs/JM7lX+3f97bxb6npj/9dDca
/HqXnEkkMfAAC0ANLXOO1r2s3IM6MMRW+5NHdf2ezl7gv5opGKPPPiEBL4PN
FF9BohrZyRU4F7kopK3mJ46q+a5eomQnFxWZXX5lAaGmEE0bznXDaBYJ1169
enWr7/Gj6hs7OGejGzQ2tZ+AujBDIlXZMSTrVZjD5shsFT521MBe6OGtbOaT
UDCezcZoyf+FEOjemQrRP64dVcs4VoumlFkEA+kKhhQGzCljuo68rNz169eP
F83vFe0QH3JhkelLeitHYBE7Zs2CuK3kR3ZK/lTdw0+AoZLX4HSyc95VIsqa
rCd+qU3qNXvblFdieGjI2ZgB0P7xwJGN4bpkq7g0RrflbUBjaQwEy6JHTRoD
wAp9m4q8d9HuyK7YOP/9Y2/DiqfrHk4RqKDnMynh/xCBb7mnt8AR1LMmsVLH
XKymQdMmOIomEbA42LRkby+LtAlvUUevTvNwsYty7JJwMe8gExOQFiUhgOMO
+jJ3YsZEjvJYTmcHylhpM+jBeAwU3cQjaPoo6hgjsvUUhTuwkZooExOL20nc
5x07EHoJxY1SgbXZRJhTxeTAAK2BiUiq1No7eoe5I2Mk2MymfmybwJ/PLCJ2
5MD87RE2SRlMskAp12v8+o658aS9zzJ/i+N1EbwgEZxBJjOJW8jAK80UJAhZ
O4r27+qh3RsWuVjV4B/jBg3QFURaP4HtHL0A2iWFAYwR+48Z0gSGI1UQVk3C
E81ojN7cO3dNNVXOHVWMDGBskH0EAV1Iifwz7L5n+S9yE7P1ZHk4lpmecaqT
aI51jP0YwnFP4yX9c+xSC1YSiRF2SHANseCeoRLGPXDFJcYcjkY0cIUw512w
muu7vXu523WCkQx6ihwGoOWa/cmrdA9sskZ2cwABfj2dCBg/QZ3zpSNJ9QsR
zEsAGtyxtAb+yk7LIQJA6Fq3igcdpKpRh3cu9WalVoiAi8gwIcjmNS5y29qU
V6Xn4RyIa92XOfubbUTY2yknRFhX6oUIJMm11kLMXUY/rSGd5vtWIsBUh0vT
hq1z4Zq8SxZMeqzvIvzhItIxd+hi4hsx8ygAbtIbc62EMA18e4RIiTcjxEia
Gfdc2TcmdoDeoKb6xowNpROvdJT+eC2CEPJ1qTDDSbB5AziuidBKr0PaXOxV
uqAQXaIfouGhOHEOEiwLyzg30UkLaD60ov2yNhzfYrCeUzXpt7fpRugn6sAq
rfRj1Fgf6uPCUov30Wo8N47URrP4HpQkGmtJCCDY6Nq88jHvBzJT+ynL73AC
HSwXVVkmiyjWlEVytXU7nPlS1+VyIyhn75PappryszldxfBWgFsec+PN9MpQ
EAdGK/Q0IaSUfmz3yfRk5QV4vB16whSi1dp4YbkniCbbJ4MPl3mOYOMlrWo2
KpM7AkMu4GCdJGOFu8dbxVBEJhINCTggNLvMEZEYEwLbasN+jmifx4fC3YGY
6DVqIfm4WiaiC0nQrekdAy04TgeGhhAH9u0Q+GQakiklyMRMLVqhFnQJDSkm
Th9+Syhd69C5NjDMdF52muf1r6v/+MQwZl4318/S3fA6kw7mIfN4/e4eojWh
ndhzVnFQj1iNGl6KyvSF0aFAsFn7KRRjQlHsUAvuUSyeACnkUG+Ha9/RbSEt
piKTcGykbChzUMlP1XZGaKwk9DniVCk/mzqa2gE2qfVsRt3QY4LItBbgrwB/
5qsbvrurfhaGERHmk8D4uKq17ryYj/oUfSXyhhjmSimiCcFamNPQUttRCRpD
j26JcK+XlBSRGadtDm2k1hFU90kT85X8csoShMifWGIyaIBw09oEub2biLUO
GR2Pn9WUvo4mvTNFa4qJSDidhNIp2dga8rAYBaeJ4CmF3Uv+Z+XfR+jpDE77
66fTp+uexiY15L66tyYI51jnpDng+2z4lpPiSF/gWJ4BynU8opfI7+tv+fdr
VKhd+KcE857/ekU/qIrgEnkSIHIb87vfsIpE+UTzoY3GDGE/spaBbzyUusyS
gimn1fXDRX8xugx483DvKo6ll1kC/jutCJFwTWradKtnb0OyH1U97uXIhTnb
M/Z49hOXUiBGIPCsS8LYozjFbBXu7f2VClGKF0gNNSHPEQX4l/pPqhUjzYoQ
zIPdNfc69uOqB/NzITnyL730UkZlJsgeNP6+nUJ/UiqWSgEpwDa8hPwvvvji
VtD9OwX9tAqiY/qmC02viPSJ1R1serzXolHQHd2q8vH5pi6kxZCnbRGZ0mgF
6o2LbzsrA67kwz2890r7WXUSLCEzdBD9g5cbvDm+oJ/XWCoIJoCNWvO2Avb2
fvzFMuoHR1T0j7ftvL09+cvbevL3JUzGIsfi0rljB/BTSxHA5MQRRSIIAp9e
SjKRGTbTZETk9FLIgZCjXtEcQNrxpfy2noxTN5ISRuYSGJX1WxdOLHFklJgi
AyJ7aL3xr9mEsehglKbNrKBSz6iJWxfJ6ouicAsQS8QSxtPtuJriFwirOoiA
AN6662wFmIOQyTLmDbhHJxDAns9xy1ISmhjiNkoRGzE94xIa7WjnlqXAiYlZ
J9Uf1ueNuJonsxXwq5sUgJeo9UGwcU/VOgJU3fptrnE2MMnbJkkQc+4C8Bpv
jwVqHFzcMzO2L3SbJWx2yDI3K8AIwPTUeTM6aQEseRzPCXdaOkCNC4PX1p43
bEn565u8yZLgdUASh0JMgsnm9279pjpBUUqRFIH8QgZ9kedN3/xd9SvHVR5u
Yfub5ckbPv4HjyP//09v1E9vevO/AflQg8w=\
\>"]],

Cell[BoxData[
 RowBox[{"shapefn", "=", 
  RowBox[{"Table", "[", 
   RowBox[{"0", ",", 
    RowBox[{"{", "5", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.568580360287612*^9, 3.568580377110589*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Xi]", "+", "\[Zeta]", "-", "1"}], ")"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Eta]", "+", "\[Zeta]", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "\[Zeta]"}], "-", "1"}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Xi]", "-", "\[Zeta]"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"\[Eta]", "+", "\[Zeta]", "-", "1"}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "\[Zeta]"}], "-", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Eta]", "-", "\[Zeta]"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"\[Xi]", "-", "\[Zeta]"}], ")"}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "\[Zeta]"}], "-", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Eta]", "-", "\[Zeta]"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Xi]", "+", "\[Zeta]", "-", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "\[Zeta]"}], "-", "1"}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"shapefn", "[", 
    RowBox[{"[", "5", "]"}], "]"}], "=", 
   RowBox[{"2", "\[Zeta]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5685841709955683`*^9, 3.568584291626081*^9}, {
  3.568584323814219*^9, 3.5685843672240343`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"CForm", "[", "shapefn", "]"}], "//", "OutputForm"}]], "Input",
 CellChangeTimes->{{3.56873438452143*^9, 3.568734404112441*^9}}],

Cell[BoxData["shapefn"], "Input",
 CellChangeTimes->{{3.568584903038062*^9, 3.568584904464512*^9}}],

Cell[BoxData[
 RowBox[{"sft", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"shapefn", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.568584030641863*^9, 3.568584041157604*^9}}],

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"sft", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Xi]", "\[Rule]", "r"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "s"}], ",", 
     RowBox[{"\[Zeta]", "\[Rule]", "t"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.56873447171907*^9, 3.5687344971855087`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Eta]1", "[", "\[Zeta]_", "]"}], ":=", "\[Zeta]"}]], "Input",
 CellChangeTimes->{{3.5685910808457823`*^9, 3.56859111859967*^9}, {
  3.568591159521947*^9, 3.5685911775691547`*^9}, {3.568591328250206*^9, 
  3.568591356735592*^9}}],

Cell[BoxData[
 RowBox[{"\[Eta]1", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.568591121320557*^9, 3.568591126807352*^9}}],

Cell[BoxData[
 RowBox[{"sft1", "=", 
  RowBox[{
   RowBox[{"sft", "/.", 
    RowBox[{"\[Eta]", "\[Rule]", 
     RowBox[{"\[Eta]1", "[", "\[Zeta]", "]"}]}]}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.5685840456251917`*^9, 3.568584065353416*^9}, {
  3.568591478767345*^9, 3.568591488892058*^9}, {3.568592048889552*^9, 
  3.568592050408657*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sft1", "/.", 
   RowBox[{"\[Xi]", "\[Rule]", "\[Zeta]"}]}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.5685920616082907`*^9, 3.568592079879773*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"shapefn", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.5685837063392973`*^9, 3.568583724892139*^9}}],

Cell[BoxData[
 RowBox[{"verts", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}], ",", "uh"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5685849313760633`*^9, 3.5685849693467627`*^9}, {
  3.568585115125445*^9, 3.5685851421935043`*^9}, {3.568595945509632*^9, 
  3.568595972697019*^9}, {3.56859600952988*^9, 3.56859601172579*^9}, {
  3.568639829877055*^9, 3.568639830113132*^9}, {3.568639864594426*^9, 
  3.5686398648821993`*^9}, {3.621032281207196*^9, 3.621032281502891*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"shapefn", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Xi]", ",", "\[Eta]", ",", "\[Zeta]"}], "}"}], "\[Rule]", 
    RowBox[{"verts", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.568585036947507*^9, 3.568585053814389*^9}}],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"shapefn", "[", 
     RowBox[{"[", "i", "]"}], "]"}], "/.", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Xi]", ",", "\[Eta]", ",", "\[Zeta]"}], "}"}], "\[Rule]", 
      RowBox[{"verts", "[", 
       RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5685849725497932`*^9, 3.5685850099377623`*^9}, {
  3.568585064034095*^9, 3.568585080326043*^9}}],

Cell[BoxData[
 RowBox[{"d3d", "=", 
  RowBox[{"Outer", "[", 
   RowBox[{"D", ",", "shapefn", ",", 
    RowBox[{"{", 
     RowBox[{"\[Xi]", ",", "\[Eta]", ",", "\[Zeta]"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.568580402498201*^9, 3.568580414016119*^9}, {
  3.5685844554697847`*^9, 3.5685844622111998`*^9}}],

Cell[BoxData[
 RowBox[{"d3d", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.56858042462578*^9, 3.5685804280325117`*^9}}],

Cell[BoxData[
 RowBox[{"d3d", "//", "Dimensions"}]], "Input",
 CellChangeTimes->{{3.568580459070413*^9, 3.568580461479883*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d3d", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"25", "+", "eps"}], ")"}], "/", "50"}]}]}], "}"}]}], "//", 
   "MatrixForm"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.568579079535315*^9, 3.568579099538196*^9}, {
  3.568584477972499*^9, 3.5685846050361853`*^9}, {3.5685957833447037`*^9, 
  3.568595789632098*^9}, {3.6210323534478207`*^9, 3.621032440739455*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"d3d", "[", 
          RowBox[{"[", 
           RowBox[{"j", ",", "i"}], "]"}], "]"}], 
         RowBox[{"xi", "[", 
          RowBox[{"j", ",", "k"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "5"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}]}], "]"}], "//", "Simplify"}]}], 
  ";"}]], "Code",
 InitializationCell->False,
 CellChangeTimes->{{3.568578631235241*^9, 3.568578699155265*^9}, {
   3.568578760912752*^9, 3.5685787807236958`*^9}, {3.568579165121344*^9, 
   3.568579165596537*^9}, {3.5685804696863747`*^9, 3.568580470218897*^9}, 
   3.568595845486967*^9, {3.56873494631391*^9, 3.568734948539298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"xx", "=", 
   RowBox[{"x", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", "r"}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", "s"}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", "t"}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.568739697356439*^9, 3.568739709186763*^9}}],

Cell["\<\
Scaling matrix to scale to an \[OpenCurlyDoubleQuote]equilateral\
\[CloseCurlyDoubleQuote] pyramid (all edges with unit length) - this is to \
multiply the Jacobian from the right (see JacobianUtil) - this effectively \
maps a physical pyramid to the equilateral pyramid, and if this is used, any \
volume scaling should be the volume of the equilateral pyramid since the \
resulting determinant is unity.

WI (0, 0) = 1;
WI (0, 2) = -1./std::sqrt (2.);
WI (1, 1) = 1;
WI (1, 2) = -1./std::sqrt (2.);
WI (2, 2) = std::sqrt (2.);
\
\>", "Text",
 CellChangeTimes->{{3.568741301106668*^9, 3.5687413011075077`*^9}, {
  3.621032650323698*^9, 3.621032693983165*^9}, {3.6210327289886723`*^9, 
  3.62103280054177*^9}, {3.6210328423227158`*^9, 3.6210328475179033`*^9}},
 EmphasizeSyntaxErrors->True],

Cell[BoxData[
 RowBox[{"WI", "=", 
  RowBox[{"IdentityMatrix", "[", "3", "]"}]}]], "Input",
 CellChangeTimes->{{3.568741308192966*^9, 3.568741332239209*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"WI", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", "1"}], "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";", " ", 
  RowBox[{
   RowBox[{"WI", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", "1"}], "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"WI", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"Sqrt", "[", "2", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.568741336578874*^9, 3.568741375374215*^9}}],

Cell[BoxData[
 RowBox[{"WI", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.568741379488226*^9, 3.5687413818783407`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"xx", "=", 
   RowBox[{"xx", ".", "WI"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.568741386370912*^9, 3.5687413989926577`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"outx", "=", "    ", 
   RowBox[{
    RowBox[{"Table", "[", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"GRAD", "[", 
        RowBox[{"i", ",", "j"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"DMDA", "[", 
         RowBox[{"j", ",", "m"}], "]"}], 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"xx", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "m"}], "]"}], "]"}], ",", 
          RowBox[{"xi", "[", 
           RowBox[{"i", ",", "j"}], "]"}]}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", "3"}], "}"}]}], "]"}], "//", "Simplify"}]}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.568740420763689*^9, 3.568740562887393*^9}, {
  3.568740624644721*^9, 3.568740640865946*^9}, {3.568740779805883*^9, 
  3.568740780461568*^9}, {3.568741409155417*^9, 3.5687414098824663`*^9}}],

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Flatten", "[", "outx", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.568740579176729*^9, 3.568740581382666*^9}, {
  3.568740793180209*^9, 3.5687407982246723`*^9}}],

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"x", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Xi]", "\[Rule]", "r"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "s"}], ",", 
     RowBox[{"\[Zeta]", "\[Rule]", "t"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.568734860953362*^9, 3.568734895893249*^9}}],

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"x", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"25", "+", "eps"}], ")"}], "/", "50"}]}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5687352585549717`*^9, 3.568735313273191*^9}, {
  3.621032473995123*^9, 3.621032479758526*^9}}],

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"x", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", "r"}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", "s"}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", "0"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.568735604026013*^9, 3.568735611920498*^9}}],

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"x", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", "0"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.568735604026013*^9, 3.568735611920498*^9}, {
  3.568736119543536*^9, 3.568736122758103*^9}}],

Cell[BoxData[
 RowBox[{"CForm", "[", 
  RowBox[{"x", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Xi]", "\[Rule]", "r"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "s"}], ",", 
     RowBox[{"\[Zeta]", "\[Rule]", "t"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.568734860953362*^9, 3.568734895893249*^9}, {
   3.568735226588112*^9, 3.5687352364128513`*^9}, 3.5687353305701447`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "=", " ", 
   RowBox[{"x", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", "1"}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.568580514743106*^9, 3.568580530171237*^9}, {
   3.568595509318421*^9, 3.56859552750352*^9}, 3.568595857277048*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", "x1", "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.568580494499257*^9, 3.568580496958352*^9}, 
   3.568580543687819*^9, {3.568595819576056*^9, 3.568595821344571*^9}}],

Cell[BoxData[
 RowBox[{"y", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d3d", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "i"}], "]"}], "]"}], 
       RowBox[{"verts", "[", 
        RowBox[{"[", 
         RowBox[{"j", ",", "k"}], "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.568639124881195*^9, 3.5686391384896*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"y1", "=", " ", 
   RowBox[{"y", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{"24", "/", "50"}]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.568639320868822*^9, 3.568639323357224*^9}, 
   3.568639359957038*^9, {3.5686397297053137`*^9, 3.568639755104415*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Det", "[", "y1", "]"}], "//", "Simplify"}], ")"}], "/.", 
  RowBox[{"uh", "\[Rule]", 
   RowBox[{"1", "/", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.568639328130845*^9, 3.5686393306149197`*^9}, {
  3.5686393716183968`*^9, 3.568639373096876*^9}, {3.621032544772304*^9, 
  3.621032557772853*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"y1", "=", " ", 
   RowBox[{"y", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", "u"}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.568639320868822*^9, 3.568639323357224*^9}, 
   3.568639359957038*^9, {3.5686397297053137`*^9, 3.568639775279849*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Det", "[", "y1", "]"}], "//", "Simplify"}], ")"}], "/.", 
  RowBox[{"uh", "\[Rule]", 
   RowBox[{"1", "/", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.568639328130845*^9, 3.5686393306149197`*^9}, {
  3.5686393716183968`*^9, 3.568639373096876*^9}, {3.621032569916806*^9, 
  3.6210325762280083`*^9}}],

Cell[BoxData[
 RowBox[{"cornerMatrix", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.621033531840933*^9, 3.621033600607398*^9}, {
  3.621033641935857*^9, 3.621033645805265*^9}}],

Cell[BoxData[
 RowBox[{"Det", "[", "cornerMatrix", "]"}]], "Input",
 CellChangeTimes->{{3.621033648321336*^9, 3.621033652458272*^9}}]
}, Open  ]]
},
WindowSize->{1409, 957},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Linux x86 (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 160, 3, 73, "Section"],
Cell[742, 27, 202, 5, 30, "Input"],
Cell[947, 34, 1584, 54, 126, "Input"],
Cell[2534, 90, 177, 4, 32, "Text"],
Cell[2714, 96, 292, 8, 30, "Input"],
Cell[3009, 106, 286, 8, 30, "Input"],
Cell[3298, 116, 695, 20, 30, "Input"],
Cell[3996, 138, 161, 2, 32, "Text"],
Cell[4160, 142, 639, 18, 30, "Input"],
Cell[4802, 162, 216, 4, 32, "Text"],
Cell[5021, 168, 392, 12, 30, "Input"],
Cell[5416, 182, 314, 9, 30, "Input"],
Cell[5733, 193, 283, 8, 30, "Input"],
Cell[6019, 203, 171, 3, 30, "Input"],
Cell[6193, 208, 123, 2, 30, "Input"],
Cell[6319, 212, 205, 4, 32, "Text"],
Cell[6527, 218, 290, 7, 30, "Input"],
Cell[6820, 227, 210, 3, 32, "Text"],
Cell[7033, 232, 401, 10, 30, "Input"],
Cell[7437, 244, 250, 6, 30, "Input"],
Cell[7690, 252, 128, 2, 30, "Input"],
Cell[7821, 256, 127, 2, 30, "Input"],
Cell[7951, 260, 384, 10, 30, "Input"],
Cell[8338, 272, 814, 23, 46, "Code",
 InitializationCell->False],
Cell[9155, 297, 504, 12, 30, "Input"],
Cell[9662, 311, 444, 13, 46, "Code",
 InitializationCell->False],
Cell[10109, 326, 219, 4, 30, "Input"],
Cell[10331, 332, 341, 10, 30, "Input"],
Cell[10675, 344, 606, 19, 30, "Input"],
Cell[11284, 365, 350, 10, 30, "Input"],
Cell[11637, 377, 207, 4, 30, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[11881, 386, 210, 4, 43, "Section"],
Cell[12094, 392, 273, 7, 83, "Text"],
Cell[12370, 401, 218476, 3588, 684, 85617, 1408, "CachedBoxData", "BoxData", \
"Output"],
Cell[230849, 3991, 202, 5, 29, "Input"],
Cell[231054, 3998, 1987, 68, 102, "Input"],
Cell[233044, 4068, 162, 3, 29, "Input"],
Cell[233209, 4073, 99, 1, 29, "Input"],
Cell[233311, 4076, 286, 8, 29, "Input"],
Cell[233600, 4086, 321, 8, 29, "Input"],
Cell[233924, 4096, 264, 5, 29, "Input"],
Cell[234191, 4103, 126, 2, 29, "Input"],
Cell[234320, 4107, 359, 9, 29, "Input"],
Cell[234682, 4118, 192, 4, 29, "Input"],
Cell[234877, 4124, 292, 8, 29, "Input"],
Cell[235172, 4134, 850, 20, 29, "Input"],
Cell[236025, 4156, 373, 10, 29, "Input"],
Cell[236401, 4168, 606, 17, 29, "Input"],
Cell[237010, 4187, 322, 8, 29, "Input"],
Cell[237335, 4197, 128, 2, 29, "Input"],
Cell[237466, 4201, 127, 2, 29, "Input"],
Cell[237596, 4205, 659, 17, 29, "Input"],
Cell[238258, 4224, 908, 25, 45, "Code",
 InitializationCell->False],
Cell[239169, 4251, 334, 9, 29, "Input"],
Cell[239506, 4262, 800, 18, 173, "Text"],
Cell[240309, 4282, 157, 3, 29, "Input"],
Cell[240469, 4287, 628, 21, 29, "Input"],
Cell[241100, 4310, 128, 2, 29, "Input"],
Cell[241231, 4314, 162, 4, 29, "Input"],
Cell[241396, 4320, 999, 28, 48, "Input"],
Cell[242398, 4350, 212, 4, 29, "Input"],
Cell[242613, 4356, 318, 8, 29, "Input"],
Cell[242934, 4366, 560, 16, 29, "Input"],
Cell[243497, 4384, 359, 9, 29, "Input"],
Cell[243859, 4395, 408, 10, 29, "Input"],
Cell[244270, 4407, 394, 9, 29, "Input"],
Cell[244667, 4418, 466, 12, 29, "Input"],
Cell[245136, 4432, 226, 4, 29, "Input"],
Cell[245365, 4438, 606, 19, 29, "Input"],
Cell[245974, 4459, 499, 13, 29, "Input"],
Cell[246476, 4474, 360, 9, 29, "Input"],
Cell[246839, 4485, 469, 12, 29, "Input"],
Cell[247311, 4499, 362, 9, 29, "Input"],
Cell[247676, 4510, 497, 14, 29, "Input"],
Cell[248176, 4526, 133, 2, 29, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
