# Tests

Cargo has an extensive test suite. Most of it is implemented as integration
tests in the [`testsuite`] directory. There are several other tests:

* Unit tests are scattered throughout.
* The dependency resolver has its own set of tests in the [`resolver-tests`]
  directory.
* All of the packages in the [`crates`] directory have their own set of tests.
* The [`build-std`] test is for the [build-std feature]. It is separate since
  it has some special requirements.
* Documentation has a variety of tests, such as link validation, and the
  [SemVer chapter validity checks].

[`testsuite`]: https://github.com/rust-lang/cargo/tree/master/tests/testsuite/
[`resolver-tests`]: https://github.com/rust-lang/cargo/tree/master/crates/resolver-tests
[`crates`]: https://github.com/rust-lang/cargo/tree/master/crates
[`build-std`]: https://github.com/rust-lang/cargo/blob/master/tests/build-std/main.rs
[build-std feature]: https://doc.rust-lang.org/nightly/cargo/reference/unstable.html#build-std
[SemVer chapter validity checks]: https://github.com/rust-lang/cargo/tree/master/src/doc/semver-check
