// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, State};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "ShumateTile")]
    pub struct Tile(Object<ffi::ShumateTile, ffi::ShumateTileClass>);

    match fn {
        type_ => || ffi::shumate_tile_get_type(),
    }
}

impl Tile {
    #[doc(alias = "shumate_tile_new")]
    pub fn new() -> Tile {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::shumate_tile_new()) }
    }

    #[doc(alias = "shumate_tile_new_full")]
    pub fn new_full(x: u32, y: u32, size: u32, zoom_level: u32) -> Tile {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::shumate_tile_new_full(x, y, size, zoom_level)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Tile`] objects.
    ///
    /// This method returns an instance of [`TileBuilder`](crate::builders::TileBuilder) which can be used to create [`Tile`] objects.
    pub fn builder() -> TileBuilder {
        TileBuilder::new()
    }

    #[doc(alias = "shumate_tile_get_fade_in")]
    #[doc(alias = "get_fade_in")]
    #[doc(alias = "fade-in")]
    pub fn is_fade_in(&self) -> bool {
        unsafe { from_glib(ffi::shumate_tile_get_fade_in(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_tile_get_paintable")]
    #[doc(alias = "get_paintable")]
    pub fn paintable(&self) -> Option<gdk::Paintable> {
        unsafe { from_glib_none(ffi::shumate_tile_get_paintable(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "shumate_tile_get_scale_factor")]
    #[doc(alias = "get_scale_factor")]
    #[doc(alias = "scale-factor")]
    pub fn scale_factor(&self) -> f64 {
        unsafe { ffi::shumate_tile_get_scale_factor(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_tile_get_size")]
    #[doc(alias = "get_size")]
    pub fn size(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_size(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_tile_get_state")]
    #[doc(alias = "get_state")]
    pub fn state(&self) -> State {
        unsafe { from_glib(ffi::shumate_tile_get_state(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_tile_get_x")]
    #[doc(alias = "get_x")]
    pub fn x(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_x(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_tile_get_y")]
    #[doc(alias = "get_y")]
    pub fn y(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_y(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_tile_get_zoom_level")]
    #[doc(alias = "get_zoom_level")]
    #[doc(alias = "zoom-level")]
    pub fn zoom_level(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_zoom_level(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_tile_set_fade_in")]
    #[doc(alias = "fade-in")]
    pub fn set_fade_in(&self, fade_in: bool) {
        unsafe {
            ffi::shumate_tile_set_fade_in(self.to_glib_none().0, fade_in.into_glib());
        }
    }

    #[doc(alias = "shumate_tile_set_paintable")]
    #[doc(alias = "paintable")]
    pub fn set_paintable(&self, paintable: &impl IsA<gdk::Paintable>) {
        unsafe {
            ffi::shumate_tile_set_paintable(
                self.to_glib_none().0,
                paintable.as_ref().to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "shumate_tile_set_scale_factor")]
    #[doc(alias = "scale-factor")]
    pub fn set_scale_factor(&self, scale_factor: f64) {
        unsafe {
            ffi::shumate_tile_set_scale_factor(self.to_glib_none().0, scale_factor);
        }
    }

    #[doc(alias = "shumate_tile_set_size")]
    #[doc(alias = "size")]
    pub fn set_size(&self, size: u32) {
        unsafe {
            ffi::shumate_tile_set_size(self.to_glib_none().0, size);
        }
    }

    #[doc(alias = "shumate_tile_set_state")]
    #[doc(alias = "state")]
    pub fn set_state(&self, state: State) {
        unsafe {
            ffi::shumate_tile_set_state(self.to_glib_none().0, state.into_glib());
        }
    }

    #[doc(alias = "shumate_tile_set_x")]
    #[doc(alias = "x")]
    pub fn set_x(&self, x: u32) {
        unsafe {
            ffi::shumate_tile_set_x(self.to_glib_none().0, x);
        }
    }

    #[doc(alias = "shumate_tile_set_y")]
    #[doc(alias = "y")]
    pub fn set_y(&self, y: u32) {
        unsafe {
            ffi::shumate_tile_set_y(self.to_glib_none().0, y);
        }
    }

    #[doc(alias = "shumate_tile_set_zoom_level")]
    #[doc(alias = "zoom-level")]
    pub fn set_zoom_level(&self, zoom_level: u32) {
        unsafe {
            ffi::shumate_tile_set_zoom_level(self.to_glib_none().0, zoom_level);
        }
    }

    #[doc(alias = "fade-in")]
    pub fn connect_fade_in_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fade_in_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fade-in\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_fade_in_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "paintable")]
    pub fn connect_paintable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_paintable_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paintable\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_paintable_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "scale-factor")]
    pub fn connect_scale_factor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_factor_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale-factor\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_scale_factor_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "size")]
    pub fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "state")]
    pub fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_state_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::state\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_state_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "x")]
    pub fn connect_x_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_x_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::x\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_x_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "y")]
    pub fn connect_y_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_y_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::y\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_y_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "zoom-level")]
    pub fn connect_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_zoom_level_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::zoom-level\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_zoom_level_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Tile {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Tile`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TileBuilder {
    builder: glib::object::ObjectBuilder<'static, Tile>,
}

impl TileBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn fade_in(self, fade_in: bool) -> Self {
        Self {
            builder: self.builder.property("fade-in", fade_in),
        }
    }

    pub fn paintable(self, paintable: &impl IsA<gdk::Paintable>) -> Self {
        Self {
            builder: self
                .builder
                .property("paintable", paintable.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    pub fn scale_factor(self, scale_factor: f64) -> Self {
        Self {
            builder: self.builder.property("scale-factor", scale_factor),
        }
    }

    pub fn size(self, size: u32) -> Self {
        Self {
            builder: self.builder.property("size", size),
        }
    }

    pub fn state(self, state: State) -> Self {
        Self {
            builder: self.builder.property("state", state),
        }
    }

    pub fn x(self, x: u32) -> Self {
        Self {
            builder: self.builder.property("x", x),
        }
    }

    pub fn y(self, y: u32) -> Self {
        Self {
            builder: self.builder.property("y", y),
        }
    }

    pub fn zoom_level(self, zoom_level: u32) -> Self {
        Self {
            builder: self.builder.property("zoom-level", zoom_level),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Tile`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Tile {
        self.builder.build()
    }
}
