% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runs.R
\name{vec_identify_runs}
\alias{vec_identify_runs}
\title{Runs}
\usage{
vec_identify_runs(x)
}
\arguments{
\item{x}{A vector.}
}
\value{
An integer vector with the same size as \code{x}. A scalar integer attribute,
\code{n}, is attached.
}
\description{
\code{vec_identify_runs()} returns a vector of identifiers for the elements of
\code{x} that indicate which run of repeated values they fall in. The number of
runs is also returned as an attribute, \code{n}.
}
\details{
Unlike \code{\link[base:rle]{base::rle()}}, adjacent missing values are considered identical when
constructing runs. For example, \code{vec_identify_runs(c(NA, NA))} will return
\code{c(1, 1)}, not \code{c(1, 2)}.
}
\examples{
x <- c("a", "z", "z", "c", "a", "a")

vec_identify_runs(x)

y <- c(1, 1, 1, 2, 2, 3)

# With multiple columns, the runs are constructed rowwise
df <- data_frame(
  x = x,
  y = y
)

vec_identify_runs(df)
}
