% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{encoding}
\alias{encoding}
\alias{guess_encoding}
\alias{repair_encoding}
\title{Guess and repair faulty character encoding.}
\usage{
guess_encoding(x)

repair_encoding(x, from = NULL)
}
\arguments{
\item{x}{A character vector.}

\item{from}{The encoding that the string is actually in. If \code{NULL},
\code{guess_encoding} will be used.}
}
\description{
These functions help you respond to web pages that declare incorrect
encodings. You can use \code{guess_encoding} to figure out what
the real encoding is (and then supply that to the \code{encoding} argument of
html), or use \code{repair_encoding} to fix character vectors after the
fact.
}
\section{stringi}{


These function are wrappers around tools from the fantastic stringi
package, so you'll need to make sure to have that installed.
}

\examples{
# A file with bad encoding included in the package
path <- system.file("html-ex", "bad-encoding.html", package = "rvest")
x <- read_html(path)
x \%>\% html_nodes("p") \%>\% html_text()

guess_encoding(x)
# Two valid encodings, only one of which is correct
read_html(path, encoding = "ISO-8859-1") \%>\% html_nodes("p") \%>\% html_text()
read_html(path, encoding = "ISO-8859-2") \%>\% html_nodes("p") \%>\% html_text()
}
