% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-dim.R
\name{drop,rvar-method}
\alias{drop,rvar-method}
\title{Drop redundant dimensions}
\usage{
\S4method{drop}{rvar}(x)
}
\arguments{
\item{x}{(rvar) an \code{\link{rvar}}.}
}
\value{
An \code{\link{rvar}} with the same length as \code{x}, but where any entry equal to \code{1}
in \code{dim(x)} has been removed. The exception is if \code{dim(x) == 1}, in which
case \code{dim(drop(x)) == 1} as well (this is because \code{\link{rvar}}s, unlike \code{\link{numeric}}s,
never have \code{NULL} dimensions).
}
\description{
Delete the dimensions of an \code{\link{rvar}} which are of size one. See \code{\link[base:drop]{base::drop()}}
}
\examples{
# Sigma is a 3x3 covariance matrix
Sigma <- as_draws_rvars(example_draws("multi_normal"))$Sigma
Sigma

Sigma[1, ]

drop(Sigma[1, ])

# equivalently ...
Sigma[1, drop = TRUE]

}
