% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_residuals.R
\name{check_residuals}
\alias{check_residuals}
\alias{check_residuals.default}
\title{Check uniformity of simulated residuals}
\usage{
check_residuals(x, ...)

\method{check_residuals}{default}(x, alternative = c("two.sided", "less", "greater"), ...)
}
\arguments{
\item{x}{An object returned by \code{\link[=simulate_residuals]{simulate_residuals()}} or
\code{\link[DHARMa:simulateResiduals]{DHARMa::simulateResiduals()}}.}

\item{...}{Passed down to \code{\link[stats:ks.test]{stats::ks.test()}}.}

\item{alternative}{A character string specifying the alternative hypothesis.
See \code{\link[stats:ks.test]{stats::ks.test()}} for details.}
}
\value{
The p-value of the test statistics.
}
\description{
\code{check_residuals()} checks generalized linear (mixed) models for uniformity
of randomized quantile residuals, which can be used to identify typical model
misspecification problems, such as over/underdispersion, zero-inflation, and
residual spatial and temporal autocorrelation.
}
\details{
Uniformity of residuals is checked using a Kolmogorov-Smirnov test.
There is a \code{plot()} method to visualize the distribution of the residuals.
The test for uniformity basically tests to which extent the observed values
deviate from the model expectations (i.e. simulated values). In this sense,
the \code{check_residuals()} function has similar goals like \code{\link[=check_predictions]{check_predictions()}}.
}
\section{Tests based on simulated residuals}{

For certain models, resp. model from certain families, tests like
\code{\link[=check_zeroinflation]{check_zeroinflation()}} or \code{\link[=check_overdispersion]{check_overdispersion()}} are based on
simulated residuals. These are usually more accurate for such tests than
the traditionally used Pearson residuals. However, when simulating from more
complex models, such as mixed models or models with zero-inflation, there are
several important considerations. \code{simulate_residuals()} relies on
\code{\link[DHARMa:simulateResiduals]{DHARMa::simulateResiduals()}}, and additional arguments specified in \code{...}
are passed further down to that function. The defaults in DHARMa are set on
the most conservative option that works for all models. However, in many
cases, the help advises to use different settings in particular situations
or for particular models. It is recommended to read the 'Details' in
\code{?DHARMa::simulateResiduals} closely to understand the implications of the
simulation process and which arguments should be modified to get the most
accurate results.
}

\examples{
\dontshow{if (require("DHARMa")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dat <- DHARMa::createData(sampleSize = 100, overdispersion = 0.5, family = poisson())
m <- glm(observedResponse ~ Environment1, family = poisson(), data = dat)
res <- simulate_residuals(m)
check_residuals(res)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=simulate_residuals]{simulate_residuals()}}, \code{\link[=check_zeroinflation]{check_zeroinflation()}},
\code{\link[=check_overdispersion]{check_overdispersion()}} and \code{\link[=check_predictions]{check_predictions()}}. See also
\code{\link[see:plot.see_performance_simres]{see::plot.see_performance_simres()}} for options to customize the plot.
}
