% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy.R
\name{anova.merModLmerTest}
\alias{anova.merModLmerTest}
\alias{legacy}
\alias{summary.merModLmerTest}
\alias{ls_means.merModLmerTest}
\alias{lsmeansLT.merModLmerTest}
\alias{difflsmeans.merModLmerTest}
\alias{drop1.merModLmerTest}
\alias{step.merModLmerTest}
\title{Methods for Legacy lmerTest Objects}
\usage{
\method{anova}{merModLmerTest}(
  object,
  ...,
  type = c("III", "II", "I", "3", "2", "1"),
  ddf = c("Satterthwaite", "Kenward-Roger", "lme4")
)

\method{summary}{merModLmerTest}(object, ..., ddf = c("Satterthwaite", "Kenward-Roger", "lme4"))

\method{ls_means}{merModLmerTest}(
  model,
  which = NULL,
  level = 0.95,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  pairwise = FALSE,
  ...
)

\method{lsmeansLT}{merModLmerTest}(
  model,
  which = NULL,
  level = 0.95,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  pairwise = FALSE,
  ...
)

\method{difflsmeans}{merModLmerTest}(
  model,
  which = NULL,
  level = 0.95,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  ...
)

\method{drop1}{merModLmerTest}(
  object,
  scope,
  ddf = c("Satterthwaite", "Kenward-Roger", "lme4"),
  force_get_contrasts = FALSE,
  ...
)

\method{step}{merModLmerTest}(
  object,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  alpha.random = 0.1,
  alpha.fixed = 0.05,
  reduce.fixed = TRUE,
  reduce.random = TRUE,
  keep,
  ...
)
}
\arguments{
\item{object}{an \code{lmerModLmerTest} object; the result of \code{lmer()}
after loading the \pkg{lmerTest}-package.}

\item{...}{for the anova method optionally additional models; for other
methods see the corresponding \code{lmerModLmerTest} methods for details.}

\item{type}{the type of ANOVA table requested (using SAS terminology)
with Type I being the familiar sequential ANOVA table.}

\item{ddf}{the method for computing the denominator degrees of freedom and
F-statistics. \code{ddf="Satterthwaite"} (default) uses Satterthwaite's method;
\code{ddf="Kenward-Roger"} uses Kenward-Roger's method,
\code{ddf = "lme4"} returns the lme4-anova table, i.e., using the anova
method for \code{lmerMod} objects as defined in the \pkg{lme4}-package and
ignores the \code{type} argument. Partial matching is allowed.}

\item{model}{a model object fitted with \code{\link{lmer}} (of class
\code{"lmerModLmerTest"}).}

\item{which}{optional character vector naming factors for which LS-means should
be computed. If \code{NULL} (default) LS-means for all factors are computed.}

\item{level}{confidence level.}

\item{pairwise}{compute pairwise differences of LS-means instead?}

\item{scope}{optional character vector naming terms to be dropped from the
model. Note that only marginal terms can be dropped. To see which terms are
marginal, use \code{drop.scope(terms(object))}.}

\item{force_get_contrasts}{enforce computation of contrast matrices by a
method in which the design matrices for full and restricted models are
compared.}

\item{alpha.random}{alpha for random effects elimination}

\item{alpha.fixed}{alpha for fixed effects elimination}

\item{reduce.fixed}{reduce fixed effect structure? \code{TRUE} by default.}

\item{reduce.random}{reduce random effect structure? \code{TRUE} by default.}

\item{keep}{an optional character vector of fixed effect terms which should
not be considered for eliminated. Valid terms are given by
\code{attr(terms(object), "term.labels")}. Terms that are marginal to terms
in keep will also not be considered for eliminations.}
}
\description{
Methods are defined for legacy lmerTest objects of class
\code{merModLmerTest} generated with \pkg{lmerTest} version \code{< 3.0-0}.
These methods are defined by interfacing code for \code{lmerModLmerTest}
methods and therefore behaves like these methods do (which may differ from
the behavior of \pkg{lmerTest} version \code{< 3.0-0}.)
}
\examples{
# Load model fits fm1 and fm2 generated with lmerTest version 2.3-37:
load(system.file("testdata","legacy_fits.RData", package="lmerTest"))

# Apply some methods defined by lmerTest:
anova(fm1)
summary(fm1)
contest(fm1, c(0, 1))
contest(fm1, c(0, 1), joint=FALSE)
drop1(fm1)
ranova(fm1)

# lme4-methods also work:
fixef(fm1)

# Ditto for second model fit:
anova(fm2)
summary(fm2)
ls_means(fm2)
difflsmeans(fm2)
}
\author{
Rune Haubo B. Christensen
}
\keyword{internal}
