% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_modelling.R
\name{add_resid}
\alias{add_resid}
\title{Add residuals of different types to dataframe}
\usage{
add_resid(data, model, var = "resid", type)
}
\arguments{
\item{data}{dataframe or tibble}

\item{model}{model object}

\item{var}{name of new variable in dataframe / tibble}

\item{type}{type of residual value}
}
\value{
dataframe / tibble
}
\description{
Add residuals of different types to dataframe
}
\examples{
data(cars)
lm1 <- lm(dist ~ speed + I(speed^2), data=cars)
lm1 |> response() |> head()
cars <- cars |> add_pred(lm1)
cars |> head()
cars <- cars |> add_resid(lm1)
cars 

}
\author{
Søren Højsgaard
}
