# Graph validation

test_that("Using an invalid graph triggers an error.", {

  # Create an empty graph
  graph <- create_graph()

  # Make the graph invalid
  graph$nodes_df <- NULL
  invalid_graph <- graph

  # Create a valid graph
  valid_graph <- create_graph()

  # Expect errors with all functions that perform
  # graph validation
  expect_snapshot(error = TRUE, {
    add_balanced_tree(invalid_graph)
    add_cycle(invalid_graph)
    add_edge(invalid_graph)
    add_edge_clone(invalid_graph)
    add_edge_df(invalid_graph)
    add_edges_from_table(invalid_graph)
    add_edges_w_string(invalid_graph)
    add_forward_edges_ws(invalid_graph)
    add_full_graph(invalid_graph)
    add_global_graph_attrs(invalid_graph)
    add_gnm_graph(invalid_graph)
    add_gnp_graph(invalid_graph)
    add_graph_action(invalid_graph)
    # graph is the second argument here.
    add_graph_to_graph_series(graph_series = invalid_graph)
    add_grid_2d(invalid_graph)
    add_grid_3d(invalid_graph)
    add_growing_graph(invalid_graph)
    add_islands_graph(invalid_graph)
    add_n_node_clones(invalid_graph)
    add_n_nodes(invalid_graph)
    add_n_nodes_ws(invalid_graph)
    add_node(invalid_graph)
    add_node_clones_ws(invalid_graph)
    add_node_df(invalid_graph)
    add_nodes_from_df_cols(invalid_graph)
    add_nodes_from_table(invalid_graph)
    add_pa_graph(invalid_graph)
    add_path(invalid_graph)
    add_prism(invalid_graph)
    add_smallworld_graph(invalid_graph)
    add_star(invalid_graph)
    add_reverse_edges_ws(invalid_graph)
    clear_selection(invalid_graph)
    colorize_edge_attrs(invalid_graph)
    colorize_node_attrs(invalid_graph)
    copy_edge_attrs(invalid_graph)
    copy_node_attrs(invalid_graph)
    count_asymmetric_node_pairs(invalid_graph)
    count_automorphisms(invalid_graph)
    count_edges(invalid_graph)
    count_loop_edges(invalid_graph)
    count_mutual_node_pairs(invalid_graph)
    count_nodes(invalid_graph)
    count_s_connected_cmpts(invalid_graph)
    count_unconnected_node_pairs(invalid_graph)
    count_unconnected_nodes(invalid_graph)
    count_w_connected_cmpts(invalid_graph)
    create_graph_series(invalid_graph)
    delete_edge(invalid_graph)
    delete_edges_ws(invalid_graph)
    delete_global_graph_attrs(invalid_graph)
    delete_graph_actions(invalid_graph)
    delete_loop_edges_ws(invalid_graph)
    deselect_edges(invalid_graph)
    deselect_nodes(invalid_graph)
    delete_node(invalid_graph)
    delete_nodes_ws(invalid_graph)
    display_metagraph(invalid_graph)
    do_bfs(invalid_graph)
    do_dfs(invalid_graph)
    drop_edge_attrs(invalid_graph)
    drop_node_attrs(invalid_graph)
    export_csv(invalid_graph)
    export_graph(invalid_graph)
    fully_connect_nodes_ws(invalid_graph)
    fully_disconnect_nodes_ws(invalid_graph)
    generate_dot(invalid_graph)
    get_adhesion(invalid_graph)
    get_agg_degree_in(invalid_graph)
    get_agg_degree_out(invalid_graph)
    get_agg_degree_total(invalid_graph)
    get_all_connected_nodes(invalid_graph)
    get_alpha_centrality(invalid_graph)
    get_articulation_points(invalid_graph)
    get_authority_centrality(invalid_graph)
    get_betweenness(invalid_graph)
    get_cache(invalid_graph)
    get_closeness(invalid_graph)
    get_closeness_vitality(invalid_graph)
    get_cmty_edge_btwns(invalid_graph)
    get_cmty_fast_greedy(invalid_graph)
    get_cmty_l_eigenvec(invalid_graph)
    get_cmty_louvain(invalid_graph)
    get_cmty_walktrap(invalid_graph)
    get_common_nbrs(invalid_graph)
    get_coreness(invalid_graph)
    get_degree_distribution(invalid_graph)
    get_degree_histogram(invalid_graph)
    get_degree_in(invalid_graph)
    get_degree_out(invalid_graph)
    get_degree_total(invalid_graph)
    get_dice_similarity(invalid_graph)
    get_eccentricity(invalid_graph)
    get_edge_attrs(invalid_graph)
    get_edge_attrs_ws(invalid_graph)
    get_edge_count_w_multiedge(invalid_graph)
    get_edge_df(invalid_graph)
    get_edge_df_ws(invalid_graph)
    get_edge_info(invalid_graph)
    get_eigen_centrality(invalid_graph)
    get_girth(invalid_graph)
    get_global_graph_attr_info(invalid_graph)
    get_graph_actions(invalid_graph)
    get_graph_log(invalid_graph)
    get_graph_name(invalid_graph)
    get_graph_time(invalid_graph)
    get_jaccard_similarity(invalid_graph)
    get_last_edges_created(invalid_graph)
    get_last_nodes_created(invalid_graph)
    get_leverage_centrality(invalid_graph)
    get_max_eccentricity(invalid_graph)
    get_mean_distance(invalid_graph)
    get_min_cut_between(invalid_graph)
    get_min_eccentricity(invalid_graph)
    get_multiedge_count(invalid_graph)
    get_nbrs(invalid_graph)
    get_node_attrs(invalid_graph)
    get_node_attrs_ws(invalid_graph)
    get_node_df(invalid_graph)
    get_node_df_ws(invalid_graph)
    get_node_ids(invalid_graph)
    get_node_info(invalid_graph)
    get_non_nbrs(invalid_graph)
    get_pagerank(invalid_graph)
    get_paths(invalid_graph)
    get_periphery(invalid_graph)
    get_predecessors(invalid_graph)
    get_radiality(invalid_graph)
    get_reciprocity(invalid_graph)
    get_s_connected_cmpts(invalid_graph)
    get_selection(invalid_graph)
    get_similar_nbrs(invalid_graph)
    get_successors(invalid_graph)
    get_w_connected_cmpts(invalid_graph)
    get_graph_info(invalid_graph)
    invert_selection(invalid_graph)
    is_edge_loop(invalid_graph)
    is_edge_multiple(invalid_graph)
    is_edge_mutual(invalid_graph)
    is_edge_present(invalid_graph)
    is_graph_connected(invalid_graph)
    is_graph_dag(invalid_graph)
    is_graph_directed(invalid_graph)
    is_graph_empty(invalid_graph)
    is_graph_simple(invalid_graph)
    is_graph_undirected(invalid_graph)
    is_graph_weighted(invalid_graph)
    is_node_present(invalid_graph)
    is_property_graph(invalid_graph)
    join_edge_attrs(invalid_graph)
    join_node_attrs(invalid_graph)
    layout_nodes_w_string(invalid_graph)
    mutate_edge_attrs(invalid_graph)
    mutate_edge_attrs_ws(invalid_graph)
    mutate_node_attrs(invalid_graph)
    mutate_node_attrs_ws(invalid_graph)
    nudge_node_positions_ws(invalid_graph)
    recode_edge_attrs(invalid_graph)
    recode_node_attrs(invalid_graph)
    rename_edge_attrs(invalid_graph)
    rename_node_attrs(invalid_graph)
    render_graph(invalid_graph)
    reorder_graph_actions(invalid_graph)
    rescale_edge_attrs(invalid_graph)
    rescale_node_attrs(invalid_graph)
    rev_edge_dir(invalid_graph)
    rev_edge_dir_ws(invalid_graph)
    select_edges(invalid_graph)
    select_edges_by_edge_id(invalid_graph)
    select_edges_by_node_id(invalid_graph)
    select_last_edges_created(invalid_graph)
    select_last_nodes_created(invalid_graph)
    select_nodes(invalid_graph)
    select_nodes_by_degree(invalid_graph)
    select_nodes_by_id(invalid_graph)
    select_nodes_in_neighborhood(invalid_graph)
    set_cache(invalid_graph)
    set_edge_attr_to_display(invalid_graph)
    set_edge_attrs(invalid_graph)
    set_edge_attrs_ws(invalid_graph)
    set_graph_directed(invalid_graph)
    set_graph_name(invalid_graph)
    set_graph_time(invalid_graph)
    set_graph_undirected(invalid_graph)
    set_node_attr_to_display(invalid_graph)
    set_node_attr_w_fcn(invalid_graph)
    set_node_attrs(invalid_graph)
    set_node_attrs_ws(invalid_graph)
    set_node_position(invalid_graph)
    to_igraph(invalid_graph)
    transform_to_complement_graph(invalid_graph)
    transform_to_min_spanning_tree(invalid_graph)
    transform_to_subgraph_ws(invalid_graph)
    trav_both(invalid_graph)
    trav_both_edge(invalid_graph)
    trav_in(invalid_graph)
    trav_in_edge(invalid_graph)
    trav_in_node(invalid_graph)
    trav_in_until(invalid_graph)
    trav_reverse_edge(invalid_graph)
    trav_out(invalid_graph)
    trav_out_edge(invalid_graph)
    trav_out_node(invalid_graph)
    trav_out_until(invalid_graph)
    trav_reverse_edge(invalid_graph)
    trigger_graph_actions(invalid_graph)
  })




  expect_error(combine_graphs(x = invalid_graph, y = valid_graph))
  expect_error(combine_graphs(x = valid_graph, y = invalid_graph))
})

test_that("Using an empty graph with trigger an error", {

  # Create an empty graph
  empty_graph <- create_graph()

  # Expect errors with all functions that check
  # for an empty graph
  expect_snapshot(error = TRUE, {
    add_edge(empty_graph)
    add_edge_df(empty_graph)
  })

  expect_error(add_edges_from_table(empty_graph))
  expect_error(add_edges_w_string(empty_graph))
  expect_error(add_n_node_clones(empty_graph))
  expect_error(add_n_nodes_ws(empty_graph))
  expect_error(add_node_clones_ws(empty_graph))
  expect_error(delete_edge(empty_graph))
  expect_error(delete_edges_ws(empty_graph))
  expect_error(delete_loop_edges_ws(empty_graph))
  expect_error(delete_node(empty_graph))
  expect_error(delete_nodes_ws(empty_graph))
  expect_error(do_bfs(empty_graph))
  expect_error(do_dfs(empty_graph))
  expect_error(fully_connect_nodes_ws(empty_graph))
  expect_error(fully_disconnect_nodes_ws(empty_graph))
  expect_error(get_degree_distribution(empty_graph))
  expect_error(get_degree_histogram(empty_graph))
  expect_error(get_eccentricity(empty_graph))
  expect_error(get_last_nodes_created(empty_graph))
  expect_error(mutate_node_attrs_ws(empty_graph))
  expect_error(nudge_node_positions_ws(empty_graph))
  expect_error(recode_node_attrs(empty_graph))
  expect_error(rename_node_attrs(empty_graph))
  expect_error(rescale_node_attrs(empty_graph))
  expect_error(select_edges(empty_graph))
  expect_error(select_last_nodes_created(empty_graph))
  expect_error(select_nodes(empty_graph))
  expect_error(select_nodes_by_degree(empty_graph))
  expect_error(select_nodes_by_id(empty_graph))
  expect_error(select_nodes_in_neighborhood(empty_graph))
  expect_error(set_node_attr_to_display(empty_graph))
  expect_error(set_node_attrs(empty_graph))
  expect_error(set_node_attrs_ws(empty_graph))
  expect_error(set_node_position(empty_graph))
  expect_error(transform_to_complement_graph(empty_graph))
  expect_error(trav_both(empty_graph))
  expect_error(trav_both_edge(empty_graph))
  expect_error(trav_in(empty_graph))
  expect_error(trav_in_edge(empty_graph))
  expect_error(trav_in_node(empty_graph))
  expect_error(trav_in_until(empty_graph))
  expect_error(trav_out(empty_graph))
  expect_error(trav_out_edge(empty_graph))
  expect_error(trav_out_node(empty_graph))
  expect_error(trav_out_until(empty_graph))
})

test_that("Using a graph with no edges with trigger an error", {

  # Create a graph with nodes but no edges
  graph_no_edges <-
    create_graph() %>%
    add_n_nodes(5)

  # Expect errors with all functions that check
  # for an empty graph
  expect_snapshot(error = TRUE, {
    add_edge_clone(graph_no_edges)
    add_forward_edges_ws(graph_no_edges)
    add_reverse_edges_ws(graph_no_edges)
    delete_edge(graph_no_edges)
    delete_edges_ws(graph_no_edges)
    get_edge_count_w_multiedge(graph_no_edges)
    get_last_edges_created(graph_no_edges)
    get_multiedge_count(graph_no_edges)
    is_edge_loop(graph_no_edges)
    is_edge_multiple(graph_no_edges)
    is_edge_mutual(graph_no_edges)
    mutate_edge_attrs_ws(graph_no_edges)
    recode_edge_attrs(graph_no_edges)
    rename_edge_attrs(graph_no_edges)
    rescale_edge_attrs(graph_no_edges)
    rev_edge_dir(graph_no_edges)
    rev_edge_dir_ws(graph_no_edges)
    select_edges(graph_no_edges)
    select_edges_by_edge_id(graph_no_edges)
    select_edges_by_node_id(graph_no_edges)
    select_last_edges_created(graph_no_edges)
    set_edge_attr_to_display(graph_no_edges)
    set_edge_attrs_ws(graph_no_edges)

    trav_both(graph_no_edges)
    trav_both_edge(graph_no_edges)
    trav_in(graph_no_edges)
    trav_in_edge(graph_no_edges)
    trav_in_node(graph_no_edges)
    trav_in_until(graph_no_edges)
    trav_out(graph_no_edges)
    trav_out_edge(graph_no_edges)
    trav_out_node(graph_no_edges)
    trav_out_until(graph_no_edges)
    trav_reverse_edge(graph_no_edges)
  })

})
