% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-length.R
\name{check_length}
\alias{check_length}
\title{Check Length}
\usage{
check_length(x, values = numeric(0), x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{values}{A flag or a whole numeric vector of the value, value range or possible values.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
An informative error if the test fails or an invisible copy of x.
}
\description{
Checks length of an object.
}
\examples{
check_length(1)
try(check_length(1, values = FALSE))
try(check_length(1, values = c(10, 2)))
}
\seealso{
Other check: 
\code{\link{check_data}()},
\code{\link{check_dim}()},
\code{\link{check_dirs}()},
\code{\link{check_files}()},
\code{\link{check_key}()},
\code{\link{check_names}()},
\code{\link{check_values}()}
}
\concept{check}
