% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwm.R
\name{toPWM}
\alias{toPWM}
\title{Convert motifs into PWMs}
\usage{
toPWM(
  motifs,
  ids = names(motifs),
  targets = names(motifs),
  seq.count = 50,
  prior = c(A = 0.25, C = 0.25, G = 0.25, T = 0.25),
  ...
)
}
\arguments{
\item{motifs}{a list of motifs either as position probability matrices (PPM) or frequency matirces (PFMs)}

\item{ids}{the set of IDs for the motifs (defaults to names of the 'motifs' list)}

\item{targets}{the set of target TF names for the motifs (defaults to names of the 'motifs' list)}

\item{seq.count}{provides a vector of sequence counts for probability matrices (PPMs). Default it 50.}

\item{prior}{frequencies of the four letters in the genome. Default is uniform background.}

\item{...}{other parameters to PWMUnscaled}
}
\description{
Convert motifs into PWMs
}
\examples{
\dontrun{
if (requireNamespace("PWMEnrich.Dmelanogaster.background")) {
   data(MotifDb.Dmel.PFM, package = "PWMEnrich.Dmelanogaster.background")

   toPWM(MotifDb.Dmel.PFM) # convert to PWM with uniform background

   # get background for drosophila (quick mode on a reduced dataset)
   prior = getBackgroundFrequencies("dm3", quick=TRUE)
   toPWM(MotifDb.Dmel.PFM, prior=prior) # convert with genomic background 
}
}
}
